/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.deserialization;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonAlias;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.sort.protocol.constant.Constant;
import org.apache.inlong.sort.protocol.deserialization.InLongMsgDeserializationInfo;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InLongMsgKvDeserializationInfo
extends InLongMsgDeserializationInfo {
    private static final long serialVersionUID = 8431516458466278968L;
    private final char entryDelimiter;
    private final char kvDelimiter;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private final Character escapeChar;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private final Character lineDelimiter;
    @JsonProperty(value="delete_escape_char_while_deserialize")
    @Nullable
    private final Boolean deleteEscapeCharWhileDes;
    @JsonProperty(value="auto_append_escape_char_after_deserialize")
    @Nullable
    private final Boolean autoAppendEscapeCharAfterDes;

    public InLongMsgKvDeserializationInfo(@JsonProperty(value="streamId") @JsonAlias(value={"tid"}) String streamId, @JsonProperty(value="entry_delimiter") char entryDelimiter, @JsonProperty(value="kv_delimiter") char kvDelimiter) {
        this(streamId, entryDelimiter, kvDelimiter, null, null);
    }

    @JsonCreator
    public InLongMsgKvDeserializationInfo(@JsonProperty(value="streamId") @JsonAlias(value={"tid"}) String streamId, @JsonProperty(value="entry_delimiter") char entryDelimiter, @JsonProperty(value="kv_delimiter") char kvDelimiter, @JsonProperty(value="escape_char") @Nullable Character escapeChar, @JsonProperty(value="line_delimiter") @Nullable Character lineDelimiter) {
        this(streamId, entryDelimiter, kvDelimiter, escapeChar, lineDelimiter, Constant.DELETE_ESCAPE_CHAR_WHILE_DESERIALIZE_DEFAULT, Constant.AUTO_APPEND_ESCAPE_CHAR_AFTER_DESERIALIZE_DEFAULT);
    }

    @JsonCreator
    public InLongMsgKvDeserializationInfo(@JsonProperty(value="streamId") @JsonAlias(value={"tid"}) String streamId, @JsonProperty(value="entry_delimiter") char entryDelimiter, @JsonProperty(value="kv_delimiter") char kvDelimiter, @JsonProperty(value="escape_char") @Nullable Character escapeChar, @JsonProperty(value="line_delimiter") @Nullable Character lineDelimiter, @JsonProperty(value="delete_escape_char_while_deserialize") @Nullable Boolean deleteEscapeCharWhileDes, @JsonProperty(value="auto_append_escape_char_after_deserialize") @Nullable Boolean autoAppendEscapeCharAfterDes) {
        super(streamId);
        this.entryDelimiter = entryDelimiter;
        this.kvDelimiter = kvDelimiter;
        this.escapeChar = escapeChar;
        this.lineDelimiter = Character.valueOf(lineDelimiter == null ? (char)'\n' : (char)lineDelimiter.charValue());
        this.deleteEscapeCharWhileDes = deleteEscapeCharWhileDes;
        this.autoAppendEscapeCharAfterDes = autoAppendEscapeCharAfterDes;
    }

    @JsonProperty(value="entry_delimiter")
    public char getEntryDelimiter() {
        return this.entryDelimiter;
    }

    @JsonProperty(value="kv_delimiter")
    public char getKvDelimiter() {
        return this.kvDelimiter;
    }

    @JsonProperty(value="escape_char")
    @Nullable
    public Character getEscapeChar() {
        return this.escapeChar;
    }

    @JsonProperty(value="line_delimiter")
    @Nullable
    public Character getLineDelimiter() {
        return this.lineDelimiter;
    }

    @JsonProperty(value="delete_escape_char_while_deserialize")
    @Nullable
    public Boolean getDeleteEscapeCharWhileDes() {
        if (this.deleteEscapeCharWhileDes != null) {
            return this.deleteEscapeCharWhileDes;
        }
        return Constant.DELETE_ESCAPE_CHAR_WHILE_DESERIALIZE_DEFAULT;
    }

    @JsonProperty(value="auto_append_escape_char_after_deserialize")
    @Nullable
    public Boolean getAutoAppendEscapeCharAfterDes() {
        if (this.autoAppendEscapeCharAfterDes != null) {
            return this.autoAppendEscapeCharAfterDes;
        }
        return Constant.AUTO_APPEND_ESCAPE_CHAR_AFTER_DESERIALIZE_DEFAULT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InLongMsgKvDeserializationInfo other = (InLongMsgKvDeserializationInfo)o;
        return super.equals(other) && this.entryDelimiter == other.entryDelimiter && this.kvDelimiter == other.kvDelimiter && Objects.equals(this.escapeChar, other.escapeChar) && Objects.equals(this.lineDelimiter, other.lineDelimiter) && Objects.equals(this.deleteEscapeCharWhileDes, other.deleteEscapeCharWhileDes) && Objects.equals(this.autoAppendEscapeCharAfterDes, other.autoAppendEscapeCharAfterDes);
    }
}

