/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.enums;

public enum RedisCommand {
    HGET("hget"),
    GET("get"),
    ZSCORE("zscore"),
    ZREVRANK("zrevrank");

    private final String value;

    private RedisCommand(String value) {
        this.value = value;
    }

    public static RedisCommand forName(String name) {
        for (RedisCommand command : RedisCommand.values()) {
            if (!command.name().equals(name)) continue;
            return command;
        }
        throw new IllegalArgumentException(String.format("Unsupported redis command=%s for Inlong", name));
    }

    public String getValue() {
        return this.value;
    }
}

