/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.enums;

public enum SchemaChangePolicy {
    ENABLE(1),
    IGNORE(2),
    LOG(3),
    ERROR(4);

    private final int code;

    private SchemaChangePolicy(int code) {
        this.code = code;
    }

    public static SchemaChangePolicy getInstance(int code) {
        for (SchemaChangePolicy policy : SchemaChangePolicy.values()) {
            if (policy.code != code) continue;
            return policy;
        }
        throw new IllegalArgumentException(String.format("Unsupported policy of schema-change: %s for InLong", code));
    }

    public int getCode() {
        return this.code;
    }

    public String toString() {
        return String.format("%s(%s)", this.name(), this.getCode());
    }
}

