/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.transformation.function;

import java.util.Collections;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.transformation.Function;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;
import org.apache.inlong.sort.protocol.transformation.StringConstantParam;

@JsonTypeName(value="customFunction")
public class CustomFunction
implements Function {
    private final String content;

    @JsonCreator
    public CustomFunction(@JsonProperty(value="content") String content) {
        this.content = content;
    }

    @Override
    public List<FunctionParam> getParams() {
        return Collections.singletonList(new StringConstantParam(this.content));
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException("Custom function is used to pass the function script that the user has organized, using content as the real function content, so there is no specific function name.");
    }

    @Override
    public String format() {
        return this.content;
    }

    public String getContent() {
        return this.content;
    }

    public String toString() {
        return "CustomFunction(content=" + this.getContent() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomFunction)) {
            return false;
        }
        CustomFunction other = (CustomFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }
}

