/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DataOperationOrderer {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final ConcurrentMap<Object, CompletionStage<Operation>> objectStages = new ConcurrentHashMap<Object, CompletionStage<Operation>>();

    public CompletionStage<Operation> orderOn(Object key, CompletionStage<Operation> register) {
        CompletionStage<Operation> current = this.objectStages.put(key, register);
        if (log.isTraceEnabled()) {
            log.tracef("Ordering upcoming future %s for key %s to run after %s", register, key, current);
        }
        return current;
    }

    public void completeOperation(Object key, CompletableFuture<Operation> registeredFuture, Operation operation) {
        if (log.isTraceEnabled()) {
            log.tracef("Ordered future %s is completed for key %s from op %s", registeredFuture, key, (Object)operation);
        }
        this.objectStages.remove(key, registeredFuture);
        registeredFuture.complete(operation);
    }

    public static enum Operation {
        READ,
        REMOVE,
        WRITE;

    }
}

