/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster.agent;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.cluster.agent.AgentClusterNodeRequest;
import org.apache.inlong.manager.pojo.module.ModuleHistory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="Agent cluster node info")
public class AgentClusterNodeDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentClusterNodeDTO.class);
    @ApiModelProperty(value="Agent group name")
    private String agentGroup;
    @ApiModelProperty(value="Module id list")
    private List<Integer> moduleIdList;
    @ApiModelProperty(value="Agent restart time")
    private Integer agentRestartTime = 0;
    @ApiModelProperty(value="Install restart time")
    private Integer installRestartTime = 0;
    @ApiModelProperty(value="History list of module")
    private List<ModuleHistory> moduleHistoryList;

    public static AgentClusterNodeDTO getFromRequest(AgentClusterNodeRequest request, String extParams) {
        if (!StringUtils.isNotBlank((CharSequence)extParams)) {
            return (AgentClusterNodeDTO)CommonBeanUtils.copyProperties((Object)request, AgentClusterNodeDTO::new, (boolean)true);
        }
        AgentClusterNodeDTO dto = AgentClusterNodeDTO.getFromJson(extParams);
        if (!CollectionUtils.isEqualCollection(request.getModuleIdList(), dto.getModuleIdList())) {
            request.setModuleHistoryList(dto.getModuleHistoryList());
            List<ModuleHistory> moduleHistoryList = request.getModuleHistoryList();
            if (moduleHistoryList.size() > 10) {
                moduleHistoryList.remove(moduleHistoryList.size() - 1);
            }
            ModuleHistory moduleHistory = ModuleHistory.builder().moduleIdList(dto.getModuleIdList()).modifier(request.getCurrentUser()).modifyTime(new Date()).build();
            moduleHistoryList.add(0, moduleHistory);
            dto.setModuleHistoryList(moduleHistoryList);
        }
        return (AgentClusterNodeDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static AgentClusterNodeDTO getFromJson(@NotNull String extParams) {
        try {
            return (AgentClusterNodeDTO)JsonUtils.parseObject((String)extParams, AgentClusterNodeDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, ErrorCodeEnum.CLUSTER_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    private static List<Integer> $default$moduleIdList() {
        return new ArrayList<Integer>();
    }

    private static List<ModuleHistory> $default$moduleHistoryList() {
        return new ArrayList<ModuleHistory>();
    }

    public static AgentClusterNodeDTOBuilder builder() {
        return new AgentClusterNodeDTOBuilder();
    }

    public String getAgentGroup() {
        return this.agentGroup;
    }

    public List<Integer> getModuleIdList() {
        return this.moduleIdList;
    }

    public Integer getAgentRestartTime() {
        return this.agentRestartTime;
    }

    public Integer getInstallRestartTime() {
        return this.installRestartTime;
    }

    public List<ModuleHistory> getModuleHistoryList() {
        return this.moduleHistoryList;
    }

    public void setAgentGroup(String agentGroup) {
        this.agentGroup = agentGroup;
    }

    public void setModuleIdList(List<Integer> moduleIdList) {
        this.moduleIdList = moduleIdList;
    }

    public void setAgentRestartTime(Integer agentRestartTime) {
        this.agentRestartTime = agentRestartTime;
    }

    public void setInstallRestartTime(Integer installRestartTime) {
        this.installRestartTime = installRestartTime;
    }

    public void setModuleHistoryList(List<ModuleHistory> moduleHistoryList) {
        this.moduleHistoryList = moduleHistoryList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentClusterNodeDTO)) {
            return false;
        }
        AgentClusterNodeDTO other = (AgentClusterNodeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$agentRestartTime = this.getAgentRestartTime();
        Integer other$agentRestartTime = other.getAgentRestartTime();
        if (this$agentRestartTime == null ? other$agentRestartTime != null : !((Object)this$agentRestartTime).equals(other$agentRestartTime)) {
            return false;
        }
        Integer this$installRestartTime = this.getInstallRestartTime();
        Integer other$installRestartTime = other.getInstallRestartTime();
        if (this$installRestartTime == null ? other$installRestartTime != null : !((Object)this$installRestartTime).equals(other$installRestartTime)) {
            return false;
        }
        String this$agentGroup = this.getAgentGroup();
        String other$agentGroup = other.getAgentGroup();
        if (this$agentGroup == null ? other$agentGroup != null : !this$agentGroup.equals(other$agentGroup)) {
            return false;
        }
        List<Integer> this$moduleIdList = this.getModuleIdList();
        List<Integer> other$moduleIdList = other.getModuleIdList();
        if (this$moduleIdList == null ? other$moduleIdList != null : !((Object)this$moduleIdList).equals(other$moduleIdList)) {
            return false;
        }
        List<ModuleHistory> this$moduleHistoryList = this.getModuleHistoryList();
        List<ModuleHistory> other$moduleHistoryList = other.getModuleHistoryList();
        return !(this$moduleHistoryList == null ? other$moduleHistoryList != null : !((Object)this$moduleHistoryList).equals(other$moduleHistoryList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgentClusterNodeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $agentRestartTime = this.getAgentRestartTime();
        result = result * 59 + ($agentRestartTime == null ? 43 : ((Object)$agentRestartTime).hashCode());
        Integer $installRestartTime = this.getInstallRestartTime();
        result = result * 59 + ($installRestartTime == null ? 43 : ((Object)$installRestartTime).hashCode());
        String $agentGroup = this.getAgentGroup();
        result = result * 59 + ($agentGroup == null ? 43 : $agentGroup.hashCode());
        List<Integer> $moduleIdList = this.getModuleIdList();
        result = result * 59 + ($moduleIdList == null ? 43 : ((Object)$moduleIdList).hashCode());
        List<ModuleHistory> $moduleHistoryList = this.getModuleHistoryList();
        result = result * 59 + ($moduleHistoryList == null ? 43 : ((Object)$moduleHistoryList).hashCode());
        return result;
    }

    public String toString() {
        return "AgentClusterNodeDTO(agentGroup=" + this.getAgentGroup() + ", moduleIdList=" + this.getModuleIdList() + ", agentRestartTime=" + this.getAgentRestartTime() + ", installRestartTime=" + this.getInstallRestartTime() + ", moduleHistoryList=" + this.getModuleHistoryList() + ")";
    }

    public AgentClusterNodeDTO() {
        this.moduleIdList = AgentClusterNodeDTO.$default$moduleIdList();
        this.moduleHistoryList = AgentClusterNodeDTO.$default$moduleHistoryList();
    }

    public AgentClusterNodeDTO(String agentGroup, List<Integer> moduleIdList, Integer agentRestartTime, Integer installRestartTime, List<ModuleHistory> moduleHistoryList) {
        this.agentGroup = agentGroup;
        this.moduleIdList = moduleIdList;
        this.agentRestartTime = agentRestartTime;
        this.installRestartTime = installRestartTime;
        this.moduleHistoryList = moduleHistoryList;
    }

    public static class AgentClusterNodeDTOBuilder {
        private String agentGroup;
        private boolean moduleIdList$set;
        private List<Integer> moduleIdList$value;
        private Integer agentRestartTime;
        private Integer installRestartTime;
        private boolean moduleHistoryList$set;
        private List<ModuleHistory> moduleHistoryList$value;

        AgentClusterNodeDTOBuilder() {
        }

        public AgentClusterNodeDTOBuilder agentGroup(String agentGroup) {
            this.agentGroup = agentGroup;
            return this;
        }

        public AgentClusterNodeDTOBuilder moduleIdList(List<Integer> moduleIdList) {
            this.moduleIdList$value = moduleIdList;
            this.moduleIdList$set = true;
            return this;
        }

        public AgentClusterNodeDTOBuilder agentRestartTime(Integer agentRestartTime) {
            this.agentRestartTime = agentRestartTime;
            return this;
        }

        public AgentClusterNodeDTOBuilder installRestartTime(Integer installRestartTime) {
            this.installRestartTime = installRestartTime;
            return this;
        }

        public AgentClusterNodeDTOBuilder moduleHistoryList(List<ModuleHistory> moduleHistoryList) {
            this.moduleHistoryList$value = moduleHistoryList;
            this.moduleHistoryList$set = true;
            return this;
        }

        public AgentClusterNodeDTO build() {
            List moduleIdList$value = this.moduleIdList$value;
            if (!this.moduleIdList$set) {
                moduleIdList$value = AgentClusterNodeDTO.$default$moduleIdList();
            }
            List moduleHistoryList$value = this.moduleHistoryList$value;
            if (!this.moduleHistoryList$set) {
                moduleHistoryList$value = AgentClusterNodeDTO.$default$moduleHistoryList();
            }
            return new AgentClusterNodeDTO(this.agentGroup, moduleIdList$value, this.agentRestartTime, this.installRestartTime, moduleHistoryList$value);
        }

        public String toString() {
            return "AgentClusterNodeDTO.AgentClusterNodeDTOBuilder(agentGroup=" + this.agentGroup + ", moduleIdList$value=" + this.moduleIdList$value + ", agentRestartTime=" + this.agentRestartTime + ", installRestartTime=" + this.installRestartTime + ", moduleHistoryList$value=" + this.moduleHistoryList$value + ")";
        }
    }
}

