/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.hudi;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.node.hudi.HudiDataNodeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="Hudi data node info")
public class HudiDataNodeDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(HudiDataNodeDTO.class);
    @ApiModelProperty(value="Catalog type, like: HIVE, HADOOP, default is HIVE")
    private String catalogType;
    @ApiModelProperty(value="Hudi data warehouse dir")
    private String warehouse;

    public static HudiDataNodeDTO getFromRequest(HudiDataNodeRequest request, String extParams) {
        HudiDataNodeDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? HudiDataNodeDTO.getFromJson(extParams) : new HudiDataNodeDTO();
        return (HudiDataNodeDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static HudiDataNodeDTO getFromJson(@NotNull String extParams) {
        try {
            return (HudiDataNodeDTO)JsonUtils.parseObject((String)extParams, HudiDataNodeDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.GROUP_INFO_INCORRECT, String.format("Failed to parse extParams for Hudi node: %s", e.getMessage()));
        }
    }

    private static String $default$catalogType() {
        return "HIVE";
    }

    public static HudiDataNodeDTOBuilder builder() {
        return new HudiDataNodeDTOBuilder();
    }

    public String getCatalogType() {
        return this.catalogType;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public void setCatalogType(String catalogType) {
        this.catalogType = catalogType;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HudiDataNodeDTO)) {
            return false;
        }
        HudiDataNodeDTO other = (HudiDataNodeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$catalogType = this.getCatalogType();
        String other$catalogType = other.getCatalogType();
        if (this$catalogType == null ? other$catalogType != null : !this$catalogType.equals(other$catalogType)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        return !(this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HudiDataNodeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $catalogType = this.getCatalogType();
        result = result * 59 + ($catalogType == null ? 43 : $catalogType.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        return result;
    }

    public String toString() {
        return "HudiDataNodeDTO(catalogType=" + this.getCatalogType() + ", warehouse=" + this.getWarehouse() + ")";
    }

    public HudiDataNodeDTO() {
        this.catalogType = HudiDataNodeDTO.$default$catalogType();
    }

    public HudiDataNodeDTO(String catalogType, String warehouse) {
        this.catalogType = catalogType;
        this.warehouse = warehouse;
    }

    public static class HudiDataNodeDTOBuilder {
        private boolean catalogType$set;
        private String catalogType$value;
        private String warehouse;

        HudiDataNodeDTOBuilder() {
        }

        public HudiDataNodeDTOBuilder catalogType(String catalogType) {
            this.catalogType$value = catalogType;
            this.catalogType$set = true;
            return this;
        }

        public HudiDataNodeDTOBuilder warehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        public HudiDataNodeDTO build() {
            String catalogType$value = this.catalogType$value;
            if (!this.catalogType$set) {
                catalogType$value = HudiDataNodeDTO.$default$catalogType();
            }
            return new HudiDataNodeDTO(catalogType$value, this.warehouse);
        }

        public String toString() {
            return "HudiDataNodeDTO.HudiDataNodeDTOBuilder(catalogType$value=" + this.catalogType$value + ", warehouse=" + this.warehouse + ")";
        }
    }
}

