/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.tenant;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.common.validation.UpdateByIdValidation;
import org.apache.inlong.manager.common.validation.UpdateByKeyValidation;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="Tenant request")
public class InlongTenantRequest {
    @ApiModelProperty(value="Primary key")
    private Integer id;
    @ApiModelProperty(value="Tenant name")
    @Pattern(regexp="^[A-Za-z0-9_-]{1,256}$", message="only supports letters, numbers, '-', or '_'")
    @NotBlank
    private @Pattern(regexp="^[A-Za-z0-9_-]{1,256}$", message="only supports letters, numbers, '-', or '_'") @NotBlank String name;
    @ApiModelProperty(value="Description of the tenant")
    @Length(max=256, message="length must be less than or equal to 256")
    private @Length(max=256, message="length must be less than or equal to 256") String description;
    @ApiModelProperty(value="Version number")
    @NotNull(groups={UpdateByIdValidation.class, UpdateByKeyValidation.class}, message="version cannot be null")
    private @NotNull(groups={UpdateByIdValidation.class, UpdateByKeyValidation.class}, message="version cannot be null") Integer version;

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongTenantRequest)) {
            return false;
        }
        InlongTenantRequest other = (InlongTenantRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlongTenantRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "InlongTenantRequest(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ")";
    }

    public InlongTenantRequest() {
    }

    public InlongTenantRequest(Integer id, String name, String description, Integer version) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.version = version;
    }
}

