/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import com.google.common.base.Preconditions;
import org.apache.flume.Source;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.channel.ChannelProcessor;
import org.apache.flume.lifecycle.LifecycleState;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class AbstractSource
implements Source {
    private ChannelProcessor channelProcessor;
    private String name;
    private LifecycleState lifecycleState = LifecycleState.IDLE;

    @Override
    public synchronized void start() {
        Preconditions.checkState((this.channelProcessor != null ? 1 : 0) != 0, (Object)"No channel processor configured");
        this.lifecycleState = LifecycleState.START;
    }

    @Override
    public synchronized void stop() {
        this.lifecycleState = LifecycleState.STOP;
    }

    @Override
    public synchronized void setChannelProcessor(ChannelProcessor cp) {
        this.channelProcessor = cp;
    }

    @Override
    public synchronized ChannelProcessor getChannelProcessor() {
        return this.channelProcessor;
    }

    @Override
    public synchronized LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    @Override
    public synchronized void setName(String name) {
        this.name = name;
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getName() + "{name:" + this.name + ",state:" + (Object)((Object)this.lifecycleState) + "}";
    }
}

