/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.send;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.audit.protocol.AuditApi;
import org.apache.inlong.audit.send.ProxyManager;
import org.apache.inlong.audit.util.AuditConfig;
import org.apache.inlong.audit.util.AuditData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SenderManager.class);
    private static final int SEND_INTERVAL_MS = 100;
    private final ConcurrentHashMap<Long, AuditData> failedDataMap = new ConcurrentHashMap();
    private AuditConfig auditConfig;
    private Socket socket = new Socket();
    private static final int PACKAGE_HEADER_LEN = 4;
    private static final int MAX_RESPONSE_LENGTH = 32768;
    private static final AtomicLong globalAuditMemory = new AtomicLong(0L);
    private static long maxGlobalAuditMemory = 0xC800000L;

    public static void setMaxGlobalAuditMemory(long maxGlobalAuditMemory) {
        SenderManager.maxGlobalAuditMemory = maxGlobalAuditMemory;
    }

    public SenderManager(AuditConfig config) {
        this.auditConfig = config;
    }

    public void closeSocket() {
        if (this.socket.isClosed()) {
            LOGGER.info("Audit socket is already closed");
            return;
        }
        try {
            this.socket.close();
            LOGGER.info("Audit socket closed successfully");
        }
        catch (IOException exception) {
            LOGGER.error("Error closing audit socket", (Throwable)exception);
        }
    }

    public boolean checkSocket() {
        if (this.socket.isClosed() || !this.socket.isConnected()) {
            InetSocketAddress inetSocketAddress = null;
            try {
                inetSocketAddress = ProxyManager.getInstance().getInetSocketAddress();
                if (inetSocketAddress == null) {
                    LOGGER.error("Audit proxy address is null!");
                    return false;
                }
                this.reconnect(inetSocketAddress, this.auditConfig.getSocketTimeout());
            }
            catch (IOException exception) {
                LOGGER.error("Connect to audit proxy {} has exception!", (Object)inetSocketAddress, (Object)exception);
                return false;
            }
        }
        return this.socket.isConnected();
    }

    private void reconnect(InetSocketAddress inetSocketAddress, int timeout) throws IOException {
        this.socket = new Socket();
        this.socket.connect(inetSocketAddress, timeout);
        this.socket.setSoTimeout(timeout);
    }

    public boolean send(AuditApi.BaseCommand baseCommand, AuditApi.AuditRequest auditRequest) {
        AuditData data = new AuditData(baseCommand, auditRequest);
        for (int retry = 0; retry < this.auditConfig.getRetryTimes(); ++retry) {
            if (this.sendData(data.getDataByte())) {
                return true;
            }
            LOGGER.warn("Failed to send data on attempt {}. Retrying...", (Object)(retry + 1));
            this.sleep();
        }
        LOGGER.error("Failed to send data after {} attempts. Storing data for later retry.", (Object)this.auditConfig.getRetryTimes());
        this.failedDataMap.putIfAbsent(baseCommand.getAuditRequest().getRequestId(), data);
        return false;
    }

    private void readFully(InputStream is, byte[] buffer, int len) throws IOException {
        int bytesRead;
        for (int totalBytesRead = 0; totalBytesRead < len && (bytesRead = is.read(buffer, totalBytesRead, len - totalBytesRead)) != -1; totalBytesRead += bytesRead) {
        }
    }

    private boolean sendData(byte[] data) {
        if (data == null || data.length == 0) {
            LOGGER.warn("Send data is empty!");
            return false;
        }
        if (!this.checkSocket()) {
            return false;
        }
        try {
            OutputStream outputStream = this.socket.getOutputStream();
            InputStream inputStream = this.socket.getInputStream();
            outputStream.write(data);
            byte[] header = new byte[4];
            this.readFully(inputStream, header, 4);
            int bodyLen = (header[0] & 0xFF) << 24 | (header[1] & 0xFF) << 16 | (header[2] & 0xFF) << 8 | header[3] & 0xFF;
            if (bodyLen > 32768) {
                this.closeSocket();
                return false;
            }
            byte[] body = new byte[bodyLen];
            this.readFully(inputStream, body, bodyLen);
            AuditApi.BaseCommand reply = AuditApi.BaseCommand.parseFrom((byte[])body);
            return AuditApi.AuditReply.RSP_CODE.SUCCESS.equals((Object)reply.getAuditReply().getRspCode());
        }
        catch (IOException exception) {
            this.closeSocket();
            LOGGER.error("Send audit data to proxy has exception!", (Throwable)exception);
            return false;
        }
    }

    public void checkFailedData() {
        LOGGER.info("Audit failed cache size: {}", (Object)this.failedDataMap.size());
        Iterator<Map.Entry<Long, AuditData>> iterator = this.failedDataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, AuditData> entry = iterator.next();
            if (!this.sendData(entry.getValue().getDataByte())) continue;
            iterator.remove();
            this.sleep();
        }
        if (this.failedDataMap.isEmpty()) {
            this.checkAuditFile();
        }
        long failedDataSize = this.getFailedDataSize();
        globalAuditMemory.addAndGet(failedDataSize);
        if (this.failedDataMap.size() > this.auditConfig.getMaxCacheRow() || globalAuditMemory.get() > maxGlobalAuditMemory) {
            LOGGER.warn("Failed cache [size: {}, threshold {}], [count {}, threshold: {}]", new Object[]{globalAuditMemory.get(), maxGlobalAuditMemory, this.failedDataMap.size(), this.auditConfig.getMaxCacheRow()});
            this.writeLocalFile();
            this.failedDataMap.clear();
        }
        globalAuditMemory.addAndGet(-failedDataSize);
    }

    private void writeLocalFile() {
        if (!this.checkFilePath()) {
            LOGGER.error("{} is not exist!", (Object)this.auditConfig.getFilePath());
            return;
        }
        File file = new File(this.auditConfig.getDisasterFile());
        try {
            if (file.exists()) {
                if (file.length() > (long)this.auditConfig.getMaxFileSize()) {
                    if (!file.delete()) {
                        LOGGER.error("Failed to delete file: {}", (Object)file.getAbsolutePath());
                        return;
                    }
                    LOGGER.info("Deleted file due to exceeding max file size: {}", (Object)file.getAbsolutePath());
                }
            } else {
                if (!file.createNewFile()) {
                    LOGGER.error("Failed to create file: {}", (Object)file.getAbsolutePath());
                    return;
                }
                LOGGER.info("Created file: {}", (Object)file.getAbsolutePath());
            }
            try (FileOutputStream fos = new FileOutputStream(file);
                 ObjectOutputStream objectOutputStream = new ObjectOutputStream(fos);){
                objectOutputStream.writeObject(this.failedDataMap);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error writing to local file: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private boolean checkFilePath() {
        File file = new File(this.auditConfig.getFilePath());
        if (!file.exists()) {
            if (!file.mkdirs()) {
                LOGGER.error("Create file {} failed!", (Object)this.auditConfig.getFilePath());
                return false;
            }
            LOGGER.info("Create file {} success", (Object)this.auditConfig.getFilePath());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAuditFile() {
        File file = new File(this.auditConfig.getDisasterFile());
        if (!file.exists()) {
            return;
        }
        try (FileInputStream inputStream = new FileInputStream(file);
             ObjectInputStream objectStream = new ObjectInputStream(inputStream);){
            ConcurrentHashMap fileData = (ConcurrentHashMap)objectStream.readObject();
            for (Map.Entry entry : fileData.entrySet()) {
                if (!this.sendData(((AuditData)entry.getValue()).getDataByte())) {
                    LOGGER.error("Local file recovery failed: {}", entry.getValue());
                }
                this.sleep();
            }
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("check audit file error:{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (!file.delete()) {
                LOGGER.error("Failed to delete file: {}", (Object)file.getAbsolutePath());
            }
        }
    }

    public int getDataMapSize() {
        return this.failedDataMap.size();
    }

    private void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (Throwable ex) {
            LOGGER.error("sleep error:{}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public void setAuditConfig(AuditConfig config) {
        this.auditConfig = config;
    }

    private long getFailedDataSize() {
        long dataSize = 0L;
        for (AuditData auditData : this.failedDataMap.values()) {
            dataSize += (long)auditData.getDataByte().length;
        }
        return dataSize;
    }
}

