/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.metric.impl;

import java.util.Map;
import org.apache.inlong.tubemq.corebase.metric.Histogram;
import org.apache.inlong.tubemq.corebase.metric.impl.BaseMetric;
import org.apache.inlong.tubemq.corebase.metric.impl.LongMaxGauge;
import org.apache.inlong.tubemq.corebase.metric.impl.LongMinGauge;
import org.apache.inlong.tubemq.corebase.metric.impl.LongStatsCounter;

public class ESTHistogram
extends BaseMetric
implements Histogram {
    private static final int NUM_BUCKETS = 18;
    private static final int MAX_BUCKET_INDEX = 17;
    private static final long POWER_2_17 = 131072L;
    private static final double LOG2_VALUE = Math.log(2.0);
    private final String p99FullKey;
    private final String p99ShortKey = "P99";
    private final String p999FullKey;
    private final String p999ShortKey = "P999";
    private final String p9999FullKey;
    private final String p9999ShortKey = "P9999";
    private final LongStatsCounter count;
    private final LongMinGauge min;
    private final LongMaxGauge max;
    private final LongStatsCounter[] buckets = new LongStatsCounter[18];

    public ESTHistogram(String metricName, String prefix) {
        super(metricName, prefix);
        this.p99FullKey = this.getFullName() + "_" + "P99";
        this.p999FullKey = this.getFullName() + "_" + "P999";
        this.p9999FullKey = this.getFullName() + "_" + "P9999";
        this.count = new LongStatsCounter("count", this.getFullName());
        this.min = new LongMinGauge("min", this.getFullName());
        this.max = new LongMaxGauge("max", this.getFullName());
        StringBuilder strBuff = new StringBuilder(512);
        for (int i = 0; i < 18; ++i) {
            strBuff.append("cell_");
            if (i == 0) {
                strBuff.append(0).append("t").append((int)Math.pow(2.0, i + 1));
            } else if (i == 17) {
                strBuff.append((int)Math.pow(2.0, i)).append("tMax");
            } else {
                strBuff.append((int)Math.pow(2.0, i)).append("t").append((int)Math.pow(2.0, i + 1));
            }
            this.buckets[i] = new LongStatsCounter(strBuff.toString(), this.getFullName());
            strBuff.delete(0, strBuff.length());
        }
    }

    @Override
    public void update(long newValue) {
        this.count.incValue();
        this.min.update(newValue);
        this.max.update(newValue);
        int index = newValue <= 0L ? 0 : (newValue >= 131072L ? 17 : (int)(Math.log(newValue) / LOG2_VALUE));
        this.buckets[index].incValue();
    }

    @Override
    public void getValue(Map<String, Long> keyValMap, boolean includeZero) {
        this.getValue2Map(keyValMap, false, includeZero);
    }

    @Override
    public void getValue(StringBuilder strBuff, boolean includeZero) {
        this.getValue2StrBuff(strBuff, false, includeZero);
    }

    @Override
    public void snapShort(Map<String, Long> keyValMap, boolean includeZero) {
        this.getValue2Map(keyValMap, true, includeZero);
    }

    @Override
    public void snapShort(StringBuilder strBuff, boolean includeZero) {
        this.getValue2StrBuff(strBuff, true, includeZero);
    }

    @Override
    public void clear() {
        this.count.clear();
        this.min.clear();
        this.max.clear();
        for (int i = 0; i < 18; ++i) {
            this.buckets[i].clear();
        }
    }

    private void getValue2Map(Map<String, Long> keyValMap, boolean snapShot, boolean includeZero) {
        long minValue;
        long maxValue;
        long curCnt;
        long p99Cnt = 0L;
        long p999Cnt = 0L;
        long p9999Cnt = 0L;
        int maxValIndex = -1;
        int match99Index = 0;
        int match999Index = 0;
        int match9999Index = 0;
        if (snapShot) {
            curCnt = this.count.getAndResetValue();
            maxValue = this.max.getAndResetValue();
            minValue = this.min.getAndResetValue();
        } else {
            curCnt = this.count.getValue();
            maxValue = this.max.getValue();
            minValue = this.min.getValue();
        }
        if (curCnt > 0L) {
            p99Cnt = (long)((double)curCnt * 0.99);
            p999Cnt = (long)((double)curCnt * 0.999);
            p9999Cnt = (long)((double)curCnt * 0.9999);
        }
        keyValMap.put(this.count.getFullName(), curCnt);
        keyValMap.put(this.min.getFullName(), minValue);
        keyValMap.put(this.max.getFullName(), maxValue);
        for (int i = 0; i < 18; ++i) {
            long bucketItemVal;
            long l = bucketItemVal = snapShot ? this.buckets[i].getAndResetValue() : this.buckets[i].getValue();
            if (bucketItemVal == 0L) {
                if (!includeZero) continue;
                keyValMap.put(this.buckets[i].getFullName(), bucketItemVal);
                continue;
            }
            keyValMap.put(this.buckets[i].getFullName(), bucketItemVal);
            maxValIndex = i;
            if (p99Cnt > 0L && (p99Cnt -= bucketItemVal) <= 0L) {
                match99Index = i;
            }
            if (p999Cnt > 0L && (p999Cnt -= bucketItemVal) <= 0L) {
                match999Index = i;
            }
            if (p9999Cnt <= 0L || (p9999Cnt -= bucketItemVal) > 0L) continue;
            match9999Index = i;
        }
        keyValMap.put(this.p99FullKey, this.getPxValue(match99Index, maxValIndex, maxValue));
        keyValMap.put(this.p999FullKey, this.getPxValue(match999Index, maxValIndex, maxValue));
        keyValMap.put(this.p9999FullKey, this.getPxValue(match9999Index, maxValIndex, maxValue));
    }

    private void getValue2StrBuff(StringBuilder strBuff, boolean snapShot, boolean includeZero) {
        long minValue;
        long maxValue;
        long curCnt;
        long p99Cnt = 0L;
        long p999Cnt = 0L;
        long p9999Cnt = 0L;
        int maxValIndex = -1;
        int match99Index = 0;
        int match999Index = 0;
        int match9999Index = 0;
        if (snapShot) {
            curCnt = this.count.getAndResetValue();
            maxValue = this.max.getAndResetValue();
            minValue = this.min.getAndResetValue();
        } else {
            curCnt = this.count.getValue();
            maxValue = this.max.getValue();
            minValue = this.min.getValue();
        }
        if (curCnt > 0L) {
            p99Cnt = (long)((double)curCnt * 0.99);
            p999Cnt = (long)((double)curCnt * 0.999);
            p9999Cnt = (long)((double)curCnt * 0.9999);
        }
        strBuff.append("\"").append(this.getFullName()).append("\":").append("{\"").append(this.count.getShortName()).append("\":").append(curCnt).append(",\"").append(this.min.getShortName()).append("\":").append(minValue).append(",\"").append(this.max.getShortName()).append("\":").append(maxValue).append(",\"cells\":{");
        int count = 0;
        for (int i = 0; i < 18; ++i) {
            long bucketItemVal;
            long l = bucketItemVal = snapShot ? this.buckets[i].getAndResetValue() : this.buckets[i].getValue();
            if (bucketItemVal == 0L) {
                if (!includeZero) continue;
                if (count++ > 0) {
                    strBuff.append(",");
                }
                strBuff.append("\"").append(this.buckets[i].getShortName()).append("\":").append(bucketItemVal);
                continue;
            }
            if (count++ > 0) {
                strBuff.append(",");
            }
            strBuff.append("\"").append(this.buckets[i].getShortName()).append("\":").append(bucketItemVal);
            maxValIndex = i;
            if (p99Cnt > 0L && (p99Cnt -= bucketItemVal) <= 0L) {
                match99Index = i;
            }
            if (p999Cnt > 0L && (p999Cnt -= bucketItemVal) <= 0L) {
                match999Index = i;
            }
            if (p9999Cnt <= 0L || (p9999Cnt -= bucketItemVal) > 0L) continue;
            match9999Index = i;
        }
        strBuff.append("},\"").append("P99").append("\":").append(this.getPxValue(match99Index, maxValIndex, maxValue)).append(",\"").append("P999").append("\":").append(this.getPxValue(match999Index, maxValIndex, maxValue)).append(",\"").append("P9999").append("\":").append(this.getPxValue(match9999Index, maxValIndex, maxValue)).append("}");
    }

    private long getPxValue(int endValIndex, int maxValIndex, long maxValue) {
        if (endValIndex < maxValIndex) {
            return (long)Math.pow(2.0, endValIndex + 1);
        }
        return maxValue == Long.MIN_VALUE ? 0L : maxValue;
    }
}

