/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.ipc.RPC;

public class ConfiguredFailoverProxyProvider<T>
extends AbstractNNFailoverProxyProvider<T> {
    protected final List<AbstractNNFailoverProxyProvider.NNProxyInfo<T>> proxies;
    private int currentProxyIndex = 0;

    public ConfiguredFailoverProxyProvider(Configuration conf, URI uri, Class<T> xface, HAProxyFactory<T> factory) {
        super(conf, uri, xface, factory);
        this.proxies = this.getProxyAddresses(uri, "dfs.namenode.rpc-address");
    }

    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        AbstractNNFailoverProxyProvider.NNProxyInfo<T> current = this.proxies.get(this.currentProxyIndex);
        return this.createProxyIfNeeded(current);
    }

    public void performFailover(T currentProxy) {
        this.incrementProxyIndex();
    }

    synchronized void incrementProxyIndex() {
        this.currentProxyIndex = (this.currentProxyIndex + 1) % this.proxies.size();
    }

    public synchronized void close() throws IOException {
        for (FailoverProxyProvider.ProxyInfo proxyInfo : this.proxies) {
            if (proxyInfo.proxy == null) continue;
            if (proxyInfo.proxy instanceof Closeable) {
                ((Closeable)proxyInfo.proxy).close();
                continue;
            }
            RPC.stopProxy((Object)proxyInfo.proxy);
        }
    }

    @Override
    public boolean useLogicalURI() {
        return true;
    }
}

