/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.metadata;

import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

public class BrokerDefMetadata {
    private int numTopicStores = 1;
    private int numPartitions = 1;
    private int unflushThreshold = 1000;
    private int unflushDataHold = 0;
    private int unflushInterval = 10000;
    private boolean acceptPublish = true;
    private boolean acceptSubscribe = true;
    private String dataPath;
    @Deprecated
    private String deleteWhen = "0 0 6,18 * * ?";
    private String deletePolicy = "delete,168h";
    private int memCacheMsgSize = 0x100000;
    private int memCacheMsgCnt = 5120;
    private int memCacheFlushInterval = 20000;

    public BrokerDefMetadata() {
    }

    public BrokerDefMetadata(String brokerDefMetaConfInfo) {
        if (TStringUtils.isBlank((String)brokerDefMetaConfInfo)) {
            return;
        }
        String[] brokerDefaultConfInfoArr = brokerDefMetaConfInfo.split(":", -1);
        this.numPartitions = Integer.parseInt(brokerDefaultConfInfoArr[0]);
        this.acceptPublish = Boolean.parseBoolean(brokerDefaultConfInfoArr[1]);
        this.acceptSubscribe = Boolean.parseBoolean(brokerDefaultConfInfoArr[2]);
        this.unflushThreshold = Integer.parseInt(brokerDefaultConfInfoArr[3]);
        this.unflushInterval = Integer.parseInt(brokerDefaultConfInfoArr[4]);
        this.deleteWhen = brokerDefaultConfInfoArr[5];
        this.deletePolicy = brokerDefaultConfInfoArr[6];
        this.numTopicStores = Integer.parseInt(brokerDefaultConfInfoArr[7]);
        this.unflushDataHold = Integer.parseInt(brokerDefaultConfInfoArr[8]);
        this.memCacheMsgSize = Integer.parseInt(brokerDefaultConfInfoArr[9]) * 1024 * 512;
        this.memCacheMsgCnt = Integer.parseInt(brokerDefaultConfInfoArr[10]) * 512;
        this.memCacheFlushInterval = Integer.parseInt(brokerDefaultConfInfoArr[11]);
    }

    public int getNumTopicStores() {
        return this.numTopicStores;
    }

    public void setNumTopicStores(int numTopicStores) {
        this.numTopicStores = numTopicStores;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public void setNumPartitions(int numPartitions) {
        this.numPartitions = numPartitions;
    }

    public int getUnflushThreshold() {
        return this.unflushThreshold;
    }

    public void setUnflushThreshold(int unflushThreshold) {
        this.unflushThreshold = unflushThreshold;
    }

    public int getUnflushDataHold() {
        return this.unflushDataHold;
    }

    public void setUnflushDataHold(int unflushDataHold) {
        this.unflushDataHold = unflushDataHold;
    }

    public int getUnflushInterval() {
        return this.unflushInterval;
    }

    public void setUnflushInterval(int unflushInterval) {
        this.unflushInterval = unflushInterval;
    }

    public boolean isAcceptPublish() {
        return this.acceptPublish;
    }

    public void setAcceptPublish(boolean acceptPublish) {
        this.acceptPublish = acceptPublish;
    }

    public boolean isAcceptSubscribe() {
        return this.acceptSubscribe;
    }

    public void setAcceptSubscribe(boolean acceptSubscribe) {
        this.acceptSubscribe = acceptSubscribe;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public String getDeleteWhen() {
        return this.deleteWhen;
    }

    public void setDeleteWhen(String deleteWhen) {
        this.deleteWhen = deleteWhen;
    }

    public String getDeletePolicy() {
        return this.deletePolicy;
    }

    public void setDeletePolicy(String deletePolicy) {
        this.deletePolicy = deletePolicy;
    }

    public int getMemCacheMsgSize() {
        return this.memCacheMsgSize;
    }

    public void setMemCacheMsgSize(int memCacheMsgSize) {
        this.memCacheMsgSize = memCacheMsgSize;
    }

    public int getMemCacheMsgCnt() {
        return this.memCacheMsgCnt;
    }

    public void setMemCacheMsgCnt(int memCacheMsgCnt) {
        this.memCacheMsgCnt = memCacheMsgCnt;
    }

    public int getMemCacheFlushInterval() {
        return this.memCacheFlushInterval;
    }

    public void setMemCacheFlushInterval(int memCacheFlushInterval) {
        this.memCacheFlushInterval = memCacheFlushInterval;
    }
}

