/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.msgstore.mem;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.inlong.tubemq.server.broker.metadata.ClusterConfigHolder;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.MsgFileStore;
import org.apache.inlong.tubemq.server.broker.msgstore.mem.GetCacheMsgResult;
import org.apache.inlong.tubemq.server.broker.stats.BrokerSrvStatsHolder;
import org.apache.inlong.tubemq.server.broker.stats.MsgStoreStatsHolder;
import org.apache.inlong.tubemq.server.common.utils.AppendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.nio.ch.DirectBuffer;

public class MsgMemStore
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(MsgMemStore.class);
    private final AtomicInteger cacheDataOffset = new AtomicInteger(0);
    private final AtomicInteger cacheIndexOffset = new AtomicInteger(0);
    private final AtomicInteger curMessageCount = new AtomicInteger(0);
    private final ReentrantLock writeLock = new ReentrantLock();
    private final Map<Integer, Integer> queuesMap = new HashMap<Integer, Integer>(20);
    private final Map<Integer, Integer> keysMap = new HashMap<Integer, Integer>(100);
    private final int maxDataCacheSize;
    private long writeDataStartPos = -1L;
    private final ByteBuffer cacheDataSegment;
    private final int maxIndexCacheSize;
    private long writeIndexStartPos = -1L;
    private final ByteBuffer cachedIndexSegment;
    private final int maxAllowedMsgCount;
    private final AtomicLong leftAppendTime = new AtomicLong(-2L);
    private final AtomicLong rightAppendTime = new AtomicLong(-2L);

    public MsgMemStore(int maxCacheSize, int maxMsgCount, long writeDataStartPos, long writeIndexStartPos) {
        this.maxDataCacheSize = maxCacheSize;
        this.maxAllowedMsgCount = maxMsgCount;
        this.maxIndexCacheSize = this.maxAllowedMsgCount * 28;
        this.cacheDataSegment = ByteBuffer.allocateDirect(this.maxDataCacheSize);
        this.cachedIndexSegment = ByteBuffer.allocateDirect(this.maxIndexCacheSize);
        this.leftAppendTime.set(System.currentTimeMillis());
        this.rightAppendTime.set(System.currentTimeMillis());
        this.writeDataStartPos = writeDataStartPos;
        this.writeIndexStartPos = writeIndexStartPos;
    }

    public void resetMemStoreStatus(long writeDataStartPos, long writeIndexStartPos) {
        this.keysMap.clear();
        this.queuesMap.clear();
        this.cacheDataOffset.set(0);
        this.cacheIndexOffset.set(0);
        this.curMessageCount.set(0);
        this.cacheDataSegment.rewind();
        this.cachedIndexSegment.rewind();
        this.writeDataStartPos = writeDataStartPos;
        this.writeIndexStartPos = writeIndexStartPos;
        this.leftAppendTime.set(System.currentTimeMillis());
        this.rightAppendTime.set(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendMsg(MsgStoreStatsHolder memStatsHolder, int partitionId, int keyCode, long timeRecv, ByteBuffer indexEntry, int dataEntryLength, ByteBuffer dataEntry, AppendResult appendResult) {
        long dataOffset;
        long indexOffset;
        boolean isAppended = true;
        boolean fullDataSize = false;
        boolean fullIndexSize = false;
        boolean fullCount = false;
        this.writeLock.lock();
        try {
            fullDataSize = this.cacheDataOffset.get() + dataEntryLength > this.maxDataCacheSize;
            fullCount = this.curMessageCount.get() + 1 > this.maxAllowedMsgCount;
            boolean bl = fullIndexSize = this.cacheIndexOffset.get() + 28 > this.maxIndexCacheSize;
            if (fullDataSize || fullCount || fullIndexSize) {
                isAppended = false;
                boolean bl2 = false;
                return bl2;
            }
            indexOffset = this.writeIndexStartPos + (long)this.cacheIndexOffset.get();
            dataOffset = this.writeDataStartPos + (long)this.cacheDataOffset.get();
            indexEntry.putLong(4, dataOffset);
            dataEntry.putLong(16, indexOffset);
            this.cacheDataSegment.put(dataEntry.array());
            this.cachedIndexSegment.put(indexEntry.array());
            this.cacheDataOffset.getAndAdd(dataEntryLength);
            int indexSizePos = this.cacheIndexOffset.getAndAdd(28);
            this.queuesMap.put(partitionId, indexSizePos);
            this.keysMap.put(keyCode, indexSizePos);
            this.curMessageCount.getAndIncrement();
            this.rightAppendTime.set(timeRecv);
            if (indexSizePos == 0) {
                this.leftAppendTime.set(timeRecv);
            }
        }
        finally {
            this.writeLock.unlock();
            if (!isAppended) {
                memStatsHolder.addCacheFullType(fullDataSize, fullIndexSize, fullCount);
            }
        }
        appendResult.putAppendResult(indexOffset, dataOffset);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetCacheMsgResult getMessages(long lstRdDataOffset, long lstRdIndexOffset, int maxReadSize, int maxReadCount, int partitionId, boolean isSecond, boolean isFilterConsume, Set<Integer> filterKeySet, long reqRcvTime) {
        int currIndexOffset;
        int currDataOffset;
        Integer lastWritePos = 0;
        boolean hasMsg = false;
        ArrayList<ByteBuffer> cacheMsgList = new ArrayList<ByteBuffer>();
        if (lstRdIndexOffset < this.writeIndexStartPos) {
            return new GetCacheMsgResult(false, 301, lstRdIndexOffset, "Request offset lower than cache minOffset");
        }
        if (lstRdIndexOffset >= this.writeIndexStartPos + (long)this.cacheIndexOffset.get()) {
            return new GetCacheMsgResult(false, 404, lstRdIndexOffset, "Request offset reached cache maxOffset");
        }
        int totalReadSize = 0;
        long lastDataRdOff = lstRdDataOffset;
        int startReadOff = (int)(lstRdIndexOffset - this.writeIndexStartPos);
        this.writeLock.lock();
        try {
            if (isFilterConsume) {
                for (Integer keyCode : filterKeySet) {
                    if (keyCode == null || (lastWritePos = this.keysMap.get(keyCode)) == null || lastWritePos < startReadOff) continue;
                    hasMsg = true;
                    break;
                }
            } else {
                lastWritePos = this.queuesMap.get(partitionId);
                if (lastWritePos != null && lastWritePos >= startReadOff) {
                    hasMsg = true;
                }
            }
            currDataOffset = this.cacheDataOffset.get();
            currIndexOffset = this.cacheIndexOffset.get();
            lastDataRdOff = this.writeDataStartPos + (long)currDataOffset;
        }
        finally {
            this.writeLock.unlock();
        }
        int limitReadSize = currIndexOffset - startReadOff;
        if (!hasMsg) {
            if (isSecond && !isFilterConsume) {
                return new GetCacheMsgResult(true, 0, "Ok2", lstRdIndexOffset, limitReadSize, lastDataRdOff, totalReadSize, cacheMsgList);
            }
            return new GetCacheMsgResult(false, 404, "Can't found Message by index!", lstRdIndexOffset, limitReadSize, lastDataRdOff, totalReadSize, cacheMsgList);
        }
        int readedSize = 0;
        int cPartitionId = 0;
        long cDataPos = 0L;
        int cDataSize = 0;
        int cKeyCode = 0;
        long cTimeRecv = 0L;
        int cDataOffset = 0;
        ByteBuffer tmpIndexRdBuf = this.cachedIndexSegment.asReadOnlyBuffer();
        ByteBuffer tmpDataRdBuf = this.cacheDataSegment.asReadOnlyBuffer();
        for (int count = 0; count < maxReadCount && startReadOff < currIndexOffset && startReadOff + 28 <= currIndexOffset; ++count, startReadOff += 28) {
            tmpIndexRdBuf.position(startReadOff);
            cPartitionId = tmpIndexRdBuf.getInt();
            cDataPos = tmpIndexRdBuf.getLong();
            cDataSize = tmpIndexRdBuf.getInt();
            cKeyCode = tmpIndexRdBuf.getInt();
            cTimeRecv = tmpIndexRdBuf.getLong();
            cDataOffset = (int)(cDataPos - this.writeDataStartPos);
            if (cDataOffset < 0 || cDataSize <= 0 || cDataOffset >= currDataOffset || cDataSize > ClusterConfigHolder.getMaxMsgSize() || cDataOffset + cDataSize > currDataOffset) {
                readedSize += 28;
                continue;
            }
            if (cPartitionId != partitionId || isFilterConsume && !filterKeySet.contains(cKeyCode)) {
                readedSize += 28;
                continue;
            }
            if (reqRcvTime != 0L && cTimeRecv < reqRcvTime) continue;
            byte[] tmpArray = new byte[cDataSize];
            ByteBuffer buffer = ByteBuffer.wrap(tmpArray);
            tmpDataRdBuf.position(cDataOffset);
            tmpDataRdBuf.get(tmpArray);
            buffer.rewind();
            cacheMsgList.add(buffer);
            lastDataRdOff = cDataPos + (long)cDataSize;
            readedSize += 28;
            if ((totalReadSize += cDataSize) >= maxReadSize) break;
        }
        return new GetCacheMsgResult(true, 0, "Ok1", lstRdIndexOffset, readedSize, lastDataRdOff, totalReadSize, cacheMsgList);
    }

    public void batchFlush(MsgFileStore msgFileStore, StringBuilder strBuffer) throws Throwable {
        if (this.curMessageCount.get() == 0) {
            return;
        }
        ByteBuffer tmpIndexBuffer = this.cachedIndexSegment.asReadOnlyBuffer();
        ByteBuffer tmpDataReadBuf = this.cacheDataSegment.asReadOnlyBuffer();
        tmpIndexBuffer.flip();
        tmpDataReadBuf.flip();
        long startTime = System.currentTimeMillis();
        msgFileStore.appendMsg(true, startTime, strBuffer, this.curMessageCount.get(), this.cacheIndexOffset.get(), tmpIndexBuffer, this.cacheDataOffset.get(), tmpDataReadBuf, this.leftAppendTime.get(), this.rightAppendTime.get());
        BrokerSrvStatsHolder.updDiskSyncDataDlt(System.currentTimeMillis() - startTime);
    }

    public int getCurMsgCount() {
        return this.curMessageCount.get();
    }

    public int getCurDataCacheSize() {
        return this.cacheDataOffset.get();
    }

    public int getIndexCacheSize() {
        return this.cacheIndexOffset.get();
    }

    public int getMaxDataCacheSize() {
        return this.maxDataCacheSize;
    }

    public int getMaxAllowedMsgCount() {
        return this.maxAllowedMsgCount;
    }

    public int isOffsetInHold(long requestOffset) {
        if (requestOffset < this.writeIndexStartPos) {
            return -1;
        }
        if (requestOffset >= this.writeIndexStartPos + (long)this.cacheIndexOffset.get()) {
            return 1;
        }
        return 0;
    }

    public long getDataLastWritePos() {
        return this.writeDataStartPos + (long)this.cacheDataOffset.get();
    }

    public long getIndexLastWritePos() {
        return this.writeIndexStartPos + (long)this.cacheIndexOffset.get();
    }

    public long getIndexStartWritePos() {
        return this.writeIndexStartPos;
    }

    public long getLeftAppendTime() {
        return this.leftAppendTime.get();
    }

    public long getRightAppendTime() {
        return this.rightAppendTime.get();
    }

    public int isTimestampInHold(long timestamp) {
        if (timestamp < this.leftAppendTime.get()) {
            return -1;
        }
        if (timestamp > this.rightAppendTime.get()) {
            return 1;
        }
        return 0;
    }

    public void clear() {
        this.writeDataStartPos = -1L;
        this.writeIndexStartPos = -1L;
        this.cacheDataOffset.set(0);
        this.cacheIndexOffset.set(0);
        this.curMessageCount.set(0);
        this.queuesMap.clear();
        this.keysMap.clear();
        this.cacheDataSegment.rewind();
        this.cachedIndexSegment.rewind();
        this.leftAppendTime.set(System.currentTimeMillis());
        this.rightAppendTime.set(System.currentTimeMillis());
    }

    @Override
    public void close() {
        ((DirectBuffer)((Object)this.cacheDataSegment)).cleaner().clean();
        ((DirectBuffer)((Object)this.cachedIndexSegment)).cleaner().clean();
    }
}

