/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.stats;

import java.lang.management.ManagementFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.inlong.tubemq.corebase.metric.MetricMXBean;
import org.apache.inlong.tubemq.server.broker.stats.BrokerSrvStatsHolder;
import org.apache.inlong.tubemq.server.common.webbase.WebCallStatsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerJMXHolder {
    private static final Logger logger = LoggerFactory.getLogger(BrokerJMXHolder.class);
    private static final AtomicBoolean registered = new AtomicBoolean(false);
    private static final BrokerServiceStatusBean serviceStatusInfo = new BrokerServiceStatusBean();
    private static final BrokerWebAPIStatusBean webAPIStatusInfo = new BrokerWebAPIStatusBean();

    public static void registerMXBean() {
        if (!registered.compareAndSet(false, true)) {
            return;
        }
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName srvStatusMxBeanName = new ObjectName("org.apache.inlong.tubemq.server.broker:type=serviceStatus");
            mbs.registerMBean(serviceStatusInfo, srvStatusMxBeanName);
            ObjectName webAPIMxBeanName = new ObjectName("org.apache.inlong.tubemq.server.broker:type=webAPI");
            mbs.registerMBean(webAPIStatusInfo, webAPIMxBeanName);
        }
        catch (Exception ex) {
            logger.error("Register Broker MXBean error: ", (Throwable)ex);
        }
    }

    private static class BrokerWebAPIStatusBean
    implements MetricMXBean {
        private BrokerWebAPIStatusBean() {
        }

        public Map<String, Long> getValue() {
            LinkedHashMap<String, Long> metricValues = new LinkedHashMap<String, Long>();
            WebCallStatsHolder.getValue(metricValues);
            return metricValues;
        }

        public Map<String, Long> snapshot() {
            LinkedHashMap<String, Long> metricValues = new LinkedHashMap<String, Long>();
            WebCallStatsHolder.snapShort(metricValues);
            return metricValues;
        }
    }

    private static class BrokerServiceStatusBean
    implements MetricMXBean {
        private BrokerServiceStatusBean() {
        }

        public Map<String, Long> getValue() {
            LinkedHashMap<String, Long> metricValues = new LinkedHashMap<String, Long>();
            BrokerSrvStatsHolder.getValue(metricValues);
            return metricValues;
        }

        public Map<String, Long> snapshot() {
            LinkedHashMap<String, Long> metricValues = new LinkedHashMap<String, Long>();
            BrokerSrvStatsHolder.snapShort(metricValues);
            return metricValues;
        }
    }
}

