/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.utils;

public class IdWorker {
    private static final long twepoch = 1350282310830L;
    private static final long workerIdBits = 10L;
    private static final long maxWorkerId = 1023L;
    private static final long sequenceBits = 12L;
    private static final long workerIdShift = 12L;
    private static final long timestampLeftShift = 22L;
    private static final long sequenceMask = 4095L;
    private final long workerId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public IdWorker(long workerId) {
        if (workerId > 1023L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id required in range [%d , 0]", 1023L));
        }
        this.workerId = workerId;
    }

    public synchronized long nextId() {
        long timestamp = System.nanoTime();
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tillNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return Math.abs(timestamp - 1350282310830L << 22 | this.workerId << 12 | this.sequence);
    }

    private long tillNextMillis(long lastTimestamp) {
        long timestamp = System.nanoTime();
        while (timestamp <= lastTimestamp) {
            timestamp = System.nanoTime();
        }
        return timestamp;
    }
}

