/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.bdbimpl;

import com.sleepycat.je.Environment;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.StoreConfig;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.server.common.exception.LoadMetaException;
import org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys.BdbGroupFlowCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupResCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.AbsGroupResCtrlMapperImpl;

public class BdbGroupResCtrlMapperImpl
extends AbsGroupResCtrlMapperImpl {
    private EntityStore groupConfStore;
    private final PrimaryIndex<String, BdbGroupFlowCtrlEntity> groupBaseCtrlIndex;

    public BdbGroupResCtrlMapperImpl(ReplicatedEnvironment repEnv, StoreConfig storeConfig) {
        this.groupConfStore = new EntityStore((Environment)repEnv, "bdbGroupFlowCtrlCfg", storeConfig);
        this.groupBaseCtrlIndex = this.groupConfStore.getPrimaryIndex(String.class, BdbGroupFlowCtrlEntity.class);
    }

    @Override
    public void close() {
        this.clearCachedData();
        if (this.groupConfStore != null) {
            try {
                this.groupConfStore.close();
                this.groupConfStore = null;
            }
            catch (Throwable e) {
                logger.error("[BDB Impl] close group control configure failure ", e);
            }
        }
        logger.info("[BDB Impl] group control configure closed!");
    }

    @Override
    public void loadConfig(StringBuilder strBuff) throws LoadMetaException {
        long totalCnt = 0L;
        EntityCursor cursor = null;
        logger.info("[BDB Impl] load group control configure start...");
        this.clearCachedData();
        try {
            cursor = this.groupBaseCtrlIndex.entities();
            for (BdbGroupFlowCtrlEntity bdbEntity : cursor) {
                if (bdbEntity == null) {
                    logger.warn("[BDB Impl] null data while loading group control configure!");
                    continue;
                }
                this.putRecord2Caches(new GroupResCtrlEntity(bdbEntity));
                ++totalCnt;
            }
        }
        catch (Exception e) {
            logger.error("[BDB Impl] load group control configure failure ", (Throwable)e);
            throw new LoadMetaException(e.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        logger.info(strBuff.append("[BDB Impl] loaded ").append(totalCnt).append(" group control configure successfully...").toString());
        strBuff.delete(0, strBuff.length());
    }

    @Override
    protected boolean putConfig2Persistent(GroupResCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        BdbGroupFlowCtrlEntity bdbEntity = entity.buildBdbGroupFlowCtrlEntity();
        try {
            this.groupBaseCtrlIndex.put((Object)bdbEntity);
        }
        catch (Throwable e) {
            logger.error("[BDB Impl] put group control configure failure ", e);
            result.setFailResult(DataOpErrCode.DERR_STORE_ABNORMAL.getCode(), strBuff.append("Put group control configure failure: ").append(e.getMessage()).toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    protected boolean delConfigFromPersistent(String recordKey, StringBuilder strBuff) {
        try {
            this.groupBaseCtrlIndex.delete((Object)recordKey);
        }
        catch (Throwable e) {
            logger.error("[BDB Impl] delete control configure failure ", e);
            return false;
        }
        return true;
    }
}

