/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;
import org.apache.inlong.tubemq.server.common.utils.WebParameterUtils;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupResCtrlEntity;
import org.apache.inlong.tubemq.server.master.web.handler.AbstractWebHandler;
import org.apache.inlong.tubemq.server.master.web.handler.GroupProcessResult;

@Deprecated
public class WebAdminFlowRuleHandler
extends AbstractWebHandler {
    private static final String blankFlowCtrlRules = "[]";
    private static final List<Integer> allowedPriorityVal = Arrays.asList(1, 2, 3);
    private static final Set<String> rsvGroupNameSet = new HashSet<String>(Arrays.asList("default_master_ctrl"));

    public WebAdminFlowRuleHandler(TMaster master) {
        super(master);
    }

    @Override
    public void registerWebApiMethod() {
        this.registerQueryWebMethod("admin_query_group_flow_control_rule", "adminQueryGroupFlowCtrlRule");
        this.registerModifyWebMethod("admin_set_group_flow_control_rule", "adminSetGroupFlowCtrlRule");
        this.registerModifyWebMethod("admin_rmv_group_flow_control_rule", "adminDelGroupFlowCtrlRule");
        this.registerModifyWebMethod("admin_upd_group_flow_control_rule", "adminUpdGroupFlowCtrlRule");
    }

    public StringBuilder adminQueryGroupFlowCtrlRule(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        GroupResCtrlEntity qryEntity = new GroupResCtrlEntity();
        if (!WebParameterUtils.getQueriedOperateInfo(req, qryEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getQryPriorityIdParameter(req, false, -2, 101, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int inQryPriorityId = (Integer)result.getRetData();
        if (!WebParameterUtils.getFlowCtrlStatusParamValue(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        EnableStatus flowCtrlEnable = (EnableStatus)((Object)result.getRetData());
        qryEntity.updModifyInfo(qryEntity.getDataVerId(), null, -2, inQryPriorityId, flowCtrlEnable, -2, null);
        Map<String, GroupResCtrlEntity> groupResCtrlEntityMap = this.defMetaDataService.getGroupCtrlConf(groupNameSet, qryEntity);
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (GroupResCtrlEntity resCtrlEntity : groupResCtrlEntityMap.values()) {
            if (resCtrlEntity == null) continue;
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            sBuffer = resCtrlEntity.toOldVerFlowCtrlWebJsonStr(sBuffer, true);
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    public StringBuilder adminSetGroupFlowCtrlRule(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdGroupFlowCtrlRule(req, sBuffer, result, true);
    }

    public StringBuilder adminUpdGroupFlowCtrlRule(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdGroupFlowCtrlRule(req, sBuffer, result, false);
    }

    public StringBuilder adminDelGroupFlowCtrlRule(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        ArrayList<GroupProcessResult> retInfoList = new ArrayList<GroupProcessResult>();
        for (String groupName : groupNameSet) {
            GroupResCtrlEntity ctrlEntity = this.defMetaDataService.getGroupCtrlConf(groupName);
            if (ctrlEntity != null && ctrlEntity.getFlowCtrlStatus() != EnableStatus.STATUS_DISABLE) {
                retInfoList.add(this.defMetaDataService.insertGroupCtrlConf(opEntity, groupName, 301, EnableStatus.STATUS_DISABLE, 0, blankFlowCtrlRules, sBuffer, result));
                continue;
            }
            result.setFullInfo(true, DataOpErrCode.DERR_SUCCESS.getCode(), "Ok");
            retInfoList.add(new GroupProcessResult(groupName, "", result));
        }
        return this.buildRetInfo(retInfoList, sBuffer);
    }

    private StringBuilder innAddOrUpdGroupFlowCtrlRule(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, boolean isAddOp) {
        if (!WebParameterUtils.getAUDBaseInfo(req, isAddOp, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getQryPriorityIdParameter(req, false, -2, 101, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int qryPriorityId = (Integer)result.getRetData();
        if (!WebParameterUtils.getFlowCtrlStatusParamValue(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        EnableStatus flowCtrlEnable = (EnableStatus)((Object)result.getRetData());
        int flowRuleCnt = WebParameterUtils.getAndCheckFlowRules(req, isAddOp ? blankFlowCtrlRules : null, sBuffer, result);
        if (!result.isSuccess()) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        String flowCtrlInfo = (String)result.getRetData();
        ArrayList<GroupProcessResult> retInfoList = new ArrayList<GroupProcessResult>();
        for (String groupName : groupNameSet) {
            GroupResCtrlEntity ctrlEntity = this.defMetaDataService.getGroupCtrlConf(groupName);
            if (ctrlEntity == null) {
                if (isAddOp) {
                    retInfoList.add(this.defMetaDataService.insertGroupCtrlConf(opEntity, groupName, qryPriorityId, flowCtrlEnable, flowRuleCnt, flowCtrlInfo, sBuffer, result));
                    continue;
                }
                result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), DataOpErrCode.DERR_NOT_EXIST.getDescription());
                retInfoList.add(new GroupProcessResult(groupName, "", result));
                continue;
            }
            retInfoList.add(this.defMetaDataService.insertGroupCtrlConf(opEntity, groupName, qryPriorityId, flowCtrlEnable, flowRuleCnt, flowCtrlInfo, sBuffer, result));
        }
        return this.buildRetInfo(retInfoList, sBuffer);
    }

    private StringBuilder buildRetInfo(List<GroupProcessResult> retInfo, StringBuilder sBuffer) {
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (GroupProcessResult entry : retInfo) {
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            sBuffer.append("{\"groupName\":\"").append(entry.getGroupName()).append("\"").append(",\"success\":").append(entry.isSuccess()).append(",\"errCode\":").append(entry.getErrCode()).append(",\"errInfo\":\"").append(entry.getErrMsg()).append("\"}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }
}

