/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;
import org.apache.inlong.tubemq.server.common.utils.WebParameterUtils;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupConsumeCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupResCtrlEntity;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumeGroupInfo;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumerInfoHolder;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.NodeRebInfo;
import org.apache.inlong.tubemq.server.master.web.handler.AbstractWebHandler;
import org.apache.inlong.tubemq.server.master.web.handler.GroupProcessResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class WebAdminGroupCtrlHandler
extends AbstractWebHandler {
    private static final Logger logger = LoggerFactory.getLogger(WebAdminGroupCtrlHandler.class);

    public WebAdminGroupCtrlHandler(TMaster master) {
        super(master);
    }

    @Override
    public void registerWebApiMethod() {
        this.registerQueryWebMethod("admin_query_black_consumer_group_info", "adminQueryBlackGroupInfo");
        this.registerQueryWebMethod("admin_query_allowed_consumer_group_info", "adminQueryConsumerGroupInfo");
        this.registerQueryWebMethod("admin_query_group_filtercond_info", "adminQueryGroupFilterCondInfo");
        this.registerQueryWebMethod("admin_query_consume_group_setting", "adminQueryConsumeGroupSetting");
        this.registerModifyWebMethod("admin_add_black_consumergroup_info", "adminAddBlackGroupInfo");
        this.registerModifyWebMethod("admin_bath_add_black_consumergroup_info", "adminBatchAddBlackGroupInfo");
        this.registerModifyWebMethod("admin_delete_black_consumergroup_info", "adminDeleteBlackGroupInfo");
        this.registerModifyWebMethod("admin_batch_delete_black_consumergroup_info", "adminBatchDeleteBlackGroupInfo");
        this.registerModifyWebMethod("admin_add_authorized_consumergroup_info", "adminAddConsumerGroupInfo");
        this.registerModifyWebMethod("admin_delete_allowed_consumer_group_info", "adminDeleteConsumerGroupInfo");
        this.registerModifyWebMethod("admin_batch_del_authorized_consumergroup_info", "adminBatchDelConsumerGroupInfo");
        this.registerModifyWebMethod("admin_bath_add_authorized_consumergroup_info", "adminBatchAddConsumerGroupInfo");
        this.registerModifyWebMethod("admin_add_group_filtercond_info", "adminAddGroupFilterCondInfo");
        this.registerModifyWebMethod("admin_bath_add_group_filtercond_info", "adminBatchAddGroupFilterCondInfo");
        this.registerModifyWebMethod("admin_mod_group_filtercond_info", "adminModGroupFilterCondInfo");
        this.registerModifyWebMethod("admin_bath_mod_group_filtercond_info", "adminBatchModGroupFilterCondInfo");
        this.registerModifyWebMethod("admin_del_group_filtercond_info", "adminDeleteGroupFilterCondInfo");
        this.registerModifyWebMethod("admin_add_consume_group_setting", "adminAddConsumeGroupSettingInfo");
        this.registerModifyWebMethod("admin_bath_add_consume_group_setting", "adminBatchAddConsumeGroupSetting");
        this.registerModifyWebMethod("admin_upd_consume_group_setting", "adminUpdConsumeGroupSetting");
        this.registerModifyWebMethod("admin_del_consume_group_setting", "adminDeleteConsumeGroupSetting");
        this.registerModifyWebMethod("admin_rebalance_group_allocate", "adminRebalanceGroupAllocateInfo");
        this.registerModifyWebMethod("admin_set_client_balance_group_consume_from_max", "adminSetBalanceGroupConsumeFromMax");
        this.registerQueryWebMethod("admin_query_client_balance_group_set", "adminQueryClientBalanceGroupSet");
    }

    public StringBuilder adminQueryBlackGroupInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        GroupConsumeCtrlEntity entity = new GroupConsumeCtrlEntity();
        if (!WebParameterUtils.getQueriedOperateInfo(req, entity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        entity.setConsumeEnable(EnableStatus.STATUS_DISABLE);
        Map<String, List<GroupConsumeCtrlEntity>> qryResult = this.defMetaDataService.getGroupConsumeCtrlConf(groupNameSet, topicNameSet, entity);
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (List<GroupConsumeCtrlEntity> entryList : qryResult.values()) {
            for (GroupConsumeCtrlEntity entry : entryList) {
                if (totalCnt++ > 0) {
                    sBuffer.append(",");
                }
                sBuffer.append("{\"groupName\":\"").append(entry.getGroupName()).append("\",\"topicName\":\"").append(entry.getTopicName()).append("\",\"reason\":\"").append(entry.getDisableReason()).append("\",\"dataVersionId\":").append(entry.getDataVerId()).append(",\"createUser\":\"").append(entry.getCreateUser()).append("\",\"createDate\":\"").append(entry.getCreateDateStr()).append("\",\"modifyUser\":\"").append(entry.getModifyUser()).append("\",\"modifyDate\":\"").append(entry.getModifyDateStr()).append("\"}");
            }
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    public StringBuilder adminQueryConsumerGroupInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        GroupConsumeCtrlEntity qryEntity = new GroupConsumeCtrlEntity();
        if (!WebParameterUtils.getQueriedOperateInfo(req, qryEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        qryEntity.setConsumeEnable(EnableStatus.STATUS_ENABLE);
        Map<String, List<GroupConsumeCtrlEntity>> qryResultMap = this.defMetaDataService.getGroupConsumeCtrlConf(groupNameSet, topicNameSet, qryEntity);
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (List<GroupConsumeCtrlEntity> entryLst : qryResultMap.values()) {
            if (entryLst == null || entryLst.isEmpty()) continue;
            for (GroupConsumeCtrlEntity entry : entryLst) {
                if (entry == null) continue;
                if (totalCnt++ > 0) {
                    sBuffer.append(",");
                }
                sBuffer.append("{\"topicName\":\"").append(entry.getTopicName()).append("\",\"groupName\":\"").append(entry.getGroupName()).append("\",\"dataVersionId\":").append(entry.getDataVerId()).append(",\"createUser\":\"").append(entry.getCreateUser()).append("\",\"createDate\":\"").append(entry.getCreateDateStr()).append("\",\"modifyUser\":\"").append(entry.getModifyUser()).append("\",\"modifyDate\":\"").append(entry.getModifyDateStr()).append("\"}");
            }
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    public StringBuilder adminQueryGroupFilterCondInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        GroupConsumeCtrlEntity qryEntity = new GroupConsumeCtrlEntity();
        if (!WebParameterUtils.getQueriedOperateInfo(req, qryEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!this.getCondStatusParamValue(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        EnableStatus filterEnable = (EnableStatus)((Object)result.getRetData());
        if (!WebParameterUtils.getFilterCondSet(req, false, true, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set filterCondSet = (Set)result.getRetData();
        qryEntity.updModifyInfo(qryEntity.getDataVerId(), null, null, filterEnable, null);
        Map<String, List<GroupConsumeCtrlEntity>> qryResultMap = this.defMetaDataService.getGroupConsumeCtrlConf(groupNameSet, topicNameSet, qryEntity);
        int totalCnt = 0;
        int condStatusId = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (List<GroupConsumeCtrlEntity> consumeCtrlEntityList : qryResultMap.values()) {
            if (consumeCtrlEntityList == null || consumeCtrlEntityList.isEmpty()) continue;
            for (GroupConsumeCtrlEntity entry : consumeCtrlEntityList) {
                if (entry == null || !WebParameterUtils.isFilterSetFullIncluded(filterCondSet, entry.getFilterCondStr())) continue;
                if (totalCnt++ > 0) {
                    sBuffer.append(",");
                }
                condStatusId = entry.getFilterEnable().isEnable() ? 2 : 0;
                String itemFilterStr = entry.getFilterCondStr().length() <= 2 ? "" : entry.getFilterCondStr();
                sBuffer.append("{\"topicName\":\"").append(entry.getTopicName()).append("\",\"groupName\":\"").append(entry.getGroupName()).append("\",\"condStatus\":").append(condStatusId).append(",\"filterConds\":\"").append(itemFilterStr).append("\",\"dataVersionId\":").append(entry.getDataVerId()).append(",\"createUser\":\"").append(entry.getCreateUser()).append("\",\"createDate\":\"").append(entry.getCreateDateStr()).append("\",\"modifyUser\":\"").append(entry.getModifyUser()).append("\",\"modifyDate\":\"").append(entry.getModifyDateStr()).append("\"}");
            }
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    public StringBuilder adminQueryConsumeGroupSetting(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        GroupResCtrlEntity entity = new GroupResCtrlEntity();
        if (!WebParameterUtils.getQueriedOperateInfo(req, entity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.OLDALWDBCRATE, false, -2, 0, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int allowedBClientRate = (Integer)result.getRetData();
        entity.updModifyInfo(entity.getDataVerId(), null, allowedBClientRate, -2, null, -2, null);
        Map<String, GroupResCtrlEntity> groupResCtrlEntityMap = this.defMetaDataService.getGroupCtrlConf(groupNameSet, entity);
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (GroupResCtrlEntity entry : groupResCtrlEntityMap.values()) {
            if (entry == null) continue;
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            sBuffer.append("{\"groupName\":\"").append(entry.getGroupName()).append("\",\"enableBind\":1,\"allowedBClientRate\":").append(entry.getAllowedBrokerClientRate()).append(",\"attributes\":\"\",\"lastBindUsedDate\":\"-\"").append(",\"dataVersionId\":").append(entry.getDataVerId()).append(",\"createUser\":\"").append(entry.getCreateUser()).append("\",\"createDate\":\"").append(entry.getCreateDateStr()).append("\",\"modifyUser\":\"").append(entry.getModifyUser()).append("\",\"modifyDate\":\"").append(entry.getModifyDateStr()).append("\"}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    public StringBuilder adminAddBlackGroupInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getAndValidTopicNameInfo(req, this.defMetaDataService, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        ArrayList<GroupProcessResult> retInfoList = new ArrayList<GroupProcessResult>();
        for (String groupName : groupNameSet) {
            for (String topicName : topicNameSet) {
                GroupConsumeCtrlEntity ctrlEntity = this.defMetaDataService.getConsumeCtrlByGroupAndTopic(groupName, topicName);
                if (ctrlEntity != null && ctrlEntity.getConsumeEnable() == EnableStatus.STATUS_DISABLE) {
                    result.setFailResult(DataOpErrCode.DERR_SUCCESS.getCode(), "Ok!");
                    retInfoList.add(new GroupProcessResult(groupName, topicName, result));
                    continue;
                }
                retInfoList.add(this.defMetaDataService.insertConsumeCtrlInfo(opEntity, groupName, topicName, EnableStatus.STATUS_DISABLE, "Old API add blacklist, disable consume", null, null, sBuffer, result));
            }
        }
        return this.buildRetInfo(retInfoList, sBuffer);
    }

    public StringBuilder adminBatchAddBlackGroupInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!this.getGroupCsmJsonSetInfo(req, opEntity, EnableStatus.STATUS_DISABLE, "Old API batch set BlackList", sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Map addRecordMap = (Map)result.getRetData();
        ArrayList<GroupProcessResult> retInfoList = new ArrayList<GroupProcessResult>();
        for (GroupConsumeCtrlEntity entry : addRecordMap.values()) {
            GroupConsumeCtrlEntity ctrlEntity = this.defMetaDataService.getConsumeCtrlByGroupAndTopic(entry.getGroupName(), entry.getTopicName());
            if (ctrlEntity != null && ctrlEntity.getConsumeEnable() == EnableStatus.STATUS_DISABLE) {
                result.setFailResult(DataOpErrCode.DERR_SUCCESS.getCode(), "Ok!");
                retInfoList.add(new GroupProcessResult(entry.getGroupName(), entry.getTopicName(), result));
                continue;
            }
            retInfoList.add(this.defMetaDataService.insertConsumeCtrlInfo(entry, sBuffer, result));
        }
        return this.buildRetInfo(retInfoList, sBuffer);
    }

    public StringBuilder adminDeleteBlackGroupInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        ArrayList<GroupProcessResult> retInfoList = new ArrayList<GroupProcessResult>();
        if (groupNameSet.isEmpty()) {
            Map<String, List<GroupConsumeCtrlEntity>> topicConsumeCtrlMap = this.defMetaDataService.getConsumeCtrlByGroupName(topicNameSet);
            for (Map.Entry<String, List<GroupConsumeCtrlEntity>> entry : topicConsumeCtrlMap.entrySet()) {
                if (!entry.getValue().isEmpty()) {
                    for (GroupConsumeCtrlEntity ctrlEntity : entry.getValue()) {
                        if (ctrlEntity == null || ctrlEntity.getConsumeEnable() == EnableStatus.STATUS_ENABLE) continue;
                        this.defMetaDataService.insertConsumeCtrlInfo(opEntity, ctrlEntity.getGroupName(), ctrlEntity.getTopicName(), EnableStatus.STATUS_ENABLE, "Old API delete blacklist, enable consume", null, null, sBuffer, result);
                    }
                }
                result.setFullInfo(true, DataOpErrCode.DERR_SUCCESS.getCode(), "Ok");
                retInfoList.add(new GroupProcessResult("", entry.getKey(), result));
            }
        } else {
            for (String groupName : groupNameSet) {
                for (String topicName : topicNameSet) {
                    GroupConsumeCtrlEntity ctrlEntity = this.defMetaDataService.getConsumeCtrlByGroupAndTopic(groupName, topicName);
                    if (ctrlEntity != null && ctrlEntity.getConsumeEnable() != EnableStatus.STATUS_ENABLE) {
                        retInfoList.add(this.defMetaDataService.insertConsumeCtrlInfo(opEntity, groupName, topicName, EnableStatus.STATUS_ENABLE, "Old API delete blacklist, enable consume", null, null, sBuffer, result));
                        continue;
                    }
                    result.setFullInfo(true, DataOpErrCode.DERR_SUCCESS.getCode(), "Ok");
                    retInfoList.add(new GroupProcessResult(groupName, topicName, result));
                }
            }
        }
        return this.buildRetInfo(retInfoList, sBuffer);
    }

    public StringBuilder adminBatchDeleteBlackGroupInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!this.getGroupCsmJsonSetInfo(req, opEntity, null, "Old API batch Disable consume", sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Map addRecordMap = (Map)result.getRetData();
        ArrayList<GroupProcessResult> retInfoList = new ArrayList<GroupProcessResult>();
        for (GroupConsumeCtrlEntity entry : addRecordMap.values()) {
            GroupConsumeCtrlEntity ctrlEntity = this.defMetaDataService.getConsumeCtrlByGroupAndTopic(entry.getGroupName(), entry.getTopicName());
            if (ctrlEntity != null && ctrlEntity.getConsumeEnable() != EnableStatus.STATUS_ENABLE) {
                retInfoList.add(this.defMetaDataService.insertConsumeCtrlInfo(opEntity, entry.getGroupName(), entry.getTopicName(), EnableStatus.STATUS_ENABLE, "Old API delete blacklist, enable consume", null, null, sBuffer, result));
                continue;
            }
            result.setFullInfo(true, DataOpErrCode.DERR_SUCCESS.getCode(), "Ok");
            retInfoList.add(new GroupProcessResult(entry.getGroupName(), entry.getTopicName(), result));
        }
        return this.buildRetInfo(retInfoList, sBuffer);
    }

    public StringBuilder adminAddConsumerGroupInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getAndValidTopicNameInfo(req, this.defMetaDataService, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        ArrayList<GroupProcessResult> retInfoList = new ArrayList<GroupProcessResult>();
        for (String groupName : groupNameSet) {
            for (String topicName : topicNameSet) {
                GroupConsumeCtrlEntity ctrlEntity = this.defMetaDataService.getConsumeCtrlByGroupAndTopic(groupName, topicName);
                if (ctrlEntity != null && ctrlEntity.getConsumeEnable() == EnableStatus.STATUS_ENABLE) {
                    result.setFailResult(DataOpErrCode.DERR_SUCCESS.getCode(), "Ok!");
                    retInfoList.add(new GroupProcessResult(groupName, topicName, result));
                    continue;
                }
                retInfoList.add(this.defMetaDataService.insertConsumeCtrlInfo(opEntity, groupName, topicName, EnableStatus.STATUS_ENABLE, "Old API add, enable consume", null, null, sBuffer, result));
            }
        }
        return this.buildRetInfo(retInfoList, sBuffer);
    }

    public StringBuilder adminBatchAddConsumerGroupInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!this.getGroupCsmJsonSetInfo(req, opEntity, EnableStatus.STATUS_ENABLE, "Old API batch set Enable Consume", sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Map addRecordMap = (Map)result.getRetData();
        ArrayList<GroupProcessResult> retInfoList = new ArrayList<GroupProcessResult>();
        for (GroupConsumeCtrlEntity entry : addRecordMap.values()) {
            GroupConsumeCtrlEntity ctrlEntity = this.defMetaDataService.getConsumeCtrlByGroupAndTopic(entry.getGroupName(), entry.getTopicName());
            if (ctrlEntity != null && ctrlEntity.getConsumeEnable() == EnableStatus.STATUS_ENABLE) {
                result.setFailResult(DataOpErrCode.DERR_SUCCESS.getCode(), "Ok!");
                retInfoList.add(new GroupProcessResult(entry.getGroupName(), entry.getTopicName(), result));
                continue;
            }
            retInfoList.add(this.defMetaDataService.insertConsumeCtrlInfo(entry, sBuffer, result));
        }
        return this.buildRetInfo(retInfoList, sBuffer);
    }

    public StringBuilder adminDeleteConsumerGroupInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        ArrayList<GroupProcessResult> retInfoList = new ArrayList<GroupProcessResult>();
        if (groupNameSet.isEmpty()) {
            Map<String, List<GroupConsumeCtrlEntity>> topicConsumeCtrlMap = this.defMetaDataService.getConsumeCtrlByGroupName(topicNameSet);
            for (Map.Entry<String, List<GroupConsumeCtrlEntity>> entry : topicConsumeCtrlMap.entrySet()) {
                if (!entry.getValue().isEmpty()) {
                    for (GroupConsumeCtrlEntity ctrlEntity : entry.getValue()) {
                        if (ctrlEntity == null || ctrlEntity.getConsumeEnable() == EnableStatus.STATUS_DISABLE) continue;
                        this.defMetaDataService.insertConsumeCtrlInfo(opEntity, ctrlEntity.getGroupName(), ctrlEntity.getTopicName(), EnableStatus.STATUS_DISABLE, "Old API delete, disable consume", null, null, sBuffer, result);
                    }
                }
                result.setFullInfo(true, DataOpErrCode.DERR_SUCCESS.getCode(), "Ok");
                retInfoList.add(new GroupProcessResult("", entry.getKey(), result));
            }
        } else {
            for (String groupName : groupNameSet) {
                for (String topicName : topicNameSet) {
                    GroupConsumeCtrlEntity ctrlEntity = this.defMetaDataService.getConsumeCtrlByGroupAndTopic(groupName, topicName);
                    if (ctrlEntity != null && ctrlEntity.getConsumeEnable() != EnableStatus.STATUS_DISABLE) {
                        retInfoList.add(this.defMetaDataService.insertConsumeCtrlInfo(opEntity, groupName, topicName, EnableStatus.STATUS_DISABLE, "Old API delete, disable consume", null, null, sBuffer, result));
                        continue;
                    }
                    result.setFullInfo(true, DataOpErrCode.DERR_SUCCESS.getCode(), "Ok");
                    retInfoList.add(new GroupProcessResult(groupName, topicName, result));
                }
            }
        }
        return this.buildRetInfo(retInfoList, sBuffer);
    }

    public StringBuilder adminBatchDelConsumerGroupInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!this.getGroupCsmJsonSetInfo(req, opEntity, EnableStatus.STATUS_DISABLE, "Old API batch delete Authorized Consume", sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Map addRecordMap = (Map)result.getRetData();
        ArrayList<GroupProcessResult> retInfoList = new ArrayList<GroupProcessResult>();
        for (GroupConsumeCtrlEntity entry : addRecordMap.values()) {
            GroupConsumeCtrlEntity ctrlEntity = this.defMetaDataService.getConsumeCtrlByGroupAndTopic(entry.getGroupName(), entry.getTopicName());
            if (ctrlEntity != null && ctrlEntity.getConsumeEnable() != EnableStatus.STATUS_DISABLE) {
                retInfoList.add(this.defMetaDataService.insertConsumeCtrlInfo(entry, sBuffer, result));
                continue;
            }
            result.setFullInfo(true, DataOpErrCode.DERR_SUCCESS.getCode(), "Ok");
            retInfoList.add(new GroupProcessResult(entry.getGroupName(), entry.getTopicName(), result));
        }
        return this.buildRetInfo(retInfoList, sBuffer);
    }

    public StringBuilder adminAddGroupFilterCondInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrModGroupFilterCondInfo(req, sBuffer, result, true);
    }

    public StringBuilder adminModGroupFilterCondInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrModGroupFilterCondInfo(req, sBuffer, result, false);
    }

    public StringBuilder adminBatchAddGroupFilterCondInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innBatchAddOrUpdGroupFilterCondInfo(req, sBuffer, result, true);
    }

    public StringBuilder adminBatchModGroupFilterCondInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innBatchAddOrUpdGroupFilterCondInfo(req, sBuffer, result, false);
    }

    public StringBuilder adminDeleteGroupFilterCondInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        ArrayList<GroupProcessResult> retInfoList = new ArrayList<GroupProcessResult>();
        if (groupNameSet.isEmpty()) {
            Map<String, List<GroupConsumeCtrlEntity>> topicConsumeCtrlMap = this.defMetaDataService.getConsumeCtrlByGroupName(topicNameSet);
            for (Map.Entry<String, List<GroupConsumeCtrlEntity>> entry : topicConsumeCtrlMap.entrySet()) {
                if (entry.getValue().isEmpty()) {
                    result.setFullInfo(true, DataOpErrCode.DERR_SUCCESS.getCode(), "Ok");
                    retInfoList.add(new GroupProcessResult("", entry.getKey(), result));
                    continue;
                }
                for (GroupConsumeCtrlEntity ctrlEntity : entry.getValue()) {
                    if (ctrlEntity == null || ctrlEntity.getFilterEnable() == EnableStatus.STATUS_DISABLE) continue;
                    this.defMetaDataService.insertConsumeCtrlInfo(opEntity, ctrlEntity.getGroupName(), ctrlEntity.getTopicName(), null, "Old API delete, disable filter", EnableStatus.STATUS_DISABLE, ",,", sBuffer, result);
                }
                result.setFullInfo(true, DataOpErrCode.DERR_SUCCESS.getCode(), "Ok");
                retInfoList.add(new GroupProcessResult("", entry.getKey(), result));
            }
        } else {
            for (String groupName : groupNameSet) {
                for (String topicName : topicNameSet) {
                    GroupConsumeCtrlEntity ctrlEntity = this.defMetaDataService.getConsumeCtrlByGroupAndTopic(groupName, topicName);
                    if (ctrlEntity != null && ctrlEntity.getFilterEnable() != EnableStatus.STATUS_DISABLE) {
                        retInfoList.add(this.defMetaDataService.insertConsumeCtrlInfo(opEntity, groupName, topicName, null, "Old API delete, disable filter", EnableStatus.STATUS_DISABLE, ",,", sBuffer, result));
                        continue;
                    }
                    result.setFullInfo(true, DataOpErrCode.DERR_SUCCESS.getCode(), "Ok");
                    retInfoList.add(new GroupProcessResult(groupName, topicName, result));
                }
            }
        }
        return this.buildRetInfo(retInfoList, sBuffer);
    }

    public StringBuilder adminRebalanceGroupAllocateInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.GROUPNAME, true, "", sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        String groupName = (String)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.REJOINWAIT, false, 0, 0, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int reJoinWait = (Integer)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSCONSUMERID, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set consumerIdSet = (Set)result.getRetData();
        ConsumerInfoHolder consumerInfoHolder = this.master.getConsumerHolder();
        ConsumeGroupInfo consumeGroupInfo = consumerInfoHolder.getConsumeGroupInfo(groupName);
        if (consumeGroupInfo == null) {
            String errInfo = sBuffer.append("The group(").append(groupName).append(") not online!").toString();
            sBuffer.delete(0, sBuffer.length());
            WebParameterUtils.buildFailResult(sBuffer, errInfo);
            return sBuffer;
        }
        Map<String, NodeRebInfo> nodeRebInfoMap = consumeGroupInfo.getBalanceMap();
        for (String consumerId : consumerIdSet) {
            if (!nodeRebInfoMap.containsKey(consumerId)) continue;
            String errInfo = sBuffer.append("Duplicated set for consumerId(").append(consumerId).append(") in group(").append(groupName).append(")! \"}").toString();
            sBuffer.delete(0, sBuffer.length());
            WebParameterUtils.buildFailResult(sBuffer, errInfo);
            return sBuffer;
        }
        logger.info(sBuffer.append("[Re-balance] Add rebalance consumer: group=").append(groupName).append(", consumerIds=").append(consumerIdSet.toString()).append(", reJoinWait=").append(reJoinWait).append(", creator=").append(opEntity.getModifyUser()).toString());
        sBuffer.delete(0, sBuffer.length());
        consumerInfoHolder.addRebConsumerInfo(groupName, consumerIdSet, reJoinWait);
        WebParameterUtils.buildSuccessResult(sBuffer);
        return sBuffer;
    }

    public StringBuilder adminAddConsumeGroupSettingInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdConsumeGroupSettingInfo(req, sBuffer, result, true);
    }

    public StringBuilder adminUpdConsumeGroupSetting(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdConsumeGroupSettingInfo(req, sBuffer, result, false);
    }

    public StringBuilder adminBatchAddConsumeGroupSetting(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!this.getGroupCtrlJsonSetInfo(req, opEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Map addRecordMap = (Map)result.getRetData();
        ArrayList<GroupProcessResult> retInfoList = new ArrayList<GroupProcessResult>();
        for (GroupResCtrlEntity resCtrlEntity : addRecordMap.values()) {
            retInfoList.add(this.defMetaDataService.insertGroupCtrlConf(resCtrlEntity, sBuffer, result));
        }
        return this.buildRetInfo(retInfoList, sBuffer);
    }

    public StringBuilder adminDeleteConsumeGroupSetting(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        ArrayList<GroupProcessResult> retInfoList = new ArrayList<GroupProcessResult>();
        for (String groupName : groupNameSet) {
            retInfoList.add(this.defMetaDataService.addOrUpdGroupCtrlConf(false, opEntity, groupName, EnableStatus.STATUS_DISABLE, 0, -2, null, -2, null, sBuffer, result));
        }
        return this.buildRetInfo(retInfoList, sBuffer);
    }

    private StringBuilder buildRetInfo(List<GroupProcessResult> retInfo, StringBuilder sBuffer) {
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (GroupProcessResult entry : retInfo) {
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            sBuffer.append("{\"groupName\":\"").append(entry.getGroupName()).append("\",\"success\":").append(entry.isSuccess()).append(",\"errCode\":").append(entry.getErrCode()).append(",\"errInfo\":\"").append(entry.getErrMsg()).append("\"}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    private StringBuilder innAddOrUpdConsumeGroupSettingInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, boolean isAddOp) {
        if (!WebParameterUtils.getAUDBaseInfo(req, isAddOp, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getEnableStatusValue(req, WebFieldDef.RESCHECKENABLE, false, isAddOp ? EnableStatus.STATUS_DISABLE : null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        EnableStatus resChkEnable = (EnableStatus)((Object)result.getRetData());
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.OLDALWDBCRATE, false, isAddOp ? 0 : -2, 0, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int allowedBClientRate = (Integer)result.getRetData();
        ArrayList<GroupProcessResult> retInfoList = new ArrayList<GroupProcessResult>();
        for (String groupName : groupNameSet) {
            GroupResCtrlEntity grpResCtrl = this.defMetaDataService.getGroupCtrlConf(groupName);
            if (!isAddOp && grpResCtrl == null) {
                result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), DataOpErrCode.DERR_NOT_EXIST.getDescription());
                retInfoList.add(new GroupProcessResult(groupName, "", result));
                continue;
            }
            retInfoList.add(this.defMetaDataService.insertGroupCtrlConf(opEntity, groupName, resChkEnable, allowedBClientRate, sBuffer, result));
        }
        return this.buildRetInfo(retInfoList, sBuffer);
    }

    private StringBuilder innAddOrModGroupFilterCondInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, boolean isAddOp) {
        if (!WebParameterUtils.getAUDBaseInfo(req, isAddOp, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getAndValidTopicNameInfo(req, this.defMetaDataService, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!this.getCondStatusParamValue(req, false, isAddOp ? EnableStatus.STATUS_DISABLE : null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        EnableStatus filterEnable = (EnableStatus)((Object)result.getRetData());
        if (!WebParameterUtils.getFilterCondString(req, false, isAddOp, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        String filterCondStr = (String)result.getRetData();
        ArrayList<GroupProcessResult> retInfoList = new ArrayList<GroupProcessResult>();
        for (String groupName : groupNameSet) {
            for (String topicName : topicNameSet) {
                GroupConsumeCtrlEntity ctrlEntity = this.defMetaDataService.getConsumeCtrlByGroupAndTopic(groupName, topicName);
                if (ctrlEntity == null) {
                    if (isAddOp) {
                        retInfoList.add(this.defMetaDataService.insertConsumeCtrlInfo(opEntity, groupName, topicName, EnableStatus.STATUS_ENABLE, "Old API set filter conditions", filterEnable, filterCondStr, sBuffer, result));
                        continue;
                    }
                    result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), DataOpErrCode.DERR_NOT_EXIST.getDescription());
                    retInfoList.add(new GroupProcessResult(groupName, "", result));
                    continue;
                }
                retInfoList.add(this.defMetaDataService.insertConsumeCtrlInfo(opEntity, groupName, topicName, null, "Old API set filter conditions", filterEnable, filterCondStr, sBuffer, result));
            }
        }
        return this.buildRetInfo(retInfoList, sBuffer);
    }

    private StringBuilder innBatchAddOrUpdGroupFilterCondInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, boolean isAddOp) {
        if (!WebParameterUtils.getAUDBaseInfo(req, isAddOp, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!this.getFilterJsonSetInfo(req, isAddOp, opEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Map addRecordMap = (Map)result.getRetData();
        ArrayList<GroupProcessResult> retInfoList = new ArrayList<GroupProcessResult>();
        for (GroupConsumeCtrlEntity entry : addRecordMap.values()) {
            GroupConsumeCtrlEntity curEntity = this.defMetaDataService.getConsumeCtrlByGroupAndTopic(entry.getGroupName(), entry.getTopicName());
            if (curEntity == null) {
                if (isAddOp) {
                    entry.setConsumeEnable(EnableStatus.STATUS_ENABLE);
                } else {
                    result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), DataOpErrCode.DERR_NOT_EXIST.getDescription());
                    retInfoList.add(new GroupProcessResult(entry.getGroupName(), entry.getTopicName(), result));
                    continue;
                }
            }
            retInfoList.add(this.defMetaDataService.insertConsumeCtrlInfo(entry, sBuffer, result));
        }
        return this.buildRetInfo(retInfoList, sBuffer);
    }

    private boolean getFilterJsonSetInfo(HttpServletRequest req, boolean isAddOp, BaseEntity defOpEntity, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getJsonArrayParamValue(req, WebFieldDef.FILTERJSONSET, true, null, result)) {
            return result.isSuccess();
        }
        List groupJsonArray = (List)result.getRetData();
        HashMap<String, GroupConsumeCtrlEntity> addRecordMap = new HashMap<String, GroupConsumeCtrlEntity>();
        Set<String> configuredTopicSet = this.defMetaDataService.getDeployedTopicSet();
        for (Map itemValueMap : groupJsonArray) {
            if (!WebParameterUtils.getAUDBaseInfo(itemValueMap, isAddOp, defOpEntity, sBuffer, result)) {
                return result.isSuccess();
            }
            BaseEntity itemOpEntity = (BaseEntity)result.getRetData();
            if (!WebParameterUtils.getStringParamValue(itemValueMap, WebFieldDef.GROUPNAME, true, "", sBuffer, result)) {
                return result.isSuccess();
            }
            String groupName = (String)result.getRetData();
            if (!WebParameterUtils.getStringParamValue(itemValueMap, WebFieldDef.TOPICNAME, true, "", sBuffer, result)) {
                return result.isSuccess();
            }
            String topicName = (String)result.getRetData();
            if (!configuredTopicSet.contains(topicName)) {
                result.setFailResult(sBuffer.append(WebFieldDef.TOPICNAME.name).append(" ").append(topicName).append(" is not configure, please configure first!").toString());
                sBuffer.delete(0, sBuffer.length());
                return result.isSuccess();
            }
            if (!this.getCondStatusParamValue(req, false, isAddOp ? EnableStatus.STATUS_DISABLE : null, sBuffer, result)) {
                return result.isSuccess();
            }
            EnableStatus filterEnable = (EnableStatus)((Object)result.getRetData());
            if (!WebParameterUtils.getFilterCondString(req, false, isAddOp, sBuffer, result)) {
                return result.isSuccess();
            }
            String filterCondStr = (String)result.getRetData();
            GroupConsumeCtrlEntity itemEntity = new GroupConsumeCtrlEntity(itemOpEntity, groupName, topicName);
            itemEntity.updModifyInfo(itemOpEntity.getDataVerId(), null, null, filterEnable, filterCondStr);
            addRecordMap.put(itemEntity.getRecordKey(), itemEntity);
        }
        if (addRecordMap.isEmpty()) {
            result.setFailResult(sBuffer.append("Not found record info in ").append(WebFieldDef.FILTERJSONSET.name).append(" parameter!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        result.setSuccResult(addRecordMap);
        return result.isSuccess();
    }

    private boolean getGroupCtrlJsonSetInfo(HttpServletRequest req, BaseEntity defOpEntity, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getJsonArrayParamValue(req, WebFieldDef.GROUPJSONSET, true, null, result)) {
            return result.isSuccess();
        }
        List groupJsonArray = (List)result.getRetData();
        HashMap<String, GroupResCtrlEntity> addRecordMap = new HashMap<String, GroupResCtrlEntity>();
        Set<String> configuredTopicSet = this.defMetaDataService.getDeployedTopicSet();
        for (int j = 0; j < groupJsonArray.size(); ++j) {
            Map itemValueMap = (Map)groupJsonArray.get(j);
            if (!WebParameterUtils.getAUDBaseInfo(itemValueMap, true, defOpEntity, sBuffer, result)) {
                return result.isSuccess();
            }
            BaseEntity itemOpEntity = (BaseEntity)result.getRetData();
            if (!WebParameterUtils.getStringParamValue(itemValueMap, WebFieldDef.GROUPNAME, true, "", sBuffer, result)) {
                return result.isSuccess();
            }
            String groupName = (String)result.getRetData();
            if (!WebParameterUtils.getEnableStatusValue(itemValueMap, WebFieldDef.RESCHECKENABLE, false, EnableStatus.STATUS_DISABLE, sBuffer, result)) {
                return result.isSuccess();
            }
            EnableStatus resChkEnable = (EnableStatus)((Object)result.getRetData());
            if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.OLDALWDBCRATE, false, 0, 0, sBuffer, result)) {
                return result.isSuccess();
            }
            int allowedB2CRate = (Integer)result.getRetData();
            GroupResCtrlEntity itemEntity = new GroupResCtrlEntity(itemOpEntity, groupName);
            itemEntity.updModifyInfo(itemOpEntity.getDataVerId(), resChkEnable, allowedB2CRate, -2, null, -2, null);
            addRecordMap.put(itemEntity.getGroupName(), itemEntity);
        }
        if (addRecordMap.isEmpty()) {
            result.setFailResult(sBuffer.append("Not found record info in ").append(WebFieldDef.GROUPJSONSET.name).append(" parameter!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        result.setSuccResult(addRecordMap);
        return result.isSuccess();
    }

    private boolean getGroupCsmJsonSetInfo(HttpServletRequest req, BaseEntity defOpEntity, EnableStatus enableCsm, String opReason, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getJsonArrayParamValue(req, WebFieldDef.GROUPJSONSET, true, null, result)) {
            return result.isSuccess();
        }
        List groupJsonArray = (List)result.getRetData();
        HashMap<String, GroupConsumeCtrlEntity> addRecordMap = new HashMap<String, GroupConsumeCtrlEntity>();
        Set<String> configuredTopicSet = this.defMetaDataService.getDeployedTopicSet();
        for (Map itemValueMap : groupJsonArray) {
            if (!WebParameterUtils.getAUDBaseInfo(itemValueMap, true, defOpEntity, sBuffer, result)) {
                return result.isSuccess();
            }
            BaseEntity itemOpEntity = (BaseEntity)result.getRetData();
            if (!WebParameterUtils.getStringParamValue(itemValueMap, WebFieldDef.GROUPNAME, true, "", sBuffer, result)) {
                return result.isSuccess();
            }
            String groupName = (String)result.getRetData();
            if (!WebParameterUtils.getStringParamValue(itemValueMap, WebFieldDef.TOPICNAME, true, "", sBuffer, result)) {
                return result.isSuccess();
            }
            String topicName = (String)result.getRetData();
            if (!configuredTopicSet.contains(topicName)) {
                result.setFailResult(sBuffer.append(WebFieldDef.TOPICNAME.name).append(" ").append(topicName).append(" is not configure, please configure first!").toString());
                sBuffer.delete(0, sBuffer.length());
                return result.isSuccess();
            }
            GroupConsumeCtrlEntity itemEntity = new GroupConsumeCtrlEntity(itemOpEntity, groupName, topicName);
            itemEntity.updModifyInfo(itemOpEntity.getDataVerId(), enableCsm, opReason, null, null);
            addRecordMap.put(itemEntity.getRecordKey(), itemEntity);
        }
        if (addRecordMap.isEmpty()) {
            result.setFailResult(sBuffer.append("Not found record info in ").append(WebFieldDef.GROUPJSONSET.name).append(" parameter!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        result.setSuccResult(addRecordMap);
        return result.isSuccess();
    }

    private <T> boolean getCondStatusParamValue(T paramCntr, boolean required, EnableStatus defValue, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getIntParamValue(paramCntr, WebFieldDef.CONDSTATUS, required, -2, 0, 2, sBuffer, result)) {
            return result.isSuccess();
        }
        int paramValue = (Integer)result.getRetData();
        if (paramValue == -2) {
            result.setSuccResult((Object)defValue);
        } else if (paramValue == 2) {
            result.setSuccResult((Object)EnableStatus.STATUS_ENABLE);
        } else {
            result.setSuccResult((Object)EnableStatus.STATUS_DISABLE);
        }
        return result.isSuccess();
    }

    public StringBuilder adminQueryClientBalanceGroupSet(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        try {
            ConsumerInfoHolder consumerHolder = this.master.getConsumerHolder();
            List<String> clientGroups = consumerHolder.getAllClientBalanceGroups();
            int j = 0;
            WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
            for (String groupName : clientGroups) {
                if (TStringUtils.isEmpty((String)groupName)) continue;
                if (j++ > 0) {
                    sBuffer.append(",");
                }
                sBuffer.append("\"").append(groupName).append("\"");
            }
            WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, j);
        }
        catch (Exception e) {
            sBuffer.delete(0, sBuffer.length());
            WebParameterUtils.buildFailResult(sBuffer, e.getMessage());
        }
        return sBuffer;
    }

    public StringBuilder adminSetBalanceGroupConsumeFromMax(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set groupNameSet = (Set)result.getRetData();
        ConsumerInfoHolder consumerHolder = this.master.getConsumerHolder();
        List<String> clientGroups = consumerHolder.getAllClientBalanceGroups();
        TreeSet<String> filtedGroupSet = new TreeSet<String>();
        for (String groupName : groupNameSet) {
            if (!clientGroups.contains(groupName)) continue;
            filtedGroupSet.add(groupName);
        }
        if (filtedGroupSet.isEmpty()) {
            WebParameterUtils.buildFailResult(sBuffer, "all consumer groups are not client balance groups");
        } else {
            for (String groupName : filtedGroupSet) {
                ConsumeGroupInfo groupInfo = consumerHolder.getConsumeGroupInfo(groupName);
                if (groupInfo == null) continue;
                groupInfo.updCsmFromMaxCtrlId();
            }
            logger.info(sBuffer.append("[Admin reset] ").append(opEntity.getModifyUser()).append(" set client-balance group consume from max offset, group set = ").append(((Object)filtedGroupSet).toString()).toString());
            sBuffer.delete(0, sBuffer.length());
            WebParameterUtils.buildSuccessResult(sBuffer);
        }
        return sBuffer;
    }
}

