/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;
import org.apache.inlong.tubemq.server.common.utils.WebParameterUtils;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.ClusterSettingEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupResCtrlEntity;
import org.apache.inlong.tubemq.server.master.web.handler.AbstractWebHandler;
import org.apache.inlong.tubemq.server.master.web.handler.GroupProcessResult;

public class WebGroupResCtrlHandler
extends AbstractWebHandler {
    public WebGroupResCtrlHandler(TMaster master) {
        super(master);
    }

    @Override
    public void registerWebApiMethod() {
        this.registerQueryWebMethod("admin_query_group_resctrl_info", "adminQueryGroupResCtrlConf");
        this.registerQueryWebMethod("admin_query_booked_resctrl_groups", "adminQueryBookedResCtrlGroups");
        this.registerModifyWebMethod("admin_add_group_resctrl_info", "adminAddGroupResCtrlConf");
        this.registerModifyWebMethod("admin_batch_add_group_resctrl_info", "adminBatchAddGroupResCtrlConf");
        this.registerModifyWebMethod("admin_update_group_resctrl_info", "adminModGroupResCtrlConf");
        this.registerModifyWebMethod("admin_batch_update_group_resctrl_info", "adminBatchUpdGroupResCtrlConf");
        this.registerModifyWebMethod("admin_delete_group_resctrl_info", "adminDelGroupResCtrlConf");
    }

    public StringBuilder adminQueryBookedResCtrlGroups(HttpServletRequest req, StringBuilder strBuff, ProcessResult result) {
        return this.innQueryGroupResCtrlInfo(req, strBuff, result, true);
    }

    public StringBuilder adminQueryGroupResCtrlConf(HttpServletRequest req, StringBuilder strBuff, ProcessResult result) {
        return this.innQueryGroupResCtrlInfo(req, strBuff, result, false);
    }

    public StringBuilder adminAddGroupResCtrlConf(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdGroupResCtrlConf(req, sBuffer, result, true);
    }

    public StringBuilder adminBatchAddGroupResCtrlConf(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innBatchAddOrUpdGroupResCtrlConf(req, sBuffer, result, true);
    }

    public StringBuilder adminModGroupResCtrlConf(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdGroupResCtrlConf(req, sBuffer, result, false);
    }

    public StringBuilder adminBatchUpdGroupResCtrlConf(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innBatchAddOrUpdGroupResCtrlConf(req, sBuffer, result, false);
    }

    public StringBuilder adminDelGroupResCtrlConf(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set batchGroupNames = (Set)result.getRetData();
        ArrayList<GroupProcessResult> retInfo = new ArrayList<GroupProcessResult>();
        for (String groupName : batchGroupNames) {
            retInfo.add(this.defMetaDataService.delGroupResCtrlConf(opEntity.getModifyUser(), groupName, sBuffer, result));
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    private StringBuilder innQueryGroupResCtrlInfo(HttpServletRequest req, StringBuilder strBuff, ProcessResult result, boolean onlyRetGroup) {
        GroupResCtrlEntity qryEntity = new GroupResCtrlEntity();
        if (!WebParameterUtils.getQueriedOperateInfo(req, qryEntity, strBuff, result)) {
            WebParameterUtils.buildFailResult(strBuff, result.getErrMsg());
            return strBuff;
        }
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, false, null, strBuff, result)) {
            WebParameterUtils.buildFailResult(strBuff, result.getErrMsg());
            return strBuff;
        }
        Set inGroupSet = (Set)result.getRetData();
        if (!WebParameterUtils.getEnableStatusValue(req, WebFieldDef.RESCHECKENABLE, false, null, strBuff, result)) {
            WebParameterUtils.buildFailResult(strBuff, result.getErrMsg());
            return strBuff;
        }
        EnableStatus resCheckEnable = (EnableStatus)((Object)result.getRetData());
        if (!WebParameterUtils.getQryPriorityIdParameter(req, false, -2, 101, strBuff, result)) {
            WebParameterUtils.buildFailResult(strBuff, result.getErrMsg());
            return strBuff;
        }
        int inQryPriorityId = (Integer)result.getRetData();
        if (!WebParameterUtils.getEnableStatusValue(req, WebFieldDef.FLOWCTRLENABLE, false, null, strBuff, result)) {
            WebParameterUtils.buildFailResult(strBuff, result.getErrMsg());
            return strBuff;
        }
        EnableStatus flowCtrlEnable = (EnableStatus)((Object)result.getRetData());
        qryEntity.updModifyInfo(qryEntity.getDataVerId(), resCheckEnable, -2, inQryPriorityId, flowCtrlEnable, -2, null);
        Map<String, GroupResCtrlEntity> groupResCtrlEntityMap = this.defMetaDataService.getGroupCtrlConf(inGroupSet, qryEntity);
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(strBuff);
        if (onlyRetGroup) {
            for (GroupResCtrlEntity entity : groupResCtrlEntityMap.values()) {
                if (entity == null) continue;
                if (totalCnt++ > 0) {
                    strBuff.append(",");
                }
                strBuff.append("\"").append(entity.getGroupName()).append("\"");
            }
        } else {
            for (GroupResCtrlEntity entity : groupResCtrlEntityMap.values()) {
                if (entity == null) continue;
                if (totalCnt++ > 0) {
                    strBuff.append(",");
                }
                strBuff = entity.toWebJsonStr(strBuff, true, true);
            }
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(strBuff, totalCnt);
        return strBuff;
    }

    private StringBuilder innAddOrUpdGroupResCtrlConf(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, boolean isAddOp) {
        if (!WebParameterUtils.getAUDBaseInfo(req, isAddOp, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set batchGroupNames = (Set)result.getRetData();
        if (!WebParameterUtils.getEnableStatusValue(req, WebFieldDef.RESCHECKENABLE, false, isAddOp ? EnableStatus.STATUS_DISABLE : null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        EnableStatus resCheckEnable = (EnableStatus)((Object)result.getRetData());
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.ALWDBCRATE, false, isAddOp ? 0 : -2, 0, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int allowedBClientRate = (Integer)result.getRetData();
        ClusterSettingEntity defClusterSetting = this.defMetaDataService.getClusterDefSetting(false);
        if (!WebParameterUtils.getQryPriorityIdParameter(req, false, isAddOp ? defClusterSetting.getQryPriorityId() : -2, 101, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int qryPriorityId = (Integer)result.getRetData();
        if (!WebParameterUtils.getEnableStatusValue(req, WebFieldDef.FLOWCTRLENABLE, false, isAddOp ? EnableStatus.STATUS_DISABLE : null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        EnableStatus flowCtrlEnable = (EnableStatus)((Object)result.getRetData());
        int flowRuleCnt = WebParameterUtils.getAndCheckFlowRules(req, isAddOp ? "[]" : null, sBuffer, result);
        if (!result.isSuccess()) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        String flowCtrlInfo = (String)result.getRetData();
        ArrayList<GroupProcessResult> retInfo = new ArrayList<GroupProcessResult>();
        for (String groupName : batchGroupNames) {
            retInfo.add(this.defMetaDataService.addOrUpdGroupCtrlConf(isAddOp, opEntity, groupName, resCheckEnable, allowedBClientRate, qryPriorityId, flowCtrlEnable, flowRuleCnt, flowCtrlInfo, sBuffer, result));
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    private StringBuilder innBatchAddOrUpdGroupResCtrlConf(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, boolean isAddOp) {
        if (!WebParameterUtils.getAUDBaseInfo(req, isAddOp, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity defOpEntity = (BaseEntity)result.getRetData();
        if (!this.getGroupResCtrlJsonSetInfo(req, isAddOp, defOpEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Map addRecordMap = (Map)result.getRetData();
        ArrayList<GroupProcessResult> retInfo = new ArrayList<GroupProcessResult>();
        for (GroupResCtrlEntity newResCtrlEntity : addRecordMap.values()) {
            retInfo.add(this.defMetaDataService.addOrUpdGroupCtrlConf(isAddOp, newResCtrlEntity, sBuffer, result));
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    private boolean getGroupResCtrlJsonSetInfo(HttpServletRequest req, boolean isAddOp, BaseEntity defOpEntity, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getJsonArrayParamValue(req, WebFieldDef.GROUPRESCTRLSET, true, null, result)) {
            return result.isSuccess();
        }
        List ctrlJsonArray = (List)result.getRetData();
        ClusterSettingEntity defClusterSetting = this.defMetaDataService.getClusterDefSetting(false);
        int defQryPriorityId = defClusterSetting.getQryPriorityId();
        HashMap<String, GroupResCtrlEntity> addRecordMap = new HashMap<String, GroupResCtrlEntity>();
        for (Map itemValueMap : ctrlJsonArray) {
            if (!WebParameterUtils.getAUDBaseInfo(itemValueMap, isAddOp, defOpEntity, sBuffer, result)) {
                return result.isSuccess();
            }
            BaseEntity itemOpEntity = (BaseEntity)result.getRetData();
            if (!WebParameterUtils.getStringParamValue(itemValueMap, WebFieldDef.GROUPNAME, true, "", sBuffer, result)) {
                return result.isSuccess();
            }
            String groupName = (String)result.getRetData();
            if (!WebParameterUtils.getEnableStatusValue(itemValueMap, WebFieldDef.RESCHECKENABLE, false, isAddOp ? EnableStatus.STATUS_DISABLE : null, sBuffer, result)) {
                return result.isSuccess();
            }
            EnableStatus resCheckEnable = (EnableStatus)((Object)result.getRetData());
            if (!WebParameterUtils.getIntParamValue(itemValueMap, WebFieldDef.ALWDBCRATE, false, isAddOp ? 0 : -2, 0, sBuffer, result)) {
                return result.isSuccess();
            }
            int allowedBClientRate = (Integer)result.getRetData();
            if (!WebParameterUtils.getQryPriorityIdParameter(itemValueMap, false, isAddOp ? defClusterSetting.getQryPriorityId() : -2, 101, sBuffer, result)) {
                return result.isSuccess();
            }
            int qryPriorityId = (Integer)result.getRetData();
            if (!WebParameterUtils.getEnableStatusValue(itemValueMap, WebFieldDef.FLOWCTRLENABLE, false, isAddOp ? EnableStatus.STATUS_DISABLE : null, sBuffer, result)) {
                return result.isSuccess();
            }
            EnableStatus flowCtrlEnable = (EnableStatus)((Object)result.getRetData());
            int flowRuleCnt = WebParameterUtils.getAndCheckFlowRules(itemValueMap, isAddOp ? "[]" : null, sBuffer, result);
            if (!result.isSuccess()) {
                return result.isSuccess();
            }
            String flowCtrlInfo = (String)result.getRetData();
            GroupResCtrlEntity itemEntity = new GroupResCtrlEntity(itemOpEntity, groupName);
            itemEntity.updModifyInfo(itemEntity.getDataVerId(), resCheckEnable, allowedBClientRate, qryPriorityId, flowCtrlEnable, flowRuleCnt, flowCtrlInfo);
            addRecordMap.put(itemEntity.getGroupName(), itemEntity);
        }
        if (addRecordMap.isEmpty()) {
            result.setFailResult(sBuffer.append("Not found record info in ").append(WebFieldDef.GROUPRESCTRLSET.name).append(" parameter!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        result.setSuccResult(addRecordMap);
        return result.isSuccess();
    }

    private StringBuilder buildRetInfo(List<GroupProcessResult> retInfo, StringBuilder sBuffer) {
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (GroupProcessResult entry : retInfo) {
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            sBuffer.append("{\"groupName\":\"").append(entry.getGroupName()).append("\"").append(",\"success\":").append(entry.isSuccess()).append(",\"errCode\":").append(entry.getErrCode()).append(",\"errInfo\":\"").append(entry.getErrMsg()).append("\"}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }
}

