/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class QuorumStateData
implements ApiMessage {
    String clusterId;
    int leaderId;
    int leaderEpoch;
    int votedId;
    long appliedOffset;
    List<Voter> currentVoters;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("cluster_id", (Type)Type.COMPACT_STRING, ""), new Field("leader_id", (Type)Type.INT32, ""), new Field("leader_epoch", (Type)Type.INT32, ""), new Field("voted_id", (Type)Type.INT32, ""), new Field("applied_offset", (Type)Type.INT64, ""), new Field("current_voters", (Type)CompactArrayOf.nullable((Type)Voter.SCHEMA_0), ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public QuorumStateData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public QuorumStateData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public QuorumStateData() {
        this.clusterId = "";
        this.leaderId = -1;
        this.leaderEpoch = -1;
        this.votedId = -1;
        this.appliedOffset = 0L;
        this.currentVoters = new ArrayList<Voter>(0);
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field clusterId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field clusterId had invalid length " + length);
        }
        this.clusterId = _readable.readString(length);
        this.leaderId = _readable.readInt();
        this.leaderEpoch = _readable.readInt();
        this.votedId = _readable.readInt();
        this.appliedOffset = _readable.readLong();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.currentVoters = null;
        } else {
            ArrayList<Voter> newCollection = new ArrayList<Voter>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new Voter(_readable, _version));
            }
            this.currentVoters = newCollection;
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = _cache.getSerializedValue((Object)this.clusterId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeInt(this.leaderId);
        _writable.writeInt(this.leaderEpoch);
        _writable.writeInt(this.votedId);
        _writable.writeLong(this.appliedOffset);
        if (this.currentVoters == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.currentVoters.size() + 1);
            _stringBytes = this.currentVoters.iterator();
            while (_stringBytes.hasNext()) {
                Voter currentVotersElement = (Voter)_stringBytes.next();
                currentVotersElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        this.clusterId = struct.getString("cluster_id");
        this.leaderId = struct.getInt("leader_id");
        this.leaderEpoch = struct.getInt("leader_epoch");
        this.votedId = struct.getInt("voted_id");
        this.appliedOffset = struct.getLong("applied_offset");
        Object[] _nestedObjects = struct.getArray("current_voters");
        if (_nestedObjects == null) {
            this.currentVoters = null;
        } else {
            this.currentVoters = new ArrayList<Voter>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.currentVoters.add(new Voter((Struct)nestedObject, _version));
            }
        }
        if (!_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        _taggedFields = new TreeMap();
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("cluster_id", (Object)this.clusterId);
        struct.set("leader_id", (Object)this.leaderId);
        struct.set("leader_epoch", (Object)this.leaderEpoch);
        struct.set("voted_id", (Object)this.votedId);
        struct.set("applied_offset", (Object)this.appliedOffset);
        if (this.currentVoters == null) {
            struct.set("current_voters", null);
        } else {
            Struct[] _nestedObjects = new Struct[this.currentVoters.size()];
            int i = 0;
            for (Voter element : this.currentVoters) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("current_voters", (Object)_nestedObjects);
        }
        struct.set("_tagged_fields", _taggedFields);
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.clusterId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'clusterId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.clusterId, _stringBytes);
        _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
        _size += 4;
        _size += 4;
        _size += 4;
        _size += 8;
        if (this.currentVoters == null) {
            ++_size;
        } else {
            int _arraySize = 0;
            _arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.currentVoters.size() + 1));
            for (Voter currentVotersElement : this.currentVoters) {
                _arraySize += currentVotersElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        return _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QuorumStateData)) {
            return false;
        }
        QuorumStateData other = (QuorumStateData)obj;
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.leaderId != other.leaderId) {
            return false;
        }
        if (this.leaderEpoch != other.leaderEpoch) {
            return false;
        }
        if (this.votedId != other.votedId) {
            return false;
        }
        if (this.appliedOffset != other.appliedOffset) {
            return false;
        }
        if (this.currentVoters == null ? other.currentVoters != null : !this.currentVoters.equals(other.currentVoters)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        hashCode = 31 * hashCode + this.leaderId;
        hashCode = 31 * hashCode + this.leaderEpoch;
        hashCode = 31 * hashCode + this.votedId;
        hashCode = 31 * hashCode + ((int)(this.appliedOffset >> 32) ^ (int)this.appliedOffset);
        hashCode = 31 * hashCode + (this.currentVoters == null ? 0 : this.currentVoters.hashCode());
        return hashCode;
    }

    public QuorumStateData duplicate() {
        QuorumStateData _duplicate = new QuorumStateData();
        _duplicate.clusterId = this.clusterId;
        _duplicate.leaderId = this.leaderId;
        _duplicate.leaderEpoch = this.leaderEpoch;
        _duplicate.votedId = this.votedId;
        _duplicate.appliedOffset = this.appliedOffset;
        if (this.currentVoters == null) {
            _duplicate.currentVoters = null;
        } else {
            ArrayList<Voter> newCurrentVoters = new ArrayList<Voter>(this.currentVoters.size());
            for (Voter _element : this.currentVoters) {
                newCurrentVoters.add(_element.duplicate());
            }
            _duplicate.currentVoters = newCurrentVoters;
        }
        return _duplicate;
    }

    public String toString() {
        return "QuorumStateData(clusterId=" + (this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ", leaderId=" + this.leaderId + ", leaderEpoch=" + this.leaderEpoch + ", votedId=" + this.votedId + ", appliedOffset=" + this.appliedOffset + ", currentVoters=" + (this.currentVoters == null ? "null" : MessageUtil.deepToString(this.currentVoters.iterator())) + ")";
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int leaderId() {
        return this.leaderId;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public int votedId() {
        return this.votedId;
    }

    public long appliedOffset() {
        return this.appliedOffset;
    }

    public List<Voter> currentVoters() {
        return this.currentVoters;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public QuorumStateData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    public QuorumStateData setLeaderId(int v) {
        this.leaderId = v;
        return this;
    }

    public QuorumStateData setLeaderEpoch(int v) {
        this.leaderEpoch = v;
        return this;
    }

    public QuorumStateData setVotedId(int v) {
        this.votedId = v;
        return this;
    }

    public QuorumStateData setAppliedOffset(long v) {
        this.appliedOffset = v;
        return this;
    }

    public QuorumStateData setCurrentVoters(List<Voter> v) {
        this.currentVoters = v;
        return this;
    }

    public static class Voter
    implements Message {
        int voterId;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("voter_id", (Type)Type.INT32, ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Voter(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public Voter(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public Voter() {
            this.voterId = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public void read(Readable _readable, short _version) {
            this.voterId = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.voterId);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void fromStruct(Struct struct, short _version) {
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            this.voterId = struct.getInt("voter_id");
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("voter_id", (Object)this.voterId);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            _size += 4;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Voter)) {
                return false;
            }
            Voter other = (Voter)obj;
            if (this.voterId != other.voterId) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.voterId;
            return hashCode;
        }

        public Voter duplicate() {
            Voter _duplicate = new Voter();
            _duplicate.voterId = this.voterId;
            return _duplicate;
        }

        public String toString() {
            return "Voter(voterId=" + this.voterId + ")";
        }

        public int voterId() {
            return this.voterId;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Voter setVoterId(int v) {
            this.voterId = v;
            return this;
        }
    }
}

