/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.page;

import com.github.pagehelper.AutoDialect;
import com.github.pagehelper.Dialect;
import com.github.pagehelper.PageException;
import com.github.pagehelper.dialect.AbstractHelperDialect;
import com.github.pagehelper.dialect.auto.C3P0AutoDialect;
import com.github.pagehelper.dialect.auto.DataSourceNegotiationAutoDialect;
import com.github.pagehelper.dialect.auto.DbcpAutoDialect;
import com.github.pagehelper.dialect.auto.DefaultAutoDialect;
import com.github.pagehelper.dialect.auto.DruidAutoDialect;
import com.github.pagehelper.dialect.auto.HikariAutoDialect;
import com.github.pagehelper.dialect.auto.TomcatAutoDialect;
import com.github.pagehelper.dialect.helper.Db2Dialect;
import com.github.pagehelper.dialect.helper.FirebirdDialect;
import com.github.pagehelper.dialect.helper.HerdDBDialect;
import com.github.pagehelper.dialect.helper.HsqldbDialect;
import com.github.pagehelper.dialect.helper.InformixDialect;
import com.github.pagehelper.dialect.helper.MySqlDialect;
import com.github.pagehelper.dialect.helper.Oracle9iDialect;
import com.github.pagehelper.dialect.helper.OracleDialect;
import com.github.pagehelper.dialect.helper.OscarDialect;
import com.github.pagehelper.dialect.helper.PostgreSqlDialect;
import com.github.pagehelper.dialect.helper.SqlServer2012Dialect;
import com.github.pagehelper.dialect.helper.SqlServerDialect;
import com.github.pagehelper.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.MappedStatement;

public class PageAutoDialect {
    private static Map<String, Class<? extends Dialect>> dialectAliasMap = new HashMap<String, Class<? extends Dialect>>();
    private static Map<String, Class<? extends AutoDialect>> autoDialectMap = new HashMap<String, Class<? extends AutoDialect>>();
    private boolean autoDialect = true;
    private Properties properties;
    private Map<Object, AbstractHelperDialect> urlDialectMap = new ConcurrentHashMap<Object, AbstractHelperDialect>();
    private ReentrantLock lock = new ReentrantLock();
    private AbstractHelperDialect delegate;
    private ThreadLocal<AbstractHelperDialect> dialectThreadLocal = new ThreadLocal();
    private AutoDialect autoDialectDelegate;

    public static void registerDialectAlias(String alias, Class<? extends Dialect> dialectClass) {
        dialectAliasMap.put(alias, dialectClass);
    }

    public static void registerAutoDialectAlias(String alias, Class<? extends AutoDialect> autoDialectClass) {
        autoDialectMap.put(alias, autoDialectClass);
    }

    public static String fromJdbcUrl(String jdbcUrl) {
        String url = jdbcUrl.toLowerCase();
        for (String dialect : dialectAliasMap.keySet()) {
            if (!url.contains(":" + dialect.toLowerCase() + ":")) continue;
            return dialect;
        }
        return null;
    }

    public AbstractHelperDialect getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        return this.dialectThreadLocal.get();
    }

    public void clearDelegate() {
        this.dialectThreadLocal.remove();
    }

    public static Class resloveDialectClass(String className) throws Exception {
        if (dialectAliasMap.containsKey(className.toLowerCase())) {
            return dialectAliasMap.get(className.toLowerCase());
        }
        return Class.forName(className);
    }

    public static AbstractHelperDialect instanceDialect(String dialectClass, Properties properties) {
        AbstractHelperDialect dialect;
        if (StringUtil.isEmpty(dialectClass)) {
            throw new PageException("\u4f7f\u7528 PageHelper \u5206\u9875\u63d2\u4ef6\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e helper \u5c5e\u6027");
        }
        try {
            Class sqlDialectClass = PageAutoDialect.resloveDialectClass(dialectClass);
            if (!AbstractHelperDialect.class.isAssignableFrom(sqlDialectClass)) {
                throw new PageException("\u4f7f\u7528 PageHelper \u65f6\uff0c\u65b9\u8a00\u5fc5\u987b\u662f\u5b9e\u73b0 " + AbstractHelperDialect.class.getCanonicalName() + " \u63a5\u53e3\u7684\u5b9e\u73b0\u7c7b!");
            }
            dialect = (AbstractHelperDialect)sqlDialectClass.newInstance();
        }
        catch (Exception e) {
            throw new PageException("\u521d\u59cb\u5316 helper [" + dialectClass + "]\u65f6\u51fa\u9519:" + e.getMessage(), e);
        }
        dialect.setProperties(properties);
        return dialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDelegateDialect(MappedStatement ms, String dialectClass) {
        if (StringUtil.isNotEmpty(dialectClass)) {
            AbstractHelperDialect dialect = this.urlDialectMap.get(dialectClass);
            if (dialect == null) {
                this.lock.lock();
                try {
                    dialect = this.urlDialectMap.get(dialectClass);
                    if (dialect == null) {
                        dialect = PageAutoDialect.instanceDialect(dialectClass, this.properties);
                        this.urlDialectMap.put(dialectClass, dialect);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            this.dialectThreadLocal.set(dialect);
        } else if (this.delegate == null) {
            if (this.autoDialect) {
                this.delegate = this.autoGetDialect(ms);
            } else {
                this.dialectThreadLocal.set(this.autoGetDialect(ms));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractHelperDialect autoGetDialect(MappedStatement ms) {
        DataSource dataSource = ms.getConfiguration().getEnvironment().getDataSource();
        Object dialectKey = this.autoDialectDelegate.extractDialectKey(ms, dataSource, this.properties);
        if (dialectKey == null) {
            return this.autoDialectDelegate.extractDialect(dialectKey, ms, dataSource, this.properties);
        }
        if (!this.urlDialectMap.containsKey(dialectKey)) {
            this.lock.lock();
            try {
                if (!this.urlDialectMap.containsKey(dialectKey)) {
                    this.urlDialectMap.put(dialectKey, this.autoDialectDelegate.extractDialect(dialectKey, ms, dataSource, this.properties));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.urlDialectMap.get(dialectKey);
    }

    private void initAutoDialectClass(Properties properties) {
        String autoDialectClassStr = properties.getProperty("autoDialectClass");
        if (StringUtil.isNotEmpty(autoDialectClassStr)) {
            try {
                Class<Object> autoDialectClass = autoDialectMap.containsKey(autoDialectClassStr) ? autoDialectMap.get(autoDialectClassStr) : Class.forName(autoDialectClassStr);
                this.autoDialectDelegate = (AutoDialect)autoDialectClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("\u8bf7\u786e\u4fdd autoDialectClass \u914d\u7f6e\u7684 AutoDialect \u5b9e\u73b0\u7c7b(" + autoDialectClassStr + ")\u5b58\u5728!", e);
            }
            catch (Exception e) {
                throw new RuntimeException(autoDialectClassStr + " \u7c7b\u5fc5\u987b\u63d0\u4f9b\u65e0\u53c2\u7684\u6784\u9020\u65b9\u6cd5", e);
            }
        } else {
            this.autoDialectDelegate = new DataSourceNegotiationAutoDialect();
        }
    }

    private void initDialectAlias(Properties properties) {
        String dialectAlias = properties.getProperty("dialectAlias");
        if (StringUtil.isNotEmpty(dialectAlias)) {
            String[] alias = dialectAlias.split(";");
            for (int i = 0; i < alias.length; ++i) {
                String[] kv = alias[i].split("=");
                if (kv.length != 2) {
                    throw new IllegalArgumentException("dialectAlias \u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u6309\u7167 alias1=xx.dialectClass;alias2=dialectClass2 \u7684\u5f62\u5f0f\u8fdb\u884c\u914d\u7f6e!");
                }
                for (int j = 0; j < kv.length; ++j) {
                    try {
                        Class<?> diallectClass = Class.forName(kv[1]);
                        PageAutoDialect.registerDialectAlias(kv[0], diallectClass);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("\u8bf7\u786e\u4fdd dialectAlias \u914d\u7f6e\u7684 Dialect \u5b9e\u73b0\u7c7b\u5b58\u5728!", e);
                    }
                }
            }
        }
    }

    public void setProperties(Properties properties) {
        this.initAutoDialectClass(properties);
        String useSqlserver2012 = properties.getProperty("useSqlserver2012");
        if (StringUtil.isNotEmpty(useSqlserver2012) && Boolean.parseBoolean(useSqlserver2012)) {
            PageAutoDialect.registerDialectAlias("sqlserver", SqlServer2012Dialect.class);
            PageAutoDialect.registerDialectAlias("sqlserver2008", SqlServerDialect.class);
        }
        this.initDialectAlias(properties);
        String dialect = properties.getProperty("helperDialect");
        String runtimeDialect = properties.getProperty("autoRuntimeDialect");
        if (StringUtil.isNotEmpty(runtimeDialect) && "TRUE".equalsIgnoreCase(runtimeDialect)) {
            this.autoDialect = false;
            this.properties = properties;
        } else if (StringUtil.isEmpty(dialect)) {
            this.autoDialect = true;
            this.properties = properties;
        } else {
            this.autoDialect = false;
            this.delegate = PageAutoDialect.instanceDialect(dialect, properties);
        }
    }

    static {
        PageAutoDialect.registerDialectAlias("hsqldb", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("h2", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("phoenix", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("postgresql", PostgreSqlDialect.class);
        PageAutoDialect.registerDialectAlias("mysql", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("mariadb", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("sqlite", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("herddb", HerdDBDialect.class);
        PageAutoDialect.registerDialectAlias("oracle", OracleDialect.class);
        PageAutoDialect.registerDialectAlias("oracle9i", Oracle9iDialect.class);
        PageAutoDialect.registerDialectAlias("db2", Db2Dialect.class);
        PageAutoDialect.registerDialectAlias("informix", InformixDialect.class);
        PageAutoDialect.registerDialectAlias("informix-sqli", InformixDialect.class);
        PageAutoDialect.registerDialectAlias("sqlserver", SqlServerDialect.class);
        PageAutoDialect.registerDialectAlias("sqlserver2012", SqlServer2012Dialect.class);
        PageAutoDialect.registerDialectAlias("derby", SqlServer2012Dialect.class);
        PageAutoDialect.registerDialectAlias("dm", OracleDialect.class);
        PageAutoDialect.registerDialectAlias("edb", OracleDialect.class);
        PageAutoDialect.registerDialectAlias("oscar", OscarDialect.class);
        PageAutoDialect.registerDialectAlias("clickhouse", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("highgo", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("xugu", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("impala", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("firebirdsql", FirebirdDialect.class);
        PageAutoDialect.registerAutoDialectAlias("old", DefaultAutoDialect.class);
        PageAutoDialect.registerAutoDialectAlias("hikari", HikariAutoDialect.class);
        PageAutoDialect.registerAutoDialectAlias("druid", DruidAutoDialect.class);
        PageAutoDialect.registerAutoDialectAlias("tomcat-jdbc", TomcatAutoDialect.class);
        PageAutoDialect.registerAutoDialectAlias("dbcp", DbcpAutoDialect.class);
        PageAutoDialect.registerAutoDialectAlias("c3p0", C3P0AutoDialect.class);
        PageAutoDialect.registerAutoDialectAlias("default", DataSourceNegotiationAutoDialect.class);
    }
}

