/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaRequestHandler;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u000b\u0017\u0001mA\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tg\u0001\u0011\t\u0011)A\u0005a!AA\u0007\u0001BC\u0002\u0013\u0005Q\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u00037\u0011!i\u0004A!b\u0001\n\u0003q\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"Aa\f\u0001B\u0001B\u0003%1\u000bC\u0003`\u0001\u0011\u0005\u0001\rC\u0004j\u0001\t\u0007I\u0011\u00026\t\r]\u0004\u0001\u0015!\u0003l\u0011\u001dA\bA1A\u0005\neDq!a\u0003\u0001A\u0003%!\u0010C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0001\u0002\u0010!A\u0011q\u0005\u0001!\u0002\u0013\t\t\u0002C\u0004\u0002*\u0001!\t!a\u000b\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u0011q\b\u0001\u0005\u0002\u0005\u0005#aF&bM.\f'+Z9vKN$\b*\u00198eY\u0016\u0014\bk\\8m\u0015\t9\u0002$\u0001\u0004tKJ4XM\u001d\u0006\u00023\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u001dE!\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0007CA\u0012'\u001b\u0005!#BA\u0013\u0019\u0003\u0015)H/\u001b7t\u0013\t9CEA\u0004M_\u001e<\u0017N\\4\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-B\u0012aB7fiJL7m]\u0005\u0003[)\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003!\u0011'o\\6fe&#W#\u0001\u0019\u0011\u0005u\t\u0014B\u0001\u001a\u001f\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\naB]3rk\u0016\u001cHo\u00115b]:,G.F\u00017!\t9$(D\u00019\u0015\tI\u0004$A\u0004oKR<xN]6\n\u0005mB$A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0010e\u0016\fX/Z:u\u0007\"\fgN\\3mA\u0005!\u0011\r]5t+\u0005y\u0004C\u0001!B\u001b\u00051\u0012B\u0001\"\u0017\u0005E\t\u0005/\u001b*fcV,7\u000f\u001e%b]\u0012dWM]\u0001\u0006CBL7\u000fI\u0001\u0005i&lW\r\u0005\u0002G\u001f6\tqI\u0003\u0002&\u0011*\u0011\u0011JS\u0001\u0007G>lWn\u001c8\u000b\u0005eY%B\u0001'N\u0003\u0019\t\u0007/Y2iK*\ta*A\u0002pe\u001eL!\u0001U$\u0003\tQKW.Z\u0001\u000b]VlG\u000b\u001b:fC\u0012\u001c\u0018a\b:fcV,7\u000f\u001e%b]\u0012dWM]!wO&#G.Z'fiJL7MT1nKB\u0011Ak\u0017\b\u0003+f\u0003\"A\u0016\u0010\u000e\u0003]S!\u0001\u0017\u000e\u0002\rq\u0012xn\u001c;?\u0013\tQf$\u0001\u0004Qe\u0016$WMZ\u0005\u00039v\u0013aa\u0015;sS:<'B\u0001.\u001f\u0003YawnZ!oIRC'/Z1e\u001d\u0006lW\r\u0015:fM&D\u0018A\u0002\u001fj]&$h\b\u0006\u0005bE\u000e$WMZ4i!\t\u0001\u0005\u0001C\u0003/\u0017\u0001\u0007\u0001\u0007C\u00035\u0017\u0001\u0007a\u0007C\u0003>\u0017\u0001\u0007q\bC\u0003E\u0017\u0001\u0007Q\tC\u0003R\u0017\u0001\u0007\u0001\u0007C\u0003S\u0017\u0001\u00071\u000bC\u0003_\u0017\u0001\u00071+\u0001\buQJ,\u0017\r\u001a)p_2\u001c\u0016N_3\u0016\u0003-\u0004\"\u0001\\;\u000e\u00035T!A\\8\u0002\r\u0005$x.\\5d\u0015\t\u0001\u0018/\u0001\u0006d_:\u001cWO\u001d:f]RT!A]:\u0002\tU$\u0018\u000e\u001c\u0006\u0002i\u0006!!.\u0019<b\u0013\t1XNA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\u0010i\"\u0014X-\u00193Q_>d7+\u001b>fA\u0005\u0011\u0012mZ4sK\u001e\fG/Z%eY\u0016lU\r^3s+\u0005Q\bcA>\u0002\b5\tAP\u0003\u0002~}\u0006!1m\u001c:f\u0015\tYsP\u0003\u0003\u0002\u0002\u0005\r\u0011AB=b[6,'O\u0003\u0002\u0002\u0006\u0005\u00191m\\7\n\u0007\u0005%APA\u0003NKR,'/A\nbO\u001e\u0014XmZ1uK&#G.Z'fi\u0016\u0014\b%A\u0005sk:t\u0017M\u00197fgV\u0011\u0011\u0011\u0003\t\u0007\u0003'\ti\"!\t\u000e\u0005\u0005U!\u0002BA\f\u00033\tq!\\;uC\ndWMC\u0002\u0002\u001cy\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty\"!\u0006\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0004\u0001\u0006\r\u0012bAA\u0013-\t\u00192*\u00194lCJ+\u0017/^3ti\"\u000bg\u000e\u001a7fe\u0006Q!/\u001e8oC\ndWm\u001d\u0011\u0002\u001b\r\u0014X-\u0019;f\u0011\u0006tG\r\\3s)\u0011\ti#a\r\u0011\u0007u\ty#C\u0002\u00022y\u0011A!\u00168ji\"1\u0011Q\u0007\nA\u0002A\n!!\u001b3\u0002!I,7/\u001b>f)\"\u0014X-\u00193Q_>dG\u0003BA\u0017\u0003wAa!!\u0010\u0014\u0001\u0004\u0001\u0014a\u00028foNK'0Z\u0001\tg\",H\u000fZ8x]R\u0011\u0011Q\u0006")
public class KafkaRequestHandlerPool
implements KafkaMetricsGroup {
    private final int brokerId;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final String logAndThreadNamePrefix;
    private final AtomicInteger threadPoolSize;
    private final Meter aggregateIdleMeter;
    private final ArrayBuffer<KafkaRequestHandler> runnables;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ApiRequestHandler apis() {
        return this.apis;
    }

    private AtomicInteger threadPoolSize() {
        return this.threadPoolSize;
    }

    private Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public ArrayBuffer<KafkaRequestHandler> runnables() {
        return this.runnables;
    }

    public synchronized void createHandler(int id) {
        this.runnables().$plus$eq((Object)new KafkaRequestHandler(id, this.brokerId(), this.aggregateIdleMeter(), this.threadPoolSize(), this.requestChannel(), this.apis(), this.time));
        KafkaThread.daemon((String)new StringBuilder(23).append(this.logAndThreadNamePrefix).append("-kafka-request-handler-").append(id).toString(), (Runnable)((Runnable)this.runnables().apply(id))).start();
    }

    public synchronized void resizeThreadPool(int newSize) {
        int currentSize = this.threadPoolSize().get();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Resizing request handler thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
        if (newSize > currentSize) {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(currentSize, newSize);
            if (range == null) {
                throw null;
            }
            Range foreach$mVc$sp_this = range;
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    this.createHandler(foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i != foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) {
                        foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                        continue;
                    }
                    break;
                }
            }
        } else if (newSize < currentSize) {
            int n = 1;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, currentSize - newSize);
            if (inclusive == null) {
                throw null;
            }
            Range.Inclusive foreach$mVc$sp_this = inclusive;
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    KafkaRequestHandlerPool.$anonfun$resizeThreadPool$3(this, currentSize, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
        }
        this.threadPoolSize().set(newSize);
    }

    public synchronized void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shutting down");
        this.runnables().foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        this.runnables().foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shut down completely");
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$3(KafkaRequestHandlerPool $this, int currentSize$1, int i) {
        ((KafkaRequestHandler)$this.runnables().remove(currentSize$1 - i)).stop();
    }

    public KafkaRequestHandlerPool(int brokerId, RequestChannel requestChannel, ApiRequestHandler apis, Time time, int numThreads, String requestHandlerAvgIdleMetricName, String logAndThreadNamePrefix) {
        this.brokerId = brokerId;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.logAndThreadNamePrefix = logAndThreadNamePrefix;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.threadPoolSize = new AtomicInteger(numThreads);
        this.aggregateIdleMeter = this.newMeter(requestHandlerAvgIdleMetricName, "percent", TimeUnit.NANOSECONDS, this.newMeter$default$4());
        this.logIdent_$eq(new StringBuilder(37).append("[").append(logAndThreadNamePrefix).append(" Kafka Request Handler on Broker ").append(brokerId).append("], ").toString());
        this.runnables = new ArrayBuffer(numThreads);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, numThreads);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                this.createHandler(foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }
}

