/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.shuffle;

import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.util.Preconditions;

public class NettyShuffleUtils {
    public static int getNetworkBuffersPerInputChannel(int configuredNetworkBuffersPerChannel) {
        return configuredNetworkBuffersPerChannel;
    }

    public static Pair<Integer, Integer> getMinMaxFloatingBuffersPerInputGate(int numFloatingBuffersPerGate) {
        return Pair.of((Object)1, (Object)numFloatingBuffersPerGate);
    }

    public static Pair<Integer, Integer> getMinMaxNetworkBuffersPerResultPartition(int configuredNetworkBuffersPerChannel, int numFloatingBuffersPerGate, int sortShuffleMinParallelism, int sortShuffleMinBuffers, int numSubpartitions, ResultPartitionType type) {
        int min;
        boolean isSortShuffle = type.isBlocking() && numSubpartitions >= sortShuffleMinParallelism;
        int n = min = isSortShuffle ? sortShuffleMinBuffers : numSubpartitions + 1;
        int max = type.isBounded() ? numSubpartitions * configuredNetworkBuffersPerChannel + numFloatingBuffersPerGate : (isSortShuffle ? Math.max(min, 4 * numSubpartitions) : Integer.MAX_VALUE);
        return Pair.of((Object)min, (Object)Math.max(min, max));
    }

    public static int computeNetworkBuffersForAnnouncing(int numBuffersPerChannel, int numFloatingBuffersPerGate, int sortShuffleMinParallelism, int sortShuffleMinBuffers, int numTotalInputChannels, int numTotalInputGates, Map<IntermediateDataSetID, Integer> subpartitionNums, Map<IntermediateDataSetID, ResultPartitionType> partitionTypes) {
        int requirementForInputs = NettyShuffleUtils.getNetworkBuffersPerInputChannel(numBuffersPerChannel) * numTotalInputChannels + (Integer)NettyShuffleUtils.getMinMaxFloatingBuffersPerInputGate(numFloatingBuffersPerGate).getRight() * numTotalInputGates;
        int requirementForOutputs = 0;
        for (IntermediateDataSetID dataSetId : subpartitionNums.keySet()) {
            int numSubs = subpartitionNums.get(dataSetId);
            Preconditions.checkArgument((boolean)partitionTypes.containsKey(dataSetId));
            ResultPartitionType partitionType = partitionTypes.get(dataSetId);
            requirementForOutputs += NettyShuffleUtils.getNumBuffersToAnnounceForResultPartition(partitionType, numBuffersPerChannel, numFloatingBuffersPerGate, sortShuffleMinParallelism, sortShuffleMinBuffers, numSubs);
        }
        return requirementForInputs + requirementForOutputs;
    }

    private static int getNumBuffersToAnnounceForResultPartition(ResultPartitionType type, int configuredNetworkBuffersPerChannel, int floatingBuffersPerGate, int sortShuffleMinParallelism, int sortShuffleMinBuffers, int numSubpartitions) {
        int ret;
        Pair<Integer, Integer> minAndMax = NettyShuffleUtils.getMinMaxNetworkBuffersPerResultPartition(configuredNetworkBuffersPerChannel, floatingBuffersPerGate, sortShuffleMinParallelism, sortShuffleMinBuffers, numSubpartitions, type);
        int n = ret = type.isPipelined() ? ((Integer)minAndMax.getRight()).intValue() : ((Integer)minAndMax.getLeft()).intValue();
        if (ret == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal to announce network memory requirement as Integer.MAX_VALUE, partition type: " + (Object)((Object)type));
        }
        return ret;
    }

    private NettyShuffleUtils() {
    }
}

