/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.consumer;

import com.google.protobuf.ProtocolStringList;
import java.lang.management.ManagementFactory;
import java.security.SecureRandom;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.inlong.tubemq.client.common.ClientStatsInfo;
import org.apache.inlong.tubemq.client.common.ConfirmResult;
import org.apache.inlong.tubemq.client.common.ConsumeResult;
import org.apache.inlong.tubemq.client.common.QueryMetaResult;
import org.apache.inlong.tubemq.client.config.ConsumerConfig;
import org.apache.inlong.tubemq.client.consumer.ClientBalanceConsumer;
import org.apache.inlong.tubemq.client.consumer.ClientSubInfo;
import org.apache.inlong.tubemq.client.consumer.ConsumeOffsetInfo;
import org.apache.inlong.tubemq.client.consumer.ConsumerSamplePrint;
import org.apache.inlong.tubemq.client.consumer.FetchContext;
import org.apache.inlong.tubemq.client.consumer.PartitionExt;
import org.apache.inlong.tubemq.client.consumer.PartitionSelectResult;
import org.apache.inlong.tubemq.client.consumer.RmtDataCache;
import org.apache.inlong.tubemq.client.consumer.TopicProcessor;
import org.apache.inlong.tubemq.client.exception.TubeClientException;
import org.apache.inlong.tubemq.client.factory.InnerSessionFactory;
import org.apache.inlong.tubemq.corebase.Message;
import org.apache.inlong.tubemq.corebase.aaaclient.ClientAuthenticateHandler;
import org.apache.inlong.tubemq.corebase.aaaclient.SimpleClientAuthenticateHandler;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientBroker;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientMaster;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.AddressUtils;
import org.apache.inlong.tubemq.corebase.utils.DataConverterUtil;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.ThreadUtils;
import org.apache.inlong.tubemq.corerpc.RpcConfig;
import org.apache.inlong.tubemq.corerpc.RpcServiceFactory;
import org.apache.inlong.tubemq.corerpc.service.BrokerReadService;
import org.apache.inlong.tubemq.corerpc.service.MasterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleClientBalanceConsumer
implements ClientBalanceConsumer {
    private static final Logger logger = LoggerFactory.getLogger(SimpleClientBalanceConsumer.class);
    private static final SecureRandom sRandom = new SecureRandom(Long.toString(System.nanoTime()).getBytes());
    protected final String consumerId;
    protected final ConsumerConfig consumerConfig;
    private final InnerSessionFactory sessionFactory;
    private final RpcServiceFactory rpcServiceFactory;
    private final MasterService masterService;
    private final AtomicInteger clientStatus = new AtomicInteger(0);
    private int sourceCount = -2;
    private int nodeId = -2;
    protected final ClientSubInfo consumeSubInfo = new ClientSubInfo();
    protected final RmtDataCache clientRmtDataCache;
    private final ConsumerSamplePrint samplePrintCtrl = new ConsumerSamplePrint();
    private final RpcConfig rpcConfig = new RpcConfig();
    private final AtomicLong visitToken = new AtomicLong(-2L);
    private final AtomicReference<String> authAuthorizedTokenRef = new AtomicReference<String>("");
    private final ClientAuthenticateHandler authenticateHandler = new SimpleClientAuthenticateHandler();
    private final ScheduledExecutorService heartService2Master;
    private final AtomicInteger metaReqStatusId = new AtomicInteger(0);
    private final AtomicLong lstMetaQueryTime = new AtomicLong(0L);
    private final AtomicBoolean needMetaSelfChk = new AtomicBoolean(false);
    private int heartbeat2MRetryTimes = 0;
    private long lastHeartbeatTime2Master = 0L;
    private Thread heartBeatThread2Broker;
    private long lastHeartbeatTime2Broker = 0L;
    private final ConcurrentHashMap<String, Long> partRegFreqCtrlMap = new ConcurrentHashMap();
    protected final ClientStatsInfo clientStatsInfo;

    public SimpleClientBalanceConsumer(InnerSessionFactory messageSessionFactory, ConsumerConfig consumerConfig) throws TubeClientException {
        Security.setProperty("networkaddress.cache.ttl", "3");
        Security.setProperty("networkaddress.cache.negative.ttl", "1");
        if (messageSessionFactory == null || consumerConfig == null) {
            throw new TubeClientException("Illegal parameter: messageSessionFactory or consumerConfig is null!");
        }
        this.sessionFactory = messageSessionFactory;
        this.consumerConfig = consumerConfig;
        try {
            this.consumerId = this.generateConsumerID();
        }
        catch (Exception e) {
            throw new TubeClientException("Get consumer id failed!", e);
        }
        this.clientRmtDataCache = new RmtDataCache(this.consumerConfig, null);
        this.clientStatsInfo = new ClientStatsInfo(false, this.consumerId, this.consumerConfig.getStatsConfig());
        this.rpcServiceFactory = this.sessionFactory.getRpcServiceFactory();
        this.rpcConfig.put("rpc.connect.timeout", (Object)3000);
        this.rpcConfig.put("rpc.request.timeout", (Object)this.consumerConfig.getRpcTimeoutMs());
        this.rpcConfig.put("rpc.netty.worker.thread.name", (Object)"tube_consumer_netty_worker-");
        this.rpcConfig.put("rpc.netty.callback.count", (Object)this.consumerConfig.getRpcRspCallBackThreadCnt());
        this.masterService = (MasterService)this.rpcServiceFactory.getFailoverService(MasterService.class, this.consumerConfig.getMasterInfo(), this.rpcConfig);
        this.heartService2Master = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, new StringBuilder(512).append("Master-Heartbeat-Thread-").append(SimpleClientBalanceConsumer.this.consumerId).toString());
                t.setPriority(10);
                return t;
            }
        });
    }

    @Override
    public boolean start(Map<String, TreeSet<String>> topicAndFilterCondMap, int sourceCount, int nodeId, ProcessResult result) throws TubeClientException {
        if (result == null) {
            throw new TubeClientException("Illegal parameter: parameter result is null!");
        }
        StringBuilder sBuffer = new StringBuilder(512);
        if (!this.validAndStoreConsumeTarget(topicAndFilterCondMap, sBuffer, result)) {
            return result.isSuccess();
        }
        if (sourceCount > 0 && (nodeId < 0 || nodeId > sourceCount - 1)) {
            result.setFailResult(400, "When groupNodeCnt is valid, the nodeId value must be between in [0, sourceCount-1]!");
            return result.isSuccess();
        }
        if (this.clientStatus.get() != 0) {
            result.setFailResult(400, "The SDK is running, please shutdown first!");
            return result.isSuccess();
        }
        if (!this.clientStatus.compareAndSet(0, 1)) {
            switch (this.clientStatus.get()) {
                case 2: {
                    result.setSuccResult();
                    break;
                }
                case 3: {
                    result.setFailResult(400, "The client is shutting down. Please try again later!");
                    break;
                }
                default: {
                    result.setFailResult(400, "Duplicated calls, the client is starting, please wait a minute!");
                }
            }
            return result.isSuccess();
        }
        if (sourceCount > 0) {
            this.sourceCount = sourceCount;
            this.nodeId = nodeId;
        }
        Map consumeTargetMap = (Map)result.getRetData();
        this.consumeSubInfo.storeConsumeTarget(consumeTargetMap);
        if (!this.startMasterAndBrokerThreads(result, sBuffer)) {
            this.clientStatus.compareAndSet(1, 0);
            return result.isSuccess();
        }
        this.clientStatus.compareAndSet(1, 2);
        result.setSuccResult();
        return result.isSuccess();
    }

    @Override
    public boolean isShutdown() {
        int tmpStatusId = this.clientStatus.get();
        return tmpStatusId <= 0 || tmpStatusId > 2;
    }

    @Override
    public ConsumerConfig getConsumerConfig() {
        return this.consumerConfig;
    }

    @Override
    public String getConsumerId() {
        return this.consumerId;
    }

    @Override
    public boolean isFilterConsume(String topic) {
        return this.consumeSubInfo.isFilterConsume(topic);
    }

    @Override
    public int getSourceCount() {
        return this.sourceCount;
    }

    @Override
    public int getNodeId() {
        return this.nodeId;
    }

    @Override
    public String getClientVersion() {
        return "2.3.0";
    }

    public void shutdown() throws Throwable {
        StringBuilder strBuffer = new StringBuilder(512);
        if (!this.clientStatus.compareAndSet(2, 3)) {
            switch (this.clientStatus.get()) {
                case 3: {
                    logger.info(strBuffer.append("[SHUTDOWN_CONSUMER] ").append(this.consumerId).append(" is shutting down, do nothing...").toString());
                    break;
                }
                case 0: {
                    logger.info(strBuffer.append("[SHUTDOWN_CONSUMER] ").append(this.consumerId).append(" was already shutdown, do nothing...").toString());
                    break;
                }
                default: {
                    logger.info(strBuffer.append("[SHUTDOWN_CONSUMER] ").append(this.consumerId).append(" is starting, please wait a minute!").toString());
                }
            }
            return;
        }
        logger.info(strBuffer.append("[SHUTDOWN_CONSUMER] Shutting down consumer:").append(this.consumerId).toString());
        strBuffer.delete(0, strBuffer.length());
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.clientRmtDataCache.close();
        Map<BrokerInfo, List<PartitionSelectResult>> unRegisterInfoMap = this.clientRmtDataCache.getAllPartitionListWithStatus();
        this.unregisterPartitions(unRegisterInfoMap);
        this.sessionFactory.removeClient(this);
        if (this.heartService2Master != null) {
            try {
                this.heartService2Master.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.heartBeatThread2Broker != null) {
            try {
                this.heartBeatThread2Broker.interrupt();
                this.heartBeatThread2Broker.join();
                this.heartBeatThread2Broker = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.clientStatsInfo.selfPrintStatsInfo(true, true, strBuffer);
        logger.info(strBuffer.append("[SHUTDOWN_CONSUMER] Partitions unregistered,  consumer :").append(this.consumerId).toString());
        strBuffer.delete(0, strBuffer.length());
        try {
            this.masterService.consumerCloseClientC2M(this.createMasterCloseRequest(), AddressUtils.getLocalAddress(), this.consumerConfig.isTlsEnable());
        }
        catch (Throwable e) {
            strBuffer.delete(0, strBuffer.length());
            logger.warn(strBuffer.append("[SHUTDOWN_CONSUMER] call closeRequest failure, error is ").append(e.getMessage()).toString());
            strBuffer.delete(0, strBuffer.length());
        }
        logger.info(strBuffer.append("[SHUTDOWN_CONSUMER] Client closed, consumer : ").append(this.consumerId).toString());
        this.clientStatus.set(0);
    }

    @Override
    public Set<String> getCurRegisteredPartSet() {
        return this.clientRmtDataCache.getCurRegisteredPartSet();
    }

    @Override
    public Map<String, ConsumeOffsetInfo> getCurPartitionOffsetInfos() {
        return this.clientRmtDataCache.getCurPartitionInfoMap();
    }

    @Override
    public boolean isPartitionsReady(long maxWaitTime) {
        return this.clientRmtDataCache.isPartitionsReady(maxWaitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getPartitionMetaInfo(QueryMetaResult result) throws TubeClientException {
        if (result == null) {
            throw new TubeClientException("Illegal parameter: parameter result is null!");
        }
        StringBuilder sBuffer = new StringBuilder(512);
        if (this.isShutdown()) {
            result.setFailResult(420, "The client is not started or closed!");
            return result.isSuccess();
        }
        if (System.currentTimeMillis() - this.lstMetaQueryTime.get() >= this.consumerConfig.getPartMetaInfoCheckPeriodMs() && this.metaReqStatusId.compareAndSet(0, 1)) {
            try {
                ClientMaster.GetPartMetaResponseM2C response = this.masterService.consumerGetPartMetaInfoC2M(this.createMasterGetPartMetaRequest(), AddressUtils.getLocalAddress(), this.consumerConfig.isTlsEnable());
                if (response == null) {
                    result.setFailResult(402, sBuffer.append("Query Failed: ").append(this.consumerId).append(" query master and return null!").toString());
                    sBuffer.delete(0, sBuffer.length());
                    boolean bl = result.isSuccess();
                    return bl;
                }
                this.needMetaSelfChk.set(false);
                this.lstMetaQueryTime.set(System.currentTimeMillis());
                if (response.getErrCode() != 200) {
                    result.setFailResult(response.getErrCode(), response.getErrMsg());
                    boolean bl = result.isSuccess();
                    return bl;
                }
                if (response.hasBrokerConfigId()) {
                    this.clientRmtDataCache.updateBrokerInfoList(response.getBrokerConfigId(), (List<String>)response.getBrokerConfigListList(), sBuffer);
                }
                if (response.hasTopicMetaInfoId()) {
                    this.clientRmtDataCache.storeTopicMetaInfo(response.getTopicMetaInfoId(), (List<String>)response.getTopicMetaInfoListList());
                    this.clearUnSubscribablePartitions();
                }
            }
            catch (Throwable e) {
                result.setFailResult(500, sBuffer.append("Query MetaInfo throw exception: ").append(e.getCause()).toString());
                sBuffer.delete(0, sBuffer.length());
                boolean bl = result.isSuccess();
                return bl;
            }
            finally {
                this.metaReqStatusId.set(0);
            }
        }
        result.setSuccResult(this.clientRmtDataCache.getConfPartMetaInfo());
        return result.isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect2Partition(String partitionKey, long boostrapOffset, ProcessResult result) throws TubeClientException {
        if (result == null) {
            throw new TubeClientException("Illegal parameter: parameter result is null!");
        }
        StringBuilder sBuffer = new StringBuilder(512);
        if (TStringUtils.isBlank((String)partitionKey)) {
            result.setFailResult(400, "Parameter partitionKey is blank!");
            return result.isSuccess();
        }
        if (this.isShutdown()) {
            result.setFailResult(420, "The client is not started or closed!");
            return result.isSuccess();
        }
        if (this.clientRmtDataCache.isPartitionInUse(partitionKey)) {
            result.setSuccResult();
            return result.isSuccess();
        }
        if (!this.clientRmtDataCache.getSubscribablePartition(partitionKey, result, sBuffer)) {
            return result.isSuccess();
        }
        Long lstTime = this.partRegFreqCtrlMap.get(partitionKey);
        if (lstTime != null && System.currentTimeMillis() - lstTime < 5000L) {
            result.setFailResult(421, sBuffer.append("High-frequency request, please call ").append(partitionKey).append(" at least ").append(5000L).append("ms interval!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        Partition partition = (Partition)result.getRetData();
        String uniqueId = sBuffer.append(this.consumerConfig.getConsumerGroup()).append("#").append(partitionKey).toString();
        sBuffer.delete(0, sBuffer.length());
        String string = uniqueId;
        synchronized (string) {
            this.registerPartitions(partition, boostrapOffset, result, sBuffer);
        }
        if (!(result.isSuccess() || result.getErrCode() != 410 && result.getErrCode() != 415)) {
            this.partRegFreqCtrlMap.put(partitionKey, System.currentTimeMillis());
        }
        return result.isSuccess();
    }

    @Override
    public boolean disconnectFromPartition(String partitionKey, ProcessResult result) throws TubeClientException {
        if (result == null) {
            throw new TubeClientException("Illegal parameter: parameter result is null!");
        }
        StringBuilder sBuffer = new StringBuilder(512);
        if (TStringUtils.isBlank((String)partitionKey)) {
            result.setFailResult(400, "Parameter partitionKey is blank!");
            return result.isSuccess();
        }
        if (this.isShutdown()) {
            result.setFailResult(420, "The client is not started or closed!");
            return result.isSuccess();
        }
        if (!this.clientRmtDataCache.isPartitionInUse(partitionKey)) {
            result.setSuccResult();
            return result.isSuccess();
        }
        this.clientRmtDataCache.removeAndGetPartition(partitionKey, this.consumerConfig.getPullRebConfirmWaitPeriodMs(), this.consumerConfig.isPullRebConfirmTimeoutRollBack(), result, sBuffer);
        PartitionExt partitionExt = (PartitionExt)((Object)result.getRetData());
        if (partitionExt == null) {
            result.setSuccResult();
            return result.isSuccess();
        }
        this.unregisterPartition(partitionExt, partitionExt.isLastPackConsumed(), sBuffer);
        result.setSuccResult();
        return result.isSuccess();
    }

    @Override
    public boolean getMessage(ConsumeResult result) throws TubeClientException {
        if (result == null) {
            throw new TubeClientException("Illegal parameter: parameter result is null!");
        }
        if (this.isShutdown()) {
            result.setFailResult(420, "The client is not started or closed!");
            return result.isSuccess();
        }
        PartitionSelectResult selectResult = null;
        long startTime = System.currentTimeMillis();
        while (true) {
            if (this.isShutdown()) {
                result.setFailResult(420, "The client has been shutdown!");
                return result.isSuccess();
            }
            selectResult = this.clientRmtDataCache.getCurrPartsStatus();
            if (selectResult.isSuccess()) break;
            if (this.consumerConfig.getPullConsumeReadyWaitPeriodMs() >= 0L && System.currentTimeMillis() - startTime >= this.consumerConfig.getPullConsumeReadyWaitPeriodMs()) {
                result.setFailResult(selectResult.getErrCode(), selectResult.getErrMsg());
                return result.isSuccess();
            }
            if (this.consumerConfig.getPullConsumeReadyChkSliceMs() <= 0L) continue;
            ThreadUtils.sleep((long)this.consumerConfig.getPullConsumeReadyChkSliceMs());
        }
        StringBuilder sBuilder = new StringBuilder(512);
        selectResult = this.clientRmtDataCache.pullSelect();
        if (!selectResult.isSuccess()) {
            result.setFailResult(selectResult.getErrCode(), selectResult.getErrMsg());
            return result.isSuccess();
        }
        FetchContext taskContext = this.fetchMessage(selectResult, sBuilder);
        result.setProcessResult(taskContext);
        return result.isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean confirmConsume(String confirmContext, boolean isConsumed, ConfirmResult result) throws TubeClientException {
        if (result == null) {
            throw new TubeClientException("Illegal parameter: parameter result is null!");
        }
        StringBuilder sBuilder = new StringBuilder(512);
        if (this.isShutdown()) {
            result.setFailResult(420, "The client is not started or closed!");
            return result.isSuccess();
        }
        long currOffset = -2L;
        long maxOffset = -2L;
        if (TStringUtils.isBlank((String)confirmContext)) {
            result.setFailResult(400, "ConfirmContext is null!");
            return result.isSuccess();
        }
        String[] strConfirmContextItems = confirmContext.split(":");
        if (strConfirmContextItems.length != 4) {
            result.setFailResult(400, "ConfirmContext format error: value must be aaaa:bbbb:cccc:ddddd !");
            return result.isSuccess();
        }
        for (String itemStr : strConfirmContextItems) {
            if (!TStringUtils.isBlank((String)itemStr)) continue;
            result.setFailResult(400, sBuilder.append("ConfirmContext's format error: item (").append(itemStr).append(") is null !").toString());
            sBuilder.delete(0, sBuilder.length());
            return result.isSuccess();
        }
        String keyId = sBuilder.append(strConfirmContextItems[0].trim()).append(":").append(strConfirmContextItems[1].trim()).append(":").append(strConfirmContextItems[2].trim()).toString();
        sBuilder.delete(0, sBuilder.length());
        String topicName = strConfirmContextItems[1].trim();
        long timeStamp = Long.parseLong(strConfirmContextItems[3]);
        long midTime = System.currentTimeMillis();
        this.clientStatsInfo.bookReturnDuration(keyId, midTime - timeStamp);
        if (!this.clientRmtDataCache.isPartitionInUse(keyId, timeStamp)) {
            result.setFailResult(400, "The confirmContext's value invalid!");
            return result.isSuccess();
        }
        Partition curPartition = this.clientRmtDataCache.getPartitionByKey(keyId);
        if (curPartition == null) {
            result.setFailResult(404, sBuilder.append("Not found the partition by confirmContext:").append(confirmContext).toString());
            sBuilder.delete(0, sBuilder.length());
            return result.isSuccess();
        }
        if (this.consumerConfig.isPullConfirmInLocal()) {
            this.clientRmtDataCache.succRspRelease(keyId, topicName, timeStamp, isConsumed, this.isFilterConsume(topicName), currOffset, maxOffset);
            result.setSuccResult(topicName, curPartition, currOffset, maxOffset);
            return result.isSuccess();
        }
        try {
            ClientBroker.CommitOffsetResponseB2C response = this.getBrokerService(curPartition.getBroker()).consumerCommitC2B(this.createBrokerCommitRequest(curPartition, isConsumed), AddressUtils.getLocalAddress(), this.getConsumerConfig().isTlsEnable());
            if (response == null) {
                result.setFailResult(402, sBuilder.append("Confirm ").append(confirmContext).append("'s offset failed, response is null!").toString());
                sBuilder.delete(0, sBuilder.length());
                boolean bl = result.isSuccess();
                return bl;
            }
            if (response.hasCurrOffset() && response.getCurrOffset() >= 0L) {
                currOffset = response.getCurrOffset();
            }
            if (response.hasMaxOffset() && response.getMaxOffset() >= 0L) {
                maxOffset = response.getMaxOffset();
            }
            result.setProcessResult(response.getSuccess(), response.getErrCode(), response.getErrMsg(), topicName, curPartition, currOffset, maxOffset);
            boolean bl = result.isSuccess();
            return bl;
        }
        catch (Throwable e) {
            sBuilder.delete(0, sBuilder.length());
            result.setFailResult(400, sBuilder.append("Confirm ").append(confirmContext).append("'s offset failed, exception is ").append(e.toString()).toString());
            sBuilder.delete(0, sBuilder.length());
            boolean bl = result.isSuccess();
            return bl;
        }
        finally {
            this.clientRmtDataCache.succRspRelease(keyId, topicName, timeStamp, isConsumed, this.isFilterConsume(topicName), currOffset, maxOffset);
            this.clientStatsInfo.bookConfirmDuration(keyId, System.currentTimeMillis() - midTime);
        }
    }

    private boolean registerPartitions(Partition partition, long boostrapOffset, ProcessResult result, StringBuilder sBuffer) {
        int maxRegisterRetryTimes = 2;
        for (int retryTimesRegister2Broker = 0; retryTimesRegister2Broker < maxRegisterRetryTimes; ++retryTimesRegister2Broker) {
            if (this.isShutdown()) {
                result.setFailResult(420, "The client is not started or closed!");
                return result.isSuccess();
            }
            if (this.clientRmtDataCache.isPartitionInUse(partition.getPartitionKey())) {
                result.setSuccResult();
                return result.isSuccess();
            }
            if (this.tryRegister2Broker(partition, boostrapOffset, result, sBuffer)) {
                return result.isSuccess();
            }
            logger.warn(sBuffer.append("register ").append(partition.toString()).append(" failure(").append(retryTimesRegister2Broker).append("), return ").append(result.getErrMsg()).toString());
            ThreadUtils.sleep((long)1000L);
        }
        return result.isSuccess();
    }

    private FetchContext fetchMessage(PartitionSelectResult partSelectResult, StringBuilder sBuffer) {
        FetchContext taskContext = new FetchContext(partSelectResult);
        Partition partition = taskContext.getPartition();
        String topic = partition.getTopic();
        String partitionKey = partition.getPartitionKey();
        long startTime = System.currentTimeMillis();
        ClientBroker.GetMessageResponseB2C msgRspB2C = null;
        try {
            msgRspB2C = this.getBrokerService(partition.getBroker()).getMessagesC2B(this.createBrokerGetMessageRequest(partition, taskContext.isLastConsumed()), AddressUtils.getLocalAddress(), this.consumerConfig.isTlsEnable());
        }
        catch (Throwable ee) {
            this.clientStatsInfo.bookFailRpcCall(400);
            this.clientRmtDataCache.errReqRelease(partitionKey, taskContext.getUsedToken(), false);
            taskContext.setFailProcessResult(400, sBuffer.append("Get message error, reason is ").append(ee.toString()).toString());
            sBuffer.delete(0, sBuffer.length());
            return taskContext;
        }
        long dltTime = System.currentTimeMillis() - startTime;
        if (msgRspB2C == null) {
            this.clientStatsInfo.bookFailRpcCall(500);
            this.clientRmtDataCache.errReqRelease(partitionKey, taskContext.getUsedToken(), false);
            taskContext.setFailProcessResult(500, "Get message null");
            return taskContext;
        }
        try {
            switch (msgRspB2C.getErrCode()) {
                case 200: {
                    int msgSize = 0;
                    int msgCount = 0;
                    List tmpMessageList = DataConverterUtil.convertMessage((String)topic, (List)msgRspB2C.getMessagesList());
                    boolean isEscLimit = msgRspB2C.hasEscFlowCtrl() && msgRspB2C.getEscFlowCtrl();
                    boolean needFilter = false;
                    Set<String> topicFilterSet = null;
                    TopicProcessor topicProcessor = this.consumeSubInfo.getTopicProcessor(topic);
                    if (topicProcessor != null && (topicFilterSet = topicProcessor.getFilterConds()) != null && !topicFilterSet.isEmpty()) {
                        needFilter = true;
                    }
                    ArrayList<Message> messageList = new ArrayList<Message>();
                    for (Message message : tmpMessageList) {
                        if (message == null || needFilter && (TStringUtils.isBlank((String)message.getMsgType()) || !topicFilterSet.contains(message.getMsgType()))) continue;
                        ++msgCount;
                        messageList.add(message);
                        msgSize += message.getData().length;
                    }
                    long dataDltVal = msgRspB2C.hasCurrDataDlt() ? msgRspB2C.getCurrDataDlt() : -1L;
                    long currOffset = msgRspB2C.hasCurrOffset() ? msgRspB2C.getCurrOffset() : -2L;
                    long maxOffset = msgRspB2C.hasMaxOffset() ? msgRspB2C.getMaxOffset() : -2L;
                    boolean isRequireSlow = msgRspB2C.hasRequireSlow() && msgRspB2C.getRequireSlow();
                    this.clientRmtDataCache.setPartitionContextInfo(partitionKey, currOffset, 1, msgRspB2C.getErrCode(), isEscLimit, msgSize, 0L, dataDltVal, isRequireSlow, maxOffset);
                    taskContext.setSuccessProcessResult(currOffset, sBuffer.append(partitionKey).append(":").append(taskContext.getUsedToken()).toString(), messageList, maxOffset);
                    sBuffer.delete(0, sBuffer.length());
                    this.clientStatsInfo.bookSuccGetMsg(dltTime, topic, partitionKey, msgCount, msgSize);
                    break;
                }
                case 411: 
                case 412: 
                case 415: {
                    this.clientRmtDataCache.removePartition(partition);
                    taskContext.setFailProcessResult(msgRspB2C.getErrCode(), msgRspB2C.getErrMsg());
                    break;
                }
                case 452: {
                    long defDltTime = msgRspB2C.hasMinLimitTime() ? (long)msgRspB2C.getMinLimitTime() : this.consumerConfig.getMsgNotFoundWaitPeriodMs();
                    this.clientRmtDataCache.errRspRelease(partitionKey, topic, taskContext.getUsedToken(), false, -2L, 0, msgRspB2C.getErrCode(), false, 0, defDltTime, this.isFilterConsume(topic), -2L, -2L);
                    taskContext.setFailProcessResult(msgRspB2C.getErrCode(), msgRspB2C.getErrMsg());
                    break;
                }
                default: {
                    long limitDlt = 300L;
                    switch (msgRspB2C.getErrCode()) {
                        case 403: {
                            limitDlt = 2000L;
                            break;
                        }
                        case 503: {
                            limitDlt = 300L;
                            break;
                        }
                        case 301: {
                            limitDlt = 200L;
                            break;
                        }
                        case 404: {
                            limitDlt = this.consumerConfig.getMsgNotFoundWaitPeriodMs();
                            break;
                        }
                    }
                    this.clientRmtDataCache.errRspRelease(partitionKey, topic, taskContext.getUsedToken(), false, -2L, 0, msgRspB2C.getErrCode(), false, 0, limitDlt, this.isFilterConsume(topic), -1L, -2L);
                    taskContext.setFailProcessResult(msgRspB2C.getErrCode(), msgRspB2C.getErrMsg());
                    break;
                }
            }
            if (msgRspB2C.getErrCode() != 200) {
                this.clientStatsInfo.bookFailRpcCall(msgRspB2C.getErrCode());
            }
            return taskContext;
        }
        catch (Throwable ee) {
            this.clientStatsInfo.bookFailRpcCall(500);
            logger.error("Process response code error", ee);
            this.clientRmtDataCache.succRspRelease(partitionKey, topic, taskContext.getUsedToken(), false, this.isFilterConsume(topic), -2L, -2L);
            taskContext.setFailProcessResult(500, sBuffer.append("Get message failed,topic=").append(topic).append(",partition=").append(partition).append(", throw info is ").append(ee.toString()).toString());
            sBuffer.delete(0, sBuffer.length());
            return taskContext;
        }
    }

    private boolean startMasterAndBrokerThreads(ProcessResult result, StringBuilder sBuffer) {
        int registerRetryTimes = 0;
        while (registerRetryTimes < this.consumerConfig.getMaxRegisterRetryTimes()) {
            if (this.tryRegister2Master(result, sBuffer)) {
                logger.info(sBuffer.append("[Registered] ").append(this.consumerId).toString());
                sBuffer.delete(0, sBuffer.length());
                break;
            }
            logger.error(result.getErrMsg());
            ThreadUtils.sleep((long)this.consumerConfig.getRegFailWaitPeriodMs());
            if (++registerRetryTimes < this.consumerConfig.getMaxRegisterRetryTimes()) continue;
            logger.error(result.getErrMsg());
            return result.isSuccess();
        }
        this.lastHeartbeatTime2Master = System.currentTimeMillis();
        this.heartService2Master.scheduleWithFixedDelay(new HeartTask2MasterWorker(), 0L, this.consumerConfig.getHeartbeatPeriodMs(), TimeUnit.MILLISECONDS);
        this.lastHeartbeatTime2Broker = System.currentTimeMillis();
        this.heartBeatThread2Broker = new Thread(new HeartTask2BrokerWorker());
        this.heartBeatThread2Broker.setName(sBuffer.append("Broker-Heartbeat-Thread-").append(this.consumerId).toString());
        sBuffer.delete(0, sBuffer.length());
        this.heartBeatThread2Broker.setPriority(10);
        this.heartBeatThread2Broker.start();
        result.setSuccResult();
        return result.isSuccess();
    }

    private boolean validAndStoreConsumeTarget(Map<String, TreeSet<String>> consumeTargetMap, StringBuilder sBuffer, ProcessResult result) {
        if (consumeTargetMap == null || consumeTargetMap.isEmpty()) {
            result.setFailResult(400, "Parameter error: the subscribed target is null or empty!");
            return result.isSuccess();
        }
        HashMap newConsumeTargetMap = new HashMap();
        for (Map.Entry<String, TreeSet<String>> entry : consumeTargetMap.entrySet()) {
            String topicName = entry.getKey();
            if (TStringUtils.isBlank((String)topicName)) {
                result.setFailResult(400, "Parameter error: an blank Topic field,topic is blank in map!");
                return result.isSuccess();
            }
            if ((topicName = topicName.trim()).length() > 64) {
                result.setFailResult(400, sBuffer.append("Parameter error: the max length of ").append(topicName).append(" in topicName parameter over ").append(64).append(" characters").toString());
                sBuffer.delete(0, sBuffer.length());
                return result.isSuccess();
            }
            TreeSet<String> filterCondSet = entry.getValue();
            TreeSet<String> newFilterCondSet = new TreeSet<String>();
            if (filterCondSet != null && !filterCondSet.isEmpty()) {
                if (filterCondSet.size() > 500) {
                    result.setFailResult(400, sBuffer.append("Parameter error: over max allowed filter count of ").append(topicName).append(", allowed count is ").append(500).toString());
                    sBuffer.delete(0, sBuffer.length());
                    return result.isSuccess();
                }
                for (String filter : filterCondSet) {
                    if (TStringUtils.isBlank((String)filter)) {
                        result.setFailResult(400, sBuffer.append("Parameter error: include blank filter value of ").append(topicName).toString());
                        sBuffer.delete(0, sBuffer.length());
                        return result.isSuccess();
                    }
                    String tmpFilter = filter.trim();
                    if (tmpFilter.length() > 256) {
                        result.setFailResult(400, sBuffer.append("Parameter error: over max allowed filter length, ").append(tmpFilter).append(" in ").append(topicName).append(", allowed length is ").append(256).toString());
                        sBuffer.delete(0, sBuffer.length());
                        return result.isSuccess();
                    }
                    newFilterCondSet.add(tmpFilter);
                }
            }
            newConsumeTargetMap.put(topicName, newFilterCondSet);
        }
        result.setSuccResult(newConsumeTargetMap);
        return true;
    }

    private boolean tryRegister2Broker(Partition partition, long boostrapOffset, ProcessResult result, StringBuilder sBuffer) {
        try {
            ClientBroker.RegisterResponseB2C response = this.getBrokerService(partition.getBroker()).consumerRegisterC2B(this.createBrokerRegisterRequest(partition, boostrapOffset), AddressUtils.getLocalAddress(), this.consumerConfig.isTlsEnable());
            if (response == null) {
                this.clientStatsInfo.bookReg2Broker(true);
                result.setFailResult(402, sBuffer.append(" register ").append(partition.toString()).append(" return null!").toString());
                return result.isSuccess();
            }
            if (response.getSuccess()) {
                this.clientStatsInfo.bookReg2Broker(false);
                long currOffset = response.hasCurrOffset() ? response.getCurrOffset() : -2L;
                long maxOffset = response.hasMaxOffset() ? response.getMaxOffset() : -2L;
                this.clientRmtDataCache.addPartition(partition, currOffset, maxOffset);
                logger.info(sBuffer.append("Registered partition: consumer is ").append(this.consumerId).append(", partition=").append(partition.toString()).append(", boostrapOffset=").append(boostrapOffset).toString());
                sBuffer.delete(0, sBuffer.length());
                result.setSuccResult();
                return result.isSuccess();
            }
            this.clientStatsInfo.bookReg2Broker(true);
            if (response.getErrCode() == 410 || response.getErrCode() == 415) {
                this.clientRmtDataCache.removePartition(partition);
                if (response.getErrCode() == 410) {
                    result.setFailResult(response.getErrCode(), sBuffer.append("[Partition occupied], curr consumerId: ").append(this.consumerId).append(", returned message : ").append(response.getErrMsg()).toString());
                } else {
                    result.setFailResult(response.getErrCode(), sBuffer.append("[Certificate failure], curr consumerId: ").append(this.consumerId).append(", returned message : ").append(response.getErrMsg()).toString());
                }
            } else {
                result.setFailResult(response.getErrCode(), sBuffer.append(" register ").append(partition.toString()).append(" return ").append(response.getErrMsg()).toString());
            }
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        catch (Throwable e) {
            sBuffer.delete(0, sBuffer.length());
            result.setFailResult(599, sBuffer.append("register ").append(partition.toString()).append(" throw exception ").append(e.toString()).toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
    }

    private boolean tryRegister2Master(ProcessResult result, StringBuilder sBuffer) {
        try {
            ClientMaster.RegisterResponseM2CV2 response = this.masterService.consumerRegisterC2MV2(this.createMasterRegisterRequest(), AddressUtils.getLocalAddress(), this.consumerConfig.isTlsEnable());
            if (response == null) {
                this.clientStatsInfo.bookReg2Master(true);
                result.setFailResult(402, sBuffer.append("Register Failed: ").append(this.consumerId).append(" register to master return null!").toString());
                sBuffer.delete(0, sBuffer.length());
                return result.isSuccess();
            }
            if (response.getErrCode() != 200) {
                this.clientStatsInfo.bookReg2Master(true);
                if (response.getErrCode() == 450) {
                    result.setFailResult(response.getErrCode(), sBuffer.append("Register Failed: ").append(this.consumerId).append("'s ConsumeGroup forbidden, ").append(response.getErrMsg()).toString());
                } else {
                    result.setFailResult(response.getErrCode(), sBuffer.append("Register Failed: ").append(this.consumerId).append(" ").append(response.getErrMsg()).toString());
                }
                sBuffer.delete(0, sBuffer.length());
                return result.isSuccess();
            }
            this.clientStatsInfo.bookReg2Master(false);
            this.clientRmtDataCache.updateReg2MasterTime();
            this.clientRmtDataCache.updateBrokerInfoList(response.getBrokerConfigId(), (List<String>)response.getBrokerConfigListList(), sBuffer);
            this.clientRmtDataCache.updOpsTaskInfo(response.getOpsTaskInfo(), sBuffer);
            this.processRegAuthorizedToken(response);
            result.setSuccResult();
            return result.isSuccess();
        }
        catch (Throwable e) {
            result.setFailResult(sBuffer.append("Register Failed: register to master throw ").append(e.getCause()).toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
    }

    private void unregisterPartition(Partition partition, boolean isLastConsumed, StringBuilder sBuffer) {
        try {
            this.getBrokerService(partition.getBroker()).consumerRegisterC2B(this.createBrokerUnregisterRequest(partition, isLastConsumed), AddressUtils.getLocalAddress(), this.consumerConfig.isTlsEnable());
            logger.info(sBuffer.append("Unregister partition: consumer is ").append(this.consumerId).append(", partition=").append(partition.toString()).append(", isLastPackConsumed=").append(isLastConsumed).toString());
        }
        catch (Throwable e) {
            logger.error(sBuffer.append("Disconnect to Broker error! broker:").append(partition.getBroker().toString()).toString(), e);
            sBuffer.delete(0, sBuffer.length());
        }
    }

    private void unregisterPartitions(Map<BrokerInfo, List<PartitionSelectResult>> unRegisterInfoMap) {
        StringBuilder strBuffer = new StringBuilder(512);
        strBuffer.append("Unregister info:");
        for (Map.Entry<BrokerInfo, List<PartitionSelectResult>> entry : unRegisterInfoMap.entrySet()) {
            for (PartitionSelectResult partResult : entry.getValue()) {
                try {
                    this.getBrokerService(partResult.getPartition().getBroker()).consumerRegisterC2B(this.createBrokerUnregisterRequest(partResult.getPartition(), partResult.isLastPackConsumed()), AddressUtils.getLocalAddress(), this.consumerConfig.isTlsEnable());
                }
                catch (Throwable e) {
                    logger.error(new StringBuilder(512).append("Disconnect to Broker error! broker:").append(partResult.getPartition().getBroker().toString()).toString(), e);
                }
                strBuffer.append(partResult.getPartition().toString());
                strBuffer.append("\n");
            }
        }
        logger.info(strBuffer.toString());
    }

    private ClientMaster.RegisterRequestC2MV2 createMasterRegisterRequest() throws Exception {
        ClientMaster.MasterCertificateInfo authInfo;
        ClientMaster.RegisterRequestC2MV2.Builder builder = ClientMaster.RegisterRequestC2MV2.newBuilder();
        builder.setClientId(this.consumerId);
        builder.setHostName(AddressUtils.getLocalAddress());
        builder.setSourceCount(this.sourceCount);
        builder.setNodeId(this.nodeId);
        builder.setJdkVersion(MixedUtils.getJavaVersion());
        builder.setGroupName(this.consumerConfig.getConsumerGroup());
        builder.addAllTopicList(this.consumeSubInfo.getSubscribedTopics());
        builder.addAllTopicCondition(this.formatTopicCondInfo(this.consumeSubInfo.getTopicCondRegistry()));
        builder.setSubRepInfo(this.clientRmtDataCache.buildClientSubRepInfo());
        ClientMaster.OpsTaskInfo opsTaskInfo = this.clientRmtDataCache.buildOpsTaskInfo();
        if (opsTaskInfo != null) {
            builder.setOpsTaskInfo(opsTaskInfo);
        }
        if ((authInfo = this.genMasterCertificateInfo(true)) != null) {
            builder.setAuthInfo(authInfo);
        }
        return builder.build();
    }

    private ClientMaster.HeartRequestC2MV2 createMasterHeartBeatRequest() {
        ClientMaster.MasterCertificateInfo authInfo;
        ClientMaster.HeartRequestC2MV2.Builder builder = ClientMaster.HeartRequestC2MV2.newBuilder();
        builder.setClientId(this.consumerId);
        builder.setGroupName(this.consumerConfig.getConsumerGroup());
        builder.setSubRepInfo(this.clientRmtDataCache.buildClientSubRepInfo());
        ClientMaster.OpsTaskInfo opsTaskInfo = this.clientRmtDataCache.buildOpsTaskInfo();
        if (opsTaskInfo != null) {
            builder.setOpsTaskInfo(opsTaskInfo);
        }
        if ((authInfo = this.genMasterCertificateInfo(false)) != null) {
            builder.setAuthInfo(authInfo);
        }
        return builder.build();
    }

    private ClientMaster.GetPartMetaRequestC2M createMasterGetPartMetaRequest() {
        ClientMaster.GetPartMetaRequestC2M.Builder builder = ClientMaster.GetPartMetaRequestC2M.newBuilder();
        builder.setClientId(this.consumerId);
        builder.setGroupName(this.consumerConfig.getConsumerGroup());
        builder.setBrokerConfigId(this.clientRmtDataCache.getLastBrokerConfigId());
        builder.setTopicMetaInfoId(this.clientRmtDataCache.getlastTopicMetaInfoId());
        ClientMaster.MasterCertificateInfo authInfo = this.genMasterCertificateInfo(false);
        if (authInfo != null) {
            builder.setAuthInfo(authInfo);
        }
        return builder.build();
    }

    private ClientMaster.CloseRequestC2M createMasterCloseRequest() {
        ClientMaster.CloseRequestC2M.Builder builder = ClientMaster.CloseRequestC2M.newBuilder();
        builder.setClientId(this.consumerId);
        builder.setGroupName(this.consumerConfig.getConsumerGroup());
        ClientMaster.MasterCertificateInfo authInfo = this.genMasterCertificateInfo(false);
        if (authInfo != null) {
            builder.setAuthInfo(authInfo);
        }
        return builder.build();
    }

    private ClientBroker.RegisterRequestC2B createBrokerRegisterRequest(Partition partition, long boostrapOffset) {
        ClientBroker.RegisterRequestC2B.Builder builder = ClientBroker.RegisterRequestC2B.newBuilder();
        builder.setClientId(this.consumerId);
        builder.setGroupName(this.consumerConfig.getConsumerGroup());
        builder.setOpType(31);
        builder.setTopicName(partition.getTopic());
        builder.setPartitionId(partition.getPartitionId());
        builder.setQryPriorityId(this.clientRmtDataCache.getQryPriorityId());
        builder.setReadStatus(this.getGroupInitReadStatus(this.clientRmtDataCache.bookPartition(partition.getPartitionKey())));
        TopicProcessor topicProcessor = this.consumeSubInfo.getTopicProcessor(partition.getTopic());
        if (topicProcessor != null && topicProcessor.getFilterConds() != null) {
            builder.addAllFilterCondStr(topicProcessor.getFilterConds());
        }
        if (boostrapOffset >= 0L) {
            builder.setCurrOffset(boostrapOffset);
        }
        builder.setAuthInfo(this.genBrokerAuthenticInfo(partition.getBrokerId(), false));
        return builder.build();
    }

    private ClientBroker.RegisterRequestC2B createBrokerUnregisterRequest(Partition partition, boolean isLastConsumered) {
        ClientBroker.RegisterRequestC2B.Builder builder = ClientBroker.RegisterRequestC2B.newBuilder();
        builder.setClientId(this.consumerId);
        builder.setGroupName(this.consumerConfig.getConsumerGroup());
        builder.setOpType(32);
        builder.setTopicName(partition.getTopic());
        builder.setPartitionId(partition.getPartitionId());
        if (isLastConsumered) {
            builder.setReadStatus(0);
        } else {
            builder.setReadStatus(1);
        }
        builder.setAuthInfo(this.genBrokerAuthenticInfo(partition.getBrokerId(), true));
        return builder.build();
    }

    private ClientBroker.HeartBeatRequestC2B createBrokerHeartBeatRequest(int brokerId, List<String> partitionList) {
        ClientBroker.HeartBeatRequestC2B.Builder builder = ClientBroker.HeartBeatRequestC2B.newBuilder();
        builder.setClientId(this.consumerId);
        builder.setGroupName(this.consumerConfig.getConsumerGroup());
        builder.setReadStatus(this.getGroupInitReadStatus(false));
        builder.setQryPriorityId(this.clientRmtDataCache.getQryPriorityId());
        builder.addAllPartitionInfo(partitionList);
        builder.setAuthInfo(this.genBrokerAuthenticInfo(brokerId, false));
        return builder.build();
    }

    protected ClientBroker.GetMessageRequestC2B createBrokerGetMessageRequest(Partition partition, boolean isLastConsumed) {
        ClientBroker.GetMessageRequestC2B.Builder builder = ClientBroker.GetMessageRequestC2B.newBuilder();
        builder.setClientId(this.consumerId);
        builder.setGroupName(this.consumerConfig.getConsumerGroup());
        builder.setTopicName(partition.getTopic());
        builder.setEscFlowCtrl(this.clientRmtDataCache.isCurGroupInFlowCtrl());
        builder.setPartitionId(partition.getPartitionId());
        builder.setLastPackConsumed(isLastConsumed);
        builder.setManualCommitOffset(false);
        return builder.build();
    }

    protected ClientBroker.CommitOffsetRequestC2B createBrokerCommitRequest(Partition partition, boolean isConsumed) {
        ClientBroker.CommitOffsetRequestC2B.Builder builder = ClientBroker.CommitOffsetRequestC2B.newBuilder();
        builder.setClientId(this.consumerId);
        builder.setGroupName(this.consumerConfig.getConsumerGroup());
        builder.setTopicName(partition.getTopic());
        builder.setPartitionId(partition.getPartitionId());
        builder.setLastPackConsumed(isConsumed);
        return builder.build();
    }

    private List<String> formatTopicCondInfo(ConcurrentHashMap<String, TopicProcessor> topicCondMap) {
        StringBuilder strBuffer = new StringBuilder(512);
        ArrayList<String> strTopicCondList = new ArrayList<String>();
        if (topicCondMap != null && !topicCondMap.isEmpty()) {
            for (Map.Entry<String, TopicProcessor> entry : topicCondMap.entrySet()) {
                Set<String> condSet;
                if (entry.getKey() == null || entry.getValue() == null || (condSet = entry.getValue().getFilterConds()) == null || condSet.isEmpty()) continue;
                int i = 0;
                strBuffer.append(entry.getKey()).append("#");
                for (String condStr : condSet) {
                    if (i++ > 0) {
                        strBuffer.append(",");
                    }
                    strBuffer.append(condStr);
                }
                strTopicCondList.add(strBuffer.toString());
                strBuffer.delete(0, strBuffer.length());
            }
        }
        return strTopicCondList;
    }

    private void clearUnSubscribablePartitions() throws Exception {
        ProcessResult tmpResult = new ProcessResult();
        Set<String> regPartSet = this.clientRmtDataCache.getCurRegisteredPartSet();
        for (String partKey : regPartSet) {
            if (!this.clientRmtDataCache.isPartSubscribable(partKey) && !this.disconnectFromPartition(partKey, tmpResult) && tmpResult.getErrCode() == 420) break;
        }
    }

    private ClientBroker.AuthorizedInfo genBrokerAuthenticInfo(int brokerId, boolean force) {
        ClientBroker.AuthorizedInfo.Builder authInfoBuilder = ClientBroker.AuthorizedInfo.newBuilder();
        authInfoBuilder.setVisitAuthorizedToken(this.visitToken.get());
        if (this.consumerConfig.isEnableUserAuthentic() && this.clientRmtDataCache.markAndGetBrokerAuthStatus(brokerId, force)) {
            authInfoBuilder.setAuthAuthorizedToken(this.authenticateHandler.genBrokerAuthenticateToken(this.consumerConfig.getUsrName(), this.consumerConfig.getUsrPassWord()));
        }
        return authInfoBuilder.build();
    }

    private ClientMaster.MasterCertificateInfo genMasterCertificateInfo(boolean force) {
        ClientMaster.MasterCertificateInfo.Builder authInfoBuilder = null;
        if (this.consumerConfig.isEnableUserAuthentic()) {
            authInfoBuilder = ClientMaster.MasterCertificateInfo.newBuilder();
            if (this.clientRmtDataCache.markAndGetAuthStatus(force)) {
                authInfoBuilder.setAuthInfo(this.authenticateHandler.genMasterAuthenticateToken(this.consumerConfig.getUsrName(), this.consumerConfig.getUsrPassWord()));
            } else {
                authInfoBuilder.setAuthorizedToken(this.authAuthorizedTokenRef.get());
            }
        }
        if (authInfoBuilder != null) {
            return authInfoBuilder.build();
        }
        return null;
    }

    private void processRegAuthorizedToken(ClientMaster.RegisterResponseM2CV2 response) {
        if (response.hasAuthorizedInfo()) {
            this.processAuthorizedToken(response.getAuthorizedInfo());
        }
    }

    private void processHeartBeatAuthorizedToken(ClientMaster.HeartResponseM2CV2 response) {
        if (response.hasAuthorizedInfo()) {
            this.processAuthorizedToken(response.getAuthorizedInfo());
        }
    }

    private void processAuthorizedToken(ClientMaster.MasterAuthorizedInfo inAuthorizedTokenInfo) {
        if (inAuthorizedTokenInfo != null) {
            String curAuthAuthorizedToken;
            String inAuthAuthorizedToken;
            this.visitToken.set(inAuthorizedTokenInfo.getVisitAuthorizedToken());
            if (inAuthorizedTokenInfo.hasAuthAuthorizedToken() && TStringUtils.isNotBlank((String)(inAuthAuthorizedToken = inAuthorizedTokenInfo.getAuthAuthorizedToken())) && !inAuthAuthorizedToken.equals(curAuthAuthorizedToken = this.authAuthorizedTokenRef.get())) {
                this.authAuthorizedTokenRef.set(inAuthAuthorizedToken);
            }
        }
    }

    private int getGroupInitReadStatus(boolean isFistReg) {
        int readStatus = 0;
        switch (this.consumerConfig.getConsumePosition()) {
            case CONSUMER_FROM_LATEST_OFFSET: {
                if (!isFistReg) break;
                readStatus = 1;
                logger.info("[Consume From Max Offset]" + this.consumerId);
                break;
            }
            case CONSUMER_FROM_MAX_OFFSET_ALWAYS: {
                if (!isFistReg) break;
                readStatus = 2;
                logger.info("[Consume From Max Offset Always]" + this.consumerId);
                break;
            }
            default: {
                readStatus = 0;
            }
        }
        return readStatus;
    }

    protected BrokerReadService getBrokerService(BrokerInfo brokerInfo) {
        return (BrokerReadService)this.rpcServiceFactory.getService(BrokerReadService.class, brokerInfo, this.rpcConfig);
    }

    private String generateConsumerID() throws Exception {
        String pidName = ManagementFactory.getRuntimeMXBean().getName();
        if (pidName != null && pidName.contains("@")) {
            pidName = pidName.split("@")[0];
        }
        return new StringBuilder(256).append(this.consumerConfig.getConsumerGroup()).append("_").append(AddressUtils.getLocalAddress()).append("-").append(pidName).append("-").append(System.nanoTime()).append("-").append(Math.abs(sRandom.nextInt())).append("-Balance-").append("2.3.0").toString();
    }

    private class HeartTask2BrokerWorker
    implements Runnable {
        private HeartTask2BrokerWorker() {
        }

        @Override
        public void run() {
            StringBuilder strBuffer = new StringBuilder(512);
            while (!SimpleClientBalanceConsumer.this.isShutdown()) {
                try {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - SimpleClientBalanceConsumer.this.lastHeartbeatTime2Broker > SimpleClientBalanceConsumer.this.consumerConfig.getHeartbeatPeriodMs() * 2L) {
                        logger.warn(strBuffer.append(SimpleClientBalanceConsumer.this.consumerId).append(" heartbeat to broker is too long, please check! Total time : ").append(currentTime - SimpleClientBalanceConsumer.this.lastHeartbeatTime2Broker).toString());
                        strBuffer.delete(0, strBuffer.length());
                    }
                    this.processBrokerHeatBeat(strBuffer);
                    if (SimpleClientBalanceConsumer.this.needMetaSelfChk.compareAndSet(true, false)) {
                        SimpleClientBalanceConsumer.this.clearUnSubscribablePartitions();
                    }
                    if (SimpleClientBalanceConsumer.this.clientRmtDataCache.isCsmFromMaxOffset()) {
                        this.resetCsmFromMaxOffset(strBuffer);
                    }
                    SimpleClientBalanceConsumer.this.lastHeartbeatTime2Broker = System.currentTimeMillis();
                    Thread.sleep(SimpleClientBalanceConsumer.this.consumerConfig.getHeartbeatPeriodMs());
                }
                catch (Throwable e) {
                    SimpleClientBalanceConsumer.this.lastHeartbeatTime2Broker = System.currentTimeMillis();
                    if (SimpleClientBalanceConsumer.this.isShutdown()) continue;
                    logger.error("heartbeat thread error 3 : ", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetCsmFromMaxOffset(StringBuilder sBuffer) {
            Set<String> regPartSet = SimpleClientBalanceConsumer.this.clientRmtDataCache.getCurRegisteredPartSet();
            if (regPartSet.isEmpty()) {
                return;
            }
            for (String partitionKey : regPartSet) {
                if (TStringUtils.isBlank((String)partitionKey)) continue;
                if (SimpleClientBalanceConsumer.this.isShutdown()) break;
                long boostrapOffset = SimpleClientBalanceConsumer.this.clientRmtDataCache.getMaxOffsetOfPartition(partitionKey);
                String uniqueId = sBuffer.append(SimpleClientBalanceConsumer.this.consumerConfig.getConsumerGroup()).append("#").append(partitionKey).toString();
                sBuffer.delete(0, sBuffer.length());
                String string = uniqueId;
                synchronized (string) {
                    Partition partition = SimpleClientBalanceConsumer.this.clientRmtDataCache.getPartitionByKey(partitionKey);
                    if (partition == null) {
                        continue;
                    }
                    try {
                        ClientBroker.RegisterResponseB2C response = SimpleClientBalanceConsumer.this.getBrokerService(partition.getBroker()).consumerRegisterC2B(SimpleClientBalanceConsumer.this.createBrokerRegisterRequest(partition, boostrapOffset), AddressUtils.getLocalAddress(), SimpleClientBalanceConsumer.this.consumerConfig.isTlsEnable());
                        if (response == null) {
                            continue;
                        }
                        if (response.getSuccess()) {
                            long currOffset = response.hasCurrOffset() ? response.getCurrOffset() : -2L;
                            long maxOffset = response.hasMaxOffset() ? response.getMaxOffset() : -2L;
                            SimpleClientBalanceConsumer.this.clientRmtDataCache.updPartOffsetInfo(partitionKey, currOffset, maxOffset);
                            logger.info(sBuffer.append("[Admin Reset] consumer is ").append(SimpleClientBalanceConsumer.this.consumerId).append(", partition=").append(partition.toString()).append(", consume from max=").append(currOffset).toString());
                            sBuffer.delete(0, sBuffer.length());
                        } else if (response.getErrCode() == 410 || response.getErrCode() == 415) {
                            SimpleClientBalanceConsumer.this.clientRmtDataCache.removePartition(partition);
                        }
                    }
                    catch (Throwable e) {
                        sBuffer.delete(0, sBuffer.length());
                        logger.info(sBuffer.append("register ").append(partition.toString()).append(" throw exception ").append(e.toString()).toString());
                        sBuffer.delete(0, sBuffer.length());
                    }
                }
            }
        }

        private void processBrokerHeatBeat(StringBuilder sBuffer) {
            for (BrokerInfo brokerInfo : SimpleClientBalanceConsumer.this.clientRmtDataCache.getAllRegisterBrokers()) {
                if (SimpleClientBalanceConsumer.this.isShutdown()) break;
                ArrayList<String> partStrSet = new ArrayList<String>();
                try {
                    List<Partition> partitions = SimpleClientBalanceConsumer.this.clientRmtDataCache.getBrokerPartitionList(brokerInfo);
                    if (partitions == null || partitions.isEmpty()) continue;
                    for (Partition partition : partitions) {
                        partStrSet.add(partition.toString());
                    }
                    ClientBroker.HeartBeatResponseB2C response = SimpleClientBalanceConsumer.this.getBrokerService(brokerInfo).consumerHeartbeatC2B(SimpleClientBalanceConsumer.this.createBrokerHeartBeatRequest(brokerInfo.getBrokerId(), partStrSet), AddressUtils.getLocalAddress(), SimpleClientBalanceConsumer.this.consumerConfig.isTlsEnable());
                    if (response == null) {
                        SimpleClientBalanceConsumer.this.clientStatsInfo.bookHB2BrokerTimeout();
                        continue;
                    }
                    if (response.getSuccess()) {
                        SimpleClientBalanceConsumer.this.clientRmtDataCache.bookBrokerRequireAuthInfo(brokerInfo.getBrokerId(), response);
                        if (!response.getHasPartFailure()) continue;
                        try {
                            ProtocolStringList strFailInfoList = response.getFailureInfoList();
                            for (String strFailInfo : strFailInfoList) {
                                int index = strFailInfo.indexOf(":");
                                if (index < 0) {
                                    logger.error(sBuffer.append("Parse Heartbeat response error : ").append("invalid response, ").append(strFailInfo).toString());
                                    sBuffer.delete(0, sBuffer.length());
                                    continue;
                                }
                                int errorCode = Integer.parseInt(strFailInfo.substring(0, index));
                                Partition failPartition = new Partition(strFailInfo.substring(index + 1));
                                SimpleClientBalanceConsumer.this.clientRmtDataCache.removePartition(failPartition);
                                logger.warn(sBuffer.append("[heart2broker error] partition:").append(failPartition.toString()).append(", errorCode=").append(errorCode).toString());
                                sBuffer.delete(0, sBuffer.length());
                            }
                            continue;
                        }
                        catch (Throwable throwable) {
                            if (SimpleClientBalanceConsumer.this.isShutdown()) continue;
                            sBuffer.delete(0, sBuffer.length());
                            logger.error(sBuffer.append("Parse Heartbeat response error :").append(throwable.getMessage()).toString());
                            sBuffer.delete(0, sBuffer.length());
                            continue;
                        }
                    }
                    SimpleClientBalanceConsumer.this.clientStatsInfo.bookHB2BrokerException();
                    if (response.getErrCode() != 415) continue;
                    for (Partition partition : partitions) {
                        SimpleClientBalanceConsumer.this.clientRmtDataCache.removePartition(partition);
                    }
                    logger.warn(sBuffer.append("[heart2broker error] certificate failure, ").append(brokerInfo.getBrokerStrInfo()).append("'s partitions area released, ").append(response.getErrMsg()).toString());
                    sBuffer.delete(0, sBuffer.length());
                }
                catch (Throwable ee) {
                    if (SimpleClientBalanceConsumer.this.isShutdown()) continue;
                    SimpleClientBalanceConsumer.this.samplePrintCtrl.printExceptionCaught(ee);
                    if (partStrSet.isEmpty()) continue;
                    sBuffer.delete(0, sBuffer.length());
                    for (String partitionStr : partStrSet) {
                        Partition tmpPartition = new Partition(partitionStr);
                        SimpleClientBalanceConsumer.this.clientRmtDataCache.removePartition(tmpPartition);
                        logger.warn(sBuffer.append("[heart2broker Throwable] release partition:").append(partitionStr).toString());
                        sBuffer.delete(0, sBuffer.length());
                    }
                }
            }
        }
    }

    private class HeartTask2MasterWorker
    implements Runnable {
        private HeartTask2MasterWorker() {
        }

        @Override
        public void run() {
            ProcessResult result = new ProcessResult();
            StringBuilder strBuffer = new StringBuilder(512);
            try {
                SimpleClientBalanceConsumer.this.clientRmtDataCache.resumeTimeoutConsumePartitions(false, SimpleClientBalanceConsumer.this.consumerConfig.getPullProtectConfirmTimeoutMs());
                SimpleClientBalanceConsumer.this.clientStatsInfo.selfPrintStatsInfo(false, true, strBuffer);
                ClientMaster.HeartResponseM2CV2 response = SimpleClientBalanceConsumer.this.masterService.consumerHeartbeatC2MV2(SimpleClientBalanceConsumer.this.createMasterHeartBeatRequest(), AddressUtils.getLocalAddress(), SimpleClientBalanceConsumer.this.consumerConfig.isTlsEnable());
                if (response == null) {
                    SimpleClientBalanceConsumer.this.clientStatsInfo.bookHB2MasterTimeout();
                    logger.warn(strBuffer.append("[Heartbeat Failed] ").append("return result is null!").toString());
                    strBuffer.delete(0, strBuffer.length());
                    SimpleClientBalanceConsumer.this.heartbeat2MRetryTimes++;
                    return;
                }
                if (response.getErrCode() != 200) {
                    if (response.getErrCode() == 411) {
                        SimpleClientBalanceConsumer.this.clientStatsInfo.bookHB2MasterTimeout();
                        if (SimpleClientBalanceConsumer.this.tryRegister2Master(result, strBuffer)) {
                            logger.info(strBuffer.append("[Re-register] ").append(SimpleClientBalanceConsumer.this.consumerId).toString());
                            strBuffer.delete(0, strBuffer.length());
                        } else {
                            logger.info(result.getErrMsg());
                        }
                        return;
                    }
                    SimpleClientBalanceConsumer.this.clientStatsInfo.bookHB2MasterException();
                    logger.error(strBuffer.append("[Heartbeat Failed] ").append(response.getErrMsg()).toString());
                    if (response.getErrCode() == 415) {
                        this.adjustHeartBeatPeriod("certificate failure", strBuffer);
                    } else {
                        SimpleClientBalanceConsumer.this.heartbeat2MRetryTimes++;
                    }
                    return;
                }
                SimpleClientBalanceConsumer.this.heartbeat2MRetryTimes = 0;
                SimpleClientBalanceConsumer.this.clientRmtDataCache.updateBrokerInfoList(response.getBrokerConfigId(), (List<String>)response.getBrokerConfigListList(), strBuffer);
                if (response.hasTopicMetaInfoId()) {
                    SimpleClientBalanceConsumer.this.needMetaSelfChk.compareAndSet(false, true);
                    SimpleClientBalanceConsumer.this.clientRmtDataCache.storeTopicMetaInfo(response.getTopicMetaInfoId(), (List<String>)response.getTopicMetaInfoListList());
                    SimpleClientBalanceConsumer.this.lstMetaQueryTime.set(System.currentTimeMillis());
                }
                SimpleClientBalanceConsumer.this.clientRmtDataCache.updOpsTaskInfo(response.getOpsTaskInfo(), strBuffer);
                SimpleClientBalanceConsumer.this.processHeartBeatAuthorizedToken(response);
                long currentTime = System.currentTimeMillis();
                if (currentTime - SimpleClientBalanceConsumer.this.lastHeartbeatTime2Master > SimpleClientBalanceConsumer.this.consumerConfig.getHeartbeatPeriodMs() * 2L) {
                    logger.warn(strBuffer.append(SimpleClientBalanceConsumer.this.consumerId).append(" heartbeat interval to master is too long,please check! Total time : ").append(currentTime - SimpleClientBalanceConsumer.this.lastHeartbeatTime2Master).toString());
                    strBuffer.delete(0, strBuffer.length());
                }
                SimpleClientBalanceConsumer.this.lastHeartbeatTime2Master = currentTime;
            }
            catch (InterruptedException ee) {
                logger.info("To Master Heartbeat thread is interrupted,existed!");
            }
            catch (Throwable e) {
                if (!SimpleClientBalanceConsumer.this.isShutdown()) {
                    SimpleClientBalanceConsumer.this.samplePrintCtrl.printExceptionCaught(e);
                }
                this.adjustHeartBeatPeriod("heartbeat exception", strBuffer);
            }
        }

        private void adjustHeartBeatPeriod(String reason, StringBuilder sBuilder) {
            SimpleClientBalanceConsumer.this.lastHeartbeatTime2Master = System.currentTimeMillis();
            SimpleClientBalanceConsumer.this.heartbeat2MRetryTimes++;
            if (!SimpleClientBalanceConsumer.this.isShutdown() && SimpleClientBalanceConsumer.this.heartbeat2MRetryTimes > SimpleClientBalanceConsumer.this.consumerConfig.getMaxHeartBeatRetryTimes()) {
                logger.warn(sBuilder.append("Adjust HeartbeatPeriod for ").append(reason).append(", sleep ").append(SimpleClientBalanceConsumer.this.consumerConfig.getHeartbeatPeriodAfterFail()).append(" Ms").toString());
                sBuilder.delete(0, sBuilder.length());
                ThreadUtils.sleep((long)SimpleClientBalanceConsumer.this.consumerConfig.getHeartbeatPeriodAfterFail());
            }
        }
    }
}

