/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import org.apache.jena.dboe.base.block.BlockMgr;
import org.apache.jena.dboe.base.page.Page;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.trans.bplustree.AccessPath;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeParams;
import org.slf4j.Logger;

public abstract class BPTreePage
implements Page {
    protected final BPlusTree bpTree;
    protected final BPlusTreeParams params;

    protected BPTreePage(BPlusTree bpTree) {
        this.bpTree = bpTree;
        this.params = bpTree == null ? null : bpTree.getParams();
    }

    protected String label() {
        return String.format("%d[%s]", this.getId(), this.typeMark());
    }

    protected abstract String typeMark();

    protected abstract Logger getLogger();

    abstract BlockMgr getBlockMgr();

    abstract BPTreePage split();

    abstract Record shiftRight(BPTreePage var1, Record var2);

    abstract Record shiftLeft(BPTreePage var1, Record var2);

    abstract BPTreePage merge(BPTreePage var1, Record var2);

    abstract boolean isFull();

    abstract boolean isMinSize();

    abstract int getCount();

    abstract void setCount(int var1);

    abstract int getMaxSize();

    abstract boolean hasAnyKeys();

    abstract Record internalSearch(AccessPath var1, Record var2);

    abstract Record internalInsert(AccessPath var1, Record var2);

    abstract Record internalDelete(AccessPath var1, Record var2);

    abstract Record getLowRecord();

    abstract Record getHighRecord();

    abstract Record internalMinRecord(AccessPath var1);

    abstract Record internalMaxRecord(AccessPath var1);

    Record minRecord() {
        return this.internalMinRecord(null);
    }

    Record maxRecord() {
        return this.internalMaxRecord(null);
    }

    abstract void write();

    abstract boolean promote();

    abstract void release();

    abstract void free();

    abstract void checkNode();

    abstract void checkNodeDeep();

    abstract Record getSplitKey();
}

