/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.index.v1;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IOX;
import org.apache.jena.geosparql.configuration.GeoSPARQLOperations;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.SRSInfo;
import org.apache.jena.geosparql.implementation.registry.SRSRegistry;
import org.apache.jena.geosparql.implementation.vocabulary.Geo;
import org.apache.jena.geosparql.implementation.vocabulary.SpatialExtension;
import org.apache.jena.geosparql.spatial.ConvertLatLon;
import org.apache.jena.geosparql.spatial.SpatialIndex;
import org.apache.jena.geosparql.spatial.SpatialIndexConstants;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.geosparql.spatial.SpatialIndexItem;
import org.apache.jena.geosparql.spatial.SpatialIndexStorage;
import org.apache.jena.geosparql.spatial.index.v1.SpatialIndexAdapterV1;
import org.apache.jena.geosparql.spatial.index.v2.SpatialIndexLib;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
public class SpatialIndexV1 {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final transient SRSInfo srsInfo;
    private boolean isBuilt;
    private final STRtree strTree;
    private static final int MINIMUM_CAPACITY = 2;
    private File location;

    private SpatialIndexV1() {
        this.strTree = new STRtree(2);
        this.isBuilt = true;
        this.strTree.build();
        this.srsInfo = SRSRegistry.getSRSInfo("http://www.opengis.net/def/crs/OGC/1.3/CRS84");
    }

    public SpatialIndexV1(int capacity, String srsURI) {
        int indexCapacity = capacity < 2 ? 2 : capacity;
        this.strTree = new STRtree(indexCapacity);
        this.isBuilt = false;
        this.srsInfo = SRSRegistry.getSRSInfo(srsURI);
    }

    public SpatialIndexV1(Collection<SpatialIndexItem> spatialIndexItems, String srsURI) throws SpatialIndexException {
        int indexCapacity = spatialIndexItems.size() < 2 ? 2 : spatialIndexItems.size();
        this.strTree = new STRtree(indexCapacity);
        this.insertItems(spatialIndexItems);
        this.strTree.build();
        this.isBuilt = true;
        this.srsInfo = SRSRegistry.getSRSInfo(srsURI);
    }

    public File getLocation() {
        return this.location;
    }

    public void setLocation(File location) {
        this.location = location;
    }

    public SRSInfo getSrsInfo() {
        return this.srsInfo;
    }

    public boolean isEmpty() {
        return this.strTree.isEmpty();
    }

    public boolean isBuilt() {
        return this.isBuilt;
    }

    public void build() {
        if (!this.isBuilt) {
            this.strTree.build();
            this.isBuilt = true;
        }
    }

    public final void insertItems(Collection<SpatialIndexItem> indexItems) throws SpatialIndexException {
        for (SpatialIndexItem indexItem : indexItems) {
            this.insertItem(indexItem.getEnvelope(), ModelUtils.convertGraphNodeToRDFNode(indexItem.getItem()).asResource());
        }
    }

    public final void insertItem(Envelope envelope, Resource item) throws SpatialIndexException {
        if (this.isBuilt) {
            throw new SpatialIndexException("SpatialIndex has been built and cannot have additional items.");
        }
        this.strTree.insert(envelope, (Object)item);
    }

    public HashSet<Resource> query(Envelope searchEnvelope) {
        if (!this.strTree.isEmpty()) {
            return new HashSet<Resource>(this.strTree.query(searchEnvelope));
        }
        return new HashSet<Resource>();
    }

    public String toString() {
        return "SpatialIndex{srsInfo=" + String.valueOf(this.srsInfo) + ", isBuilt=" + this.isBuilt + ", strTree=" + String.valueOf(this.strTree) + "}";
    }

    public static final SpatialIndexV1 retrieve(ExecutionContext execCxt) throws SpatialIndexException {
        Context context2 = execCxt.getContext();
        SpatialIndexV1 spatialIndex = context2.get(SpatialIndexConstants.symSpatialIndex, null);
        if (spatialIndex == null) {
            throw new SpatialIndexException("Dataset Context does not contain SpatialIndex.");
        }
        return spatialIndex;
    }

    public static final boolean isDefined(ExecutionContext execCxt) {
        Context context2 = execCxt.getContext();
        return context2.isDefined(SpatialIndexConstants.symSpatialIndex);
    }

    public static final void setSpatialIndex(Dataset dataset, SpatialIndexV1 spatialIndex) {
        Context context2 = dataset.getContext();
        SpatialIndexAdapterV1 wrapper = new SpatialIndexAdapterV1(spatialIndex);
        SpatialIndexLib.setSpatialIndex(context2, (SpatialIndex)wrapper);
    }

    public static SpatialIndexV1 buildSpatialIndex(Dataset dataset, String srsURI, File spatialIndexFile) throws SpatialIndexException {
        SpatialIndexV1 spatialIndex = SpatialIndexV1.load(spatialIndexFile);
        spatialIndex.setLocation(spatialIndexFile);
        if (spatialIndex.isEmpty()) {
            Collection<SpatialIndexItem> spatialIndexItems = SpatialIndexV1.findSpatialIndexItems(dataset, srsURI);
            SpatialIndexV1.save(spatialIndexFile, spatialIndexItems, srsURI);
            spatialIndex = new SpatialIndexV1(spatialIndexItems, srsURI);
            spatialIndex.build();
        }
        SpatialIndexV1.setSpatialIndex(dataset, spatialIndex);
        return spatialIndex;
    }

    public static SpatialIndexV1 buildSpatialIndex(Dataset dataset, File spatialIndexFile) throws SpatialIndexException {
        String srsURI = GeoSPARQLOperations.findModeSRS(dataset);
        SpatialIndexV1 spatialIndex = SpatialIndexV1.buildSpatialIndex(dataset, srsURI, spatialIndexFile);
        return spatialIndex;
    }

    public static SpatialIndexV1 buildSpatialIndex(Dataset dataset, String srsURI) throws SpatialIndexException {
        LOGGER.info("Building Spatial Index - Started");
        Collection<SpatialIndexItem> items = SpatialIndexV1.findSpatialIndexItems(dataset, srsURI);
        SpatialIndexV1 spatialIndex = new SpatialIndexV1(items, srsURI);
        spatialIndex.build();
        SpatialIndexV1.setSpatialIndex(dataset, spatialIndex);
        LOGGER.info("Building Spatial Index - Completed");
        return spatialIndex;
    }

    public static Collection<SpatialIndexItem> findSpatialIndexItems(Dataset dataset, String srsURI) throws SpatialIndexException {
        dataset.begin(ReadWrite.READ);
        Model defaultModel = dataset.getDefaultModel();
        Collection<SpatialIndexItem> items = SpatialIndexV1.getSpatialIndexItems(defaultModel, srsURI);
        Iterator<String> graphNames = dataset.listNames();
        while (graphNames.hasNext()) {
            String graphName = graphNames.next();
            Model namedModel = dataset.getNamedModel(graphName);
            Collection<SpatialIndexItem> graphItems = SpatialIndexV1.getSpatialIndexItems(namedModel, srsURI);
            items.addAll(graphItems);
        }
        dataset.end();
        return items;
    }

    public static SpatialIndexV1 buildSpatialIndex(Dataset dataset) throws SpatialIndexException {
        String srsURI = GeoSPARQLOperations.findModeSRS(dataset);
        SpatialIndexV1 spatialIndex = SpatialIndexV1.buildSpatialIndex(dataset, srsURI);
        return spatialIndex;
    }

    public static final Dataset wrapModel(Model model, String srsURI) throws SpatialIndexException {
        Dataset dataset = DatasetFactory.createTxnMem();
        dataset.setDefaultModel(model);
        SpatialIndexV1.buildSpatialIndex(dataset, srsURI);
        return dataset;
    }

    public static final Dataset wrapModel(Model model) throws SpatialIndexException {
        Dataset dataset = DatasetFactory.createTxnMem();
        dataset.setDefaultModel(model);
        String srsURI = GeoSPARQLOperations.findModeSRS(dataset);
        SpatialIndexV1.buildSpatialIndex(dataset, srsURI);
        return dataset;
    }

    public static final Collection<SpatialIndexItem> getSpatialIndexItems(Model model, String srsURI) throws SpatialIndexException {
        ArrayList<SpatialIndexItem> items = new ArrayList<SpatialIndexItem>();
        if (model.contains(null, Geo.HAS_GEOMETRY_PROP, (RDFNode)null)) {
            LOGGER.info("Feature-hasGeometry-Geometry statements found.");
            if (model.contains(null, SpatialExtension.GEO_LAT_PROP, (RDFNode)null)) {
                LOGGER.warn("Lat/Lon Geo predicates also found but will not be added to index.");
            }
            Collection<SpatialIndexItem> geometryLiteralItems = SpatialIndexV1.getGeometryLiteralIndexItems(model, srsURI);
            items.addAll(geometryLiteralItems);
        } else if (model.contains(null, SpatialExtension.GEO_LAT_PROP, (RDFNode)null)) {
            LOGGER.info("Geo predicate statements found.");
            Collection<SpatialIndexItem> geoPredicateItems = SpatialIndexV1.getGeoPredicateIndexItems(model, srsURI);
            items.addAll(geoPredicateItems);
        }
        return items;
    }

    private static Collection<SpatialIndexItem> getGeometryLiteralIndexItems(Model model, String srsURI) throws SpatialIndexException {
        ArrayList<SpatialIndexItem> items = new ArrayList<SpatialIndexItem>();
        StmtIterator stmtIt = model.listStatements(null, Geo.HAS_GEOMETRY_PROP, (RDFNode)null);
        while (stmtIt.hasNext()) {
            Statement stmt = stmtIt.nextStatement();
            Resource feature = stmt.getSubject();
            Resource geometry = stmt.getResource();
            ExtendedIterator<RDFNode> nodeIter = model.listObjectsOfProperty(geometry, Geo.HAS_SERIALIZATION_PROP);
            if (!nodeIter.hasNext()) {
                NodeIterator wktNodeIter = model.listObjectsOfProperty(geometry, Geo.AS_WKT_PROP);
                NodeIterator gmlNodeIter = model.listObjectsOfProperty(geometry, Geo.AS_GML_PROP);
                nodeIter = wktNodeIter.andThen(gmlNodeIter);
            }
            while (nodeIter.hasNext()) {
                Literal geometryLiteral = ((RDFNode)nodeIter.next()).asLiteral();
                GeometryWrapper geometryWrapper = GeometryWrapper.extract(geometryLiteral);
                try {
                    GeometryWrapper transformedGeometryWrapper = geometryWrapper.convertSRS(srsURI);
                    Envelope envelope = transformedGeometryWrapper.getEnvelope();
                    SpatialIndexItem item = new SpatialIndexItem(envelope, feature);
                    items.add(item);
                }
                catch (MismatchedDimensionException | TransformException | FactoryException ex) {
                    throw new SpatialIndexException("Transformation Exception: " + String.valueOf(geometryLiteral) + ". " + ex.getMessage());
                }
            }
        }
        return items;
    }

    private static Collection<SpatialIndexItem> getGeoPredicateIndexItems(Model model, String srsURI) throws SpatialIndexException {
        ArrayList<SpatialIndexItem> items = new ArrayList<SpatialIndexItem>();
        ResIterator resIt = model.listResourcesWithProperty(SpatialExtension.GEO_LAT_PROP);
        while (resIt.hasNext()) {
            Resource feature = resIt.nextResource();
            Literal lat = feature.getRequiredProperty(SpatialExtension.GEO_LAT_PROP).getLiteral();
            Literal lon = feature.getProperty(SpatialExtension.GEO_LON_PROP).getLiteral();
            if (lon == null) {
                LOGGER.warn("Geo predicates: latitude found but not longitude. " + String.valueOf(feature));
                continue;
            }
            Literal latLonPoint = ConvertLatLon.toLiteral(lat.getFloat(), lon.getFloat());
            GeometryWrapper geometryWrapper = GeometryWrapper.extract(latLonPoint);
            try {
                GeometryWrapper transformedGeometryWrapper = geometryWrapper.convertSRS(srsURI);
                Envelope envelope = transformedGeometryWrapper.getEnvelope();
                SpatialIndexItem item = new SpatialIndexItem(envelope, feature);
                items.add(item);
            }
            catch (MismatchedDimensionException | TransformException | FactoryException ex) {
                throw new SpatialIndexException("Transformation Exception: " + geometryWrapper.getLexicalForm() + ". " + ex.getMessage());
            }
        }
        return items;
    }

    public static final SpatialIndexV1 load(File spatialIndexFile) throws SpatialIndexException {
        if (spatialIndexFile != null && spatialIndexFile.exists()) {
            SpatialIndexV1 spatialIndexV1;
            LOGGER.info("Loading Spatial Index - Started: {}", (Object)spatialIndexFile.getAbsolutePath());
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(spatialIndexFile));
            try {
                SpatialIndexStorage storage = (SpatialIndexStorage)in.readObject();
                SpatialIndexV1 spatialIndex = storage.getSpatialIndex();
                LOGGER.info("Loading Spatial Index - Completed: {}", (Object)spatialIndexFile.getAbsolutePath());
                spatialIndexV1 = spatialIndex;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | ClassNotFoundException ex) {
                    throw new SpatialIndexException("Loading Exception: " + ex.getMessage(), ex);
                }
            }
            in.close();
            return spatialIndexV1;
        }
        return new SpatialIndexV1();
    }

    public static final void save(String spatialIndexFileURI, Collection<SpatialIndexItem> spatialIndexItems, String srsURI) throws SpatialIndexException {
        SpatialIndexV1.save(new File(spatialIndexFileURI), spatialIndexItems, srsURI);
    }

    public static final void save(File spatialIndexFile, Collection<SpatialIndexItem> spatialIndexItems, String srsURI) throws SpatialIndexException {
        if (spatialIndexFile != null) {
            LOGGER.info("Saving Spatial Index - Started: {}", (Object)spatialIndexFile.getAbsolutePath());
            SpatialIndexStorage storage = new SpatialIndexStorage(spatialIndexItems, srsURI);
            String filename = spatialIndexFile.getAbsolutePath();
            Path file = Path.of(filename, new String[0]);
            Path tmpFile = IOX.uniqueDerivedPath(file, null);
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException ex) {
                throw new SpatialIndexException("Failed to delete file: " + ex.getMessage());
            }
            try {
                IOX.safeWriteOrCopy(file, tmpFile, out -> {
                    ObjectOutputStream oos = new ObjectOutputStream((OutputStream)out);
                    oos.writeObject(storage);
                    oos.flush();
                });
            }
            catch (RuntimeIOException ex) {
                throw new SpatialIndexException("Save Exception: " + ex.getMessage());
            }
            finally {
                LOGGER.info("Saving Spatial Index - Completed: {}", (Object)spatialIndexFile.getAbsolutePath());
            }
        }
    }
}

