/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiActivityStatus;
import com.cloudera.api.swagger.model.ApiActivityType;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Represents a user activity, such as a MapReduce job, a Hive query, an Oozie workflow, etc.")
public class ApiActivity {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="type")
    private ApiActivityType type = null;
    @SerializedName(value="parent")
    private String parent = null;
    @SerializedName(value="startTime")
    private String startTime = null;
    @SerializedName(value="finishTime")
    private String finishTime = null;
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="status")
    private ApiActivityStatus status = null;
    @SerializedName(value="user")
    private String user = null;
    @SerializedName(value="group")
    private String group = null;
    @SerializedName(value="inputDir")
    private String inputDir = null;
    @SerializedName(value="outputDir")
    private String outputDir = null;
    @SerializedName(value="mapper")
    private String mapper = null;
    @SerializedName(value="combiner")
    private String combiner = null;
    @SerializedName(value="reducer")
    private String reducer = null;
    @SerializedName(value="queueName")
    private String queueName = null;
    @SerializedName(value="schedulerPriority")
    private String schedulerPriority = null;

    public ApiActivity name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Activity name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiActivity type(ApiActivityType type) {
        this.type = type;
        return this;
    }

    @Schema(description="")
    public ApiActivityType getType() {
        return this.type;
    }

    public void setType(ApiActivityType type) {
        this.type = type;
    }

    public ApiActivity parent(String parent) {
        this.parent = parent;
        return this;
    }

    @Schema(description="The name of the parent activity.")
    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public ApiActivity startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @Schema(description="The start time of this activity.")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public ApiActivity finishTime(String finishTime) {
        this.finishTime = finishTime;
        return this;
    }

    @Schema(description="The finish time of this activity.")
    public String getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(String finishTime) {
        this.finishTime = finishTime;
    }

    public ApiActivity id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Activity id, which is unique within a MapReduce service.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ApiActivity status(ApiActivityStatus status) {
        this.status = status;
        return this;
    }

    @Schema(description="")
    public ApiActivityStatus getStatus() {
        return this.status;
    }

    public void setStatus(ApiActivityStatus status) {
        this.status = status;
    }

    public ApiActivity user(String user) {
        this.user = user;
        return this;
    }

    @Schema(description="The user who submitted this activity.")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public ApiActivity group(String group) {
        this.group = group;
        return this;
    }

    @Schema(description="The user-group of this activity.")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public ApiActivity inputDir(String inputDir) {
        this.inputDir = inputDir;
        return this;
    }

    @Schema(description="The input data directory of the activity. An HDFS url.")
    public String getInputDir() {
        return this.inputDir;
    }

    public void setInputDir(String inputDir) {
        this.inputDir = inputDir;
    }

    public ApiActivity outputDir(String outputDir) {
        this.outputDir = outputDir;
        return this;
    }

    @Schema(description="The output result directory of the activity. An HDFS url.")
    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public ApiActivity mapper(String mapper) {
        this.mapper = mapper;
        return this;
    }

    @Schema(description="The mapper class.")
    public String getMapper() {
        return this.mapper;
    }

    public void setMapper(String mapper) {
        this.mapper = mapper;
    }

    public ApiActivity combiner(String combiner) {
        this.combiner = combiner;
        return this;
    }

    @Schema(description="The combiner class.")
    public String getCombiner() {
        return this.combiner;
    }

    public void setCombiner(String combiner) {
        this.combiner = combiner;
    }

    public ApiActivity reducer(String reducer) {
        this.reducer = reducer;
        return this;
    }

    @Schema(description="The reducer class.")
    public String getReducer() {
        return this.reducer;
    }

    public void setReducer(String reducer) {
        this.reducer = reducer;
    }

    public ApiActivity queueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    @Schema(description="The scheduler queue this activity is in.")
    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public ApiActivity schedulerPriority(String schedulerPriority) {
        this.schedulerPriority = schedulerPriority;
        return this;
    }

    @Schema(description="The scheduler priority of this activity.")
    public String getSchedulerPriority() {
        return this.schedulerPriority;
    }

    public void setSchedulerPriority(String schedulerPriority) {
        this.schedulerPriority = schedulerPriority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiActivity apiActivity = (ApiActivity)o;
        return Objects.equals(this.name, apiActivity.name) && Objects.equals((Object)this.type, (Object)apiActivity.type) && Objects.equals(this.parent, apiActivity.parent) && Objects.equals(this.startTime, apiActivity.startTime) && Objects.equals(this.finishTime, apiActivity.finishTime) && Objects.equals(this.id, apiActivity.id) && Objects.equals((Object)this.status, (Object)apiActivity.status) && Objects.equals(this.user, apiActivity.user) && Objects.equals(this.group, apiActivity.group) && Objects.equals(this.inputDir, apiActivity.inputDir) && Objects.equals(this.outputDir, apiActivity.outputDir) && Objects.equals(this.mapper, apiActivity.mapper) && Objects.equals(this.combiner, apiActivity.combiner) && Objects.equals(this.reducer, apiActivity.reducer) && Objects.equals(this.queueName, apiActivity.queueName) && Objects.equals(this.schedulerPriority, apiActivity.schedulerPriority);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.parent, this.startTime, this.finishTime, this.id, this.status, this.user, this.group, this.inputDir, this.outputDir, this.mapper, this.combiner, this.reducer, this.queueName, this.schedulerPriority});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiActivity {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    finishTime: ").append(this.toIndentedString(this.finishTime)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    inputDir: ").append(this.toIndentedString(this.inputDir)).append("\n");
        sb.append("    outputDir: ").append(this.toIndentedString(this.outputDir)).append("\n");
        sb.append("    mapper: ").append(this.toIndentedString(this.mapper)).append("\n");
        sb.append("    combiner: ").append(this.toIndentedString(this.combiner)).append("\n");
        sb.append("    reducer: ").append(this.toIndentedString(this.reducer)).append("\n");
        sb.append("    queueName: ").append(this.toIndentedString(this.queueName)).append("\n");
        sb.append("    schedulerPriority: ").append(this.toIndentedString(this.schedulerPriority)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

