/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHdfsCloudReplicationArguments;
import com.cloudera.api.swagger.model.ApiHdfsReplicationArguments;
import com.cloudera.api.swagger.model.ApiRangerReplicationExportArgs;
import com.cloudera.api.swagger.model.ApiRangerReplicationImportArgs;
import com.cloudera.api.swagger.model.ApiRangerReplicationTransformArgs;
import com.cloudera.api.swagger.model.ApiServiceRef;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Replication arguments for replicating services defined in Ranger. It works the following way: <ol> <li> EXPORT the given services, policies and roles from the source Ranger, then COPY the exported result to destination, see available arguments in ApiRangerReplicationExportArgs. Note that if #getExportArgs() not provided, then services defined in Ranger won't be replicated, it will be skipped. </li> <li> TRANSFORM the exported services, policies and roles from the source Ranger on the destination, see available arguments in ApiRangerReplicationTransformArgs. Includes arguments for transforming HDFS Ranger service policies to cloud policies. </li> <li> IMPORT the exported and transformed services, policies and roles from source to destination Ranger, see available arguments in ApiRangerReplicationImportArgs </li> <li>For replicating the Ranger HDFS audit logs, there are 2 options: <ul> <li> If #getAuditLogDistCpArgs() is provided then the replication will distributed copy Ranger HDFS audit logs from source HDFS to destination HDFS, see available arguments in ApiHdfsReplicationArguments. If provided, then the mandatory fields are ApiHdfsReplicationArguments#getUserName() (destination user) and ApiHdfsReplicationArguments#getSourceUser() (source user). Any other ApiHdfsReplicationArguments fields could be provided, sourcePath and destinationPath will be set appropriately by CM, when not specified. </li> <li> Alternatively, you can provide #getAuditLogDistCpCloudArgs(), in this case distributed copy for Ranger HDFS audit logs from source HDFS to destination cloud storage, see available arguments in ApiHdfsCloudReplicationArguments. Mandatory fields are ApiHdfsCloudReplicationArguments#getSourceUser() (source user), ApiHdfsCloudReplicationArguments#getDestinationAccount() (destination user) and ApiHdfsCloudReplicationArguments#getDestinationPath(). Any other ApiHdfsCloudReplicationArguments fields could be provided, sourcePath will be set appropriately by CM, when not specified. </li> </ul> </li> </ol> Note that at least one of #getExportArgs(), #getAuditLogDistCpArgs(), #getAuditLogDistCpCloudArgs() must be provided, otherwise the replication would not do anything.")
public class ApiRangerReplicationArgs {
    @SerializedName(value="sourceRangerService")
    private ApiServiceRef sourceRangerService = null;
    @SerializedName(value="exportArgs")
    private ApiRangerReplicationExportArgs exportArgs = null;
    @SerializedName(value="transformArgs")
    private ApiRangerReplicationTransformArgs transformArgs = null;
    @SerializedName(value="importArgs")
    private ApiRangerReplicationImportArgs importArgs = null;
    @SerializedName(value="auditLogDistCpArgs")
    private ApiHdfsReplicationArguments auditLogDistCpArgs = null;
    @SerializedName(value="auditLogDistCpCloudArgs")
    private ApiHdfsCloudReplicationArguments auditLogDistCpCloudArgs = null;

    public ApiRangerReplicationArgs sourceRangerService(ApiServiceRef sourceRangerService) {
        this.sourceRangerService = sourceRangerService;
        return this;
    }

    @Schema(description="")
    public ApiServiceRef getSourceRangerService() {
        return this.sourceRangerService;
    }

    public void setSourceRangerService(ApiServiceRef sourceRangerService) {
        this.sourceRangerService = sourceRangerService;
    }

    public ApiRangerReplicationArgs exportArgs(ApiRangerReplicationExportArgs exportArgs) {
        this.exportArgs = exportArgs;
        return this;
    }

    @Schema(description="")
    public ApiRangerReplicationExportArgs getExportArgs() {
        return this.exportArgs;
    }

    public void setExportArgs(ApiRangerReplicationExportArgs exportArgs) {
        this.exportArgs = exportArgs;
    }

    public ApiRangerReplicationArgs transformArgs(ApiRangerReplicationTransformArgs transformArgs) {
        this.transformArgs = transformArgs;
        return this;
    }

    @Schema(description="")
    public ApiRangerReplicationTransformArgs getTransformArgs() {
        return this.transformArgs;
    }

    public void setTransformArgs(ApiRangerReplicationTransformArgs transformArgs) {
        this.transformArgs = transformArgs;
    }

    public ApiRangerReplicationArgs importArgs(ApiRangerReplicationImportArgs importArgs) {
        this.importArgs = importArgs;
        return this;
    }

    @Schema(description="")
    public ApiRangerReplicationImportArgs getImportArgs() {
        return this.importArgs;
    }

    public void setImportArgs(ApiRangerReplicationImportArgs importArgs) {
        this.importArgs = importArgs;
    }

    public ApiRangerReplicationArgs auditLogDistCpArgs(ApiHdfsReplicationArguments auditLogDistCpArgs) {
        this.auditLogDistCpArgs = auditLogDistCpArgs;
        return this;
    }

    @Schema(description="")
    public ApiHdfsReplicationArguments getAuditLogDistCpArgs() {
        return this.auditLogDistCpArgs;
    }

    public void setAuditLogDistCpArgs(ApiHdfsReplicationArguments auditLogDistCpArgs) {
        this.auditLogDistCpArgs = auditLogDistCpArgs;
    }

    public ApiRangerReplicationArgs auditLogDistCpCloudArgs(ApiHdfsCloudReplicationArguments auditLogDistCpCloudArgs) {
        this.auditLogDistCpCloudArgs = auditLogDistCpCloudArgs;
        return this;
    }

    @Schema(description="")
    public ApiHdfsCloudReplicationArguments getAuditLogDistCpCloudArgs() {
        return this.auditLogDistCpCloudArgs;
    }

    public void setAuditLogDistCpCloudArgs(ApiHdfsCloudReplicationArguments auditLogDistCpCloudArgs) {
        this.auditLogDistCpCloudArgs = auditLogDistCpCloudArgs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiRangerReplicationArgs apiRangerReplicationArgs = (ApiRangerReplicationArgs)o;
        return Objects.equals(this.sourceRangerService, apiRangerReplicationArgs.sourceRangerService) && Objects.equals(this.exportArgs, apiRangerReplicationArgs.exportArgs) && Objects.equals(this.transformArgs, apiRangerReplicationArgs.transformArgs) && Objects.equals(this.importArgs, apiRangerReplicationArgs.importArgs) && Objects.equals(this.auditLogDistCpArgs, apiRangerReplicationArgs.auditLogDistCpArgs) && Objects.equals(this.auditLogDistCpCloudArgs, apiRangerReplicationArgs.auditLogDistCpCloudArgs);
    }

    public int hashCode() {
        return Objects.hash(this.sourceRangerService, this.exportArgs, this.transformArgs, this.importArgs, this.auditLogDistCpArgs, this.auditLogDistCpCloudArgs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiRangerReplicationArgs {\n");
        sb.append("    sourceRangerService: ").append(this.toIndentedString(this.sourceRangerService)).append("\n");
        sb.append("    exportArgs: ").append(this.toIndentedString(this.exportArgs)).append("\n");
        sb.append("    transformArgs: ").append(this.toIndentedString(this.transformArgs)).append("\n");
        sb.append("    importArgs: ").append(this.toIndentedString(this.importArgs)).append("\n");
        sb.append("    auditLogDistCpArgs: ").append(this.toIndentedString(this.auditLogDistCpArgs)).append("\n");
        sb.append("    auditLogDistCpCloudArgs: ").append(this.toIndentedString(this.auditLogDistCpCloudArgs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

