/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.jobhistory.cache.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.jobhistory.cache.domain.TaskResult;
import org.apache.linkis.jobhistory.cache.utils.MD5Util;
import org.apache.linkis.jobhistory.util.QueryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTaskResultCache {
    private static Logger logger = LoggerFactory.getLogger(UserTaskResultCache.class);
    Cache<String, TaskResult> resultCache = CacheBuilder.newBuilder().expireAfterWrite(((Long)QueryConfig.CACHE_MAX_EXPIRE_HOUR().getValue()).longValue(), TimeUnit.DAYS).maximumSize(((Long)QueryConfig.CACHE_MAX_SIZE().getValue()).longValue()).build();
    Long lastCleaned = System.currentTimeMillis();
    private static final int ONE_THOUSAND = 1000;

    public void refresh() {
        this.resultCache.invalidateAll();
        logger.info("Cache refreshed.");
    }

    public void clean() {
        this.resultCache.cleanUp();
        logger.info("Cache cleaned up.");
        for (Map.Entry taskResultEntry : this.resultCache.asMap().entrySet()) {
            TaskResult taskResult = (TaskResult)taskResultEntry.getValue();
            if (taskResult == null || !this.expired(taskResult)) continue;
            this.resultCache.invalidate(taskResultEntry.getKey());
        }
        logger.info("Finished checking expired cache records.");
        this.lastCleaned = System.currentTimeMillis();
    }

    public void put(TaskResult taskResult) {
        String md5 = this.getMD5(taskResult.getExecutionCode());
        TaskResult existingCacheOjb = (TaskResult)this.resultCache.getIfPresent((Object)md5);
        if (existingCacheOjb != null && taskResult.getExpireAt() < existingCacheOjb.getExpireAt()) {
            taskResult.setExpireAt(existingCacheOjb.getExpireAt());
        }
        this.resultCache.put((Object)md5, (Object)taskResult);
    }

    public TaskResult get(String executionCode, Long readCacheBefore) {
        String md5 = this.getMD5(executionCode);
        TaskResult taskResult = (TaskResult)this.resultCache.getIfPresent((Object)md5);
        if (taskResult == null) {
            return null;
        }
        if (this.expired(taskResult)) {
            this.resultCache.invalidate((Object)md5);
            return null;
        }
        if (taskResult.getCreatedAt() < System.currentTimeMillis() - readCacheBefore * 1000L) {
            return null;
        }
        return taskResult;
    }

    public void remove(String executionCode) {
        String md5 = this.getMD5(executionCode);
        this.resultCache.invalidate((Object)md5);
    }

    private boolean expired(TaskResult taskResult) {
        return taskResult.getExpireAt() <= System.currentTimeMillis();
    }

    private String getMD5(String executionCode) {
        return MD5Util.getMD5(executionCode, true, 32);
    }

    public Long getLastCleaned() {
        return this.lastCleaned;
    }
}

