/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.jobhistory.conversions;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.JsonUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.governance.common.entity.job.SubJobDetail;
import org.apache.linkis.governance.common.entity.task.RequestQueryTask;
import org.apache.linkis.jobhistory.conf.JobhistoryConfiguration$;
import org.apache.linkis.jobhistory.entity.JobDetail;
import org.apache.linkis.jobhistory.entity.JobHistory;
import org.apache.linkis.jobhistory.entity.QueryTask;
import org.apache.linkis.jobhistory.entity.QueryTaskVO;
import org.apache.linkis.jobhistory.transitional.TaskStatus;
import org.apache.linkis.jobhistory.util.QueryUtils$;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.protocol.utils.ZuulEntranceUtils$;
import org.apache.linkis.server.BDPJettyServerHelper$;
import org.apache.linkis.server.package$;
import org.slf4j.Logger;
import org.springframework.beans.BeanUtils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class TaskConversions$
implements Logging {
    public static TaskConversions$ MODULE$;
    private LabelBuilderFactory labelBuilderFactory;
    private Logger logger;
    private volatile byte bitmap$0;

    static {
        new TaskConversions$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        TaskConversions$ taskConversions$ = this;
        synchronized (taskConversions$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private LabelBuilderFactory labelBuilderFactory$lzycompute() {
        TaskConversions$ taskConversions$ = this;
        synchronized (taskConversions$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.labelBuilderFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.labelBuilderFactory;
    }

    private LabelBuilderFactory labelBuilderFactory() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.labelBuilderFactory$lzycompute();
        }
        return this.labelBuilderFactory;
    }

    public QueryTask requestQueryTask2QueryTask(RequestQueryTask requestQueryTask) {
        QueryTask task = new QueryTask();
        BeanUtils.copyProperties((Object)requestQueryTask, (Object)task);
        if (requestQueryTask.getParams() != null) {
            task.setParamsJson(BDPJettyServerHelper$.MODULE$.gson().toJson((Object)requestQueryTask.getParams()));
        } else {
            task.setParamsJson(null);
        }
        return task;
    }

    public boolean isJobFinished(String status) {
        return TaskStatus.Succeed.toString().equals(status) || TaskStatus.Failed.toString().equals(status) || TaskStatus.Cancelled.toString().equals(status) || TaskStatus.Timeout.toString().equals(status);
    }

    public List<JobRequest> jobHistory2JobRequest(List<JobHistory> jobHistoryList) {
        ArrayList<JobRequest> jobRequestList = new ArrayList<JobRequest>(jobHistoryList.size());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(jobHistoryList).asScala()).foreach((Function1 & Serializable & scala.Serializable)job -> BoxesRunTime.boxToBoolean((boolean)TaskConversions$.$anonfun$jobHistory2JobRequest$1(jobRequestList, job)));
        return jobRequestList;
    }

    public JobRequest jobHistory2JobRequest(JobHistory job) {
        if (job == null) {
            return null;
        }
        JobRequest jobReq = new JobRequest();
        jobReq.setId(job.getId());
        jobReq.setReqId(job.getJobReqId());
        jobReq.setSubmitUser(job.getSubmitUser());
        jobReq.setExecuteUser(job.getExecuteUser());
        if (job.getSource() != null) {
            jobReq.setSource((Map)BDPJettyServerHelper$.MODULE$.gson().fromJson(job.getSource(), Map.class));
        }
        if (job.getLabels() != null) {
            jobReq.setLabels(this.getLabelListFromJson(job.getLabels()));
        }
        jobReq.setParams((Map)BDPJettyServerHelper$.MODULE$.gson().fromJson(job.getParams(), Map.class));
        jobReq.setProgress(job.getProgress());
        jobReq.setStatus(job.getStatus());
        jobReq.setLogPath(job.getLogPath());
        jobReq.setErrorCode(job.getErrorCode());
        jobReq.setErrorDesc(job.getErrorDesc());
        jobReq.setCreatedTime(job.getCreatedTime());
        jobReq.setUpdatedTime(job.getUpdatedTime());
        jobReq.setMetrics((Map)BDPJettyServerHelper$.MODULE$.gson().fromJson(job.getMetrics(), Map.class));
        jobReq.setInstances(job.getInstances());
        jobReq.setResultLocation(job.getResultLocation());
        QueryUtils$.MODULE$.exchangeExecutionCode(job);
        jobReq.setExecutionCode(job.getExecutionCode());
        jobReq.setObserveInfo(job.getObserveInfo());
        return jobReq;
    }

    public JobHistory jobRequest2JobHistory(JobRequest jobReq) {
        JobHistory jobHistory;
        block12: {
            if (jobReq == null) {
                return null;
            }
            if (this.logger().isDebugEnabled()) {
                try {
                    this.logger().debug(new StringBuilder(13).append("input jobReq:").append(JsonUtils$.MODULE$.jackson().writeValueAsString((Object)jobReq)).toString());
                }
                catch (JsonProcessingException e) {
                    this.logger().debug(new StringBuilder(36).append("convert jobReq to string with error:").append(e.getMessage()).toString());
                }
            }
            jobHistory = new JobHistory();
            jobHistory.setId(jobReq.getId());
            jobHistory.setJobReqId(jobReq.getReqId());
            jobHistory.setSubmitUser(jobReq.getSubmitUser());
            jobHistory.setExecuteUser(jobReq.getExecuteUser());
            jobHistory.setSource(BDPJettyServerHelper$.MODULE$.gson().toJson((Object)jobReq.getSource()));
            if (jobReq.getLabels() != null) {
                HashMap labelMap = new HashMap(jobReq.getLabels().size());
                ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(jobReq.getLabels()).asScala()).map((Function1 & Serializable & scala.Serializable)l -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)l.getLabelKey()), (Object)l.getStringValue()), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)kv -> (String)labelMap.put(kv._1(), kv._2()));
                jobHistory.setLabels(BDPJettyServerHelper$.MODULE$.gson().toJson(labelMap));
            }
            if (jobReq.getParams() != null) {
                jobHistory.setParams(BDPJettyServerHelper$.MODULE$.gson().toJson((Object)jobReq.getParams()));
            }
            jobHistory.setProgress(jobReq.getProgress());
            jobHistory.setStatus(jobReq.getStatus());
            jobHistory.setLogPath(jobReq.getLogPath());
            jobHistory.setErrorCode(jobReq.getErrorCode());
            jobHistory.setErrorDesc(jobReq.getErrorDesc());
            jobHistory.setResultLocation(jobReq.getResultLocation());
            if (jobReq.getCreatedTime() != null) {
                jobHistory.setCreatedTime(new Date(jobReq.getCreatedTime().getTime()));
            }
            if (jobReq.getUpdatedTime() != null) {
                jobHistory.setUpdatedTime(new Date(jobReq.getUpdatedTime().getTime()));
            }
            jobHistory.setInstances(jobReq.getInstances());
            if (jobReq.getMetrics() != null) {
                jobHistory.setMetrics(BDPJettyServerHelper$.MODULE$.gson().toJson((Object)jobReq.getMetrics()));
            }
            String engineType = LabelUtil$.MODULE$.getEngineType(jobReq.getLabels());
            jobHistory.setEngineType(engineType);
            jobHistory.setExecutionCode(jobReq.getExecutionCode());
            if (this.logger().isDebugEnabled()) {
                try {
                    this.logger().debug(new StringBuilder(28).append("after jobRequest2JobHistory:").append(JsonUtils$.MODULE$.jackson().writeValueAsString((Object)jobHistory)).toString());
                }
                catch (JsonProcessingException e) {
                    this.logger().debug(new StringBuilder(51).append("convert jobRequest2JobHistory to string with error:").append(e.getMessage()).toString());
                }
            }
            if (jobReq.getObserveInfo() == null) break block12;
            jobHistory.setObserveInfo(jobReq.getObserveInfo());
        }
        return jobHistory;
    }

    public List<JobDetail> subjobDetails2JobDetail(List<SubJobDetail> subjobDetails) {
        ArrayList<JobDetail> lists = new ArrayList<JobDetail>(subjobDetails.size());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(subjobDetails).asScala()).foreach((Function1 & Serializable & scala.Serializable)j -> BoxesRunTime.boxToBoolean((boolean)lists.add(TaskConversions$.MODULE$.subjobDetail2JobDetail(j))));
        return lists;
    }

    public List<SubJobDetail> jobdetails2SubjobDetail(List<JobDetail> jobdetails) {
        ArrayList<SubJobDetail> lists = new ArrayList<SubJobDetail>(jobdetails.size());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(jobdetails).asScala()).foreach((Function1 & Serializable & scala.Serializable)j -> BoxesRunTime.boxToBoolean((boolean)lists.add(TaskConversions$.MODULE$.jobdetail2SubjobDetail(j))));
        return lists;
    }

    public JobDetail subjobDetail2JobDetail(SubJobDetail subjob) {
        if (subjob == null) {
            return null;
        }
        JobDetail jobDetail = new JobDetail();
        jobDetail.setId(subjob.getId());
        jobDetail.setJobHistoryId(subjob.getJobGroupId());
        jobDetail.setResultLocation(subjob.getResultLocation());
        jobDetail.setResultArraySize(subjob.getResultSize());
        jobDetail.setExecutionContent(subjob.getExecutionContent());
        jobDetail.setJobGroupInfo(subjob.getJobGroupInfo());
        jobDetail.setCreatedTime(subjob.getCreatedTime());
        jobDetail.setUpdatedTime(subjob.getUpdatedTime());
        jobDetail.setStatus(subjob.getStatus());
        jobDetail.setPriority(subjob.getPriority());
        return jobDetail;
    }

    public SubJobDetail jobdetail2SubjobDetail(JobDetail jobdetail) {
        if (jobdetail == null) {
            return null;
        }
        SubJobDetail subjobDetail = new SubJobDetail();
        subjobDetail.setId(jobdetail.getId());
        subjobDetail.setJobGroupId(jobdetail.getJobHistoryId());
        subjobDetail.setResultLocation(jobdetail.getResultLocation());
        subjobDetail.setResultSize(jobdetail.getResultArraySize());
        subjobDetail.setExecutionContent(jobdetail.getExecutionContent());
        subjobDetail.setJobGroupInfo(jobdetail.getJobGroupInfo());
        subjobDetail.setCreatedTime(jobdetail.getCreatedTime());
        subjobDetail.setUpdatedTime(jobdetail.getUpdatedTime());
        subjobDetail.setStatus(jobdetail.getStatus());
        subjobDetail.setPriority(jobdetail.getPriority());
        return subjobDetail;
    }

    public QueryTaskVO jobHistory2TaskVO(JobHistory job, List<SubJobDetail> subjobs) {
        if (job == null) {
            return null;
        }
        QueryTaskVO taskVO = new QueryTaskVO();
        taskVO.setTaskID(job.getId());
        taskVO.setInstance(job.getInstances());
        taskVO.setExecId(job.getJobReqId());
        taskVO.setUmUser(job.getSubmitUser());
        taskVO.setExecuteUser(job.getExecuteUser());
        taskVO.setProgress(job.getProgress());
        taskVO.setLogPath(job.getLogPath());
        taskVO.setStatus(job.getStatus());
        taskVO.setResultLocation(job.getResultLocation());
        if (job.getCreatedTime() != null) {
            taskVO.setCreatedTime(new Date(job.getCreatedTime().getTime()));
        }
        if (job.getUpdatedTime() != null) {
            taskVO.setUpdatedTime(new Date(job.getUpdatedTime().getTime()));
        }
        List<Label<?>> labelList = this.getLabelListFromJson(job.getLabels());
        String engineType = job.getEngineType();
        String codeType = "";
        String creator = "";
        if (labelList != null && labelList.size() > 0) {
            if (engineType == null) {
                engineType = LabelUtil$.MODULE$.getEngineType(labelList);
            }
            codeType = LabelUtil$.MODULE$.getCodeType(labelList);
            Tuple2 userCreator = (Tuple2)Option$.MODULE$.apply((Object)LabelUtil$.MODULE$.getUserCreator(labelList)).orNull(Predef$.MODULE$.$conforms());
            if (userCreator != null) {
                creator = (String)userCreator._2();
            }
        }
        taskVO.setEngineType(engineType);
        taskVO.setExecuteApplicationName(job.getEngineType());
        taskVO.setRequestApplicationName(creator);
        taskVO.setRunType(codeType);
        taskVO.setParamsJson(job.getParams());
        taskVO.setCreatedTime(job.getCreatedTime());
        taskVO.setUpdatedTime(job.getUpdatedTime());
        taskVO.setErrCode(job.getErrorCode());
        taskVO.setErrDesc(job.getErrorDesc());
        ArrayList<String> labelStringList = new ArrayList<String>();
        package$.MODULE$.toScalaBuffer(labelList).foreach((Function1 & Serializable & scala.Serializable)label -> BoxesRunTime.boxToBoolean((boolean)labelStringList.add(new StringBuilder(1).append(label.getLabelKey()).append(":").append(label.getStringValue()).toString())));
        taskVO.setLabels(labelStringList);
        Map metrics = (Map)BDPJettyServerHelper$.MODULE$.gson().fromJson(job.getMetrics(), Map.class);
        Date completeTime = null;
        if (metrics != null && metrics.containsKey("completeTime") && metrics.get("completeTime") != null) {
            completeTime = this.dealString2Date(metrics.get("completeTime").toString());
        }
        Date createTime = null;
        if (metrics != null && metrics.containsKey("submitTime") && metrics.get("submitTime") != null) {
            createTime = this.dealString2Date(metrics.get("submitTime").toString());
        }
        if (metrics != null && metrics.containsKey("isReuse") && metrics.get("isReuse") != null) {
            taskVO.setIsReuse(Predef$.MODULE$.boolean2Boolean(BooleanUtils.toBoolean((String)metrics.get("isReuse").toString())));
        }
        Date requestStartTime = null;
        Date requestEndTime = null;
        if (metrics != null && metrics.containsKey("submitTime") && metrics.get("submitTime") != null) {
            requestStartTime = this.dealString2Date(metrics.get("submitTime").toString());
            taskVO.setRequestStartTime(requestStartTime);
        }
        if (metrics != null && metrics.containsKey("scheduleTime") && metrics.get("scheduleTime") != null) {
            requestEndTime = this.dealString2Date(metrics.get("scheduleTime").toString());
            taskVO.setRequestEndTime(requestEndTime);
        }
        if (requestStartTime != null && requestEndTime != null) {
            taskVO.setRequestSpendTime(Predef$.MODULE$.long2Long(requestEndTime.getTime() - requestStartTime.getTime()));
        }
        if (createTime != null) {
            if (this.isJobFinished(job.getStatus())) {
                if (completeTime != null) {
                    taskVO.setCostTime(Predef$.MODULE$.long2Long(completeTime.getTime() - createTime.getTime()));
                } else if (job.getUpdatedTime() != null) {
                    taskVO.setCostTime(Predef$.MODULE$.long2Long(job.getUpdatedTime().getTime() - createTime.getTime()));
                } else {
                    taskVO.setCostTime(Predef$.MODULE$.long2Long(System.currentTimeMillis() - createTime.getTime()));
                }
            } else {
                taskVO.setCostTime(Predef$.MODULE$.long2Long(System.currentTimeMillis() - createTime.getTime()));
            }
        }
        if (metrics != null && metrics.containsKey("engineInstance")) {
            taskVO.setEngineInstance(metrics.get("engineInstance").toString());
        } else if (TaskStatus.Failed.toString().equals(job.getStatus())) {
            taskVO.setCanRetry(true);
        }
        String entranceName = (String)JobhistoryConfiguration$.MODULE$.ENTRANCE_SPRING_NAME().getValue();
        String[] instances = job.getInstances().split((String)JobhistoryConfiguration$.MODULE$.ENTRANCE_INSTANCE_DELEMITER().getValue());
        taskVO.setStrongerExecId(ZuulEntranceUtils$.MODULE$.generateExecID(job.getJobReqId(), entranceName, instances));
        taskVO.setSourceJson(job.getSource());
        if (StringUtils.isNotBlank((CharSequence)job.getExecutionCode())) {
            taskVO.setExecutionCode(job.getExecutionCode());
        }
        taskVO.setSourceJson(job.getSource());
        Object object = StringUtils.isNotBlank((CharSequence)job.getSource()) ? Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map source = (Map)BDPJettyServerHelper$.MODULE$.gson().fromJson(job.getSource(), Map.class);
            taskVO.setSourceTailor(new StringOps(Predef$.MODULE$.augmentString((String)((TraversableOnce)package$.MODULE$.toScalaMap(source).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._2(), Iterable$.MODULE$.canBuildFrom())).foldLeft((Object)"", (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> new StringBuilder(1).append((String)x$2).append((String)x$3).append("-").toString()))).stripSuffix("-"));
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            TaskConversions$.$anonfun$jobHistory2TaskVO$5(x0$1);
            return BoxedUnit.UNIT;
        }) : BoxedUnit.UNIT;
        taskVO.setObserveInfo(job.getObserveInfo());
        taskVO.setMetrics(job.getMetrics());
        return taskVO;
    }

    public List<Label<?>> getLabelListFromJson(String labelJson) {
        HashMap labelMap = (HashMap)BDPJettyServerHelper$.MODULE$.gson().fromJson(labelJson, HashMap.class);
        ArrayList labels = new ArrayList();
        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)labelMap).asScala()).map((Function1 & Serializable & scala.Serializable)l -> MODULE$.labelBuilderFactory().createLabel((String)l._1(), l._2()), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)labels.add(x$1))), this.logger());
        return labels;
    }

    public Date dealString2Date(String strDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        return (Date)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            Date date = df.parse(strDate);
            return date;
        }, (Function1 & Serializable & scala.Serializable)x$4 -> {
            MODULE$.logger().warn("String to Date deserialization failed.");
            return null;
        });
    }

    public String dateFomat(Date date) {
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return dateFormat.format(date);
        }
        return "";
    }

    public String getJobRuntime(Map<String, String> metricsMap) {
        String runTime = "";
        if (metricsMap.containsKey("completeTime")) {
            long completeTime = this.dealString2Date(metricsMap.get("completeTime").toString()).getTime();
            long submitTime = this.dealString2Date(metricsMap.get("submitTime").toString()).getTime();
            runTime = ByteTimeUtils.msDurationToString((long)(completeTime - submitTime));
        } else {
            runTime = "The task did not end normally and the usage time could not be counted.(\u4efb\u52a1\u5e76\u672a\u6b63\u5e38\u7ed3\u675f\uff0c\u65e0\u6cd5\u7edf\u8ba1\u4f7f\u7528\u65f6\u95f4)";
        }
        return runTime;
    }

    public static final /* synthetic */ boolean $anonfun$jobHistory2JobRequest$1(ArrayList jobRequestList$1, JobHistory job) {
        JobRequest jobReq = MODULE$.jobHistory2JobRequest(job);
        return jobRequestList$1.add(jobReq);
    }

    public static final /* synthetic */ void $anonfun$jobHistory2TaskVO$5(Throwable x0$1) {
        Throwable throwable = x0$1;
        MODULE$.logger().warn("sourceJson deserialization failed, this task may be the old data.");
    }

    private TaskConversions$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

