/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.jobhistory.service.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.governance.common.constant.job.JobRequestConstants$;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.governance.common.entity.job.JobRequestWithDetail;
import org.apache.linkis.governance.common.entity.job.QueryException;
import org.apache.linkis.governance.common.entity.job.SubJobDetail;
import org.apache.linkis.governance.common.protocol.conf.EntranceInstanceConfRequest;
import org.apache.linkis.governance.common.protocol.job.JobReqBatchUpdate;
import org.apache.linkis.governance.common.protocol.job.JobReqInsert;
import org.apache.linkis.governance.common.protocol.job.JobReqQuery;
import org.apache.linkis.governance.common.protocol.job.JobReqUpdate;
import org.apache.linkis.governance.common.protocol.job.JobRespProtocol;
import org.apache.linkis.jobhistory.conversions.TaskConversions$;
import org.apache.linkis.jobhistory.dao.JobHistoryMapper;
import org.apache.linkis.jobhistory.entity.JobHistory;
import org.apache.linkis.jobhistory.entity.QueryJobHistory;
import org.apache.linkis.jobhistory.errorcode.JobhistoryErrorCodeSummary;
import org.apache.linkis.jobhistory.service.JobHistoryQueryService;
import org.apache.linkis.jobhistory.transitional.TaskStatus;
import org.apache.linkis.jobhistory.util.QueryUtils$;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@ScalaSignature(bytes="\u0006\u0001\t-d\u0001B\f\u0019\u0001\u0015BQA\u000f\u0001\u0005\u0002mB\u0011B\u0010\u0001A\u0002\u0003\u0007I\u0011B \t\u0013\u0019\u0003\u0001\u0019!a\u0001\n\u00139\u0005\"\u0003)\u0001\u0001\u0004\u0005\t\u0015)\u0003A\u0011\u001dq\u0006A1A\u0005\n}Ca!\u001f\u0001!\u0002\u0013\u0001\u0007\"\u0002>\u0001\t\u0003Z\bbBA\u0017\u0001\u0011\u0005\u0013q\u0006\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\t9\u0006\u0001C!\u00033Bq!a\u001a\u0001\t\u0003\nI\u0007C\u0004\u0002\u0006\u0002!\t%a\"\t\u000f\u00055\u0005\u0001\"\u0011\u0002\u0010\"9\u0011q\u0019\u0001\u0005B\u0005%\u0007bBAo\u0001\u0011%\u0011q\u001c\u0005\b\u0003_\u0004A\u0011IAy\u0011\u001d\tI\u0010\u0001C!\u0003wDqA!\u0003\u0001\t\u0013\u0011Y\u0001C\u0004\u0003\u001a\u0001!\tEa\u0007\t\u000f\t\u0005\u0002\u0001\"\u0011\u0003$!9!1\t\u0001\u0005B\t\u0015\u0003b\u0002B(\u0001\u0011\u0005#\u0011\u000b\u0002\u001b\u0015>\u0014\u0007*[:u_JL\u0018+^3ssN+'O^5dK&k\u0007\u000f\u001c\u0006\u00033i\tA![7qY*\u00111\u0004H\u0001\bg\u0016\u0014h/[2f\u0015\tib$\u0001\u0006k_\nD\u0017n\u001d;pefT!a\b\u0011\u0002\r1Lgn[5t\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\u0004\u0001M!\u0001A\n\u00183!\t9C&D\u0001)\u0015\tI#&\u0001\u0003mC:<'\"A\u0016\u0002\t)\fg/Y\u0005\u0003[!\u0012aa\u00142kK\u000e$\bCA\u00181\u001b\u0005Q\u0012BA\u0019\u001b\u0005YQuN\u0019%jgR|'/_)vKJL8+\u001a:wS\u000e,\u0007CA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0015)H/\u001b7t\u0015\t9d$\u0001\u0004d_6lwN\\\u0005\u0003sQ\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002yA\u0011Q\bA\u0007\u00021\u0005\u0001\"n\u001c2ISN$xN]=NCB\u0004XM]\u000b\u0002\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\u00111\tH\u0001\u0004I\u0006|\u0017BA#C\u0005AQuN\u0019%jgR|'/_'baB,'/\u0001\u000bk_\nD\u0015n\u001d;pefl\u0015\r\u001d9fe~#S-\u001d\u000b\u0003\u0011:\u0003\"!\u0013'\u000e\u0003)S\u0011aS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b*\u0013A!\u00168ji\"9qjAA\u0001\u0002\u0004\u0001\u0015a\u0001=%c\u0005\t\"n\u001c2ISN$xN]=NCB\u0004XM\u001d\u0011)\u0005\u0011\u0011\u0006CA*]\u001b\u0005!&BA+W\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003/b\u000bqAZ1di>\u0014\u0018P\u0003\u0002Z5\u0006)!-Z1og*\u00111LI\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&\u0011Q\f\u0016\u0002\n\u0003V$xn^5sK\u0012\fq\"\u001e8E_:,G+Y:l\u0007\u0006\u001c\u0007.Z\u000b\u0002AB!\u0011-[6w\u001b\u0005\u0011'BA2e\u0003\u0015\u0019\u0017m\u00195f\u0015\t9TM\u0003\u0002gO\u00061qm\\8hY\u0016T\u0011\u0001[\u0001\u0004G>l\u0017B\u00016c\u0005\u0015\u0019\u0015m\u00195f!\ta7O\u0004\u0002ncB\u0011aNS\u0007\u0002_*\u0011\u0001\u000fJ\u0001\u0007yI|w\u000e\u001e \n\u0005IT\u0015A\u0002)sK\u0012,g-\u0003\u0002uk\n11\u000b\u001e:j]\u001eT!A\u001d&\u0011\u0005\u001d:\u0018B\u0001=)\u0005\u001dIe\u000e^3hKJ\f\u0001#\u001e8E_:,G+Y:l\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\u0007\u0005$G\rF\u0002}\u0003\u001f\u00012!`A\u0006\u001b\u0005q(bA@\u0002\u0002\u0005\u0019!n\u001c2\u000b\t\u0005\r\u0011QA\u0001\taJ|Go\\2pY*\u0019q'a\u0002\u000b\u0007\u0005%a$\u0001\u0006h_Z,'O\\1oG\u0016L1!!\u0004\u007f\u0005=QuN\u0019*fgB\u0004&o\u001c;pG>d\u0007bBA\t\u000f\u0001\u0007\u00111C\u0001\rU>\u0014'+Z9J]N,'\u000f\u001e\t\u0004{\u0006U\u0011bAA\f}\na!j\u001c2SKFLen]3si\"\u001aq!a\u0007\u0011\t\u0005u\u0011\u0011F\u0007\u0003\u0003?Q1!VA\u0011\u0015\u0011\t\u0019#!\n\u0002\u000f5,7o]1hK*\u0019\u0011q\u0005\u0010\u0002\u0007I\u00048-\u0003\u0003\u0002,\u0005}!\u0001\u0003*fG\u0016Lg/\u001a:\u0002\r\rD\u0017M\\4f)\ra\u0018\u0011\u0007\u0005\b\u0003gA\u0001\u0019AA\u001b\u00031QwN\u0019*fcV\u0003H-\u0019;f!\ri\u0018qG\u0005\u0004\u0003sq(\u0001\u0004&pEJ+\u0017/\u00169eCR,\u0007f\u0001\u0005\u0002\u001c\u0005Y!-\u0019;dQ\u000eC\u0017M\\4f)\u0011\t\t%!\u0014\u0011\u000b\u0005\r\u0013\u0011\n?\u000e\u0005\u0005\u0015#bAA$U\u0005!Q\u000f^5m\u0013\u0011\tY%!\u0012\u0003\u0013\u0005\u0013(/Y=MSN$\bbBA\u001a\u0013\u0001\u0007\u0011q\n\t\u0004{\u0006E\u0013bAA*}\n\t\"j\u001c2SKF\u0014\u0015\r^2i+B$\u0017\r^3)\u0007%\tY\"A\u0003rk\u0016\u0014\u0018\u0010F\u0002}\u00037Bq!!\u0018\u000b\u0001\u0004\ty&A\u0006k_\n\u0014V-])vKJL\bcA?\u0002b%\u0019\u00111\r@\u0003\u0017){'MU3r#V,'/\u001f\u0015\u0004\u0015\u0005m\u0011\u0001G4fi*{'\rS5ti>\u0014\u0018PQ=JI\u0006sGMT1nKR1\u00111NA<\u0003\u0003\u0003B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0004\u0003cb\u0012AB3oi&$\u00180\u0003\u0003\u0002v\u0005=$A\u0003&pE\"K7\u000f^8ss\"9\u0011\u0011P\u0006A\u0002\u0005m\u0014!\u00026pE&#\u0007cA\u0014\u0002~%\u0019\u0011q\u0010\u0015\u0003\t1{gn\u001a\u0005\u0007\u0003\u0007[\u0001\u0019A6\u0002\u0011U\u001cXM\u001d(b[\u0016\fadZ3u\u0015>\u0014\u0007*[:u_JL()_%e\u0003:$g*Y7f\u001d>\u001cu\u000eZ3\u0015\r\u0005-\u0014\u0011RAF\u0011\u001d\tI\b\u0004a\u0001\u0003wBa!a!\r\u0001\u0004Y\u0017AB:fCJ\u001c\u0007\u000e\u0006\r\u0002\u0012\u0006]\u0015\u0011TAO\u0003C\u000b)+a,\u00024\u0006]\u00161XA`\u0003\u0007\u0004b!a\u0011\u0002\u0014\u0006-\u0014\u0002BAK\u0003\u000b\u0012A\u0001T5ti\"9\u0011\u0011P\u0007A\u0002\u0005m\u0004BBAN\u001b\u0001\u00071.\u0001\u0005vg\u0016\u0014h.Y7f\u0011\u0019\ty*\u0004a\u0001W\u000611\u000f^1ukNDa!a)\u000e\u0001\u0004Y\u0017aB2sK\u0006$xN\u001d\u0005\b\u0003Ok\u0001\u0019AAU\u0003\u0015\u0019H)\u0019;f!\u0011\t\u0019%a+\n\t\u00055\u0016Q\t\u0002\u0005\t\u0006$X\rC\u0004\u000226\u0001\r!!+\u0002\u000b\u0015$\u0015\r^3\t\r\u0005UV\u00021\u0001l\u0003))gnZ5oKRK\b/\u001a\u0005\b\u0003sk\u0001\u0019AA>\u0003)\u0019H/\u0019:u\u0015>\u0014\u0017\n\u001a\u0005\u0007\u0003{k\u0001\u0019A6\u0002\u0011%t7\u000f^1oG\u0016Da!!1\u000e\u0001\u0004Y\u0017\u0001\u00043fa\u0006\u0014H/\\3oi&#\u0007BBAc\u001b\u0001\u00071.\u0001\bf]\u001eLg.Z%ogR\fgnY3\u0002\u001d\u001d,G/U;fef4v\nT5tiR!\u00111ZAm!\u0019\t\u0019%a%\u0002NB!\u0011qZAk\u001b\t\t\tNC\u0002\u0000\u0003'TA!!\u001d\u0002\u0006%!\u0011q[Ai\u0005)QuN\u0019*fcV,7\u000f\u001e\u0005\b\u00037t\u0001\u0019AAI\u0003\u0011a\u0017n\u001d;\u0002\u0019MDw.\u001e7e+B$\u0017\r^3\u0015\r\u0005\u0005\u0018q]Av!\rI\u00151]\u0005\u0004\u0003KT%a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003S|\u0001\u0019A6\u0002\u0013=dGm\u0015;biV\u001c\bBBAw\u001f\u0001\u00071.A\u0005oK^\u001cF/\u0019;vg\u0006I1/Z1sG\"|e.\u001a\u000b\t\u0003W\n\u00190!>\u0002x\"9\u0011\u0011\u0010\tA\u0002\u0005m\u0004bBAT!\u0001\u0007\u0011\u0011\u0016\u0005\b\u0003c\u0003\u0002\u0019AAU\u0003A\u0019w.\u001e8u+:$wN\\3UCN\\7\u000fF\u0007w\u0003{\fyP!\u0001\u0003\u0004\t\u0015!q\u0001\u0005\u0007\u00037\u000b\u0002\u0019A6\t\r\u0005\r\u0016\u00031\u0001l\u0011\u001d\t9+\u0005a\u0001\u0003SCq!!-\u0012\u0001\u0004\tI\u000b\u0003\u0004\u00026F\u0001\ra\u001b\u0005\b\u0003s\u000b\u0002\u0019AA>\u0003M9W\r^\"pk:$XK\u001c3p]\u0016$\u0016m]6t)51(Q\u0002B\b\u0005#\u0011\u0019B!\u0006\u0003\u0018!1\u00111\u0014\nA\u0002-Da!a)\u0013\u0001\u0004Y\u0007bBAT%\u0001\u0007\u0011\u0011\u0016\u0005\b\u0003c\u0013\u0002\u0019AAU\u0011\u0019\t)L\u0005a\u0001W\"9\u0011\u0011\u0018\nA\u0002\u0005m\u0014!F2iC:<Wm\u00142tKJ4X-\u00138g_\nK\u0018\n\u001a\u000b\u0004\u0011\nu\u0001b\u0002B\u0010'\u0001\u0007\u00111N\u0001\u000bU>\u0014\u0007*[:u_JL\u0018AI2mK\u0006\u0014XK\u001c3p]\u0016$\u0016m]6t\u0005f,e\u000e\u001e:b]\u000e,\u0017J\\:uC:\u001cW\rF\u0003I\u0005K\u0011)\u0004C\u0004\u0003(Q\u0001\rA!\u000b\u0002\u000fI,\u0017/^3tiB!!1\u0006B\u0019\u001b\t\u0011iC\u0003\u0003\u00030\u0005\u0005\u0011\u0001B2p]\u001aLAAa\r\u0003.\tYRI\u001c;sC:\u001cW-\u00138ti\u0006t7-Z\"p]\u001a\u0014V-];fgRDqAa\u000e\u0015\u0001\u0004\u0011I$\u0001\u0004tK:$WM\u001d\t\u0005\u0005w\u0011i$\u0004\u0002\u0002&%!!qHA\u0013\u0005\u0019\u0019VM\u001c3fe\"\u001aA#a\u0007\u0002\u001bM,\u0017M]2i\u0005f$\u0016m]6t)\u0019\t\tJa\u0012\u0003N!9!\u0011J\u000bA\u0002\t-\u0013A\u0003;bg.LG\rT5tiB)\u00111IAJW\"1\u00111T\u000bA\u0002-\f\u0001\u0003^1tW\u0012+(/\u0019;j_:$v\u000e\u001d(\u0015\u0019\u0005E%1\u000bB+\u0005/\u0012IFa\u0017\t\u000f\u0005\u001df\u00031\u0001\u0002*\"9\u0011\u0011\u0017\fA\u0002\u0005%\u0006BBAN-\u0001\u00071\u000e\u0003\u0004\u0002$Z\u0001\ra\u001b\u0005\u0007\u0003k3\u0002\u0019A6)\u0007\u0001\u0011y\u0006\u0005\u0003\u0003b\t\u001dTB\u0001B2\u0015\r\u0011)GW\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002B5\u0005G\u0012qaU3sm&\u001cW\r")
public class JobHistoryQueryServiceImpl
implements JobHistoryQueryService,
Logging {
    @Autowired
    private JobHistoryMapper jobHistoryMapper;
    private final Cache<String, Integer> unDoneTaskCache;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        JobHistoryQueryServiceImpl jobHistoryQueryServiceImpl = this;
        synchronized (jobHistoryQueryServiceImpl) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private JobHistoryMapper jobHistoryMapper() {
        return this.jobHistoryMapper;
    }

    private void jobHistoryMapper_$eq(JobHistoryMapper x$1) {
        this.jobHistoryMapper = x$1;
    }

    private Cache<String, Integer> unDoneTaskCache() {
        return this.unDoneTaskCache;
    }

    @Override
    @Receiver
    public JobRespProtocol add(JobReqInsert jobReqInsert) {
        this.logger().info(new StringBuilder(41).append("Insert data into the database(\u5f80\u6570\u636e\u5e93\u4e2d\u63d2\u5165\u6570\u636e)\uff1a").append(jobReqInsert.toString()).toString());
        JobRespProtocol jobResp = new JobRespProtocol();
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            QueryUtils$.MODULE$.storeExecutionCode(jobReqInsert.jobReq());
            JobHistory jobInsert = TaskConversions$.MODULE$.jobRequest2JobHistory(jobReqInsert.jobReq());
            jobInsert.setUpdatedTime(jobInsert.getCreatedTime());
            this.jobHistoryMapper().insertJobHistory(jobInsert);
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put(JobRequestConstants$.MODULE$.JOB_ID(), jobInsert.getId());
            jobResp.setStatus(0);
            jobResp.setData(map);
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            JobHistoryQueryServiceImpl.$anonfun$add$2(this, jobReqInsert, jobResp, x0$1);
            return BoxedUnit.UNIT;
        });
        return jobResp;
    }

    @Override
    @Receiver
    public JobRespProtocol change(JobReqUpdate jobReqUpdate) {
        JobRequest jobReq = jobReqUpdate.jobReq();
        jobReq.setExecutionCode(null);
        this.logger().info(new StringBuilder(51).append("Update data to the database(\u5f80\u6570\u636e\u5e93\u4e2d\u66f4\u65b0\u6570\u636e)\uff1atask ").append(jobReq.getId()).append("status:").append(jobReq.getStatus()).toString());
        JobRespProtocol jobResp = new JobRespProtocol();
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String oldStatus;
            if (jobReq.getErrorDesc() != null && jobReq.getErrorDesc().length() > GovernanceCommonConf$.MODULE$.ERROR_CODE_DESC_LEN()) {
                this.logger().info("errorDesc is too long,we will cut some message");
                jobReq.setErrorDesc(new StringBuilder(3).append(jobReq.getErrorDesc().substring(0, GovernanceCommonConf$.MODULE$.ERROR_CODE_DESC_LEN() - 3)).append("...").toString());
                this.logger().info(String.valueOf(jobReq.getErrorDesc()));
            }
            if (jobReq.getStatus() != null && (oldStatus = this.jobHistoryMapper().selectJobHistoryStatusForUpdate(jobReq.getId())) != null && !this.shouldUpdate(oldStatus, jobReq.getStatus())) {
                throw new QueryException(120001, new StringBuilder(77).append("jobId:").append(jobReq.getId()).append("\uff0coldStatus(\u5728\u6570\u636e\u5e93\u4e2d\u7684task\u72b6\u6001\u4e3a)\uff1a").append(oldStatus).append(",").append(" newStatus(\u66f4\u65b0\u7684task\u72b6\u6001\u4e3a)\uff1a").append(jobReq.getStatus()).append("\uff0cupdate failed(\u66f4\u65b0\u5931\u8d25)\uff01").toString());
            }
            JobHistory jobUpdate = TaskConversions$.MODULE$.jobRequest2JobHistory(jobReq);
            if (jobUpdate.getUpdatedTime() == null) {
                throw new QueryException(120001, new StringBuilder(69).append("jobId:").append(jobReq.getId()).append("\uff0cupdate job failed, updatetime needed(\u66f4\u65b0job\u76f8\u5173\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u8be5\u8bf7\u6c42\u7684\u66f4\u65b0\u65f6\u95f4)!").toString());
            }
            this.logger().info(new StringBuilder(80).append("Update data to the database(\u5f80\u6570\u636e\u5e93\u4e2d\u66f4\u65b0\u6570\u636e)\uff1atask ").append(jobReq.getId()).append(" ,status ").append(jobReq.getStatus()).append(",").append(" updateTime: ").append(jobUpdate.getUpdateTimeMills()).append(", progress : ").append(jobUpdate.getProgress()).toString());
            this.jobHistoryMapper().updateJobHistory(jobUpdate);
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put(JobRequestConstants$.MODULE$.JOB_ID(), jobReq.getId());
            jobResp.setStatus(0);
            jobResp.setData(map);
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            JobHistoryQueryServiceImpl.$anonfun$change$2(this, jobReq, jobResp, x0$1);
            return BoxedUnit.UNIT;
        });
        return jobResp;
    }

    @Override
    @Receiver
    public ArrayList<JobRespProtocol> batchChange(JobReqBatchUpdate jobReqUpdate) {
        ArrayList<JobRespProtocol> jobRespList;
        block0: {
            ArrayList jobReqList = jobReqUpdate.jobReq();
            jobRespList = new ArrayList<JobRespProtocol>();
            if (jobReqList == null) break block0;
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)jobReqList).asScala()).foreach((Function1 & Serializable & scala.Serializable)jobReq -> BoxesRunTime.boxToBoolean((boolean)JobHistoryQueryServiceImpl.$anonfun$batchChange$1(this, jobRespList, jobReq)));
        }
        return jobRespList;
    }

    @Override
    @Receiver
    public JobRespProtocol query(JobReqQuery jobReqQuery) {
        this.logger().info(new StringBuilder(19).append("query history task\uff1a").append(jobReqQuery.toString()).toString());
        JobRespProtocol jobResp = new JobRespProtocol();
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JobHistory jobHistory = TaskConversions$.MODULE$.jobRequest2JobHistory(jobReqQuery.jobReq());
            List<JobHistory> task = this.jobHistoryMapper().selectJobHistory(jobHistory);
            ArrayList tasksWithDetails = new ArrayList();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(task).asScala()).foreach((Function1 & Serializable & scala.Serializable)job -> BoxesRunTime.boxToBoolean((boolean)JobHistoryQueryServiceImpl.$anonfun$query$2(tasksWithDetails, job)));
            HashMap map = new HashMap();
            map.put(JobRequestConstants$.MODULE$.JOB_HISTORY_LIST(), tasksWithDetails);
            jobResp.setStatus(0);
            jobResp.setData(map);
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            JobHistoryQueryServiceImpl.$anonfun$query$3(this, jobReqQuery, jobResp, x0$1);
            return BoxedUnit.UNIT;
        });
        return jobResp;
    }

    @Override
    public JobHistory getJobHistoryByIdAndName(Long jobId, String userName) {
        JobHistory jobReq = new JobHistory();
        jobReq.setId(jobId);
        jobReq.setSubmitUser(userName);
        List<JobHistory> jobHistoryList = this.jobHistoryMapper().selectJobHistory(jobReq);
        if (jobHistoryList.isEmpty()) {
            return null;
        }
        return jobHistoryList.get(0);
    }

    @Override
    public JobHistory getJobHistoryByIdAndNameNoCode(Long jobId, String userName) {
        JobHistory jobReq = new JobHistory();
        jobReq.setId(jobId);
        jobReq.setSubmitUser(userName);
        List<JobHistory> jobHistoryList = this.jobHistoryMapper().selectJobHistoryNoCode(jobReq);
        if (jobHistoryList.isEmpty()) {
            return null;
        }
        return jobHistoryList.get(0);
    }

    @Override
    public List<JobHistory> search(Long jobId, String username, String status, String creator, Date sDate, Date eDate, String engineType, Long startJobId, String instance, String departmentId, String engineInstance) {
        List<JobHistory> list;
        List split;
        List list2 = split = status != null ? (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])status.split(","))).toList()).asJava() : null;
        if (StringUtils.isBlank((CharSequence)creator)) {
            list = this.jobHistoryMapper().search(jobId, username, split, sDate, eDate, engineType, startJobId, instance, departmentId, engineInstance);
        } else if (StringUtils.isBlank((CharSequence)username)) {
            UserCreatorLabel fakeLabel = new UserCreatorLabel();
            list = this.jobHistoryMapper().searchWithCreatorOnly(jobId, username, fakeLabel.getLabelKey(), creator, split, sDate, eDate, engineType, startJobId, instance, departmentId, engineInstance);
        } else {
            UserCreatorLabel fakeLabel = new UserCreatorLabel();
            fakeLabel.setUser(username);
            fakeLabel.setCreator(creator);
            String userCreator = fakeLabel.getStringValue();
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fakeLabel.valueCheck(userCreator), (Function1 & Serializable & scala.Serializable)t -> {
                this.logger().info("input user or creator is not correct", t);
                throw t;
            });
            list = this.jobHistoryMapper().searchWithUserCreator(jobId, username, fakeLabel.getLabelKey(), userCreator, split, sDate, eDate, engineType, startJobId, instance, departmentId, engineInstance);
        }
        List<JobHistory> result = list;
        return result;
    }

    @Override
    public List<JobRequest> getQueryVOList(List<JobHistory> list) {
        return TaskConversions$.MODULE$.jobHistory2JobRequest(list);
    }

    private boolean shouldUpdate(String oldStatus, String newStatus) {
        TaskStatus taskStatus = TaskStatus.valueOf(oldStatus);
        TaskStatus taskStatus2 = TaskStatus.valueOf(newStatus);
        if (!(taskStatus != null ? !((Object)((Object)taskStatus)).equals((Object)taskStatus2) : taskStatus2 != null)) {
            return true;
        }
        return TaskStatus.valueOf(oldStatus).ordinal() <= TaskStatus.valueOf(newStatus).ordinal() && !TaskStatus.isComplete(TaskStatus.valueOf(oldStatus));
    }

    @Override
    public JobHistory searchOne(Long jobId, Date sDate, Date eDate) {
        List<JobHistory> list = this.jobHistoryMapper().search(jobId, null, null, sDate, eDate, null, null, null, null, null);
        QueryJobHistory queryJobHistory = new QueryJobHistory();
        queryJobHistory.setId(jobId);
        queryJobHistory.setStatus(TaskStatus.Inited.toString());
        queryJobHistory.setSubmitUser("EMPTY");
        return (JobHistory)Iterables.getFirst(list, (Object)queryJobHistory);
    }

    @Override
    public Integer countUndoneTasks(String username, String creator, Date sDate, Date eDate, String engineType, Long startJobId) {
        String cacheKey;
        String string = cacheKey = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{username, creator, engineType}) ? new StringBuilder(2).append(username).append("_").append(creator).append("_").append(engineType).toString() : "";
        if (StringUtils.isBlank((CharSequence)cacheKey)) {
            return this.org$apache$linkis$jobhistory$service$impl$JobHistoryQueryServiceImpl$$getCountUndoneTasks(username, creator, sDate, eDate, engineType, startJobId);
        }
        this.logger().info("From cache to get un Done task {}", new Object[]{cacheKey});
        return (Integer)this.unDoneTaskCache().get((Object)cacheKey, (Callable)new Callable<Integer>(this, username, creator, sDate, eDate, engineType, startJobId){
            private final /* synthetic */ JobHistoryQueryServiceImpl $outer;
            private final String username$1;
            private final String creator$1;
            private final Date sDate$1;
            private final Date eDate$1;
            private final String engineType$1;
            private final Long startJobId$1;

            public Integer call() {
                Integer n;
                try {
                    n = this.$outer.org$apache$linkis$jobhistory$service$impl$JobHistoryQueryServiceImpl$$getCountUndoneTasks(this.username$1, this.creator$1, this.sDate$1, this.eDate$1, this.engineType$1, this.startJobId$1);
                }
                catch (Exception e) {
                    this.$outer.logger().error("Failed to get count undone tasks", (Throwable)e);
                    n = Predef$.MODULE$.int2Integer(0);
                }
                return n;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.username$1 = username$1;
                this.creator$1 = creator$1;
                this.sDate$1 = sDate$1;
                this.eDate$1 = eDate$1;
                this.engineType$1 = engineType$1;
                this.startJobId$1 = startJobId$1;
            }
        });
    }

    public Integer org$apache$linkis$jobhistory$service$impl$JobHistoryQueryServiceImpl$$getCountUndoneTasks(String username, String creator, Date sDate, Date eDate, String engineType, Long startJobId) {
        Integer n;
        this.logger().info("Get count undone Tasks {}, {}, {}, {}", new Object[]{username, creator, engineType, startJobId});
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(TaskStatus.Running.toString());
        statusList.add(TaskStatus.Inited.toString());
        statusList.add(TaskStatus.Scheduled.toString());
        if (StringUtils.isBlank((CharSequence)creator)) {
            n = this.jobHistoryMapper().countUndoneTaskNoCreator(username, statusList, sDate, eDate, engineType, startJobId);
        } else if (StringUtils.isBlank((CharSequence)username)) {
            UserCreatorLabel fakeLabel = new UserCreatorLabel();
            n = this.jobHistoryMapper().countUndoneTaskWithCreatorOnly(username, fakeLabel.getLabelKey(), creator, statusList, sDate, eDate, engineType, startJobId);
        } else {
            UserCreatorLabel fakeLabel = new UserCreatorLabel();
            fakeLabel.setUser(username);
            fakeLabel.setCreator(creator);
            String userCreator = fakeLabel.getStringValue();
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fakeLabel.valueCheck(userCreator), (Function1 & Serializable & scala.Serializable)t -> {
                this.logger().info("input user or creator is not correct", t);
                throw t;
            });
            n = this.jobHistoryMapper().countUndoneTaskWithUserCreator(username, fakeLabel.getLabelKey(), userCreator, statusList, sDate, eDate, engineType, startJobId);
        }
        Integer count = n;
        return count;
    }

    @Override
    public void changeObserveInfoById(JobHistory jobHistory) {
        this.jobHistoryMapper().updateOberverById(jobHistory.getId(), jobHistory.getObserveInfo());
    }

    @Override
    @Receiver
    public void clearUndoneTasksByEntranceInstance(EntranceInstanceConfRequest request, Sender sender) {
        this.logger().info("Request Entrance Instance :{}", new Object[]{request.instance()});
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(TaskStatus.WaitForRetry.toString());
        statusList.add(TaskStatus.Inited.toString());
        statusList.add(TaskStatus.Scheduled.toString());
        statusList.add(TaskStatus.Running.toString());
        Date eDate = new Date(System.currentTimeMillis());
        Date sDate = DateUtils.addDays((Date)eDate, (int)-1);
        List<JobHistory> jobHistoryList = this.jobHistoryMapper().search(null, null, statusList, sDate, eDate, null, null, request.instance(), null, null);
        List idlist2 = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(jobHistoryList).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Buffer$.MODULE$.canBuildFrom())).asJava();
        this.logger().info("Tasks id will be canceled ids :{}", new Object[]{idlist2});
        String errorMsg = JobhistoryErrorCodeSummary.UNFINISHED_TASKS.getErrorDesc();
        if (!idlist2.isEmpty()) {
            if (idlist2.size() >= 1000) {
                this.logger().error("The number of batch modification tasks exceeds 1000");
            }
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(Lists.partition((List)idlist2, (int)100)).asScala()).foreach((Function1 & Serializable & scala.Serializable)idlist -> {
                JobHistoryQueryServiceImpl.$anonfun$clearUndoneTasksByEntranceInstance$2(this, errorMsg, idlist);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public List<JobHistory> searchByTasks(List<String> taskidList, String username) {
        return this.jobHistoryMapper().selectJobHistoryByTaskidList(taskidList, username);
    }

    @Override
    public List<JobHistory> taskDurationTopN(Date sDate, Date eDate, String username, String creator, String engineType) {
        List<JobHistory> list;
        if (StringUtils.isBlank((CharSequence)creator)) {
            list = this.jobHistoryMapper().taskDurationTopN(sDate, eDate, username, engineType);
        } else if (StringUtils.isBlank((CharSequence)username)) {
            UserCreatorLabel fakeLabel = new UserCreatorLabel();
            list = this.jobHistoryMapper().taskDurationTopNWithCreatorOnly(username, fakeLabel.getLabelKey(), creator, sDate, eDate, engineType);
        } else {
            UserCreatorLabel fakeLabel = new UserCreatorLabel();
            fakeLabel.setUser(username);
            fakeLabel.setCreator(creator);
            String userCreator = fakeLabel.getStringValue();
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fakeLabel.valueCheck(userCreator), (Function1 & Serializable & scala.Serializable)t -> {
                this.logger().info("input user or creator is not correct", t);
                throw t;
            });
            list = this.jobHistoryMapper().taskDurationTopNWithUserCreator(username, fakeLabel.getLabelKey(), userCreator, sDate, eDate, engineType);
        }
        List<JobHistory> result = list;
        return result;
    }

    public static final /* synthetic */ void $anonfun$add$2(JobHistoryQueryServiceImpl $this, JobReqInsert jobReqInsert$1, JobRespProtocol jobResp$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            $this.logger().error(new StringBuilder(43).append("Failed to add JobReqInsert ").append(jobReqInsert$1.toString()).append(",should be retry").toString(), (Throwable)exception);
            jobResp$1.setStatus(2);
            jobResp$1.setMsg(ExceptionUtils.getRootCauseMessage((Throwable)exception));
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ void $anonfun$change$2(JobHistoryQueryServiceImpl $this, JobRequest jobReq$1, JobRespProtocol jobResp$2, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof QueryException) {
            QueryException queryException = (QueryException)throwable;
            $this.logger().error(new StringBuilder(38).append("Failed to update JobReqUpdate ").append(jobReq$1.getId()).append(",status ").append(jobReq$1.getStatus()).toString(), (Throwable)queryException);
            jobResp$2.setStatus(1);
            jobResp$2.setMsg(ExceptionUtils.getRootCauseMessage((Throwable)queryException));
            return;
        }
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            $this.logger().error(new StringBuilder(38).append("Failed to update JobReqUpdate ").append(jobReq$1.getId()).append(",status ").append(jobReq$1.getStatus()).toString(), (Throwable)exception);
            jobResp$2.setStatus(2);
            jobResp$2.setMsg(ExceptionUtils.getRootCauseMessage((Throwable)exception));
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ void $anonfun$batchChange$3(JobHistoryQueryServiceImpl $this, JobRequest jobReq$2, JobRespProtocol jobResp$3, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            $this.logger().error(new StringBuilder(38).append("Failed to update JobReqUpdate ").append(jobReq$2.getId()).append(",status ").append(jobReq$2.getStatus()).toString(), (Throwable)exception);
            jobResp$3.setStatus(1);
            jobResp$3.setMsg(ExceptionUtils.getRootCauseMessage((Throwable)exception));
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ boolean $anonfun$batchChange$1(JobHistoryQueryServiceImpl $this, ArrayList jobRespList$1, JobRequest jobReq) {
        jobReq.setExecutionCode(null);
        $this.logger().info(new StringBuilder(46).append("Update data to the database(\u5f80\u6570\u636e\u5e93\u4e2d\u66f4\u65b0\u6570\u636e)\uff1astatus:").append(jobReq.getStatus()).toString());
        JobRespProtocol jobResp = new JobRespProtocol();
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String oldStatus;
            if (jobReq.getErrorDesc() != null && jobReq.getErrorDesc().length() > GovernanceCommonConf$.MODULE$.ERROR_CODE_DESC_LEN()) {
                $this.logger().info("errorDesc is too long,we will cut some message");
                jobReq.setErrorDesc(new StringBuilder(3).append(jobReq.getErrorDesc().substring(0, GovernanceCommonConf$.MODULE$.ERROR_CODE_DESC_LEN() - 3)).append("...").toString());
                $this.logger().info(String.valueOf(jobReq.getErrorDesc()));
            }
            if (jobReq.getStatus() != null && (oldStatus = $this.jobHistoryMapper().selectJobHistoryStatusForUpdate(jobReq.getId())) != null && !$this.shouldUpdate(oldStatus, jobReq.getStatus())) {
                throw new QueryException(120001, new StringBuilder(76).append("jobId:").append(jobReq.getId()).append("\uff0coldStatus(\u5728\u6570\u636e\u5e93\u4e2d\u7684task\u72b6\u6001\u4e3a)\uff1a").append(oldStatus).append("\uff0c").append("newStatus(\u66f4\u65b0\u7684task\u72b6\u6001\u4e3a)\uff1a").append(jobReq.getStatus()).append("\uff0cupdate failed(\u66f4\u65b0\u5931\u8d25)\uff01").toString());
            }
            JobHistory jobUpdate = TaskConversions$.MODULE$.jobRequest2JobHistory(jobReq);
            jobUpdate.setUpdatedTime(new Timestamp(System.currentTimeMillis()));
            $this.jobHistoryMapper().updateJobHistory(jobUpdate);
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put(JobRequestConstants$.MODULE$.JOB_ID(), jobReq.getId());
            jobResp.setStatus(0);
            jobResp.setData(map);
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            JobHistoryQueryServiceImpl.$anonfun$batchChange$3($this, jobReq, jobResp, x0$1);
            return BoxedUnit.UNIT;
        });
        return jobRespList$1.add(jobResp);
    }

    public static final /* synthetic */ boolean $anonfun$query$2(ArrayList tasksWithDetails$1, JobHistory job) {
        ArrayList<SubJobDetail> subJobDetails = new ArrayList<SubJobDetail>();
        SubJobDetail subJobDetail = new SubJobDetail();
        subJobDetail.setResultLocation(job.getResultLocation());
        subJobDetails.add(subJobDetail);
        return tasksWithDetails$1.add(new JobRequestWithDetail(TaskConversions$.MODULE$.jobHistory2JobRequest(job)).setSubJobDetailList(subJobDetails));
    }

    public static final /* synthetic */ void $anonfun$query$3(JobHistoryQueryServiceImpl $this, JobReqQuery jobReqQuery$1, JobRespProtocol jobResp$4, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            $this.logger().error(new StringBuilder(20).append("Failed to query job ").append(jobReqQuery$1.jobReq().getId()).toString(), (Throwable)exception);
            jobResp$4.setStatus(1);
            jobResp$4.setMsg(ExceptionUtils.getRootCauseMessage((Throwable)exception));
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ void $anonfun$clearUndoneTasksByEntranceInstance$2(JobHistoryQueryServiceImpl $this, String errorMsg$1, List idlist) {
        $this.jobHistoryMapper().updateJobHistoryCancelById(idlist, errorMsg$1);
    }

    public JobHistoryQueryServiceImpl() {
        Logging.$init$((Logging)this);
        this.unDoneTaskCache = CacheBuilder.newBuilder().concurrencyLevel(5).expireAfterWrite(1L, TimeUnit.MINUTES).initialCapacity(20).maximumSize(1000L).recordStats().build();
    }
}

