/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.server.security;

import java.io.Serializable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.errorcode.LinkisModuleErrorCodeSummary;
import org.apache.linkis.server.conf.ServerConfiguration$;
import org.apache.linkis.server.exception.IllegalUserTicketException;
import org.apache.linkis.server.exception.LoginExpireException;
import org.apache.linkis.server.security.SSOUtils$;
import org.apache.linkis.server.security.SecurityFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SecurityFilter$ {
    public static SecurityFilter$ MODULE$;
    private final Logger org$apache$linkis$server$security$SecurityFilter$$logger;
    private final String OTHER_SYSTEM_IGNORE_UM_USER;
    private final String ALLOW_ACCESS_WITHOUT_TIMEOUT;

    static {
        new SecurityFilter$();
    }

    public Logger org$apache$linkis$server$security$SecurityFilter$$logger() {
        return this.org$apache$linkis$server$security$SecurityFilter$$logger;
    }

    public String OTHER_SYSTEM_IGNORE_UM_USER() {
        return this.OTHER_SYSTEM_IGNORE_UM_USER;
    }

    public String ALLOW_ACCESS_WITHOUT_TIMEOUT() {
        return this.ALLOW_ACCESS_WITHOUT_TIMEOUT;
    }

    public Option<String> getLoginUserThrowsExceptionWhenTimeout(HttpServletRequest req) {
        return Option$.MODULE$.apply((Object)req.getCookies()).flatMap((Function1 & Serializable & scala.Serializable)cs -> SSOUtils$.MODULE$.getLoginUser((Function0<Cookie[]>)(Function0 & Serializable & scala.Serializable)() -> cs)).orElse((Function0 & Serializable & scala.Serializable)() -> SSOUtils$.MODULE$.getLoginUserIgnoreTimeout((Function1<String, Option<String>>)(Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.apply((Object)req.getHeader(key))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SecurityFilter$.$anonfun$getLoginUserThrowsExceptionWhenTimeout$5(x$1))));
    }

    public Option<String> getLoginUser(HttpServletRequest req) {
        return (Option)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> MODULE$.getLoginUserThrowsExceptionWhenTimeout(req), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof LoginExpireException) {
                return SSOUtils$.MODULE$.getLoginUserIgnoreTimeout((Function1<String, Option<String>>)(Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.apply((Object)req.getCookies()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2)).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SecurityFilter$.$anonfun$getLoginUser$5(key, x$3))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getValue()))).filter((Function1 & Serializable & scala.Serializable)user -> BoxesRunTime.boxToBoolean((boolean)SecurityFilter$.$anonfun$getLoginUser$7(req, user)));
            }
            throw throwable;
        });
    }

    public boolean isRequestIgnoreTimeout(HttpServletRequest req) {
        return Option$.MODULE$.apply((Object)req.getCookies()).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SecurityFilter$.$anonfun$isRequestIgnoreTimeout$1(x$5)));
    }

    public void addIgnoreTimeoutSignal(HttpServletResponse response) {
        response.addCookie(this.ignoreTimeoutSignal());
    }

    public Cookie ignoreTimeoutSignal() {
        Cookie cookie;
        block0: {
            cookie = new Cookie(this.ALLOW_ACCESS_WITHOUT_TIMEOUT(), "true");
            cookie.setMaxAge(-1);
            cookie.setPath("/");
            if (!SSOUtils$.MODULE$.sslEnable()) break block0;
            cookie.setSecure(true);
        }
        return cookie;
    }

    public void removeIgnoreTimeoutSignal(HttpServletResponse response) {
        Cookie cookie = new Cookie(this.ALLOW_ACCESS_WITHOUT_TIMEOUT(), "false");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        if (SSOUtils$.MODULE$.sslEnable()) {
            cookie.setSecure(true);
        }
        response.addCookie(cookie);
    }

    public String getLoginUsername(HttpServletRequest req) {
        if (BoxesRunTime.unboxToBoolean((Object)Configuration$.MODULE$.IS_TEST_MODE().getValue())) {
            String testUser = (String)ServerConfiguration$.MODULE$.BDP_TEST_USER().getValue();
            if (StringUtils.isBlank((CharSequence)testUser)) {
                throw new IllegalUserTicketException("Need to set test user when enable test module");
            }
            return testUser;
        }
        return (String)this.getLoginUser(req).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalUserTicketException(LinkisModuleErrorCodeSummary.ILLEGAL_USER_TOKEN.getErrorDesc());
        });
    }

    public void setLoginUser(HttpServletResponse resp, String username) {
        SSOUtils$.MODULE$.setLoginUser((Function1<Cookie, BoxedUnit>)(Function1 & Serializable & scala.Serializable)c -> {
            resp.addCookie(c);
            return BoxedUnit.UNIT;
        }, username, SSOUtils$.MODULE$.setLoginUser$default$3());
    }

    public void removeLoginUser(HttpServletRequest req, HttpServletResponse resp) {
        SSOUtils$.MODULE$.removeLoginUser((Function0<Cookie[]>)(Function0 & Serializable & scala.Serializable)() -> req.getCookies());
        SSOUtils$.MODULE$.removeLoginUserByAddCookie((Function1<Cookie, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
            resp.addCookie(s);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getLoginUserThrowsExceptionWhenTimeout$5(String x$1) {
        String string = x$1;
        String string2 = MODULE$.OTHER_SYSTEM_IGNORE_UM_USER();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getLoginUser$5(String key$1, Cookie x$3) {
        String string = x$3.getName();
        String string2 = key$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getLoginUser$7(HttpServletRequest req$2, String user) {
        String string = user;
        String string2 = MODULE$.OTHER_SYSTEM_IGNORE_UM_USER();
        return (string == null ? string2 != null : !string.equals(string2)) && MODULE$.isRequestIgnoreTimeout(req$2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isRequestIgnoreTimeout$2(Cookie c) {
        String string = c.getName();
        String string2 = MODULE$.ALLOW_ACCESS_WITHOUT_TIMEOUT();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = c.getValue();
        String string4 = "true";
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$isRequestIgnoreTimeout$1(Cookie[] x$5) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$5)).exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SecurityFilter$.$anonfun$isRequestIgnoreTimeout$2(c)));
    }

    private SecurityFilter$() {
        MODULE$ = this;
        this.org$apache$linkis$server$security$SecurityFilter$$logger = LoggerFactory.getLogger(SecurityFilter.class);
        this.OTHER_SYSTEM_IGNORE_UM_USER = "dataworkcloud_rpc_user";
        this.ALLOW_ACCESS_WITHOUT_TIMEOUT = "dataworkcloud_inner_request";
    }
}

