/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.restful.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.utils.JsonUtils;
import org.apache.linkis.configuration.entity.ConfigKeyLimitVo;
import org.apache.linkis.configuration.exception.ConfigurationException;
import org.apache.linkis.configuration.service.TemplateConfigKeyService;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"configuration template"})
@RestController
@RequestMapping(path={"/configuration/template"})
public class TemplateRestfulApi {
    private static final Logger logger = LoggerFactory.getLogger(TemplateRestfulApi.class);
    @Autowired
    private TemplateConfigKeyService templateConfigKeyService;

    @ApiOperation(value="updateKeyMapping", notes="query engineconn info list", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="templateUid", dataType="String", required=true, value="templateUid"), @ApiImplicitParam(name="templateName", dataType="String", required=true, value="engine type"), @ApiImplicitParam(name="engineType", dataType="String", required=true, value="String"), @ApiImplicitParam(name="operator", dataType="String", value="operator"), @ApiImplicitParam(name="isFullMode", dataType="Boolbean", value="isFullMode"), @ApiImplicitParam(name="itemList", dataType="Array", value="itemList")})
    @RequestMapping(path={"/updateKeyMapping"}, method={RequestMethod.POST})
    public Message updateKeyMapping(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws ConfigurationException {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"updateKeyMapping");
        String token = ModuleUserUtils.getToken((HttpServletRequest)req);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            if (!Configuration.isAdminToken((String)token)) {
                logger.warn("Token:{} has no permission to updateKeyMapping.", (Object)token);
                return Message.error((String)("Token:" + token + " has no permission to updateKeyMapping."));
            }
        } else if (!Configuration.isAdmin((String)username)) {
            logger.warn("User:{} has no permission to updateKeyMapping.", (Object)username);
            return Message.error((String)("User:" + username + " has no permission to updateKeyMapping."));
        }
        String templateUid = jsonNode.get("templateUid").asText();
        String templateName = jsonNode.get("templateName").asText();
        String engineType = jsonNode.get("engineType").asText();
        String operator = jsonNode.get("operator").asText();
        if (StringUtils.isBlank((CharSequence)templateUid)) {
            return Message.error((String)"parameters:templateUid can not be empty(\u8bf7\u6c42\u53c2\u6570\u3010templateUid\u3011\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        if (StringUtils.isBlank((CharSequence)templateName)) {
            return Message.error((String)"parameters:templateName can not be empty(\u8bf7\u6c42\u53c2\u6570\u3010templateName\u3011\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        if (StringUtils.isBlank((CharSequence)engineType)) {
            return Message.error((String)"parameters:engineType can not be empty(\u8bf7\u6c42\u53c2\u6570\u3010engineType\u3011\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        if (StringUtils.isBlank((CharSequence)operator)) {
            return Message.error((String)"parameters:operator can not be empty(\u8bf7\u6c42\u53c2\u6570\u3010operator\u3011\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        boolean isFullMode = true;
        try {
            isFullMode = jsonNode.get("isFullMode").asBoolean();
            logger.info("will update by param isFullMode:" + isFullMode);
        }
        catch (Exception e) {
            logger.info("will update by default isFullMode:" + isFullMode);
        }
        JsonNode itemParms = jsonNode.get("itemList");
        ArrayList<ConfigKeyLimitVo> confKeyList = new ArrayList();
        if (itemParms != null && !itemParms.isNull()) {
            try {
                confKeyList = (List)JsonUtils.jackson().readValue(itemParms.toString(), (TypeReference)new TypeReference<List<ConfigKeyLimitVo>>(){});
            }
            catch (JsonProcessingException e) {
                return Message.error((String)("parameters:itemList parsing failed(\u8bf7\u6c42\u53c2\u6570\u3010itemList\u3011\u89e3\u6790\u5931\u8d25), error with:" + e.getMessage()));
            }
        } else {
            return Message.error((String)"parameters:itemList can not be empty(\u8bf7\u6c42\u53c2\u6570\u3010itemList\u3011\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        logger.info("request parameters templateUid:{}, templateName:{}, engineType:{}, operator:{},isFullMode:{}, itemList:[{}]", new Object[]{templateUid, templateName, engineType, operator, itemParms.asText()});
        if (Configuration.GLOBAL_CONF_SYMBOL().equals(engineType)) {
            engineType = "";
        }
        this.templateConfigKeyService.updateKeyMapping(templateUid, templateName, engineType, operator, confKeyList, isFullMode);
        return Message.ok();
    }

    @ApiOperation(value="queryKeyInfoList", notes="query key info list", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="templateUidList", dataType="Array", value="templateUidList")})
    @RequestMapping(path={"/queryKeyInfoList"}, method={RequestMethod.POST})
    public Message queryKeyInfoList(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws ConfigurationException {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"queryKeyInfoList");
        String token = ModuleUserUtils.getToken((HttpServletRequest)req);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            if (!Configuration.isAdminToken((String)token)) {
                logger.warn("Token:{} has no permission to queryKeyInfoList.", (Object)token);
                return Message.error((String)("Token:" + token + " has no permission to queryKeyInfoList."));
            }
        } else if (!Configuration.isAdmin((String)username)) {
            logger.warn("User:{} has no permission to queryKeyInfoList.", (Object)username);
            return Message.error((String)("User:" + username + " has no permission to queryKeyInfoList."));
        }
        JsonNode templateUidListParms = jsonNode.get("templateUidList");
        ArrayList<String> uuidList = new ArrayList();
        if (templateUidListParms != null && !templateUidListParms.isNull()) {
            try {
                uuidList = (List)JsonUtils.jackson().readValue(templateUidListParms.toString(), (TypeReference)new TypeReference<List<String>>(){});
            }
            catch (JsonProcessingException e) {
                return Message.error((String)("parameters:templateUidList parsing failed(\u8bf7\u6c42\u53c2\u6570\u3010templateUidList\u3011\u89e3\u6790\u5931\u8d25), error with:" + e.getMessage()));
            }
        } else {
            return Message.error((String)"parameters:templateUidList can not be empty(\u8bf7\u6c42\u53c2\u6570\u3010templateUidList\u3011\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        List<Object> result = this.templateConfigKeyService.queryKeyInfoList(uuidList);
        return Message.ok().data("list", result);
    }

    @ApiOperation(value="apply", notes="apply conf template rule", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="templateUid", dataType="String", required=true, value="templateUid"), @ApiImplicitParam(name="application", dataType="String", value="application"), @ApiImplicitParam(name="engineType", dataType="String", value="engineType"), @ApiImplicitParam(name="engineVersion", dataType="String", value="engineVersion"), @ApiImplicitParam(name="operator", dataType="String", value="operator"), @ApiImplicitParam(name="userList", dataType="Array", value="userList")})
    @RequestMapping(path={"/apply"}, method={RequestMethod.POST})
    public Message apply(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws ConfigurationException {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"apply");
        String token = ModuleUserUtils.getToken((HttpServletRequest)req);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            if (!Configuration.isAdminToken((String)token)) {
                logger.warn("Token:{} has no permission to apply.", (Object)token);
                return Message.error((String)("Token:" + token + " has no permission to apply."));
            }
        } else if (!Configuration.isAdmin((String)username)) {
            logger.warn("User:{} has no permission to apply.", (Object)username);
            return Message.error((String)("User:" + username + " has no permission to apply."));
        }
        String templateUid = jsonNode.get("templateUid").asText();
        String application = jsonNode.get("application").asText();
        String engineType = jsonNode.get("engineType").asText();
        String engineVersion = jsonNode.get("engineVersion").asText();
        String operator = jsonNode.get("operator").asText();
        if (StringUtils.isBlank((CharSequence)templateUid)) {
            return Message.error((String)"parameters:templateUid can not be empty(\u8bf7\u6c42\u53c2\u6570\u3010templateUid\u3011\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        if (StringUtils.isBlank((CharSequence)application)) {
            return Message.error((String)"parameters:application can not be empty(\u8bf7\u6c42\u53c2\u6570\u3010application\u3011\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        if (StringUtils.isBlank((CharSequence)engineType)) {
            return Message.error((String)"parameters:engineType can not be empty(\u8bf7\u6c42\u53c2\u6570\u3010engineType\u3011\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        if (StringUtils.isBlank((CharSequence)engineVersion)) {
            return Message.error((String)"parameters:engineVersion can not be empty(\u8bf7\u6c42\u53c2\u6570\u3010engineVersion\u3011\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        if (StringUtils.isBlank((CharSequence)operator)) {
            return Message.error((String)"parameters:operator can not be empty(\u8bf7\u6c42\u53c2\u6570\u3010operator\u3011\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        JsonNode userParms = jsonNode.get("userList");
        ArrayList<String> userList = new ArrayList();
        if (userParms != null && !userParms.isNull()) {
            try {
                userList = (List)JsonUtils.jackson().readValue(userParms.toString(), (TypeReference)new TypeReference<List<String>>(){});
            }
            catch (JsonProcessingException e) {
                return Message.error((String)("parameters:userList parsing failed(\u8bf7\u6c42\u53c2\u6570\u3010userList\u3011\u89e3\u6790\u5931\u8d25), error with:" + e.getMessage()));
            }
        } else {
            return Message.error((String)"parameters:userList can not be empty(\u8bf7\u6c42\u53c2\u6570\u3010userList\u3011\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        logger.info("request parameters templateUid:{}, application:{}, engineType:{}, engineVersion:{}, operator:{},userList:[{}]", new Object[]{templateUid, application, engineType, engineVersion, operator, String.join((CharSequence)",", userList)});
        Map<String, Object> result = this.templateConfigKeyService.apply(templateUid, application, engineType, engineVersion, operator, userList);
        Message message = Message.ok();
        message.getData().putAll(result);
        return message;
    }
}

