/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.restful.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.configuration.entity.UserIpVo;
import org.apache.linkis.configuration.exception.ConfigurationException;
import org.apache.linkis.configuration.service.UserIpConfigService;
import org.apache.linkis.governance.common.constant.job.JobRequestConstants;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api
@RestController
@RequestMapping(path={"/configuration/user-ip-mapping"})
public class UserIpConfigrationRestfulApi {
    private static final Logger logger = LoggerFactory.getLogger(UserIpConfigrationRestfulApi.class);
    @Autowired
    private UserIpConfigService userIpConfigService;

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="HttpServletRequest", name="req", value=""), @ApiImplicitParam(paramType="body", dataType="UserIpVo", name="userIpVo", value="userIpVo")})
    @ApiOperation(value="create-user-ip", notes="create user ip", httpMethod="POST")
    @RequestMapping(path={"/create-user-ip"}, method={RequestMethod.POST})
    public Message createUserIp(HttpServletRequest req, @RequestBody UserIpVo userIpVo) {
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"execute createUserIP");
            if (!Configuration.isAdmin((String)userName)) {
                return Message.error((String)"Failed to create-user-ip,msg: only administrators can configure");
            }
            if (this.userIpConfigService.userExists(userIpVo.getUser(), userIpVo.getCreator())) {
                throw new ConfigurationException("User-creator is existed");
            }
            this.parameterVerification(userIpVo);
            this.userIpConfigService.createUserIP(userIpVo);
        }
        catch (DuplicateKeyException e) {
            return Message.error((String)"Failed to create-user-ip,msg:create user-creator is existed");
        }
        catch (ConfigurationException e) {
            return Message.error((String)("Failed to create-user-ip,msg:" + e.getMessage()));
        }
        return Message.ok();
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="HttpServletRequest", name="req", value=""), @ApiImplicitParam(paramType="body", dataType="UserIpVo", name="UserIpVo", value="UserIpVo")})
    @ApiOperation(value="update-user-ip", notes="update user ip", httpMethod="POST")
    @RequestMapping(path={"/update-user-ip"}, method={RequestMethod.POST})
    public Message updateUserIp(HttpServletRequest req, @RequestBody UserIpVo userIpVo) {
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"execute updateUserIP");
            if (!Configuration.isAdmin((String)userName)) {
                return Message.error((String)"Failed to update-user-ip,msg: only administrators can configure ");
            }
            this.parameterVerification(userIpVo);
            this.userIpConfigService.updateUserIP(userIpVo);
        }
        catch (ConfigurationException e) {
            return Message.error((String)("Failed to update-user-ip,msg:" + e.getMessage()));
        }
        return Message.ok();
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="HttpServletRequest", name="req", value=""), @ApiImplicitParam(paramType="query", dataType="int", name="id", value="id")})
    @ApiOperation(value="delete-user-ip", notes="delete user ip", httpMethod="GET")
    @RequestMapping(path={"/delete-user-ip"}, method={RequestMethod.GET})
    public Message deleteUserIp(HttpServletRequest req, @RequestParam(value="id") Integer id) {
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("execute deleteUserIp,id: " + id));
            if (!Configuration.isAdmin((String)userName)) {
                return Message.error((String)"Failed to delete-user-ip,msg: only administrators can configure");
            }
            this.userIpConfigService.deleteUserIP(id);
        }
        catch (ConfigurationException e) {
            return Message.error((String)("Failed to check-user-creator,msg:" + e.getMessage()));
        }
        return Message.ok();
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="HttpServletRequest", name="req", value=""), @ApiImplicitParam(paramType="query", dataType="string", name="user", value="user"), @ApiImplicitParam(paramType="query", dataType="string", name="creator", value="creator")})
    @ApiOperation(value="query-user-ip-list", notes="query user ip list", httpMethod="GET")
    @RequestMapping(path={"/query-user-ip-list"}, method={RequestMethod.GET})
    public Message queryUserIpList(HttpServletRequest req, @RequestParam(value="user", required=false) String user, @RequestParam(value="creator", required=false) String creator, @RequestParam(value="pageNow") Integer pageNow, @RequestParam(value="pageSize") Integer pageSize) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"queryUserIPList");
        if (!Configuration.isAdmin((String)userName)) {
            return Message.error((String)"Failed to query-user-ip-list,msg: only administrators can configure");
        }
        if (StringUtils.isBlank((String)user)) {
            user = null;
        }
        if (StringUtils.isBlank((String)creator)) {
            creator = null;
        }
        if (null == pageNow) {
            pageNow = 1;
        }
        if (null == pageSize) {
            pageSize = 20;
        }
        Map<String, Object> resultMap = this.userIpConfigService.queryUserIPList(user, creator, pageNow, pageSize);
        return Message.ok().data("userIpList", resultMap.get("userIpList")).data(JobRequestConstants.TOTAL_PAGE(), resultMap.get(JobRequestConstants.TOTAL_PAGE()));
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="HttpServletRequest", name="req", value=""), @ApiImplicitParam(paramType="query", dataType="string", name="user", value="user"), @ApiImplicitParam(paramType="query", dataType="string", name="creator", value="creator")})
    @ApiOperation(value="check-user-creator", notes=" check user creator", httpMethod="GET")
    @RequestMapping(path={"/check-user-creator"}, method={RequestMethod.GET})
    public Message checkUserCreator(HttpServletRequest req, @RequestParam(value="user") String user, @RequestParam(value="creator") String creator) {
        boolean result = false;
        try {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"checkUserCreator");
            if (!Configuration.isAdmin((String)userName)) {
                return Message.error((String)"Failed to check-user-creator,msg: only administrators can configure");
            }
            if (StringUtils.isBlank((String)creator)) {
                throw new ConfigurationException("Application Name couldn't be empty ");
            }
            if (StringUtils.isBlank((String)user)) {
                throw new ConfigurationException("User Name couldn't be empty ");
            }
            if (creator.equals("*")) {
                throw new ConfigurationException("Application Name couldn't be '*' ");
            }
            result = this.userIpConfigService.userExists(user, creator);
        }
        catch (ConfigurationException e) {
            return Message.error((String)("Failed to check-user-creator,msg:" + e.getMessage()));
        }
        return Message.ok().data("exist", (Object)result);
    }

    private void parameterVerification(UserIpVo userIpVo) throws ConfigurationException {
        if (StringUtils.isBlank((String)userIpVo.getCreator())) {
            throw new ConfigurationException("Application Name couldn't be empty ");
        }
        if (StringUtils.isBlank((String)userIpVo.getUser())) {
            throw new ConfigurationException("User Name couldn't be empty ");
        }
        if (StringUtils.isBlank((String)userIpVo.getBussinessUser())) {
            throw new ConfigurationException("Creat User couldn't be empty ");
        }
        if (StringUtils.isBlank((String)userIpVo.getIpList())) {
            throw new ConfigurationException("Ip List couldn't be empty ");
        }
        if (StringUtils.isBlank((String)userIpVo.getDesc())) {
            throw new ConfigurationException("Description couldn't be empty ");
        }
    }
}

