/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.configuration.dao.UserIpMapper;
import org.apache.linkis.configuration.entity.UserIpVo;
import org.apache.linkis.configuration.exception.ConfigurationException;
import org.apache.linkis.configuration.service.UserIpConfigService;
import org.apache.linkis.configuration.util.CommonUtils;
import org.apache.linkis.governance.common.constant.job.JobRequestConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserIpConfigServiceImpl
implements UserIpConfigService {
    private static final Logger logger = LoggerFactory.getLogger(UserIpConfigServiceImpl.class);
    @Autowired
    private UserIpMapper userIpMapper;

    @Override
    public void createUserIP(UserIpVo userIpVo) throws ConfigurationException {
        this.dataProcessing(userIpVo);
        UserIpVo userIpVoLowerCase = this.toLowerCase(userIpVo);
        userIpVoLowerCase.setCreateTime(new Date());
        userIpVoLowerCase.setUpdateTime(new Date());
        this.userIpMapper.createUserIP(userIpVoLowerCase);
    }

    @Override
    public void updateUserIP(UserIpVo userIpVo) throws ConfigurationException {
        if (StringUtils.isBlank((String)userIpVo.getId())) {
            throw new ConfigurationException("id couldn't be empty ");
        }
        this.dataProcessing(userIpVo);
        UserIpVo userIpVoLowerCase = this.toLowerCase(userIpVo);
        userIpVoLowerCase.setUpdateTime(new Date());
        logger.info("updateUserIP : {}", (Object)userIpVoLowerCase);
        this.userIpMapper.updateUserIP(userIpVoLowerCase);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void deleteUserIP(Integer id) throws ConfigurationException {
        logger.info("deleteUserIP : id:{}", (Object)id);
        if (StringUtils.isBlank((String)id.toString())) {
            throw new ConfigurationException("id couldn't be empty ");
        }
        this.userIpMapper.deleteUserIP(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> queryUserIPList(String user, String creator, Integer pageNow, Integer pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        List<UserIpVo> userIpVos = null;
        PageHelper.startPage((int)pageNow, (int)pageSize);
        try {
            userIpVos = this.userIpMapper.queryUserIPList(user, creator);
        }
        finally {
            PageHelper.clearPage();
        }
        PageInfo pageInfo = new PageInfo(userIpVos);
        result.put("userIpList", userIpVos);
        result.put(JobRequestConstants.TOTAL_PAGE(), pageInfo.getTotal());
        return result;
    }

    private void dataProcessing(UserIpVo userIpVo) throws ConfigurationException {
        String ipList = userIpVo.getIpList();
        if (!ipList.equals("*")) {
            String[] split = ipList.split(",");
            StringJoiner joiner = new StringJoiner(",");
            Arrays.stream(split).distinct().filter(ipStr -> !CommonUtils.ipCheck(ipStr)).forEach(joiner::add);
            if (StringUtils.isNotBlank((String)joiner.toString())) {
                throw new ConfigurationException(joiner + ",Illegal IP address ");
            }
        }
    }

    @Override
    public boolean userExists(String user, String creator) {
        Map<String, Object> resultMap = this.queryUserIPList(user.toLowerCase(), creator.toLowerCase(), 1, 20);
        Object userIpList = resultMap.getOrDefault(JobRequestConstants.TOTAL_PAGE(), 0);
        return Integer.parseInt(String.valueOf(userIpList)) > 0;
    }

    @Override
    public UserIpVo queryUserIP(String user, String creator) {
        return this.userIpMapper.queryUserIP(user, creator);
    }

    private UserIpVo toLowerCase(UserIpVo userIpVo) {
        userIpVo.setCreator(userIpVo.getCreator().toLowerCase());
        userIpVo.setUser(userIpVo.getUser().toLowerCase());
        return userIpVo;
    }
}

