/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.httpclient.dws.discovery;

import org.apache.http.HttpResponse;
import org.apache.linkis.httpclient.discovery.AbstractDiscovery;
import org.apache.linkis.httpclient.discovery.HeartbeatAction;
import org.apache.linkis.httpclient.discovery.HeartbeatResult;
import org.apache.linkis.httpclient.dws.request.DWSHeartbeatAction;
import org.apache.linkis.httpclient.dws.response.DWSHeartbeatResult;
import org.apache.linkis.httpclient.request.Action;
import org.apache.linkis.httpclient.response.Result;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u00153A!\u0002\u0004\u0001'!)\u0011\u0004\u0001C\u00015!)q\u0001\u0001C);!)q\u0006\u0001C)a!)a\u0007\u0001C!o\t\u0019BiV*HCR,w/Y=ESN\u001cwN^3ss*\u0011q\u0001C\u0001\nI&\u001c8m\u001c<fefT!!\u0003\u0006\u0002\u0007\u0011<8O\u0003\u0002\f\u0019\u0005Q\u0001\u000e\u001e;qG2LWM\u001c;\u000b\u00055q\u0011A\u00027j].L7O\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!F\f\u000e\u0003YQ!a\u0002\u0006\n\u0005a1\"!E!cgR\u0014\u0018m\u0019;ESN\u001cwN^3ss\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0002\u000b\u0002=A\u0019qD\t\u0013\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012Q!\u0011:sCf\u0004\"!\n\u0017\u000f\u0005\u0019R\u0003CA\u0014!\u001b\u0005A#BA\u0015\u0013\u0003\u0019a$o\\8u}%\u00111\u0006I\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,A\u0005\u0011r-\u001a;IK\u0006\u0014HOY3bi\u0006\u001bG/[8o)\t\tD\u0007\u0005\u0002\u0016e%\u00111G\u0006\u0002\u0010\u0011\u0016\f'\u000f\u001e2fCR\f5\r^5p]\")Qg\u0001a\u0001I\u0005I1/\u001a:wKJ,&\u000f\\\u0001\u0013O\u0016$\b*Z1si\n,\u0017\r\u001e*fgVdG\u000fF\u00029w\r\u0003\"!F\u001d\n\u0005i2\"a\u0004%fCJ$(-Z1u%\u0016\u001cX\u000f\u001c;\t\u000bq\"\u0001\u0019A\u001f\u0002\u0011I,7\u000f]8og\u0016\u0004\"AP!\u000e\u0003}R!\u0001\u0011\b\u0002\t!$H\u000f]\u0005\u0003\u0005~\u0012A\u0002\u0013;uaJ+7\u000f]8og\u0016DQ\u0001\u0012\u0003A\u0002E\nQB]3rk\u0016\u001cH/Q2uS>t\u0007")
public class DWSGatewayDiscovery
extends AbstractDiscovery {
    public String[] discovery() {
        String serverUrl = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getServerInstances())).isEmpty() ? this.getServerUrl() : (String)((IterableLike)Random$.MODULE$.shuffle((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getServerInstances())).toList(), List$.MODULE$.canBuildFrom())).head();
        this.logger().info(new StringBuilder(21).append("discovery to gateway ").append(serverUrl).toString());
        Result result = this.getClient().execute((Action)this.getHeartbeatAction(serverUrl));
        if (result instanceof DWSHeartbeatResult) {
            DWSHeartbeatResult dWSHeartbeatResult = (DWSHeartbeatResult)result;
            return dWSHeartbeatResult.getGatewayList();
        }
        throw new MatchError((Object)result);
    }

    public HeartbeatAction getHeartbeatAction(String serverUrl) {
        return new DWSHeartbeatAction(serverUrl);
    }

    public HeartbeatResult getHeartbeatResult(HttpResponse response, HeartbeatAction requestAction) {
        HeartbeatAction heartbeatAction = requestAction;
        if (heartbeatAction instanceof DWSHeartbeatAction) {
            DWSHeartbeatAction dWSHeartbeatAction = (DWSHeartbeatAction)heartbeatAction;
            return new DWSHeartbeatResult(response, dWSHeartbeatAction.serverUrl());
        }
        throw new MatchError((Object)heartbeatAction);
    }
}

