/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.ecm.server.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.bml.client.BmlClient;
import org.apache.linkis.bml.client.BmlClientFactory;
import org.apache.linkis.bml.protocol.BmlDownloadResponse;
import org.apache.linkis.common.utils.HardwareUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.ecm.errorcode.EngineconnServerErrorCodeSummary;
import org.apache.linkis.ecm.server.conf.ECMConfiguration$;
import org.apache.linkis.ecm.server.exception.ECMErrorException;
import org.apache.linkis.manager.common.entity.resource.LoadInstanceResource;
import org.apache.linkis.manager.common.protocol.bml.BmlResource;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.storage.fs.FileSystem;
import org.slf4j.Logger;
import scala.Function0;
import scala.math.package$;

public final class ECMUtils$
implements Logging {
    public static ECMUtils$ MODULE$;
    private volatile BmlClient bmlClient;
    private final Object lock;
    private final String address;
    private final LoadInstanceResource initMaxResource;
    private final LoadInstanceResource initMinResource;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ECMUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ECMUtils$ eCMUtils$ = this;
        synchronized (eCMUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public BmlClient bmlClient() {
        return this.bmlClient;
    }

    public void bmlClient_$eq(BmlClient x$1) {
        this.bmlClient = x$1;
    }

    public Object lock() {
        return this.lock;
    }

    private Map<String, Object> download(BmlResource resource, String userName) {
        BmlClient client = this.getBMLClient(userName);
        BmlDownloadResponse response = null;
        response = resource.getVersion() == null ? client.downloadShareResource(userName, resource.getResourceId()) : client.downloadShareResource(userName, resource.getResourceId(), resource.getVersion());
        if (!response.isSuccess()) {
            throw new ECMErrorException(EngineconnServerErrorCodeSummary.FAILED_TO_DOWNLOAD.getErrorCode(), EngineconnServerErrorCodeSummary.FAILED_TO_DOWNLOAD.getErrorDesc());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("path", response.fullFilePath());
        map.put("is", response.inputStream());
        return map;
    }

    public void downLoadBmlResourceToLocal(BmlResource resource, String userName, String path, FileSystem fs) {
        InputStream is = (InputStream)this.download(resource, userName).get("is");
        FileOutputStream os = FileUtils.openOutputStream((File)new File(new StringBuilder(0).append(path).append(File.separator).append(resource.getFileName()).toString()));
        IOUtils.copy((InputStream)is, (OutputStream)os);
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((InputStream)is);
    }

    private BmlClient getBMLClient(String userName) {
        if (this.bmlClient() == null) {
            Object object = this.lock();
            synchronized (object) {
                if (this.bmlClient() == null) {
                    this.bmlClient_$eq(BmlClientFactory.createBmlClient((String)userName));
                }
            }
        }
        return this.bmlClient();
    }

    private String address() {
        return this.address;
    }

    public LoadInstanceResource initMaxResource() {
        return this.initMaxResource;
    }

    public LoadInstanceResource initMinResource() {
        return this.initMinResource;
    }

    public String getInstanceByPort(String port) {
        return new StringBuilder(1).append(this.address()).append(":").append(port).toString();
    }

    public long inferDefaultMemory() {
        if (ECMConfiguration$.MODULE$.ECM_STIMATE_ACTUAL_MEMORY_ENABLE()) {
            long totalByte = HardwareUtils$.MODULE$.getMaxMemory();
            long resultMemory = package$.MODULE$.max(totalByte, ECMConfiguration$.MODULE$.ECM_PROTECTED_MEMORY());
            this.logger().info(new StringBuilder(90).append("Ecm protected memory:").append(ECMConfiguration$.MODULE$.ECM_PROTECTED_MEMORY()).append(" byte, ecm machine physical max memory:").append(totalByte).append(" byte, will use the lager one:").append(resultMemory).toString());
            return resultMemory;
        }
        return ECMConfiguration$.MODULE$.ECM_MAX_MEMORY_AVAILABLE();
    }

    private ECMUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.lock = new Object();
        this.address = Sender$.MODULE$.getThisInstance().substring(0, Sender$.MODULE$.getThisInstance().lastIndexOf(":"));
        this.initMaxResource = new LoadInstanceResource(this.inferDefaultMemory(), ECMConfiguration$.MODULE$.ECM_MAX_CORES_AVAILABLE(), ECMConfiguration$.MODULE$.ECM_MAX_CREATE_INSTANCES());
        this.initMinResource = new LoadInstanceResource(ECMConfiguration$.MODULE$.ECM_PROTECTED_MEMORY(), ECMConfiguration$.MODULE$.ECM_PROTECTED_CORES(), ECMConfiguration$.MODULE$.ECM_PROTECTED_INSTANCES());
    }
}

