/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.vendor;

import com.alibaba.druid.pool.ValidConnectionChecker;
import com.alibaba.druid.pool.ValidConnectionCheckerAdapter;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.StringUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Properties;

public class MySqlValidConnectionChecker
extends ValidConnectionCheckerAdapter
implements ValidConnectionChecker,
Serializable {
    public static final int DEFAULT_VALIDATION_QUERY_TIMEOUT = 1;
    public static final String DEFAULT_VALIDATION_QUERY = "/* ping */ SELECT 1";
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(MySqlValidConnectionChecker.class);
    private boolean usePingMethod = true;

    public MySqlValidConnectionChecker() {
        this.configFromProperties(System.getProperties());
    }

    @Override
    public void configFromProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        String property = properties.getProperty("druid.mysql.usePingMethod");
        if ("true".equals(property)) {
            this.setUsePingMethod(true);
        } else if ("false".equals(property)) {
            this.setUsePingMethod(false);
        }
    }

    public boolean isUsePingMethod() {
        return this.usePingMethod;
    }

    public void setUsePingMethod(boolean usePingMethod) {
        this.usePingMethod = usePingMethod;
    }

    @Override
    public boolean isValidConnection(Connection conn, String validateQuery, int validationQueryTimeout) throws Exception {
        if (conn.isClosed()) {
            return false;
        }
        if (this.usePingMethod || StringUtils.isEmpty(validateQuery)) {
            validateQuery = DEFAULT_VALIDATION_QUERY;
        }
        return ValidConnectionCheckerAdapter.execValidQuery(conn, validateQuery, validationQueryTimeout);
    }
}

