/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.util;

import com.github.pagehelper.BoundSqlInterceptor;
import com.github.pagehelper.Dialect;
import com.github.pagehelper.PageException;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public abstract class ExecutorUtil {
    private static Field additionalParametersField;
    private static Field providerMethodArgumentNamesField;

    public static Map<String, Object> getAdditionalParameter(BoundSql boundSql) {
        try {
            return (Map)additionalParametersField.get(boundSql);
        }
        catch (IllegalAccessException e) {
            throw new PageException("\u83b7\u53d6 BoundSql \u5c5e\u6027\u503c additionalParameters \u5931\u8d25: " + e, e);
        }
    }

    public static String[] getProviderMethodArgumentNames(ProviderSqlSource providerSqlSource) {
        try {
            return providerMethodArgumentNamesField != null ? (String[])providerMethodArgumentNamesField.get(providerSqlSource) : null;
        }
        catch (IllegalAccessException e) {
            throw new PageException("\u83b7\u53d6 ProviderSqlSource \u5c5e\u6027\u503c providerMethodArgumentNames: " + e, e);
        }
    }

    public static MappedStatement getExistedMappedStatement(Configuration configuration, String msId) {
        MappedStatement mappedStatement = null;
        try {
            mappedStatement = configuration.getMappedStatement(msId, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mappedStatement;
    }

    public static Long executeManualCount(Executor executor, MappedStatement countMs, Object parameter, BoundSql boundSql, ResultHandler resultHandler) throws SQLException {
        BoundSql countBoundSql;
        CacheKey countKey = executor.createCacheKey(countMs, parameter, RowBounds.DEFAULT, boundSql);
        List countResultList = executor.query(countMs, parameter, RowBounds.DEFAULT, resultHandler, countKey, countBoundSql = countMs.getBoundSql(parameter));
        if (countResultList == null || countResultList.isEmpty()) {
            return 0L;
        }
        return ((Number)countResultList.get(0)).longValue();
    }

    public static Long executeAutoCount(Dialect dialect, Executor executor, MappedStatement countMs, Object parameter, BoundSql boundSql, RowBounds rowBounds, ResultHandler resultHandler) throws SQLException {
        List countResultList;
        Map<String, Object> additionalParameters = ExecutorUtil.getAdditionalParameter(boundSql);
        CacheKey countKey = executor.createCacheKey(countMs, parameter, RowBounds.DEFAULT, boundSql);
        String countSql = dialect.getCountSql(countMs, boundSql, parameter, rowBounds, countKey);
        BoundSql countBoundSql = new BoundSql(countMs.getConfiguration(), countSql, boundSql.getParameterMappings(), parameter);
        for (String key : additionalParameters.keySet()) {
            countBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
        }
        if (dialect instanceof BoundSqlInterceptor.Chain) {
            countBoundSql = ((BoundSqlInterceptor.Chain)((Object)dialect)).doBoundSql(BoundSqlInterceptor.Type.COUNT_SQL, countBoundSql, countKey);
        }
        if ((countResultList = executor.query(countMs, parameter, RowBounds.DEFAULT, resultHandler, countKey, countBoundSql)) == null || countResultList.isEmpty()) {
            return 0L;
        }
        return ((Number)countResultList.get(0)).longValue();
    }

    public static <E> List<E> pageQuery(Dialect dialect, Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql, CacheKey cacheKey) throws SQLException {
        if (dialect.beforePage(ms, parameter, rowBounds)) {
            CacheKey pageKey = cacheKey;
            parameter = dialect.processParameterObject(ms, parameter, boundSql, pageKey);
            String pageSql = dialect.getPageSql(ms, boundSql, parameter, rowBounds, pageKey);
            BoundSql pageBoundSql = new BoundSql(ms.getConfiguration(), pageSql, boundSql.getParameterMappings(), parameter);
            Map<String, Object> additionalParameters = ExecutorUtil.getAdditionalParameter(boundSql);
            for (String key : additionalParameters.keySet()) {
                pageBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
            }
            if (dialect instanceof BoundSqlInterceptor.Chain) {
                pageBoundSql = ((BoundSqlInterceptor.Chain)((Object)dialect)).doBoundSql(BoundSqlInterceptor.Type.PAGE_SQL, pageBoundSql, pageKey);
            }
            return executor.query(ms, parameter, RowBounds.DEFAULT, resultHandler, pageKey, pageBoundSql);
        }
        return executor.query(ms, parameter, RowBounds.DEFAULT, resultHandler, cacheKey, boundSql);
    }

    static {
        try {
            additionalParametersField = BoundSql.class.getDeclaredField("additionalParameters");
            additionalParametersField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new PageException("\u83b7\u53d6 BoundSql \u5c5e\u6027 additionalParameters \u5931\u8d25: " + e, e);
        }
        try {
            providerMethodArgumentNamesField = ProviderSqlSource.class.getDeclaredField("providerMethodArgumentNames");
            providerMethodArgumentNamesField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }
}

