/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.jobhistory.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.governance.common.entity.job.SubJobDetail;
import org.apache.linkis.jobhistory.entity.JobHistory;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.FileSystemUtils$;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;

public final class QueryUtils$
implements Logging {
    public static QueryUtils$ MODULE$;
    private final CommonVars<String> CODE_STORE_PREFIX;
    private final CommonVars<String> CODE_STORE_PREFIX_VIEW_FS;
    private final CommonVars<String> CODE_STORE_SUFFIX;
    private final CommonVars<Object> CODE_STORE_LENGTH;
    private final String CHARSET;
    private final String CODE_SPLIT;
    private final String LENGTH_SPLIT;
    private final String NAME_REGEX;
    private final String INSTANCE_NAME_REGEX;
    private final Pattern nameRegexPattern;
    private final Pattern instanceNameRegexPattern;
    private final ThreadLocal<SimpleDateFormat> dateFormatLocal;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new QueryUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        QueryUtils$ queryUtils$ = this;
        synchronized (queryUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private CommonVars<String> CODE_STORE_PREFIX() {
        return this.CODE_STORE_PREFIX;
    }

    private CommonVars<String> CODE_STORE_PREFIX_VIEW_FS() {
        return this.CODE_STORE_PREFIX_VIEW_FS;
    }

    private CommonVars<String> CODE_STORE_SUFFIX() {
        return this.CODE_STORE_SUFFIX;
    }

    private CommonVars<Object> CODE_STORE_LENGTH() {
        return this.CODE_STORE_LENGTH;
    }

    private String CHARSET() {
        return this.CHARSET;
    }

    private String CODE_SPLIT() {
        return this.CODE_SPLIT;
    }

    private String LENGTH_SPLIT() {
        return this.LENGTH_SPLIT;
    }

    private String NAME_REGEX() {
        return this.NAME_REGEX;
    }

    private String INSTANCE_NAME_REGEX() {
        return this.INSTANCE_NAME_REGEX;
    }

    private Pattern nameRegexPattern() {
        return this.nameRegexPattern;
    }

    private Pattern instanceNameRegexPattern() {
        return this.instanceNameRegexPattern;
    }

    private ThreadLocal<SimpleDateFormat> dateFormatLocal() {
        return this.dateFormatLocal;
    }

    public void storeExecutionCode(JobRequest jobRequest) {
        this.storeExecutionCode(jobRequest.getExecuteUser(), jobRequest.getExecutionCode(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            jobRequest.setExecutionCode(path);
            return BoxedUnit.UNIT;
        });
    }

    public void storeExecutionCode(SubJobDetail subJobDetail, String user) {
        this.storeExecutionCode(user, subJobDetail.getExecutionContent(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            subJobDetail.setExecutionContent(path);
            return BoxedUnit.UNIT;
        });
    }

    public void storeExecutionCode(String user, String code, Function1<String, BoxedUnit> pathCallback) {
        if (code == null || code.getBytes().length < BoxesRunTime.unboxToInt((Object)this.CODE_STORE_LENGTH().getValue())) {
            return;
        }
        String path = this.getCodeStorePath(user);
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = (FileSystem)FSFactory$.MODULE$.getFsByProxyUser(fsPath, user);
        fileSystem.init(null);
        ObjectRef os = ObjectRef.create(null);
        LongRef position = LongRef.create((long)0L);
        byte[] codeBytes = code.getBytes(this.CHARSET());
        String string = path.intern();
        synchronized (string) {
            Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (!fileSystem.exists(fsPath)) {
                    FileSystemUtils$.MODULE$.createNewFile(fsPath, user, true);
                }
                os$1.elem = fileSystem.write(fsPath, false);
                position$1.elem = fileSystem.get(path).getLength();
                IOUtils.write((byte[])codeBytes, (OutputStream)((OutputStream)os$1.elem));
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                IOUtils.closeQuietly((OutputStream)((OutputStream)os$1.elem));
                if (fileSystem != null) {
                    fileSystem.close();
                    return;
                }
            });
        }
        int length = codeBytes.length;
        pathCallback.apply((Object)new StringBuilder(0).append(path).append(this.CODE_SPLIT()).append(position.elem).append(this.LENGTH_SPLIT()).append(length).toString());
    }

    public void exchangeExecutionCode(JobHistory queryTask) {
        Object object;
        if (queryTask.getExecutionCode() == null || !queryTask.getExecutionCode().startsWith(StorageUtils$.MODULE$.HDFS_SCHEMA())) {
            return;
        }
        String codePath = queryTask.getExecutionCode();
        scala.collection.mutable.StringBuilder executionCode = new scala.collection.mutable.StringBuilder();
        if (codePath.split(this.CODE_SPLIT()).length >= 2) {
            String path = codePath.substring(0, codePath.lastIndexOf(this.CODE_SPLIT()));
            String codeInfo = codePath.substring(codePath.lastIndexOf(this.CODE_SPLIT()) + 1);
            String[] infos = codeInfo.split(this.LENGTH_SPLIT());
            int position = new StringOps(Predef$.MODULE$.augmentString(infos[0])).toInt();
            IntRef lengthLeft = IntRef.create((int)new StringOps(Predef$.MODULE$.augmentString(infos[1])).toInt());
            char[] tub = new char[1024];
            FsPath fsPath = new FsPath(path);
            FileSystem fileSystem = (FileSystem)FSFactory$.MODULE$.getFsByProxyUser(fsPath, queryTask.getExecuteUser());
            fileSystem.init(null);
            ObjectRef is = ObjectRef.create(null);
            ObjectRef bufferedReader = ObjectRef.create(null);
            if (!fileSystem.exists(fsPath)) {
                return;
            }
            object = Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                is$1.elem = fileSystem.read(fsPath);
                bufferedReader$1.elem = new BufferedReader(new InputStreamReader((InputStream)is$1.elem, MODULE$.CHARSET()));
                Object object = position > 0 ? BoxesRunTime.boxToLong((long)((BufferedReader)bufferedReader$1.elem).skip(position)) : BoxedUnit.UNIT;
                Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    while (lengthLeft$1.elem > 0) {
                        int readed = ((BufferedReader)bufferedReader$1.elem).read(tub);
                        int useful = Math.min(readed, lengthLeft$1.elem);
                        if (useful < 0) {
                            throw Breaks$.MODULE$.break();
                        }
                        lengthLeft$1.elem -= useful;
                        char[] usefulChars = new char[useful];
                        System.arraycopy(tub, 0, usefulChars, 0, useful);
                        executionCode.append(new String(usefulChars));
                    }
                });
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                IOUtils.closeQuietly((Reader)((BufferedReader)bufferedReader$1.elem));
                if (fileSystem != null) {
                    Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fileSystem.close(), MODULE$.logger());
                    return;
                }
            });
        } else {
            this.logger().error(new StringBuilder(59).append("Can't read executionCode from HDFS, jobId:").append(queryTask.getId()).append(",error codePath:").append(codePath).append(" ").toString());
            object = BoxedUnit.UNIT;
        }
        queryTask.setExecutionCode(executionCode.toString());
    }

    private String getCodeStorePath(String user) {
        String date = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        String suffix = new StringBuilder(8).append(DateFormatUtils.format((long)System.currentTimeMillis(), (String)"HH_mm_ss_SSS")).append("_scripts").toString();
        if (BoxesRunTime.unboxToBoolean((Object)Configuration$.MODULE$.IS_VIEW_FS_ENV().getValue())) {
            return new StringBuilder(16).append(this.CODE_STORE_PREFIX_VIEW_FS().getValue()).append(user).append(this.CODE_STORE_SUFFIX().getValue()).append("/executionCode/").append(date).append("/").append(suffix).toString();
        }
        return new StringBuilder(16).append(this.CODE_STORE_PREFIX().getValue()).append(user).append(this.CODE_STORE_SUFFIX().getValue()).append("/executionCode/").append(date).append("/").append(suffix).toString();
    }

    public String dateToString(Date date) {
        return ((DateFormat)this.dateFormatLocal().get()).format(date);
    }

    public boolean checkNameValid(String param) {
        return this.nameRegexPattern().matcher(param).find();
    }

    public boolean checkInstanceNameValid(String param) {
        return this.instanceNameRegexPattern().matcher(param).find();
    }

    private QueryUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.CODE_STORE_PREFIX = CommonVars$.MODULE$.apply("wds.linkis.query.store.prefix", (Object)"hdfs:///apps-data/bdp-ide/");
        this.CODE_STORE_PREFIX_VIEW_FS = CommonVars$.MODULE$.apply("wds.linkis.query.store.prefix.viewfs", (Object)"hdfs:///apps-data/");
        this.CODE_STORE_SUFFIX = CommonVars$.MODULE$.apply("wds.linkis.query.store.suffix", (Object)"");
        this.CODE_STORE_LENGTH = CommonVars$.MODULE$.apply("wds.linkis.query.code.store.length", (Object)BoxesRunTime.boxToInteger((int)50000));
        this.CHARSET = "utf-8";
        this.CODE_SPLIT = ";";
        this.LENGTH_SPLIT = "#";
        this.NAME_REGEX = "^[a-zA-Z\\-\\d_\\.]+$";
        this.INSTANCE_NAME_REGEX = "^[a-zA-Z\\-\\d_\\.:]+$";
        this.nameRegexPattern = Pattern.compile(this.NAME_REGEX());
        this.instanceNameRegexPattern = Pattern.compile(this.INSTANCE_NAME_REGEX());
        this.dateFormatLocal = new ThreadLocal<SimpleDateFormat>(){

            public SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            }
        };
    }
}

