/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.FileService;
import org.apache.linkis.common.utils.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class ZipUtils$ {
    public static ZipUtils$ MODULE$;
    private final int BUFFER_SIZE;

    static {
        new ZipUtils$();
    }

    private int BUFFER_SIZE() {
        return this.BUFFER_SIZE;
    }

    public void zip(String sourceFilePath, String zipFilePath, String fileName, Fs fs) {
        ObjectRef bis = ObjectRef.create(null);
        ObjectRef zos = ObjectRef.create(null);
        FsPath sourcePath = new FsPath(sourceFilePath);
        if (!fs.exists(sourcePath)) {
            throw new IOException(new StringBuilder(62).append("File directory to be compressed\uff08\u5f85\u538b\u7f29\u7684\u6587\u4ef6\u76ee\u5f55\uff09\uff1a").append(sourceFilePath).append("does not exist\uff08\u4e0d\u5b58\u5728\uff09.").toString());
        }
        FsPath zipFile = FsPath.getFsPath(zipFilePath, fileName);
        if (fs.exists(zipFile)) {
            throw new IOException(new StringBuilder(65).append(zipFilePath).append("The name exists under the directory\uff08\u76ee\u5f55\u4e0b\u5b58\u5728\u540d\u5b57\u4e3a\uff09:").append(fileName).append("Package file\uff08\u6253\u5305\u6587\u4ef6\uff09.").toString());
        }
        List<FsPath> sourceFiles = fs.list(sourcePath);
        if (sourceFiles == null || sourceFiles.size() < 1) {
            throw new IOException(new StringBuilder(103).append("File directory to be compressed\uff08\u5f85\u538b\u7f29\u7684\u6587\u4ef6\u76ee\u5f55\uff09\uff1a").append(sourceFilePath).append("There are no files in it, no need to compress.(\u91cc\u9762\u4e0d\u5b58\u5728\u6587\u4ef6\uff0c\u65e0\u9700\u538b\u7f29.)").toString());
        }
        Utils$.MODULE$.tryFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            OutputStream fos = fs.write(zipFile, true);
            zos$1.elem = new ZipOutputStream(new BufferedOutputStream(fos));
            byte[] bufs = new byte[MODULE$.BUFFER_SIZE()];
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sourceFiles).asScala()).foreach((Function1 & Serializable & scala.Serializable)f -> {
                ZipUtils$.$anonfun$zip$2(zos, bis, bufs, f);
                return BoxedUnit.UNIT;
            });
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((OutputStream)((ZipOutputStream)zos$1.elem)));
    }

    public void zipDir(String sourceFilePath, String zipFilePath, String fileName, FileService fileService, String user) {
        ObjectRef bis = ObjectRef.create(null);
        ObjectRef zos = ObjectRef.create(null);
        if (!fileService.exists(sourceFilePath, user)) {
            throw new IOException(new StringBuilder(62).append("File directory to be compressed\uff08\u5f85\u538b\u7f29\u7684\u6587\u4ef6\u76ee\u5f55\uff09\uff1a").append(sourceFilePath).append("does not exist\uff08\u4e0d\u5b58\u5728\uff09.").toString());
        }
        File zipFile = new File(zipFilePath, fileName);
        if (fileService.exists(zipFile.getAbsolutePath(), user)) {
            throw new IOException(new StringBuilder(65).append(zipFilePath).append("The name exists under the directory\uff08\u76ee\u5f55\u4e0b\u5b58\u5728\u540d\u5b57\u4e3a\uff09:").append(fileName).append("Package file\uff08\u6253\u5305\u6587\u4ef6\uff09.").toString());
        }
        fileService.createFile(zipFile.getAbsolutePath(), user, true);
        String[] sourceFiles = fileService.listFileNames(sourceFilePath, user);
        if (sourceFiles == null || sourceFiles.length < 1) {
            throw new IOException(new StringBuilder(102).append("File directory to be compressed(\u5f85\u538b\u7f29\u7684\u6587\u4ef6\u76ee\u5f55)\uff1a").append(sourceFilePath).append("There are no files in it, no need to compress(\u91cc\u9762\u4e0d\u5b58\u5728\u6587\u4ef6\uff0c\u65e0\u9700\u538b\u7f29).").toString());
        }
        Utils$.MODULE$.tryFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            OutputStream fos = fileService.append(zipFile.getAbsolutePath(), user, true);
            zos$2.elem = new ZipOutputStream(new BufferedOutputStream(fos));
            byte[] bufs = new byte[MODULE$.BUFFER_SIZE()];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceFiles)).foreach((Function1 & Serializable & scala.Serializable)f -> {
                ZipUtils$.$anonfun$zipDir$2(zos, fileService, sourceFilePath, user, bis, bufs, f);
                return BoxedUnit.UNIT;
            });
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((OutputStream)((ZipOutputStream)zos$2.elem)));
    }

    public void fileToZip(String sourceFilePath, String zipFilePath, String fileName) {
        File sourceFile = new File(sourceFilePath);
        Object bis = null;
        ObjectRef zos = ObjectRef.create(null);
        if (!sourceFile.exists()) {
            throw new IOException(new StringBuilder(62).append("File directory to be compressed(\u5f85\u538b\u7f29\u7684\u6587\u4ef6\u76ee\u5f55)\uff1a").append(sourceFilePath).append("does not exist(\u4e0d\u5b58\u5728).").toString());
        }
        File zipFile = new File(new StringBuilder(1).append(zipFilePath).append("/").append(fileName).toString());
        if (zipFile.exists()) {
            throw new IOException(new StringBuilder(65).append(zipFilePath).append("The name exists under the directory(\u76ee\u5f55\u4e0b\u5b58\u5728\u540d\u5b57\u4e3a):").append(fileName).append("Package file(\u6253\u5305\u6587\u4ef6).").toString());
        }
        File[] sourceFiles = sourceFile.listFiles();
        if (sourceFiles == null || sourceFiles.length < 1) {
            throw new IOException(new StringBuilder(102).append("File directory to be compressed(\u5f85\u538b\u7f29\u7684\u6587\u4ef6\u76ee\u5f55)\uff1a").append(sourceFilePath).append("There are no files in it, no need to compress(\u91cc\u9762\u4e0d\u5b58\u5728\u6587\u4ef6\uff0c\u65e0\u9700\u538b\u7f29).").toString());
        }
        Utils$.MODULE$.tryFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FileOutputStream fos = new FileOutputStream(zipFile);
            zos$3.elem = new ZipOutputStream(new BufferedOutputStream(fos));
            MODULE$.write(sourceFilePath.substring(sourceFilePath.lastIndexOf(File.separator) + 1), sourceFile, "", (ZipOutputStream)zos$3.elem);
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((OutputStream)((ZipOutputStream)zos$3.elem)));
    }

    private void write(String rootPath, File file, String parentPath, ZipOutputStream zos) {
        if (file.isDirectory()) {
            String _parentPath = new StringBuilder(0).append(parentPath).append(file.getName()).append(File.separator).toString();
            File[] files = file.listFiles();
            if (files.length != 0) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).foreach((Function1 & Serializable & scala.Serializable)f -> {
                    ZipUtils$.MODULE$.write(rootPath, f, _parentPath, zos);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            try {
                zos.putNextEntry(new ZipEntry(_parentPath));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        zos.putNextEntry(new ZipEntry(new StringBuilder(0).append(parentPath.substring(rootPath.length() + 1)).append(file.getName()).toString()));
        FileInputStream fis = new FileInputStream(file);
        byte[] bufs = new byte[this.BUFFER_SIZE()];
        BufferedInputStream bis = new BufferedInputStream(fis, 10240);
        Utils$.MODULE$.tryFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int read = bis.read(bufs, 0, 1024);
            while (read > 0) {
                zos.write(bufs, 0, read);
                read = bis.read(bufs, 0, 1024);
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((InputStream)bis));
    }

    public void unzipDir(String zipFilePath, String unzipDir, FileService fileService, String user) {
        ZipInputStream zipIn = new ZipInputStream(fileService.open(zipFilePath, user));
        Utils$.MODULE$.tryFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FsPath destDir = new FsPath(unzipDir);
            if (!fileService.exists(unzipDir, user)) {
                fileService.mkdirs(unzipDir, user, true);
            }
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                String entryName = entry.getName();
                if (entryName.contains(new StringBuilder(2).append("..").append(File.separator).toString())) {
                    throw new IOException(new StringBuilder(39).append("Zip entry contains illegal characters: ").append(entryName).toString());
                }
                String filePath = new StringBuilder(0).append(destDir.getPath()).append(File.separator).append(entryName).toString();
                if (!entry.isDirectory()) {
                    MODULE$.extractPath(zipIn, filePath, fileService, user);
                } else {
                    fileService.mkdirs(filePath, user, true);
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((InputStream)zipIn));
    }

    private void extractPath(ZipInputStream zipIn, String destFilePath, FileService fileService, String user) {
        File destFile = new File(destFilePath);
        if (!fileService.exists(destFile.getParent(), user)) {
            fileService.mkdirs(destFile.getParent(), user, true);
        }
        BufferedOutputStream bos = new BufferedOutputStream(fileService.append(destFilePath, user, true));
        Utils$.MODULE$.tryFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            byte[] bytesIn = new byte[MODULE$.BUFFER_SIZE()];
            int read = zipIn.read(bytesIn);
            while (read != -1) {
                bos.write(bytesIn, 0, read);
                read = zipIn.read(bytesIn);
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((OutputStream)bos));
    }

    public void unzip(String zipFilePath, String unzipDir, Fs fs) {
        ZipInputStream zipIn = new ZipInputStream(fs.read(new FsPath(zipFilePath)));
        Utils$.MODULE$.tryFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FsPath destDir = new FsPath(unzipDir);
            Object object = !fs.exists(destDir) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdir(new FsPath(unzipDir))) : BoxedUnit.UNIT;
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                Object object2;
                String entryName = entry.getName();
                if (entryName.contains(new StringBuilder(2).append("..").append(File.separator).toString())) {
                    throw new IOException(new StringBuilder(39).append("Zip entry contains illegal characters: ").append(entryName).toString());
                }
                String filePath = new StringBuilder(0).append(destDir.getPath()).append(File.separator).append(entryName).toString();
                if (!entry.isDirectory()) {
                    MODULE$.extractFsPath(zipIn, filePath, fs);
                    object2 = BoxedUnit.UNIT;
                } else {
                    object2 = BoxesRunTime.boxToBoolean((boolean)fs.mkdir(new FsPath(filePath)));
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((InputStream)zipIn));
    }

    private void extractFsPath(ZipInputStream zipIn, String destFilePath, Fs fs) {
        FsPath destFile = new FsPath(destFilePath);
        Object object = !fs.exists(destFile.getParent()) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdir(destFile.getParent())) : BoxedUnit.UNIT;
        BufferedOutputStream bos = new BufferedOutputStream(fs.write(destFile, true));
        Utils$.MODULE$.tryFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            byte[] bytesIn = new byte[MODULE$.BUFFER_SIZE()];
            int read = zipIn.read(bytesIn);
            while (read != -1) {
                bos.write(bytesIn, 0, read);
                read = zipIn.read(bytesIn);
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((OutputStream)bos));
    }

    public void fileToUnzip(String zipFilePath, String unzipDir) {
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        Utils$.MODULE$.tryFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File destDir = new File(unzipDir);
            Object object = !destDir.exists() ? BoxesRunTime.boxToBoolean((boolean)destDir.mkdir()) : BoxedUnit.UNIT;
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                Object object2;
                String entryName = entry.getName();
                if (entryName.contains(new StringBuilder(2).append("..").append(File.separator).toString())) {
                    throw new IOException(new StringBuilder(39).append("Zip entry contains illegal characters: ").append(entryName).toString());
                }
                String filePath = new StringBuilder(0).append(destDir.getPath()).append(File.separator).append(entryName).toString();
                if (!entry.isDirectory()) {
                    MODULE$.extractFile(zipIn, filePath);
                    object2 = BoxedUnit.UNIT;
                } else {
                    File dir = new File(filePath);
                    object2 = BoxesRunTime.boxToBoolean((boolean)dir.mkdir());
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((InputStream)zipIn));
    }

    private void extractFile(ZipInputStream zipIn, String destFilePath) {
        File destFile = new File(destFilePath);
        Object object = !destFile.exists() ? BoxesRunTime.boxToBoolean((boolean)destFile.getParentFile().mkdirs()) : BoxedUnit.UNIT;
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));
        Utils$.MODULE$.tryFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            byte[] bytesIn = new byte[MODULE$.BUFFER_SIZE()];
            int read = zipIn.read(bytesIn);
            while (read != -1) {
                bos.write(bytesIn, 0, read);
                read = zipIn.read(bytesIn);
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((OutputStream)bos));
    }

    public static final /* synthetic */ void $anonfun$zip$2(ObjectRef zos$1, ObjectRef bis$1, byte[] bufs$1, FsPath f) {
        ZipEntry zipEntry = new ZipEntry(f.toFile().getName());
        ((ZipOutputStream)zos$1.elem).putNextEntry(zipEntry);
        FileInputStream fis = new FileInputStream(f.toFile());
        bis$1.elem = new BufferedInputStream(fis, 10240);
        Utils$.MODULE$.tryFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int read = ((BufferedInputStream)bis$1.elem).read(bufs$1, 0, 1024);
            while (read > 0) {
                ((ZipOutputStream)zos$1.elem).write(bufs$1, 0, read);
                read = ((BufferedInputStream)bis$1.elem).read(bufs$1, 0, 1024);
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((InputStream)((BufferedInputStream)bis$1.elem)));
    }

    public static final /* synthetic */ void $anonfun$zipDir$2(ObjectRef zos$2, FileService fileService$1, String sourceFilePath$1, String user$1, ObjectRef bis$2, byte[] bufs$2, String f) {
        ZipEntry zipEntry = new ZipEntry(f);
        ((ZipOutputStream)zos$2.elem).putNextEntry(zipEntry);
        InputStream fis = fileService$1.open(new File(sourceFilePath$1, f).getPath(), user$1);
        bis$2.elem = new BufferedInputStream(fis, 10240);
        Utils$.MODULE$.tryFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int read = ((BufferedInputStream)bis$2.elem).read(bufs$2, 0, 1024);
            while (read > 0) {
                ((ZipOutputStream)zos$2.elem).write(bufs$2, 0, read);
                read = ((BufferedInputStream)bis$2.elem).read(bufs$2, 0, 1024);
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((InputStream)((BufferedInputStream)bis$2.elem)));
    }

    private ZipUtils$() {
        MODULE$ = this;
        this.BUFFER_SIZE = 4096;
    }
}

