/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.monitor.Pollers;
import com.netflix.servo.util.Clock;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

class StepLong {
    private static final int PREVIOUS = 0;
    private static final int CURRENT = 1;
    private final long init;
    private final Clock clock;
    private final AtomicLong[] data;
    private final AtomicLong[] lastInitPos;

    StepLong(long init, Clock clock) {
        int i;
        this.init = init;
        this.clock = clock;
        this.lastInitPos = new AtomicLong[Pollers.NUM_POLLERS];
        for (i = 0; i < Pollers.NUM_POLLERS; ++i) {
            this.lastInitPos[i] = new AtomicLong(0L);
        }
        this.data = new AtomicLong[2 * Pollers.NUM_POLLERS];
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = new AtomicLong(init);
        }
    }

    void addAndGet(long amount) {
        for (int i = 0; i < Pollers.NUM_POLLERS; ++i) {
            this.getCurrent(i).addAndGet(amount);
        }
    }

    private void rollCount(int pollerIndex, long now) {
        long step = Pollers.POLLING_INTERVALS[pollerIndex];
        long stepTime = now / step;
        long lastInit = this.lastInitPos[pollerIndex].get();
        if (lastInit < stepTime && this.lastInitPos[pollerIndex].compareAndSet(lastInit, stepTime)) {
            int prev = 2 * pollerIndex + 0;
            int curr = 2 * pollerIndex + 1;
            long v = this.data[curr].getAndSet(this.init);
            this.data[prev].set(lastInit == stepTime - 1L ? v : this.init);
        }
    }

    AtomicLong getCurrent(int pollerIndex) {
        this.rollCount(pollerIndex, this.clock.now());
        return this.data[2 * pollerIndex + 1];
    }

    long poll(int pollerIndex) {
        this.rollCount(pollerIndex, this.clock.now());
        int prevPos = 2 * pollerIndex + 0;
        return this.data[prevPos].get();
    }

    public String toString() {
        return "StepLong{init=" + this.init + ", data=" + Arrays.toString(this.data) + ", lastInitPos=" + Arrays.toString(this.lastInitPos) + '}';
    }
}

