/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.persistence.impl;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.exception.LinkisRetryException;
import org.apache.linkis.manager.common.entity.node.AMEMNode;
import org.apache.linkis.manager.common.entity.node.AMEngineNode;
import org.apache.linkis.manager.common.entity.node.EMNode;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.common.entity.node.Node;
import org.apache.linkis.manager.common.entity.persistence.PersistenceNode;
import org.apache.linkis.manager.common.entity.persistence.PersistenceNodeEntity;
import org.apache.linkis.manager.dao.NodeManagerMapper;
import org.apache.linkis.manager.dao.NodeMetricManagerMapper;
import org.apache.linkis.manager.errorcode.LinkisManagerPersistenceErrorCodeSummary;
import org.apache.linkis.manager.exception.NodeInstanceDuplicateException;
import org.apache.linkis.manager.exception.NodeInstanceNotFoundException;
import org.apache.linkis.manager.exception.PersistenceErrorException;
import org.apache.linkis.manager.persistence.NodeManagerPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;

public class DefaultNodeManagerPersistence
implements NodeManagerPersistence {
    private Logger logger = LoggerFactory.getLogger(DefaultNodeManagerPersistence.class);
    private NodeManagerMapper nodeManagerMapper;
    private NodeMetricManagerMapper metricManagerMapper;

    public NodeManagerMapper getNodeManagerMapper() {
        return this.nodeManagerMapper;
    }

    public void setNodeManagerMapper(NodeManagerMapper nodeManagerMapper) {
        this.nodeManagerMapper = nodeManagerMapper;
    }

    public NodeMetricManagerMapper getMetricManagerMapper() {
        return this.metricManagerMapper;
    }

    public void setMetricManagerMapper(NodeMetricManagerMapper metricManagerMapper) {
        this.metricManagerMapper = metricManagerMapper;
    }

    @Override
    public void addNodeInstance(Node node) throws PersistenceErrorException {
        PersistenceNode persistenceNode = new PersistenceNode();
        persistenceNode.setInstance(node.getServiceInstance().getInstance());
        persistenceNode.setName(node.getServiceInstance().getApplicationName());
        persistenceNode.setOwner(node.getOwner());
        persistenceNode.setMark(node.getMark());
        persistenceNode.setTicketId(node.getTicketId());
        persistenceNode.setCreateTime(new Date());
        persistenceNode.setUpdateTime(new Date());
        persistenceNode.setCreator(node.getOwner());
        persistenceNode.setUpdator(node.getOwner());
        try {
            this.nodeManagerMapper.addNodeInstance(persistenceNode);
        }
        catch (DuplicateKeyException e) {
            NodeInstanceDuplicateException nodeInstanceDuplicateException = new NodeInstanceDuplicateException(LinkisManagerPersistenceErrorCodeSummary.NODE_INSTANCE_ALREADY_EXISTS.getErrorCode(), LinkisManagerPersistenceErrorCodeSummary.NODE_INSTANCE_ALREADY_EXISTS.getErrorDesc());
            nodeInstanceDuplicateException.initCause(e);
            throw nodeInstanceDuplicateException;
        }
    }

    @Override
    public void updateEngineNode(ServiceInstance serviceInstance, Node node) throws PersistenceErrorException, LinkisRetryException {
        PersistenceNode persistenceNode = new PersistenceNode();
        persistenceNode.setInstance(node.getServiceInstance().getInstance());
        persistenceNode.setName(node.getServiceInstance().getApplicationName());
        persistenceNode.setOwner(node.getOwner());
        persistenceNode.setMark(node.getMark());
        persistenceNode.setUpdateTime(new Date());
        persistenceNode.setCreator(node.getOwner());
        persistenceNode.setUpdator(node.getOwner());
        String mappingPorts = node.getServiceInstance().getMappingPorts();
        persistenceNode.setMappingPorts(mappingPorts);
        String mappingHost = node.getServiceInstance().getMappingHost();
        persistenceNode.setMappingHost(mappingHost);
        try {
            this.nodeManagerMapper.updateNodeInstance(serviceInstance.getInstance(), persistenceNode);
            this.nodeManagerMapper.updateNodeRelation(serviceInstance.getInstance(), node.getServiceInstance().getInstance());
            this.nodeManagerMapper.updateNodeLabelRelation(serviceInstance.getInstance(), node.getServiceInstance().getInstance());
        }
        catch (DuplicateKeyException e) {
            LinkisRetryException linkisRetryException = new LinkisRetryException(LinkisManagerPersistenceErrorCodeSummary.NODE_INFO_DUPLICATE.getErrorCode(), LinkisManagerPersistenceErrorCodeSummary.NODE_INFO_DUPLICATE.getErrorMessage());
            linkisRetryException.initCause((Throwable)e);
            throw linkisRetryException;
        }
        catch (Exception e) {
            NodeInstanceNotFoundException nodeInstanceNotFoundException = new NodeInstanceNotFoundException(LinkisManagerPersistenceErrorCodeSummary.NODE_INSTANCE_DOES_NOT_EXIST.getErrorCode(), LinkisManagerPersistenceErrorCodeSummary.NODE_INSTANCE_DOES_NOT_EXIST.getErrorDesc());
            nodeInstanceNotFoundException.initCause(e);
            throw nodeInstanceNotFoundException;
        }
    }

    @Override
    public void removeNodeInstance(Node node) throws PersistenceErrorException {
        String instance = node.getServiceInstance().getInstance();
        try {
            this.nodeManagerMapper.removeNodeInstance(instance);
        }
        catch (Exception e) {
            NodeInstanceNotFoundException nodeInstanceNotFoundException = new NodeInstanceNotFoundException(LinkisManagerPersistenceErrorCodeSummary.NODE_INSTANCE_DOES_NOT_EXIST.getErrorCode(), LinkisManagerPersistenceErrorCodeSummary.NODE_INSTANCE_DOES_NOT_EXIST.getErrorDesc());
            nodeInstanceNotFoundException.initCause(e);
            throw nodeInstanceNotFoundException;
        }
    }

    @Override
    public List<Node> getNodes(String owner) throws PersistenceErrorException {
        List<PersistenceNode> nodeInstances = this.nodeManagerMapper.getNodeInstancesByOwner(owner);
        ArrayList<Node> persistenceNodeEntitys = new ArrayList<Node>();
        if (!nodeInstances.isEmpty()) {
            for (PersistenceNode persistenceNode : nodeInstances) {
                PersistenceNodeEntity persistenceNodeEntity = new PersistenceNodeEntity();
                ServiceInstance serviceInstance = new ServiceInstance();
                serviceInstance.setApplicationName(persistenceNode.getName());
                serviceInstance.setInstance(persistenceNode.getInstance());
                persistenceNodeEntity.setServiceInstance(serviceInstance);
                persistenceNodeEntity.setMark(persistenceNode.getMark());
                persistenceNodeEntity.setOwner(persistenceNode.getOwner());
                persistenceNodeEntity.setStartTime(persistenceNode.getCreateTime());
                persistenceNodeEntity.setIdentifier(persistenceNode.getIdentifier());
                persistenceNodeEntity.setTicketId(persistenceNode.getTicketId());
                persistenceNodeEntitys.add((Node)persistenceNodeEntity);
            }
        }
        return persistenceNodeEntitys;
    }

    @Override
    public List<Node> getAllNodes() throws PersistenceErrorException {
        List<PersistenceNode> nodeInstances = this.nodeManagerMapper.getAllNodes();
        ArrayList<Node> persistenceNodeEntitys = new ArrayList<Node>();
        if (!nodeInstances.isEmpty()) {
            for (PersistenceNode persistenceNode : nodeInstances) {
                PersistenceNodeEntity persistenceNodeEntity = new PersistenceNodeEntity();
                ServiceInstance serviceInstance = new ServiceInstance();
                serviceInstance.setApplicationName(persistenceNode.getName());
                serviceInstance.setInstance(persistenceNode.getInstance());
                persistenceNodeEntity.setServiceInstance(serviceInstance);
                persistenceNodeEntity.setMark(persistenceNode.getMark());
                persistenceNodeEntity.setIdentifier(persistenceNode.getIdentifier());
                persistenceNodeEntity.setTicketId(persistenceNode.getTicketId());
                persistenceNodeEntity.setOwner(persistenceNode.getOwner());
                persistenceNodeEntity.setStartTime(persistenceNode.getCreateTime());
                persistenceNodeEntity.setUpdateTime(persistenceNode.getUpdateTime());
                persistenceNodeEntitys.add((Node)persistenceNodeEntity);
            }
        }
        return persistenceNodeEntitys;
    }

    @Override
    public void updateNodeInstance(Node node) {
        if (Objects.nonNull(node)) {
            PersistenceNode persistenceNode = new PersistenceNode();
            persistenceNode.setInstance(node.getServiceInstance().getInstance());
            persistenceNode.setName(node.getServiceInstance().getApplicationName());
            persistenceNode.setMark(node.getMark());
            persistenceNode.setUpdateTime(new Date());
            persistenceNode.setCreator(node.getOwner());
            persistenceNode.setUpdator(node.getOwner());
            persistenceNode.setIdentifier(node.getIdentifier());
            this.nodeManagerMapper.updateNodeInstanceByInstance(persistenceNode);
        }
    }

    @Override
    public Node getNode(ServiceInstance serviceInstance) {
        String instance = serviceInstance.getInstance();
        PersistenceNode nodeInstances = this.nodeManagerMapper.getNodeInstance(instance);
        if (null == nodeInstances) {
            return null;
        }
        PersistenceNodeEntity persistenceNodeEntity = new PersistenceNodeEntity();
        persistenceNodeEntity.setServiceInstance(serviceInstance);
        persistenceNodeEntity.setOwner(nodeInstances.getOwner());
        persistenceNodeEntity.setMark(nodeInstances.getMark());
        persistenceNodeEntity.setIdentifier(nodeInstances.getIdentifier());
        persistenceNodeEntity.setTicketId(nodeInstances.getTicketId());
        persistenceNodeEntity.setStartTime(nodeInstances.getCreateTime());
        return persistenceNodeEntity;
    }

    @Override
    public void addEngineNode(EngineNode engineNode) throws PersistenceErrorException {
        this.addNodeInstance((Node)engineNode);
        String engineNodeInstance = engineNode.getServiceInstance().getInstance();
        if (null == engineNode.getEMNode()) {
            throw new PersistenceErrorException(LinkisManagerPersistenceErrorCodeSummary.THE_EMNODE_IS_NULL.getErrorCode(), MessageFormat.format(LinkisManagerPersistenceErrorCodeSummary.THE_EMNODE_IS_NULL.getErrorDesc(), engineNode.getServiceInstance()));
        }
        String emNodeInstance = engineNode.getEMNode().getServiceInstance().getInstance();
        this.nodeManagerMapper.addEngineNode(engineNodeInstance, emNodeInstance);
    }

    @Override
    public void deleteEngineNode(EngineNode engineNode) throws PersistenceErrorException {
        String engineNodeInstance = engineNode.getServiceInstance().getInstance();
        if (null != engineNode.getEMNode()) {
            String emNodeInstance = engineNode.getEMNode().getServiceInstance().getInstance();
            this.nodeManagerMapper.deleteEngineNode(engineNodeInstance, emNodeInstance);
        }
        this.metricManagerMapper.deleteNodeMetricsByInstance(engineNodeInstance);
        this.nodeManagerMapper.removeNodeInstance(engineNode.getServiceInstance().getInstance());
    }

    @Override
    public EngineNode getEngineNode(ServiceInstance serviceInstance) throws PersistenceErrorException {
        AMEngineNode amEngineNode = new AMEngineNode();
        amEngineNode.setServiceInstance(serviceInstance);
        PersistenceNode engineNode = this.nodeManagerMapper.getNodeInstance(serviceInstance.getInstance());
        if (null == engineNode) {
            return null;
        }
        amEngineNode.setOwner(engineNode.getOwner());
        amEngineNode.setMark(engineNode.getMark());
        amEngineNode.setIdentifier(engineNode.getIdentifier());
        amEngineNode.setTicketId(engineNode.getTicketId());
        amEngineNode.setStartTime(engineNode.getCreateTime());
        PersistenceNode emNode = this.nodeManagerMapper.getEMNodeInstanceByEngineNode(serviceInstance.getInstance());
        if (emNode != null) {
            String emInstance = emNode.getInstance();
            String emName = emNode.getName();
            ServiceInstance emServiceInstance = new ServiceInstance();
            emServiceInstance.setApplicationName(emName);
            emServiceInstance.setInstance(emInstance);
            emServiceInstance.setMappingPorts(String.valueOf(emNode.getMappingPorts()));
            emServiceInstance.setMappingHost(String.valueOf(emNode.getMappingHost()));
            AMEMNode amemNode = new AMEMNode();
            amemNode.setMark(emNode.getMark());
            amemNode.setOwner(emNode.getOwner());
            amemNode.setServiceInstance(emServiceInstance);
            amemNode.setStartTime(emNode.getCreateTime());
            amEngineNode.setEMNode((EMNode)amemNode);
        }
        return amEngineNode;
    }

    @Override
    public EngineNode getEngineNodeByTicketId(String ticketId) {
        AMEngineNode amEngineNode = new AMEngineNode();
        PersistenceNode engineNode = this.nodeManagerMapper.getNodeInstanceByTicketId(ticketId);
        if (null == engineNode) {
            return null;
        }
        ServiceInstance serviceInstance = new ServiceInstance();
        serviceInstance.setInstance(engineNode.getInstance());
        serviceInstance.setApplicationName(engineNode.getName());
        amEngineNode.setServiceInstance(serviceInstance);
        amEngineNode.setOwner(engineNode.getOwner());
        amEngineNode.setMark(engineNode.getMark());
        amEngineNode.setIdentifier(engineNode.getIdentifier());
        amEngineNode.setTicketId(engineNode.getTicketId());
        amEngineNode.setStartTime(engineNode.getCreateTime());
        return amEngineNode;
    }

    @Override
    public List<EngineNode> getEngineNodeByEM(ServiceInstance serviceInstance) throws PersistenceErrorException {
        PersistenceNode emNode = this.nodeManagerMapper.getNodeInstance(serviceInstance.getInstance());
        if (null == emNode) {
            return new ArrayList<EngineNode>();
        }
        List<PersistenceNode> engineNodeList = this.nodeManagerMapper.getNodeInstances(serviceInstance.getInstance());
        ArrayList<EngineNode> amEngineNodeList = new ArrayList<EngineNode>();
        for (PersistenceNode engineNode : engineNodeList) {
            AMEMNode amEmNode = new AMEMNode();
            amEmNode.setServiceInstance(serviceInstance);
            amEmNode.setOwner(emNode.getOwner());
            amEmNode.setMark(emNode.getMark());
            amEmNode.setStartTime(emNode.getCreateTime());
            AMEngineNode amEngineNode = new AMEngineNode();
            ServiceInstance engineServiceInstance = new ServiceInstance();
            engineServiceInstance.setInstance(engineNode.getInstance());
            engineServiceInstance.setApplicationName(engineNode.getName());
            engineServiceInstance.setMappingPorts(String.valueOf(engineNode.getMappingPorts()));
            engineServiceInstance.setMappingHost(String.valueOf(engineNode.getMappingHost()));
            amEngineNode.setServiceInstance(engineServiceInstance);
            amEngineNode.setOwner(engineNode.getOwner());
            amEngineNode.setMark(engineNode.getMark());
            amEngineNode.setIdentifier(engineNode.getIdentifier());
            amEngineNode.setTicketId(engineNode.getTicketId());
            amEngineNode.setStartTime(engineNode.getCreateTime());
            amEngineNode.setEMNode((EMNode)amEmNode);
            amEngineNodeList.add((EngineNode)amEngineNode);
        }
        return amEngineNodeList;
    }

    @Override
    public List<EngineNode> getEngineNodeByServiceInstance(List<ServiceInstance> serviceInstanceList) throws PersistenceErrorException {
        ArrayList<EngineNode> amEngineNodeList = new ArrayList<EngineNode>();
        List partition = Lists.partition(serviceInstanceList, (int)100);
        partition.forEach(instanceList -> {
            List<PersistenceNode> engineNodeList;
            List<String> collect = instanceList.stream().map(ServiceInstance::getInstance).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect) && CollectionUtils.isNotEmpty(engineNodeList = this.nodeManagerMapper.getNodesByInstances(collect))) {
                instanceList.forEach(serviceInstance -> {
                    PersistenceNode engineNode = engineNodeList.stream().filter(engineNodeInfo -> engineNodeInfo.getInstance().equals(serviceInstance.getInstance())).findFirst().orElse(new PersistenceNode());
                    AMEngineNode amEngineNode = new AMEngineNode();
                    amEngineNode.setServiceInstance(serviceInstance);
                    amEngineNode.setOwner(engineNode.getOwner());
                    amEngineNode.setMark(engineNode.getMark());
                    amEngineNode.setIdentifier(engineNode.getIdentifier());
                    amEngineNode.setTicketId(engineNode.getTicketId());
                    amEngineNode.setStartTime(engineNode.getCreateTime());
                    amEngineNodeList.add((EngineNode)amEngineNode);
                });
            }
        });
        return amEngineNodeList;
    }

    @Override
    public List<Node> getNodesByOwnerList(List<String> ownerlist) {
        List<PersistenceNode> nodeInstances;
        ArrayList<Node> persistenceNodeEntitys = new ArrayList<Node>();
        if (CollectionUtils.isNotEmpty(ownerlist) && CollectionUtils.isNotEmpty(nodeInstances = this.nodeManagerMapper.getNodeInstancesByOwnerList(ownerlist))) {
            for (PersistenceNode persistenceNode : nodeInstances) {
                PersistenceNodeEntity persistenceNodeEntity = new PersistenceNodeEntity();
                ServiceInstance serviceInstance = new ServiceInstance();
                serviceInstance.setApplicationName(persistenceNode.getName());
                serviceInstance.setInstance(persistenceNode.getInstance());
                persistenceNodeEntity.setServiceInstance(serviceInstance);
                persistenceNodeEntity.setMark(persistenceNode.getMark());
                persistenceNodeEntity.setOwner(persistenceNode.getOwner());
                persistenceNodeEntity.setStartTime(persistenceNode.getCreateTime());
                persistenceNodeEntity.setIdentifier(persistenceNode.getIdentifier());
                persistenceNodeEntity.setTicketId(persistenceNode.getTicketId());
                persistenceNodeEntitys.add((Node)persistenceNodeEntity);
            }
        }
        return persistenceNodeEntitys;
    }
}

