/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.linkis.manager.common.entity.persistence.PersistenceLabel;
import org.apache.linkis.manager.entity.Tunple;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.utils.LabelUtils;

public class PersistenceUtils {
    private static final LabelBuilderFactory labelFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();

    public static PersistenceLabel setValue(PersistenceLabel persistenceLabel) {
        Label label = labelFactory.createLabel(persistenceLabel.getLabelKey(), (Object)persistenceLabel.getStringValue());
        if (label.getValue() instanceof Map) {
            persistenceLabel.setValue((Map)LabelUtils.Jackson.fromJson((String)persistenceLabel.getStringValue(), Map.class, (Class[])new Class[0]));
        }
        return persistenceLabel;
    }

    public static Tunple<String, Map<String, String>> entryToTunple(PersistenceLabel label) {
        return new Tunple<String, Object>(label.getLabelKey(), label.getValue());
    }

    public static boolean valueListIsEmpty(List<Map<String, String>> valueList) {
        return CollectionUtils.isEmpty(valueList) || CollectionUtils.isEmpty((Collection)valueList.stream().filter(MapUtils::isNotEmpty).collect(Collectors.toList()));
    }

    public static List<Map<String, String>> filterEmptyValueList(List<Map<String, String>> valueList) {
        return valueList.stream().filter(MapUtils::isNotEmpty).collect(Collectors.toList());
    }

    public static boolean KeyValueMapIsEmpty(Map<String, Map<String, String>> keyValueMap) {
        return MapUtils.isEmpty(keyValueMap) || MapUtils.isEmpty(keyValueMap.entrySet().stream().filter(e -> MapUtils.isNotEmpty((Map)((Map)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public static Map<String, Map<String, String>> filterEmptyKeyValueMap(Map<String, Map<String, String>> keyValueMap) {
        return keyValueMap.entrySet().stream().filter(e -> MapUtils.isNotEmpty((Map)((Map)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static boolean persistenceLabelListIsEmpty(List<PersistenceLabel> persistenceLabelList) {
        return CollectionUtils.isEmpty(persistenceLabelList) || CollectionUtils.isEmpty((Collection)persistenceLabelList.stream().filter(l -> MapUtils.isNotEmpty((Map)((Map)l.getValue()))).collect(Collectors.toList()));
    }

    public static List<PersistenceLabel> filterEmptyPersistenceLabelList(List<PersistenceLabel> persistenceLabelList) {
        return persistenceLabelList.stream().filter(e -> MapUtils.isNotEmpty((Map)((Map)e.getValue()))).collect(Collectors.toList());
    }
}

