/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.computation.concurrent.monitor;

import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.utils.HardwareUtils;
import org.apache.linkis.engineconn.computation.concurrent.monitor.MonitorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HardwareMonitorService
implements MonitorService {
    private static Logger LOG = LoggerFactory.getLogger(HardwareMonitorService.class);
    private static CommonVars<Double> MEMORY_MAX_USAGE = CommonVars.apply((String)"linkis.engineconn.concurrent.max.memory.usage", (Object)0.95);
    private static CommonVars<Double> CPU_MAX_USAGE = CommonVars.apply((String)"linkis.engineconn.concurrent.max.cpu.usage", (Object)0.99);
    private Double lastLoadAverageUsage = 0.0;
    private Double lastMemoryUsage = 0.0;

    @Override
    public boolean isAvailable() {
        boolean isUnavailable;
        double memoryUsage = HardwareUtils.memoryUsage();
        double loadAverageUsage = HardwareUtils.loadAverageUsage();
        Double maxMemoryUsage = (Double)MEMORY_MAX_USAGE.getValue();
        Double maxCpuUsage = (Double)CPU_MAX_USAGE.getValue();
        boolean bl = isUnavailable = memoryUsage > maxMemoryUsage && this.lastMemoryUsage > maxMemoryUsage || loadAverageUsage > maxCpuUsage && this.lastLoadAverageUsage > maxCpuUsage;
        if (isUnavailable) {
            LOG.warn("current load average {} is too high or memory usage {} is too high, over max cpu load avg={} and memory usage {}", new Object[]{loadAverageUsage, memoryUsage, maxCpuUsage, maxMemoryUsage});
        }
        this.lastLoadAverageUsage = loadAverageUsage;
        this.lastMemoryUsage = memoryUsage;
        return !isUnavailable;
    }
}

