/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.core.hook;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineconn.core.hook.ShutdownHook$;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0010!\u00015BQ\u0001\u0010\u0001\u0005\u0002uBq\u0001\u0011\u0001A\u0002\u0013\u0005\u0011\tC\u0004F\u0001\u0001\u0007I\u0011\u0001$\t\r1\u0003\u0001\u0015)\u0003C\u0011\u001di\u0005A1A\u0005\n9Caa\u0017\u0001!\u0002\u0013y\u0005b\u0002/\u0001\u0005\u0004%I!\u0018\u0005\u0007C\u0002\u0001\u000b\u0011\u00020\t\u000f\t\u0004\u0001\u0019!C\u0005G\"9\u0001\u000f\u0001a\u0001\n\u0013\t\bBB:\u0001A\u0003&A\rC\u0004u\u0001\u0001\u0007I\u0011B;\t\u000fe\u0004\u0001\u0019!C\u0005u\"1A\u0010\u0001Q!\nYDq! \u0001C\u0002\u0013%a\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0011B@\t\u0011\u00055\u0001A1A\u0005\n\u0005Cq!a\u0004\u0001A\u0003%!\tC\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001\"CA\u0016\u0001E\u0005I\u0011AA\u0017\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!!\u0013\u0001\t\u0003\tYeB\u0004\u0002N\u0001B\t!a\u0014\u0007\r}\u0001\u0003\u0012AA)\u0011\u0019a$\u0004\"\u0001\u0002T!I\u0011Q\u000b\u000eC\u0002\u0013%\u0011q\u000b\u0005\b\u00033R\u0002\u0015!\u0003?\u0011\u001d\tYF\u0007C\u0001\u0003/\u0012Ab\u00155vi\u0012|wO\u001c%p_.T!!\t\u0012\u0002\t!|wn\u001b\u0006\u0003G\u0011\nAaY8sK*\u0011QEJ\u0001\u000bK:<\u0017N\\3d_:t'BA\u0014)\u0003\u0019a\u0017N\\6jg*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u00185!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0019\te.\u001f*fMB\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0006kRLGn\u001d\u0006\u0003s\u0019\naaY8n[>t\u0017BA\u001e7\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001 \u0011\u0005}\u0002Q\"\u0001\u0011\u0002\u0011\u0015D\u0018\u000e^\"pI\u0016,\u0012A\u0011\t\u0003_\rK!\u0001\u0012\u0019\u0003\u0007%sG/\u0001\u0007fq&$8i\u001c3f?\u0012*\u0017\u000f\u0006\u0002H\u0015B\u0011q\u0006S\u0005\u0003\u0013B\u0012A!\u00168ji\"91jAA\u0001\u0002\u0004\u0011\u0015a\u0001=%c\u0005IQ\r_5u\u0007>$W\rI\u0001\u0005Y>\u001c7.F\u0001P!\t\u0001\u0016,D\u0001R\u0015\t\u00116+A\u0003m_\u000e\\7O\u0003\u0002U+\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Y;\u0016\u0001B;uS2T\u0011\u0001W\u0001\u0005U\u00064\u0018-\u0003\u0002[#\ni!+Z3oiJ\fg\u000e\u001e'pG.\fQ\u0001\\8dW\u0002\n\u0011bY8oI&$\u0018n\u001c8\u0016\u0003y\u0003\"\u0001U0\n\u0005\u0001\f&!C\"p]\u0012LG/[8o\u0003)\u0019wN\u001c3ji&|g\u000eI\u0001\u0006KJ\u0014xN]\u000b\u0002IB\u0011Q-\u001c\b\u0003M.t!a\u001a6\u000e\u0003!T!!\u001b\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0014B\u000171\u0003\u001d\u0001\u0018mY6bO\u0016L!A\\8\u0003\u0013QC'o\\<bE2,'B\u000171\u0003%)'O]8s?\u0012*\u0017\u000f\u0006\u0002He\"91JCA\u0001\u0002\u0004!\u0017AB3se>\u0014\b%A\u0004ti>\u0004\b/\u001a3\u0016\u0003Y\u0004\"aL<\n\u0005a\u0004$a\u0002\"p_2,\u0017M\\\u0001\fgR|\u0007\u000f]3e?\u0012*\u0017\u000f\u0006\u0002Hw\"91*DA\u0001\u0002\u00041\u0018\u0001C:u_B\u0004X\r\u001a\u0011\u0002\u0019Q\u0014\u0018p\u0015;paRKW.Z:\u0016\u0003}\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000b\u0019\u0016AB1u_6L7-\u0003\u0003\u0002\n\u0005\r!!D!u_6L7-\u00138uK\u001e,'/A\u0007uef\u001cFo\u001c9US6,7\u000fI\u0001\t[\u0006DH+[7fg\u0006IQ.\u0019=US6,7\u000fI\u0001\f]>$\u0018NZ=FeJ|'\u000fF\u0002H\u0003+Aa!a\u0006\u0014\u0001\u0004!\u0017!A3\u0002\u00159|G/\u001b4z'R|\u0007\u000fF\u0001H\u0003I9\u0018-\u001b;G_J\u001cFo\u001c9Pe\u0016\u0013(o\u001c:\u0015\u0007Y\f\t\u0003C\u0005\u0002$U\u0001\n\u00111\u0001\u0002&\u00059A/[7f_V$\bcA\u0018\u0002(%\u0019\u0011\u0011\u0006\u0019\u0003\t1{gnZ\u0001\u001do\u0006LGOR8s'R|\u0007o\u0014:FeJ|'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tyC\u000b\u0003\u0002&\u0005E2FAA\u001a!\u0011\t)$a\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005u\u0002'\u0001\u0006b]:|G/\u0019;j_:LA!!\u0011\u00028\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0017M,G/\u0012=ji\u000e{G-\u001a\u000b\u0004\u000f\u0006\u001d\u0003\"\u0002!\u0018\u0001\u0004\u0011\u0015aC4fi\u0016C\u0018\u000e^\"pI\u0016$\u0012AQ\u0001\r'\",H\u000fZ8x]\"{wn\u001b\t\u0003\u007fi\u0019\"A\u0007\u0018\u0015\u0005\u0005=\u0013\u0001D:ikR$wn\u001e8I_>\\W#\u0001 \u0002\u001bMDW\u000f\u001e3po:Dun\\6!\u0003=9W\r^*ikR$wn\u001e8I_>\\\u0007")
public class ShutdownHook
implements Logging {
    private int exitCode;
    private final ReentrantLock lock;
    private final Condition condition;
    private Throwable error;
    private boolean stopped;
    private final AtomicInteger tryStopTimes;
    private final int maxTimes;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static ShutdownHook getShutdownHook() {
        return ShutdownHook$.MODULE$.getShutdownHook();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ShutdownHook shutdownHook = this;
        synchronized (shutdownHook) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public int exitCode() {
        return this.exitCode;
    }

    public void exitCode_$eq(int x$1) {
        this.exitCode = x$1;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    private Condition condition() {
        return this.condition;
    }

    private Throwable error() {
        return this.error;
    }

    private void error_$eq(Throwable x$1) {
        this.error = x$1;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private AtomicInteger tryStopTimes() {
        return this.tryStopTimes;
    }

    private int maxTimes() {
        return this.maxTimes;
    }

    public void notifyError(Throwable e) {
        this.lock().lock();
        try {
            this.setExitCode(1);
            this.error_$eq(e);
            this.logger().error("process exit reason: ", e);
            this.condition().signalAll();
        }
        finally {
            this.lock().unlock();
        }
    }

    public void notifyStop() {
        this.lock().lock();
        int num = this.tryStopTimes().incrementAndGet();
        try {
            this.setExitCode(0);
            this.stopped_$eq(true);
            this.condition().signalAll();
        }
        finally {
            this.lock().unlock();
            if (num >= this.maxTimes()) {
                this.logger().error(new StringBuilder(46).append("try to stop with times:").append(num).append(", now do system exit!!!").toString());
                System.exit(0);
            }
        }
    }

    public boolean waitForStopOrError(long timeout) {
        boolean bl;
        this.lock().lock();
        try {
            if (timeout < 0L) {
                while (!this.stopped() && this.error() == null) {
                    this.condition().await();
                }
            } else {
                long nanos = TimeUnit.MILLISECONDS.toNanos(timeout);
                while (!this.stopped() && this.error() == null && nanos > 0L) {
                    nanos = this.condition().awaitNanos(nanos);
                }
            }
            if (this.error() != null) {
                throw this.error();
            }
            bl = this.stopped();
        }
        finally {
            this.lock().unlock();
        }
        return bl;
    }

    public long waitForStopOrError$default$1() {
        return -1L;
    }

    public void setExitCode(int exitCode) {
        this.exitCode_$eq(exitCode);
    }

    public int getExitCode() {
        return this.exitCode();
    }

    public ShutdownHook() {
        Logging.$init$((Logging)this);
        this.exitCode = 0;
        this.lock = new ReentrantLock();
        this.condition = this.lock().newCondition();
        this.error = null;
        this.stopped = false;
        this.tryStopTimes = new AtomicInteger(0);
        this.maxTimes = 10;
    }
}

