/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.apache.thrift.transport;

import shaded.parquet.org.apache.thrift.transport.AutoExpandingBufferReadTransport;
import shaded.parquet.org.apache.thrift.transport.AutoExpandingBufferWriteTransport;
import shaded.parquet.org.apache.thrift.transport.TFramedTransport;
import shaded.parquet.org.apache.thrift.transport.TTransport;
import shaded.parquet.org.apache.thrift.transport.TTransportException;
import shaded.parquet.org.apache.thrift.transport.TTransportFactory;

public class TFastFramedTransport
extends TTransport {
    public static final int DEFAULT_BUF_CAPACITY = 1024;
    public static final int DEFAULT_MAX_LENGTH = 0xFA0000;
    private final TTransport underlying;
    private final AutoExpandingBufferWriteTransport writeBuffer;
    private final AutoExpandingBufferReadTransport readBuffer;
    private final byte[] i32buf = new byte[4];
    private final int maxLength;

    public TFastFramedTransport(TTransport underlying) {
        this(underlying, 1024, 0xFA0000);
    }

    public TFastFramedTransport(TTransport underlying, int initialBufferCapacity) {
        this(underlying, initialBufferCapacity, 0xFA0000);
    }

    public TFastFramedTransport(TTransport underlying, int initialBufferCapacity, int maxLength) {
        this.underlying = underlying;
        this.maxLength = maxLength;
        this.writeBuffer = new AutoExpandingBufferWriteTransport(initialBufferCapacity, 1.5);
        this.readBuffer = new AutoExpandingBufferReadTransport(initialBufferCapacity, 1.5);
    }

    public void close() {
        this.underlying.close();
    }

    public boolean isOpen() {
        return this.underlying.isOpen();
    }

    public void open() throws TTransportException {
        this.underlying.open();
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        int got = this.readBuffer.read(buf, off, len);
        if (got > 0) {
            return got;
        }
        this.readFrame();
        return this.readBuffer.read(buf, off, len);
    }

    private void readFrame() throws TTransportException {
        this.underlying.readAll(this.i32buf, 0, 4);
        int size = TFramedTransport.decodeFrameSize(this.i32buf);
        if (size < 0) {
            throw new TTransportException("Read a negative frame size (" + size + ")!");
        }
        if (size > this.maxLength) {
            throw new TTransportException("Frame size (" + size + ") larger than max length (" + this.maxLength + ")!");
        }
        this.readBuffer.fill(this.underlying, size);
    }

    public void write(byte[] buf, int off, int len) throws TTransportException {
        this.writeBuffer.write(buf, off, len);
    }

    public void consumeBuffer(int len) {
        this.readBuffer.consumeBuffer(len);
    }

    public void flush() throws TTransportException {
        int length = this.writeBuffer.getPos();
        TFramedTransport.encodeFrameSize(length, this.i32buf);
        this.underlying.write(this.i32buf, 0, 4);
        this.underlying.write(this.writeBuffer.getBuf().array(), 0, length);
        this.writeBuffer.reset();
        this.underlying.flush();
    }

    public byte[] getBuffer() {
        return this.readBuffer.getBuffer();
    }

    public int getBufferPosition() {
        return this.readBuffer.getBufferPosition();
    }

    public int getBytesRemainingInBuffer() {
        return this.readBuffer.getBytesRemainingInBuffer();
    }

    public static class Factory
    extends TTransportFactory {
        private final int initialCapacity;
        private final int maxLength;

        public Factory() {
            this(1024, 0xFA0000);
        }

        public Factory(int initialCapacity) {
            this(initialCapacity, 0xFA0000);
        }

        public Factory(int initialCapacity, int maxLength) {
            this.initialCapacity = initialCapacity;
            this.maxLength = maxLength;
        }

        public TTransport getTransport(TTransport trans) {
            return new TFastFramedTransport(trans, this.initialCapacity, this.maxLength);
        }
    }
}

