/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.bml.client.BmlClient;
import org.apache.linkis.bml.client.BmlClientFactory;
import org.apache.linkis.bml.protocol.BmlDownloadResponse;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.metadata.query.common.exception.MetaRuntimeException;
import org.apache.linkis.metadata.query.common.service.AbstractDbMetaService;
import org.apache.linkis.metadata.query.common.service.MetadataConnection;
import org.apache.linkis.metadata.query.service.KafkaConnection;
import org.apache.linkis.metadata.query.service.KafkaParamsMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMetaService
extends AbstractDbMetaService<KafkaConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaMetaService.class);
    private static final CommonVars<String> TMP_FILE_STORE_LOCATION = CommonVars.apply((String)"wds.linkis.server.mdm.service.temp.location", (Object)"/tmp/keytab");
    private BmlClient client = BmlClientFactory.createBmlClient();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MetadataConnection<KafkaConnection> getConnection(String operator, Map<String, Object> params) throws Exception {
        KafkaConnection conn;
        FileUtils.forceMkdir((File)new File((String)TMP_FILE_STORE_LOCATION.getValue()));
        String brokers = String.valueOf(params.getOrDefault(KafkaParamsMapper.PARAM_KAFKA_BROKERS.getValue(), ""));
        String principle = String.valueOf(params.getOrDefault(KafkaParamsMapper.PARAM_KAFKA_PRINCIPLE.getValue(), ""));
        if (StringUtils.isNotBlank((CharSequence)principle)) {
            LOG.info("Try to connect Kafka MetaStore in kerberos with principle:[" + principle + "]");
            String keytabResourceId = String.valueOf(params.getOrDefault(KafkaParamsMapper.PARAM_KAFKA_KEYTAB.getValue(), ""));
            if (!StringUtils.isNotBlank((CharSequence)keytabResourceId)) throw new MetaRuntimeException("Cannot find the keytab file in connect parameters", null);
            LOG.info("Start to download resource id:[" + keytabResourceId + "]");
            String keytabFilePath = (String)TMP_FILE_STORE_LOCATION.getValue() + "/" + UUID.randomUUID().toString().replace("-", "") + ".keytab";
            if (!this.downloadResource(keytabResourceId, operator, keytabFilePath)) {
                throw new MetaRuntimeException("Fail to download resource i:[" + keytabResourceId + "]", null);
            }
            conn = new KafkaConnection(brokers, principle, keytabFilePath);
        } else {
            conn = new KafkaConnection(brokers);
        }
        conn.getClient().listTopics().names().get();
        return new MetadataConnection((Object)conn, true);
    }

    public List<String> queryDatabases(KafkaConnection connection) {
        return Arrays.asList("default");
    }

    public List<String> queryTables(KafkaConnection connection, String database) {
        try {
            return ((Set)connection.getClient().listTopics().names().get()).stream().collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to get Kafka topics(\u83b7\u53d6topic\u5217\u8868\u5931\u8d25)", e);
        }
    }

    private boolean downloadResource(String resourceId, String user, String absolutePath) throws IOException {
        LOG.info("Try to download resource resourceId:[" + resourceId + "]" + ",user=[" + user + "], will store in path:" + absolutePath);
        BmlDownloadResponse downloadResponse = this.client.downloadResource(user, resourceId, absolutePath);
        if (downloadResponse.isSuccess()) {
            IOUtils.copy((InputStream)downloadResponse.inputStream(), (OutputStream)new FileOutputStream(absolutePath));
            return true;
        }
        return false;
    }
}

