/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client.http;

import java.util.HashMap;
import java.util.Map;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.cs.client.http.DefaultContextPostAction;
import org.apache.linkis.cs.client.utils.SerializeHelper;
import org.apache.linkis.cs.common.entity.history.ContextHistory;
import org.apache.linkis.cs.common.entity.source.ContextID;

public class ContextPostActionBuilder {
    private final DefaultContextPostAction action;
    private Map<String, Object> requestParams = new HashMap<String, Object>(4);
    private Map<String, String> headerParams = new HashMap<String, String>(2);

    public ContextPostActionBuilder(String url) {
        this.action = new DefaultContextPostAction(url);
    }

    public static ContextPostActionBuilder of(String url) {
        return new ContextPostActionBuilder(url);
    }

    public ContextPostActionBuilder with(ContextID contextID) throws ErrorException {
        String contextIDStr = SerializeHelper.serializeContextID(contextID);
        this.requestParams.put("contextID", contextIDStr);
        return this;
    }

    public ContextPostActionBuilder with(ContextHistory history) throws ErrorException {
        String historyStr = SerializeHelper.serializeContextHistory(history);
        this.requestParams.put("contextHistory", historyStr);
        return this;
    }

    public ContextPostActionBuilder with(String key, Object object) throws ErrorException {
        this.requestParams.put(key, object);
        return this;
    }

    public ContextPostActionBuilder addHeader(String key, String value) throws ErrorException {
        this.headerParams.put(key, value);
        return this;
    }

    public DefaultContextPostAction build() {
        this.action.getRequestPayloads().putAll(this.requestParams);
        this.action.getHeaders().putAll(this.headerParams);
        return this.action;
    }
}

